/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.arrow.schema;

import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.Type;

class Map3Levels {
    private final GroupType map;
    private final GroupType repeated;
    private final Type key;
    private final Type value;

    public Map3Levels(GroupType map) {
        if (map.getLogicalTypeAnnotation() != LogicalTypeAnnotation.mapType() || map.getFields().size() != 1) {
            throw new IllegalArgumentException("invalid map type: " + map);
        }
        this.map = map;
        Type repeatedField = (Type)map.getFields().get(0);
        if (repeatedField.isPrimitive() || !repeatedField.isRepetition(Type.Repetition.REPEATED) || repeatedField.asGroupType().getFields().size() != 2) {
            throw new IllegalArgumentException("invalid map key: " + map);
        }
        this.repeated = repeatedField.asGroupType();
        this.key = (Type)this.repeated.getFields().get(0);
        this.value = (Type)this.repeated.getFields().get(1);
    }

    public GroupType getMap() {
        return this.map;
    }

    public GroupType getRepeated() {
        return this.repeated;
    }

    public Type getKey() {
        return this.key;
    }

    public Type getValue() {
        return this.value;
    }
}

