/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.arrow.schema;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.parquet.arrow.schema.List3Levels;
import org.apache.parquet.arrow.schema.Map3Levels;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class SchemaMapping {
    private final Schema arrowSchema;
    private final MessageType parquetSchema;
    private final List<TypeMapping> children;

    SchemaMapping(Schema arrowSchema, MessageType parquetSchema, List<TypeMapping> children) {
        this.arrowSchema = arrowSchema;
        this.parquetSchema = parquetSchema;
        this.children = Collections.unmodifiableList(children);
    }

    public Schema getArrowSchema() {
        return this.arrowSchema;
    }

    public MessageType getParquetSchema() {
        return this.parquetSchema;
    }

    public List<TypeMapping> getChildren() {
        return this.children;
    }

    public static class RepeatedTypeMapping
    extends TypeMapping {
        private final TypeMapping child;

        public RepeatedTypeMapping(Field arrowField, Type parquetType, TypeMapping child) {
            super(arrowField, parquetType, Arrays.asList(child));
            this.child = child;
        }

        public TypeMapping getChild() {
            return this.child;
        }

        @Override
        public <T> T accept(TypeMappingVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class MapTypeMapping
    extends TypeMapping {
        private final Map3Levels map3levels;
        private final TypeMapping key;
        private final TypeMapping value;

        public MapTypeMapping(Field arrowField, Map3Levels map3levels, TypeMapping key, TypeMapping value) {
            super(arrowField, (Type)map3levels.getMap(), Arrays.asList(key, value));
            this.map3levels = map3levels;
            this.key = key;
            this.value = value;
        }

        public Map3Levels getMap3Levels() {
            return this.map3levels;
        }

        public TypeMapping getKey() {
            return this.key;
        }

        public TypeMapping getValue() {
            return this.value;
        }

        @Override
        public <T> T accept(TypeMappingVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class ListTypeMapping
    extends TypeMapping {
        private final List3Levels list3Levels;
        private final TypeMapping child;

        public ListTypeMapping(Field arrowField, List3Levels list3Levels, TypeMapping child) {
            super(arrowField, (Type)list3Levels.getList(), Collections.singletonList(child));
            this.list3Levels = list3Levels;
            this.child = child;
            if (list3Levels.getElement() != child.getParquetType()) {
                throw new IllegalArgumentException(list3Levels + " <=> " + child);
            }
        }

        public List3Levels getList3Levels() {
            return this.list3Levels;
        }

        public TypeMapping getChild() {
            return this.child;
        }

        @Override
        public <T> T accept(TypeMappingVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class UnionTypeMapping
    extends TypeMapping {
        public UnionTypeMapping(Field arrowField, GroupType parquetType, List<TypeMapping> children) {
            super(arrowField, (Type)parquetType, children);
        }

        @Override
        public <T> T accept(TypeMappingVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class StructTypeMapping
    extends TypeMapping {
        public StructTypeMapping(Field arrowField, GroupType parquetType, List<TypeMapping> children) {
            super(arrowField, (Type)parquetType, children);
        }

        @Override
        public <T> T accept(TypeMappingVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static class PrimitiveTypeMapping
    extends TypeMapping {
        public PrimitiveTypeMapping(Field arrowField, PrimitiveType parquetType) {
            super(arrowField, (Type)parquetType, Collections.emptyList());
        }

        @Override
        public <T> T accept(TypeMappingVisitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static abstract class TypeMapping {
        private final Field arrowField;
        private final Type parquetType;
        private final List<TypeMapping> children;

        TypeMapping(Field arrowField, Type parquetType, List<TypeMapping> children) {
            this.arrowField = arrowField;
            this.parquetType = parquetType;
            this.children = children;
        }

        public Field getArrowField() {
            return this.arrowField;
        }

        public Type getParquetType() {
            return this.parquetType;
        }

        public List<TypeMapping> getChildren() {
            return this.children;
        }

        public abstract <T> T accept(TypeMappingVisitor<T> var1);
    }

    public static interface TypeMappingVisitor<T> {
        public T visit(PrimitiveTypeMapping var1);

        public T visit(StructTypeMapping var1);

        public T visit(UnionTypeMapping var1);

        public T visit(ListTypeMapping var1);

        public T visit(MapTypeMapping var1);

        public T visit(RepeatedTypeMapping var1);
    }
}

