/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.arrow.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.parquet.arrow.schema.List3Levels;
import org.apache.parquet.arrow.schema.Map3Levels;
import org.apache.parquet.arrow.schema.SchemaMapping;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class SchemaConverter {
    private final boolean convertInt96ToArrowTimestamp;

    public SchemaConverter() {
        this(false);
    }

    public SchemaConverter(boolean convertInt96ToArrowTimestamp) {
        this.convertInt96ToArrowTimestamp = convertInt96ToArrowTimestamp;
    }

    public SchemaMapping fromArrow(Schema arrowSchema) {
        List fields = arrowSchema.getFields();
        List<SchemaMapping.TypeMapping> parquetFields = this.fromArrow(fields);
        MessageType parquetType = (MessageType)this.addToBuilder(parquetFields, (Types.GroupBuilder)Types.buildMessage()).named("root");
        return new SchemaMapping(arrowSchema, parquetType, parquetFields);
    }

    private <T> Types.GroupBuilder<T> addToBuilder(List<SchemaMapping.TypeMapping> parquetFields, Types.GroupBuilder<T> builder) {
        for (SchemaMapping.TypeMapping type : parquetFields) {
            builder = (Types.GroupBuilder)builder.addField(type.getParquetType());
        }
        return builder;
    }

    private List<SchemaMapping.TypeMapping> fromArrow(List<Field> fields) {
        ArrayList<SchemaMapping.TypeMapping> result = new ArrayList<SchemaMapping.TypeMapping>(fields.size());
        for (Field field : fields) {
            result.add(this.fromArrow(field));
        }
        return result;
    }

    private SchemaMapping.TypeMapping fromArrow(Field field) {
        return this.fromArrow(field, field.getName());
    }

    private SchemaMapping.TypeMapping fromArrow(final Field field, final String fieldName) {
        final List children = field.getChildren();
        return (SchemaMapping.TypeMapping)field.getType().accept((ArrowType.ArrowTypeVisitor)new ArrowType.ArrowTypeVisitor<SchemaMapping.TypeMapping>(){

            public SchemaMapping.TypeMapping visit(ArrowType.Null type) {
                return this.primitive(PrimitiveType.PrimitiveTypeName.BINARY);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Struct type) {
                List parquetTypes = SchemaConverter.this.fromArrow(children);
                return new SchemaMapping.StructTypeMapping(field, (GroupType)SchemaConverter.this.addToBuilder(parquetTypes, Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL)).named(fieldName), (List<SchemaMapping.TypeMapping>)parquetTypes);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.List type) {
                return this.createListTypeMapping();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.LargeList largeList) {
                return this.createListTypeMapping();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.FixedSizeList type) {
                return this.createListTypeMapping();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.ListView type) {
                return this.createListTypeMapping();
            }

            private SchemaMapping.ListTypeMapping createListTypeMapping() {
                if (children.size() != 1) {
                    throw new IllegalArgumentException("list fields must have exactly one child: " + field);
                }
                SchemaMapping.TypeMapping parquetChild = SchemaConverter.this.fromArrow((Field)children.get(0), "element");
                GroupType list = (GroupType)Types.optionalList().element(parquetChild.getParquetType()).named(fieldName);
                return new SchemaMapping.ListTypeMapping(field, new List3Levels(list), parquetChild);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Union type) {
                List parquetTypes = SchemaConverter.this.fromArrow(children);
                return new SchemaMapping.UnionTypeMapping(field, (GroupType)SchemaConverter.this.addToBuilder(parquetTypes, Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL)).named(fieldName), (List<SchemaMapping.TypeMapping>)parquetTypes);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Map map) {
                if (children.size() != 2) {
                    throw new IllegalArgumentException("Map fields must have exactly two children: " + field);
                }
                SchemaMapping.TypeMapping keyChild = SchemaConverter.this.fromArrow((Field)children.get(0), "key");
                SchemaMapping.TypeMapping valueChild = SchemaConverter.this.fromArrow((Field)children.get(1), "value");
                GroupType groupType = (GroupType)((Types.MapBuilder)((Types.MapBuilder)Types.optionalMap().key(keyChild.getParquetType())).value(valueChild.getParquetType())).named(fieldName);
                return new SchemaMapping.MapTypeMapping(field, new Map3Levels(groupType), keyChild, valueChild);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Int type) {
                boolean signed = type.getIsSigned();
                switch (type.getBitWidth()) {
                    case 8: 
                    case 16: 
                    case 32: {
                        return this.primitive(PrimitiveType.PrimitiveTypeName.INT32, (LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)type.getBitWidth(), (boolean)signed));
                    }
                    case 64: {
                        return this.primitive(PrimitiveType.PrimitiveTypeName.INT64, (LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)64, (boolean)signed));
                    }
                }
                throw new IllegalArgumentException("Illegal int type: " + field);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.FloatingPoint type) {
                switch (type.getPrecision()) {
                    case HALF: {
                        return this.primitive(PrimitiveType.PrimitiveTypeName.FLOAT);
                    }
                    case SINGLE: {
                        return this.primitive(PrimitiveType.PrimitiveTypeName.FLOAT);
                    }
                    case DOUBLE: {
                        return this.primitive(PrimitiveType.PrimitiveTypeName.DOUBLE);
                    }
                }
                throw new IllegalArgumentException("Illegal float type: " + field);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Utf8 type) {
                return this.primitive(PrimitiveType.PrimitiveTypeName.BINARY, (LogicalTypeAnnotation)LogicalTypeAnnotation.stringType());
            }

            public SchemaMapping.TypeMapping visit(ArrowType.LargeUtf8 largeUtf8) {
                return this.primitive(PrimitiveType.PrimitiveTypeName.BINARY, (LogicalTypeAnnotation)LogicalTypeAnnotation.stringType());
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Utf8View type) {
                return this.primitive(PrimitiveType.PrimitiveTypeName.BINARY, (LogicalTypeAnnotation)LogicalTypeAnnotation.stringType());
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Binary type) {
                return this.primitive(PrimitiveType.PrimitiveTypeName.BINARY);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.BinaryView type) {
                return this.primitive(PrimitiveType.PrimitiveTypeName.BINARY);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.LargeBinary largeBinary) {
                return this.primitive(PrimitiveType.PrimitiveTypeName.BINARY);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Bool type) {
                return this.primitive(PrimitiveType.PrimitiveTypeName.BOOLEAN);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Decimal type) {
                int precision = type.getPrecision();
                int scale = type.getScale();
                if (1 <= precision && precision <= 9) {
                    return this.decimal(PrimitiveType.PrimitiveTypeName.INT32, precision, scale);
                }
                if (1 <= precision && precision <= 18) {
                    return this.decimal(PrimitiveType.PrimitiveTypeName.INT64, precision, scale);
                }
                return this.decimal(PrimitiveType.PrimitiveTypeName.BINARY, precision, scale);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Date type) {
                return this.primitive(PrimitiveType.PrimitiveTypeName.INT32, (LogicalTypeAnnotation)LogicalTypeAnnotation.dateType());
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Time type) {
                int bitWidth = type.getBitWidth();
                TimeUnit timeUnit = type.getUnit();
                if (bitWidth == 32 && timeUnit == TimeUnit.MILLISECOND) {
                    return this.primitive(PrimitiveType.PrimitiveTypeName.INT32, (LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS));
                }
                if (bitWidth == 64 && timeUnit == TimeUnit.MICROSECOND) {
                    return this.primitive(PrimitiveType.PrimitiveTypeName.INT64, (LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS));
                }
                if (bitWidth == 64 && timeUnit == TimeUnit.NANOSECOND) {
                    return this.primitive(PrimitiveType.PrimitiveTypeName.INT64, (LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS));
                }
                throw new UnsupportedOperationException("Unsupported type " + type);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Timestamp type) {
                TimeUnit timeUnit = type.getUnit();
                if (timeUnit == TimeUnit.MILLISECOND) {
                    return this.primitive(PrimitiveType.PrimitiveTypeName.INT64, (LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)this.isUtcNormalized(type), (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS));
                }
                if (timeUnit == TimeUnit.MICROSECOND) {
                    return this.primitive(PrimitiveType.PrimitiveTypeName.INT64, (LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)this.isUtcNormalized(type), (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS));
                }
                if (timeUnit == TimeUnit.NANOSECOND) {
                    return this.primitive(PrimitiveType.PrimitiveTypeName.INT64, (LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)this.isUtcNormalized(type), (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS));
                }
                throw new UnsupportedOperationException("Unsupported type " + type);
            }

            private boolean isUtcNormalized(ArrowType.Timestamp timestamp) {
                String timeZone = timestamp.getTimezone();
                return timeZone != null && !timeZone.isEmpty();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Interval type) {
                return this.primitiveFLBA(12, LogicalTypeAnnotation.IntervalLogicalTypeAnnotation.getInstance());
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Duration duration) {
                return this.primitiveFLBA(12, LogicalTypeAnnotation.IntervalLogicalTypeAnnotation.getInstance());
            }

            public SchemaMapping.TypeMapping visit(ArrowType.ExtensionType type) {
                return (SchemaMapping.TypeMapping)super.visit(type);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.FixedSizeBinary fixedSizeBinary) {
                return this.primitive(PrimitiveType.PrimitiveTypeName.BINARY);
            }

            private SchemaMapping.TypeMapping mapping(PrimitiveType parquetType) {
                return new SchemaMapping.PrimitiveTypeMapping(field, parquetType);
            }

            private SchemaMapping.TypeMapping decimal(PrimitiveType.PrimitiveTypeName type, int precision, int scale) {
                return this.mapping((PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)type).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)scale, (int)precision))).named(fieldName));
            }

            private SchemaMapping.TypeMapping primitive(PrimitiveType.PrimitiveTypeName type) {
                return this.mapping((PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)type).named(fieldName));
            }

            private SchemaMapping.TypeMapping primitive(PrimitiveType.PrimitiveTypeName type, LogicalTypeAnnotation otype) {
                return this.mapping((PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)type).as(otype)).named(fieldName));
            }

            private SchemaMapping.TypeMapping primitiveFLBA(int length, LogicalTypeAnnotation otype) {
                return this.mapping((PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(length)).as(otype)).named(fieldName));
            }
        });
    }

    public SchemaMapping fromParquet(MessageType parquetSchema) {
        List fields = parquetSchema.getFields();
        List<SchemaMapping.TypeMapping> mappings = this.fromParquet(fields);
        List<Field> arrowFields = this.fields(mappings);
        return new SchemaMapping(new Schema(arrowFields), parquetSchema, mappings);
    }

    private List<Field> fields(List<SchemaMapping.TypeMapping> mappings) {
        ArrayList<Field> result = new ArrayList<Field>(mappings.size());
        for (SchemaMapping.TypeMapping typeMapping : mappings) {
            result.add(typeMapping.getArrowField());
        }
        return result;
    }

    private List<SchemaMapping.TypeMapping> fromParquet(List<Type> fields) {
        ArrayList<SchemaMapping.TypeMapping> result = new ArrayList<SchemaMapping.TypeMapping>(fields.size());
        for (Type type : fields) {
            result.add(this.fromParquet(type));
        }
        return result;
    }

    private SchemaMapping.TypeMapping fromParquet(Type type) {
        return this.fromParquet(type, type.getName(), type.getRepetition());
    }

    private SchemaMapping.TypeMapping fromParquet(Type type, String name, Type.Repetition repetition) {
        if (repetition == Type.Repetition.REPEATED) {
            SchemaMapping.TypeMapping child = this.fromParquet(type, null, Type.Repetition.REQUIRED);
            Field arrowField = new Field(name, FieldType.notNullable((ArrowType)new ArrowType.List()), Collections.singletonList(child.getArrowField()));
            return new SchemaMapping.RepeatedTypeMapping(arrowField, type, child);
        }
        if (type.isPrimitive()) {
            return this.fromParquetPrimitive(type.asPrimitiveType(), name);
        }
        return this.fromParquetGroup(type.asGroupType(), name);
    }

    private SchemaMapping.TypeMapping fromParquetGroup(final GroupType type, final String name) {
        LogicalTypeAnnotation logicalType = type.getLogicalTypeAnnotation();
        if (logicalType == null) {
            FieldType field = type.isRepetition(Type.Repetition.OPTIONAL) ? FieldType.nullable((ArrowType)new ArrowType.Struct()) : FieldType.notNullable((ArrowType)new ArrowType.Struct());
            List<SchemaMapping.TypeMapping> typeMappings = this.fromParquet(type.getFields());
            Field arrowField = new Field(name, field, this.fields(typeMappings));
            return new SchemaMapping.StructTypeMapping(arrowField, type, typeMappings);
        }
        return (SchemaMapping.TypeMapping)logicalType.accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<SchemaMapping.TypeMapping>(){

            public Optional<SchemaMapping.TypeMapping> visit(LogicalTypeAnnotation.ListLogicalTypeAnnotation listLogicalType) {
                List3Levels list3Levels = new List3Levels(type);
                SchemaMapping.TypeMapping child = SchemaConverter.this.fromParquet(list3Levels.getElement(), null, list3Levels.getElement().getRepetition());
                Field arrowField = new Field(name, FieldType.nullable((ArrowType)new ArrowType.List()), Collections.singletonList(child.getArrowField()));
                return Optional.of(new SchemaMapping.ListTypeMapping(arrowField, list3Levels, child));
            }

            public Optional<SchemaMapping.TypeMapping> visit(LogicalTypeAnnotation.MapLogicalTypeAnnotation mapLogicalType) {
                Map3Levels map3levels = new Map3Levels(type);
                SchemaMapping.TypeMapping keyType = SchemaConverter.this.fromParquet(map3levels.getKey(), null, map3levels.getKey().getRepetition());
                SchemaMapping.TypeMapping valueType = SchemaConverter.this.fromParquet(map3levels.getValue(), null, map3levels.getValue().getRepetition());
                Field arrowField = new Field(name, FieldType.nullable((ArrowType)new ArrowType.Map(false)), Arrays.asList(keyType.getArrowField(), valueType.getArrowField()));
                return Optional.of(new SchemaMapping.MapTypeMapping(arrowField, map3levels, keyType, valueType));
            }
        }).orElseThrow(() -> new UnsupportedOperationException("Unsupported type " + type));
    }

    private SchemaMapping.TypeMapping fromParquetPrimitive(final PrimitiveType type, final String name) {
        return (SchemaMapping.TypeMapping)type.getPrimitiveTypeName().convert((PrimitiveType.PrimitiveTypeNameConverter)new PrimitiveType.PrimitiveTypeNameConverter<SchemaMapping.TypeMapping, RuntimeException>(){

            private SchemaMapping.TypeMapping field(ArrowType arrowType) {
                Field field = type.isRepetition(Type.Repetition.OPTIONAL) ? Field.nullable((String)name, (ArrowType)arrowType) : Field.notNullable((String)name, (ArrowType)arrowType);
                return new SchemaMapping.PrimitiveTypeMapping(field, type);
            }

            public SchemaMapping.TypeMapping convertFLOAT(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                return this.field((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE));
            }

            public SchemaMapping.TypeMapping convertDOUBLE(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                return this.field((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE));
            }

            public SchemaMapping.TypeMapping convertINT32(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                LogicalTypeAnnotation logicalTypeAnnotation = type.getLogicalTypeAnnotation();
                if (logicalTypeAnnotation == null) {
                    return this.integer(32, true);
                }
                return (SchemaMapping.TypeMapping)logicalTypeAnnotation.accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<SchemaMapping.TypeMapping>(){

                    public Optional<SchemaMapping.TypeMapping> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType) {
                        return Optional.of(this.decimal(decimalLogicalType.getPrecision(), decimalLogicalType.getScale()));
                    }

                    public Optional<SchemaMapping.TypeMapping> visit(LogicalTypeAnnotation.DateLogicalTypeAnnotation dateLogicalType) {
                        return Optional.of(this.field((ArrowType)new ArrowType.Date(DateUnit.DAY)));
                    }

                    public Optional<SchemaMapping.TypeMapping> visit(LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeLogicalType) {
                        return timeLogicalType.getUnit() == LogicalTypeAnnotation.TimeUnit.MILLIS ? Optional.of(this.field((ArrowType)new ArrowType.Time(TimeUnit.MILLISECOND, 32))) : Optional.empty();
                    }

                    public Optional<SchemaMapping.TypeMapping> visit(LogicalTypeAnnotation.IntLogicalTypeAnnotation intLogicalType) {
                        if (intLogicalType.getBitWidth() == 64) {
                            return Optional.empty();
                        }
                        return Optional.of(this.integer(intLogicalType.getBitWidth(), intLogicalType.isSigned()));
                    }
                }).orElseThrow(() -> new IllegalArgumentException("illegal type " + type));
            }

            public SchemaMapping.TypeMapping convertINT64(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                LogicalTypeAnnotation logicalTypeAnnotation = type.getLogicalTypeAnnotation();
                if (logicalTypeAnnotation == null) {
                    return this.integer(64, true);
                }
                return (SchemaMapping.TypeMapping)logicalTypeAnnotation.accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<SchemaMapping.TypeMapping>(){

                    public Optional<SchemaMapping.TypeMapping> visit(LogicalTypeAnnotation.DateLogicalTypeAnnotation dateLogicalType) {
                        return Optional.of(this.field((ArrowType)new ArrowType.Date(DateUnit.DAY)));
                    }

                    public Optional<SchemaMapping.TypeMapping> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType) {
                        return Optional.of(this.decimal(decimalLogicalType.getPrecision(), decimalLogicalType.getScale()));
                    }

                    public Optional<SchemaMapping.TypeMapping> visit(LogicalTypeAnnotation.IntLogicalTypeAnnotation intLogicalType) {
                        return Optional.of(this.integer(intLogicalType.getBitWidth(), intLogicalType.isSigned()));
                    }

                    public Optional<SchemaMapping.TypeMapping> visit(LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeLogicalType) {
                        if (timeLogicalType.getUnit() == LogicalTypeAnnotation.TimeUnit.MICROS) {
                            return Optional.of(this.field((ArrowType)new ArrowType.Time(TimeUnit.MICROSECOND, 64)));
                        }
                        if (timeLogicalType.getUnit() == LogicalTypeAnnotation.TimeUnit.NANOS) {
                            return Optional.of(this.field((ArrowType)new ArrowType.Time(TimeUnit.NANOSECOND, 64)));
                        }
                        return Optional.empty();
                    }

                    public Optional<SchemaMapping.TypeMapping> visit(LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalType) {
                        switch (timestampLogicalType.getUnit()) {
                            case MICROS: {
                                return Optional.of(this.field((ArrowType)new ArrowType.Timestamp(TimeUnit.MICROSECOND, this.getTimeZone(timestampLogicalType))));
                            }
                            case MILLIS: {
                                return Optional.of(this.field((ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, this.getTimeZone(timestampLogicalType))));
                            }
                            case NANOS: {
                                return Optional.of(this.field((ArrowType)new ArrowType.Timestamp(TimeUnit.NANOSECOND, this.getTimeZone(timestampLogicalType))));
                            }
                        }
                        return Optional.empty();
                    }

                    private String getTimeZone(LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalType) {
                        return timestampLogicalType.isAdjustedToUTC() ? "UTC" : null;
                    }
                }).orElseThrow(() -> new IllegalArgumentException("illegal type " + type));
            }

            public SchemaMapping.TypeMapping convertINT96(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                if (SchemaConverter.this.convertInt96ToArrowTimestamp) {
                    return this.field((ArrowType)new ArrowType.Timestamp(TimeUnit.NANOSECOND, null));
                }
                return this.field((ArrowType)new ArrowType.Binary());
            }

            public SchemaMapping.TypeMapping convertFIXED_LEN_BYTE_ARRAY(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                LogicalTypeAnnotation logicalTypeAnnotation = type.getLogicalTypeAnnotation();
                if (logicalTypeAnnotation == null) {
                    return this.field((ArrowType)new ArrowType.Binary());
                }
                return (SchemaMapping.TypeMapping)logicalTypeAnnotation.accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<SchemaMapping.TypeMapping>(){

                    public Optional<SchemaMapping.TypeMapping> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType) {
                        return Optional.of(this.decimal(decimalLogicalType.getPrecision(), decimalLogicalType.getScale()));
                    }
                }).orElseThrow(() -> new IllegalArgumentException("illegal type " + type));
            }

            public SchemaMapping.TypeMapping convertBOOLEAN(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                return this.field((ArrowType)new ArrowType.Bool());
            }

            public SchemaMapping.TypeMapping convertBINARY(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws RuntimeException {
                LogicalTypeAnnotation logicalTypeAnnotation = type.getLogicalTypeAnnotation();
                if (logicalTypeAnnotation == null) {
                    return this.field((ArrowType)new ArrowType.Binary());
                }
                return (SchemaMapping.TypeMapping)logicalTypeAnnotation.accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<SchemaMapping.TypeMapping>(){

                    public Optional<SchemaMapping.TypeMapping> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation stringLogicalType) {
                        return Optional.of(this.field((ArrowType)new ArrowType.Utf8()));
                    }

                    public Optional<SchemaMapping.TypeMapping> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType) {
                        return Optional.of(this.decimal(decimalLogicalType.getPrecision(), decimalLogicalType.getScale()));
                    }
                }).orElseThrow(() -> new IllegalArgumentException("illegal type " + type));
            }

            private SchemaMapping.TypeMapping decimal(int precision, int scale) {
                return this.field((ArrowType)new ArrowType.Decimal(precision, scale));
            }

            private SchemaMapping.TypeMapping integer(int width, boolean signed) {
                return this.field((ArrowType)new ArrowType.Int(width, signed));
            }
        });
    }

    public SchemaMapping map(Schema arrowSchema, MessageType parquetSchema) {
        List<SchemaMapping.TypeMapping> children = this.map(arrowSchema.getFields(), parquetSchema.getFields());
        return new SchemaMapping(arrowSchema, parquetSchema, children);
    }

    private List<SchemaMapping.TypeMapping> map(List<Field> arrowFields, List<Type> parquetFields) {
        if (arrowFields.size() != parquetFields.size()) {
            throw new IllegalArgumentException("Can not map schemas as sizes differ: " + arrowFields + " != " + parquetFields);
        }
        ArrayList<SchemaMapping.TypeMapping> result = new ArrayList<SchemaMapping.TypeMapping>(arrowFields.size());
        for (int i = 0; i < arrowFields.size(); ++i) {
            Field arrowField = arrowFields.get(i);
            Type parquetField = parquetFields.get(i);
            result.add(this.map(arrowField, parquetField));
        }
        return result;
    }

    private SchemaMapping.TypeMapping map(final Field arrowField, final Type parquetField) {
        return (SchemaMapping.TypeMapping)arrowField.getType().accept((ArrowType.ArrowTypeVisitor)new ArrowType.ArrowTypeVisitor<SchemaMapping.TypeMapping>(){

            public SchemaMapping.TypeMapping visit(ArrowType.Null type) {
                if (!parquetField.isRepetition(Type.Repetition.OPTIONAL)) {
                    throw new IllegalArgumentException("Parquet type can't be null: " + parquetField);
                }
                return this.primitive();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Struct type) {
                if (parquetField.isPrimitive()) {
                    throw new IllegalArgumentException("Parquet type not a group: " + parquetField);
                }
                GroupType groupType = parquetField.asGroupType();
                return new SchemaMapping.StructTypeMapping(arrowField, groupType, (List<SchemaMapping.TypeMapping>)SchemaConverter.this.map(arrowField.getChildren(), groupType.getFields()));
            }

            public SchemaMapping.TypeMapping visit(ArrowType.List type) {
                return this.createListTypeMapping((ArrowType.ComplexType)type);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.LargeList largeList) {
                return this.createListTypeMapping((ArrowType.ComplexType)largeList);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.FixedSizeList type) {
                return this.createListTypeMapping((ArrowType.ComplexType)type);
            }

            public SchemaMapping.TypeMapping visit(ArrowType.ListView type) {
                return this.createListTypeMapping((ArrowType.ComplexType)type);
            }

            private SchemaMapping.TypeMapping createListTypeMapping(ArrowType.ComplexType type) {
                if (arrowField.getChildren().size() != 1) {
                    throw new IllegalArgumentException("Invalid list type: " + type);
                }
                Field arrowChild = (Field)arrowField.getChildren().get(0);
                if (parquetField.isRepetition(Type.Repetition.REPEATED)) {
                    return new SchemaMapping.RepeatedTypeMapping(arrowField, parquetField, SchemaConverter.this.map(arrowChild, parquetField));
                }
                if (parquetField.isPrimitive()) {
                    throw new IllegalArgumentException("Parquet type not a group: " + parquetField);
                }
                List3Levels list3Levels = new List3Levels(parquetField.asGroupType());
                if (arrowField.getChildren().size() != 1) {
                    throw new IllegalArgumentException("invalid arrow list: " + arrowField);
                }
                return new SchemaMapping.ListTypeMapping(arrowField, list3Levels, SchemaConverter.this.map(arrowChild, list3Levels.getElement()));
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Union type) {
                if (parquetField.isPrimitive()) {
                    throw new IllegalArgumentException("Parquet type not a group: " + parquetField);
                }
                GroupType groupType = parquetField.asGroupType();
                return new SchemaMapping.UnionTypeMapping(arrowField, groupType, (List<SchemaMapping.TypeMapping>)SchemaConverter.this.map(arrowField.getChildren(), groupType.getFields()));
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Map map) {
                if (arrowField.getChildren().size() != 2) {
                    throw new IllegalArgumentException("Invalid map type: " + map);
                }
                if (parquetField.isPrimitive()) {
                    throw new IllegalArgumentException("Parquet type not a group: " + parquetField);
                }
                Map3Levels map3levels = new Map3Levels(parquetField.asGroupType());
                if (arrowField.getChildren().size() != 2) {
                    throw new IllegalArgumentException("invalid arrow map: " + arrowField);
                }
                Field keyChild = (Field)arrowField.getChildren().get(0);
                Field valueChild = (Field)arrowField.getChildren().get(1);
                return new SchemaMapping.MapTypeMapping(arrowField, map3levels, SchemaConverter.this.map(keyChild, map3levels.getKey()), SchemaConverter.this.map(valueChild, map3levels.getValue()));
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Int type) {
                return this.primitive();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.FloatingPoint type) {
                return this.primitive();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Utf8 type) {
                return this.primitive();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.LargeUtf8 largeUtf8) {
                return this.primitive();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Utf8View type) {
                return this.primitive();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Binary type) {
                return this.primitive();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.LargeBinary largeBinary) {
                return this.primitive();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.BinaryView type) {
                return this.primitive();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Bool type) {
                return this.primitive();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Decimal type) {
                return this.primitive();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Date type) {
                return this.primitive();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Time type) {
                return this.primitive();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Timestamp type) {
                return this.primitive();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Interval type) {
                return this.primitive();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.Duration duration) {
                return this.primitive();
            }

            public SchemaMapping.TypeMapping visit(ArrowType.FixedSizeBinary fixedSizeBinary) {
                return this.primitive();
            }

            private SchemaMapping.TypeMapping primitive() {
                if (!parquetField.isPrimitive()) {
                    throw new IllegalArgumentException("Can not map schemas as one is primitive and the other is not: " + arrowField + " != " + parquetField);
                }
                return new SchemaMapping.PrimitiveTypeMapping(arrowField, parquetField.asPrimitiveType());
            }
        });
    }
}

