/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.arrow.schema;

import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.Type;

class List3Levels {
    private final GroupType list;
    private final GroupType repeated;
    private final Type element;

    public List3Levels(GroupType list) {
        if (list.getLogicalTypeAnnotation() != LogicalTypeAnnotation.listType() || list.getFields().size() != 1) {
            throw new IllegalArgumentException("invalid list type: " + list);
        }
        this.list = list;
        Type repeatedField = (Type)list.getFields().get(0);
        if (repeatedField.isPrimitive() || !repeatedField.isRepetition(Type.Repetition.REPEATED) || repeatedField.asGroupType().getFields().size() != 1) {
            throw new IllegalArgumentException("invalid list type: " + list);
        }
        this.repeated = repeatedField.asGroupType();
        this.element = (Type)this.repeated.getFields().get(0);
    }

    public GroupType getList() {
        return this.list;
    }

    public GroupType getRepeated() {
        return this.repeated;
    }

    public Type getElement() {
        return this.element;
    }
}

