/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.avro;

import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.chars.CharArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.Stringable;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.util.ClassUtils;
import org.apache.parquet.Preconditions;
import org.apache.parquet.avro.AvroConverters;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.avro.ParentValueContainer;
import org.apache.parquet.io.InvalidRecordException;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

class AvroRecordConverter<T>
extends AvroConverters.AvroGroupConverter {
    private static final String STRINGABLE_PROP = "avro.java.string";
    private static final String JAVA_CLASS_PROP = "java-class";
    private static final String JAVA_KEY_CLASS_PROP = "java-key-class";
    protected T currentRecord;
    private final Converter[] converters;
    private final Schema avroSchema;
    private final GenericData model;
    private final Map<Schema.Field, Object> recordDefaults = new HashMap<Schema.Field, Object>();

    public AvroRecordConverter(MessageType parquetSchema, Schema avroSchema, GenericData baseModel) {
        this(null, (GroupType)parquetSchema, avroSchema, baseModel);
    }

    public AvroRecordConverter(ParentValueContainer parent, GroupType parquetSchema, Schema avroSchema, GenericData model) {
        super(parent);
        this.avroSchema = avroSchema;
        this.model = model == null ? ReflectData.get() : model;
        this.converters = new Converter[parquetSchema.getFieldCount()];
        HashMap<String, Integer> avroFieldIndexes = new HashMap<String, Integer>();
        int avroFieldIndex = 0;
        for (Schema.Field field : avroSchema.getFields()) {
            avroFieldIndexes.put(field.name(), avroFieldIndex++);
        }
        Class<T> recordClass = null;
        if (model instanceof ReflectData) {
            recordClass = AvroRecordConverter.getDatumClass(avroSchema, model);
        }
        int parquetFieldIndex = 0;
        for (Type parquetField : parquetSchema.getFields()) {
            final Schema.Field avroField = this.getAvroField(parquetField.getName());
            Schema nonNullSchema = AvroSchemaConverter.getNonNull(avroField.schema());
            final int finalAvroIndex = (Integer)avroFieldIndexes.remove(avroField.name());
            ParentValueContainer container = new ParentValueContainer(){

                @Override
                public void add(Object value) {
                    AvroRecordConverter.this.set(avroField.name(), finalAvroIndex, value);
                }
            };
            this.converters[parquetFieldIndex] = AvroRecordConverter.newConverter(nonNullSchema, parquetField, this.model, container);
            if (recordClass != null && this.converters[parquetFieldIndex] instanceof AvroConverters.FieldStringConverter) {
                try {
                    Field field = recordClass.getDeclaredField(avroField.name());
                    if (field.isAnnotationPresent(Stringable.class)) {
                        this.converters[parquetFieldIndex] = new AvroConverters.FieldStringableConverter(container, field.getType());
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
            ++parquetFieldIndex;
        }
        for (String fieldName : avroFieldIndexes.keySet()) {
            Schema.Field field = avroSchema.getField(fieldName);
            if (field.schema().getType() == Schema.Type.NULL || field.defaultValue() == null || this.model.getDefaultValue(field) == null) continue;
            this.recordDefaults.put(field, this.model.getDefaultValue(field));
        }
    }

    private Schema.Field getAvroField(String parquetFieldName) {
        Schema.Field avroField = this.avroSchema.getField(parquetFieldName);
        if (avroField != null) {
            return avroField;
        }
        for (Schema.Field f : this.avroSchema.getFields()) {
            if (!f.aliases().contains(parquetFieldName)) continue;
            return f;
        }
        throw new InvalidRecordException(String.format("Parquet/Avro schema mismatch: Avro field '%s' not found", parquetFieldName));
    }

    private static Converter newConverter(Schema schema, Type type, GenericData model, ParentValueContainer parent) {
        if (schema.getType().equals((Object)Schema.Type.BOOLEAN)) {
            return new AvroConverters.FieldBooleanConverter(parent);
        }
        if (schema.getType().equals((Object)Schema.Type.INT)) {
            Class datumClass = AvroRecordConverter.getDatumClass(schema, model);
            if (datumClass == null) {
                return new AvroConverters.FieldIntegerConverter(parent);
            }
            if (datumClass == Byte.TYPE || datumClass == Byte.class) {
                return new AvroConverters.FieldByteConverter(parent);
            }
            if (datumClass == Short.TYPE || datumClass == Short.class) {
                return new AvroConverters.FieldShortConverter(parent);
            }
            if (datumClass == Character.TYPE || datumClass == Character.class) {
                return new AvroConverters.FieldCharConverter(parent);
            }
            return new AvroConverters.FieldIntegerConverter(parent);
        }
        if (schema.getType().equals((Object)Schema.Type.LONG)) {
            return new AvroConverters.FieldLongConverter(parent);
        }
        if (schema.getType().equals((Object)Schema.Type.FLOAT)) {
            return new AvroConverters.FieldFloatConverter(parent);
        }
        if (schema.getType().equals((Object)Schema.Type.DOUBLE)) {
            return new AvroConverters.FieldDoubleConverter(parent);
        }
        if (schema.getType().equals((Object)Schema.Type.BYTES)) {
            Class datumClass = AvroRecordConverter.getDatumClass(schema, model);
            if (datumClass == null) {
                return new AvroConverters.FieldByteBufferConverter(parent);
            }
            if (datumClass.isArray() && datumClass.getComponentType() == Byte.TYPE) {
                return new AvroConverters.FieldByteArrayConverter(parent);
            }
            return new AvroConverters.FieldByteBufferConverter(parent);
        }
        if (schema.getType().equals((Object)Schema.Type.STRING)) {
            return AvroRecordConverter.newStringConverter(schema, model, parent);
        }
        if (schema.getType().equals((Object)Schema.Type.RECORD)) {
            return new AvroRecordConverter(parent, type.asGroupType(), schema, model);
        }
        if (schema.getType().equals((Object)Schema.Type.ENUM)) {
            return new AvroConverters.FieldEnumConverter(parent, schema, model);
        }
        if (schema.getType().equals((Object)Schema.Type.ARRAY)) {
            Class datumClass = AvroRecordConverter.getDatumClass(schema, model);
            if (datumClass != null && datumClass.isArray()) {
                return new AvroArrayConverter(parent, type.asGroupType(), schema, model, datumClass);
            }
            return new AvroCollectionConverter(parent, type.asGroupType(), schema, model, datumClass);
        }
        if (schema.getType().equals((Object)Schema.Type.MAP)) {
            return new MapConverter(parent, type.asGroupType(), schema, model);
        }
        if (schema.getType().equals((Object)Schema.Type.UNION)) {
            return new AvroUnionConverter(parent, type, schema, model);
        }
        if (schema.getType().equals((Object)Schema.Type.FIXED)) {
            return new AvroConverters.FieldFixedConverter(parent, schema, model);
        }
        throw new UnsupportedOperationException(String.format("Cannot convert Avro type: %s to Parquet type: %s", schema, type));
    }

    private static Converter newStringConverter(Schema schema, GenericData model, ParentValueContainer parent) {
        Class<?> stringableClass = AvroRecordConverter.getStringableClass(schema, model);
        if (stringableClass == String.class) {
            return new AvroConverters.FieldStringConverter(parent);
        }
        if (stringableClass == CharSequence.class) {
            return new AvroConverters.FieldUTF8Converter(parent);
        }
        return new AvroConverters.FieldStringableConverter(parent, stringableClass);
    }

    private static Class<?> getStringableClass(Schema schema, GenericData model) {
        boolean isMap;
        String stringableClass;
        if (model instanceof SpecificData && (stringableClass = schema.getProp((isMap = schema.getType() == Schema.Type.MAP) ? JAVA_KEY_CLASS_PROP : JAVA_CLASS_PROP)) != null) {
            try {
                return ClassUtils.forName((ClassLoader)model.getClassLoader(), (String)stringableClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (ReflectData.class.isAssignableFrom(model.getClass())) {
            return String.class;
        }
        String name = schema.getProp(STRINGABLE_PROP);
        if (name == null) {
            return CharSequence.class;
        }
        switch (GenericData.StringType.valueOf((String)name)) {
            case String: {
                return String.class;
            }
        }
        return CharSequence.class;
    }

    private static <T> Class<T> getDatumClass(Schema schema, GenericData model) {
        Method getClassMethod;
        if (model instanceof SpecificData) {
            return ((SpecificData)model).getClass(schema);
        }
        if (model.getClass() == GenericData.class) {
            return null;
        }
        Class<?> modelClass = model.getClass();
        try {
            getClassMethod = modelClass.getMethod("getClass", Schema.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        try {
            return (Class)getClassMethod.invoke((Object)schema, new Object[0]);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    protected void set(String name, int avroIndex, Object value) {
        this.model.setField(this.currentRecord, name, avroIndex, value);
    }

    public Converter getConverter(int fieldIndex) {
        return this.converters[fieldIndex];
    }

    public void start() {
        this.currentRecord = this.model.newRecord(null, this.avroSchema);
    }

    public void end() {
        this.fillInDefaults();
        if (this.parent != null) {
            this.parent.add(this.currentRecord);
        }
    }

    private void fillInDefaults() {
        for (Map.Entry<Schema.Field, Object> entry : this.recordDefaults.entrySet()) {
            Schema.Field f = entry.getKey();
            Object defaultValue = this.deepCopy(f.schema(), entry.getValue());
            this.set(f.name(), f.pos(), defaultValue);
        }
    }

    private Object deepCopy(Schema schema, Object value) {
        switch (schema.getType()) {
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return value;
            }
        }
        return this.model.deepCopy(schema, value);
    }

    T getCurrentRecord() {
        return this.currentRecord;
    }

    private static boolean isElementType(Type repeatedType, Schema elementSchema) {
        if (repeatedType.isPrimitive() || repeatedType.asGroupType().getFieldCount() > 1) {
            return true;
        }
        return elementSchema != null && elementSchema.getType() == Schema.Type.RECORD && elementSchema.getFields().size() == 1 && ((Schema.Field)elementSchema.getFields().get(0)).name().equals(repeatedType.asGroupType().getFieldName(0));
    }

    static final class MapConverter<K, V>
    extends GroupConverter {
        private final ParentValueContainer parent;
        private final Converter keyValueConverter;
        private final Schema schema;
        private final Class<?> mapClass;
        private Map<K, V> map;

        public MapConverter(ParentValueContainer parent, GroupType mapType, Schema mapSchema, GenericData model) {
            this.parent = parent;
            GroupType repeatedKeyValueType = mapType.getType(0).asGroupType();
            this.keyValueConverter = new MapKeyValueConverter(repeatedKeyValueType, mapSchema, model);
            this.schema = mapSchema;
            this.mapClass = AvroRecordConverter.getDatumClass(mapSchema, model);
        }

        public Converter getConverter(int fieldIndex) {
            return this.keyValueConverter;
        }

        public void start() {
            this.map = this.newMap();
        }

        public void end() {
            this.parent.add(this.map);
        }

        private Map<K, V> newMap() {
            if (this.mapClass == null || this.mapClass.isAssignableFrom(HashMap.class)) {
                return new HashMap();
            }
            return (Map)ReflectData.newInstance(this.mapClass, (Schema)this.schema);
        }

        final class MapKeyValueConverter
        extends GroupConverter {
            private K key;
            private V value;
            private final Converter keyConverter;
            private final Converter valueConverter;

            public MapKeyValueConverter(GroupType keyValueType, Schema mapSchema, GenericData model) {
                this.keyConverter = AvroRecordConverter.newStringConverter(mapSchema, model, new ParentValueContainer(){

                    @Override
                    public void add(Object value) {
                        MapKeyValueConverter.this.key = value;
                    }
                });
                Type valueType = keyValueType.getType(1);
                Schema nonNullValueSchema = AvroSchemaConverter.getNonNull(mapSchema.getValueType());
                this.valueConverter = AvroRecordConverter.newConverter(nonNullValueSchema, valueType, model, new ParentValueContainer(){

                    @Override
                    public void add(Object value) {
                        MapKeyValueConverter.this.value = value;
                    }
                });
            }

            public Converter getConverter(int fieldIndex) {
                if (fieldIndex == 0) {
                    return this.keyConverter;
                }
                if (fieldIndex == 1) {
                    return this.valueConverter;
                }
                throw new IllegalArgumentException("only the key (0) and value (1) fields expected: " + fieldIndex);
            }

            public void start() {
                this.key = null;
                this.value = null;
            }

            public void end() {
                MapConverter.this.map.put(this.key, this.value);
            }
        }
    }

    static final class AvroUnionConverter
    extends AvroConverters.AvroGroupConverter {
        private final Converter[] memberConverters;
        private Object memberValue = null;

        public AvroUnionConverter(ParentValueContainer parent, Type parquetSchema, Schema avroSchema, GenericData model) {
            super(parent);
            GroupType parquetGroup = parquetSchema.asGroupType();
            this.memberConverters = new Converter[parquetGroup.getFieldCount()];
            int parquetIndex = 0;
            for (int index = 0; index < avroSchema.getTypes().size(); ++index) {
                Schema memberSchema = (Schema)avroSchema.getTypes().get(index);
                if (memberSchema.getType().equals((Object)Schema.Type.NULL)) continue;
                Type memberType = parquetGroup.getType(parquetIndex);
                this.memberConverters[parquetIndex] = AvroRecordConverter.newConverter(memberSchema, memberType, model, new ParentValueContainer(){

                    @Override
                    public void add(Object value) {
                        Preconditions.checkArgument((AvroUnionConverter.this.memberValue == null ? 1 : 0) != 0, (String)"Union is resolving to more than one type");
                        AvroUnionConverter.this.memberValue = value;
                    }
                });
                ++parquetIndex;
            }
        }

        public Converter getConverter(int fieldIndex) {
            return this.memberConverters[fieldIndex];
        }

        public void start() {
            this.memberValue = null;
        }

        public void end() {
            this.parent.add(this.memberValue);
        }
    }

    static final class AvroArrayConverter
    extends GroupConverter {
        private final ParentValueContainer parent;
        private final Schema avroSchema;
        private final Converter converter;
        private Class<?> elementClass;
        private Collection<?> container;

        public AvroArrayConverter(ParentValueContainer parent, GroupType type, Schema avroSchema, GenericData model, Class<?> arrayClass) {
            this.parent = parent;
            this.avroSchema = avroSchema;
            Preconditions.checkArgument((boolean)arrayClass.isArray(), (String)("Cannot convert non-array: " + arrayClass.getName()));
            this.elementClass = arrayClass.getComponentType();
            ParentValueContainer setter = this.createSetterAndContainer();
            Schema elementSchema = this.avroSchema.getElementType();
            Type repeatedType = type.getType(0);
            this.converter = AvroRecordConverter.isElementType(repeatedType, elementSchema) ? AvroRecordConverter.newConverter(elementSchema, repeatedType, model, setter) : new PrimitiveElementConverter(repeatedType.asGroupType(), elementSchema, model, setter);
        }

        public Converter getConverter(int fieldIndex) {
            return this.converter;
        }

        public void start() {
            this.container.clear();
        }

        public void end() {
            if (this.elementClass == Boolean.TYPE) {
                this.parent.add(((BooleanArrayList)this.container).toBooleanArray());
            } else if (this.elementClass == Byte.TYPE) {
                this.parent.add(((ByteArrayList)this.container).toByteArray());
            } else if (this.elementClass == Character.TYPE) {
                this.parent.add(((CharArrayList)this.container).toCharArray());
            } else if (this.elementClass == Short.TYPE) {
                this.parent.add(((ShortArrayList)this.container).toShortArray());
            } else if (this.elementClass == Integer.TYPE) {
                this.parent.add(((IntArrayList)this.container).toIntArray());
            } else if (this.elementClass == Long.TYPE) {
                this.parent.add(((LongArrayList)this.container).toLongArray());
            } else if (this.elementClass == Float.TYPE) {
                this.parent.add(((FloatArrayList)this.container).toFloatArray());
            } else if (this.elementClass == Double.TYPE) {
                this.parent.add(((DoubleArrayList)this.container).toDoubleArray());
            } else {
                this.parent.add(((ArrayList)this.container).toArray());
            }
        }

        private ParentValueContainer createSetterAndContainer() {
            if (this.elementClass == Boolean.TYPE) {
                BooleanArrayList list;
                this.container = list = new BooleanArrayList();
                return new ParentValueContainer(){

                    @Override
                    public void addBoolean(boolean value) {
                        list.add(value);
                    }
                };
            }
            if (this.elementClass == Byte.TYPE) {
                ByteArrayList list;
                this.container = list = new ByteArrayList();
                return new ParentValueContainer(){

                    @Override
                    public void addByte(byte value) {
                        list.add(value);
                    }
                };
            }
            if (this.elementClass == Character.TYPE) {
                CharArrayList list;
                this.container = list = new CharArrayList();
                return new ParentValueContainer(){

                    @Override
                    public void addChar(char value) {
                        list.add(value);
                    }
                };
            }
            if (this.elementClass == Short.TYPE) {
                ShortArrayList list;
                this.container = list = new ShortArrayList();
                return new ParentValueContainer(){

                    @Override
                    public void addShort(short value) {
                        list.add(value);
                    }
                };
            }
            if (this.elementClass == Integer.TYPE) {
                IntArrayList list;
                this.container = list = new IntArrayList();
                return new ParentValueContainer(){

                    @Override
                    public void addInt(int value) {
                        list.add(value);
                    }
                };
            }
            if (this.elementClass == Long.TYPE) {
                LongArrayList list;
                this.container = list = new LongArrayList();
                return new ParentValueContainer(){

                    @Override
                    public void addLong(long value) {
                        list.add(value);
                    }
                };
            }
            if (this.elementClass == Float.TYPE) {
                FloatArrayList list;
                this.container = list = new FloatArrayList();
                return new ParentValueContainer(){

                    @Override
                    public void addFloat(float value) {
                        list.add(value);
                    }
                };
            }
            if (this.elementClass == Double.TYPE) {
                DoubleArrayList list;
                this.container = list = new DoubleArrayList();
                return new ParentValueContainer(){

                    @Override
                    public void addDouble(double value) {
                        list.add(value);
                    }
                };
            }
            final ArrayList list = new ArrayList();
            this.container = list;
            return new ParentValueContainer(){

                @Override
                public void add(Object value) {
                    list.add(value);
                }
            };
        }

        final class PrimitiveElementConverter
        extends GroupConverter {
            private boolean isSet;
            private final Converter elementConverter;

            public PrimitiveElementConverter(GroupType repeatedType, Schema elementSchema, GenericData model, final ParentValueContainer setter) {
                Type elementType = repeatedType.getType(0);
                Preconditions.checkArgument((!AvroArrayConverter.this.elementClass.isPrimitive() || elementType.isRepetition(Type.Repetition.REQUIRED) ? 1 : 0) != 0, (String)"Cannot convert list of optional elements to primitive array");
                Schema nonNullElementSchema = AvroSchemaConverter.getNonNull(elementSchema);
                this.elementConverter = AvroRecordConverter.newConverter(nonNullElementSchema, elementType, model, new ParentValueContainer(){

                    @Override
                    public void add(Object value) {
                        PrimitiveElementConverter.this.isSet = true;
                        setter.add(value);
                    }

                    @Override
                    public void addByte(byte value) {
                        PrimitiveElementConverter.this.isSet = true;
                        setter.addByte(value);
                    }

                    @Override
                    public void addBoolean(boolean value) {
                        PrimitiveElementConverter.this.isSet = true;
                        setter.addBoolean(value);
                    }

                    @Override
                    public void addChar(char value) {
                        PrimitiveElementConverter.this.isSet = true;
                        setter.addChar(value);
                    }

                    @Override
                    public void addShort(short value) {
                        PrimitiveElementConverter.this.isSet = true;
                        setter.addShort(value);
                    }

                    @Override
                    public void addInt(int value) {
                        PrimitiveElementConverter.this.isSet = true;
                        setter.addInt(value);
                    }

                    @Override
                    public void addLong(long value) {
                        PrimitiveElementConverter.this.isSet = true;
                        setter.addLong(value);
                    }

                    @Override
                    public void addFloat(float value) {
                        PrimitiveElementConverter.this.isSet = true;
                        setter.addFloat(value);
                    }

                    @Override
                    public void addDouble(double value) {
                        PrimitiveElementConverter.this.isSet = true;
                        setter.addDouble(value);
                    }
                });
            }

            public Converter getConverter(int fieldIndex) {
                Preconditions.checkArgument((fieldIndex == 0 ? 1 : 0) != 0, (String)("Illegal field index: " + fieldIndex));
                return this.elementConverter;
            }

            public void start() {
                this.isSet = false;
            }

            public void end() {
                if (!this.isSet) {
                    AvroArrayConverter.this.container.add(null);
                }
            }
        }
    }

    static final class AvroCollectionConverter
    extends GroupConverter {
        private final ParentValueContainer parent;
        private final Schema avroSchema;
        private final Converter converter;
        private Class<?> containerClass;
        private Collection<Object> container;

        public AvroCollectionConverter(ParentValueContainer parent, GroupType type, Schema avroSchema, GenericData model, Class<?> containerClass) {
            this.parent = parent;
            this.avroSchema = avroSchema;
            this.containerClass = containerClass;
            Schema elementSchema = AvroSchemaConverter.getNonNull(avroSchema.getElementType());
            Type repeatedType = type.getType(0);
            this.converter = AvroRecordConverter.isElementType(repeatedType, elementSchema) ? AvroRecordConverter.newConverter(elementSchema, repeatedType, model, new ParentValueContainer(){

                @Override
                public void add(Object value) {
                    AvroCollectionConverter.this.container.add(value);
                }
            }) : new ElementConverter(repeatedType.asGroupType(), elementSchema, model);
        }

        public Converter getConverter(int fieldIndex) {
            return this.converter;
        }

        public void start() {
            this.container = this.newContainer();
        }

        public void end() {
            this.parent.add(this.container);
        }

        private Collection<Object> newContainer() {
            if (this.containerClass == null) {
                return new GenericData.Array(0, this.avroSchema);
            }
            if (this.containerClass.isAssignableFrom(ArrayList.class)) {
                return new ArrayList<Object>();
            }
            return (Collection)ReflectData.newInstance(this.containerClass, (Schema)this.avroSchema);
        }

        final class ElementConverter
        extends GroupConverter {
            private Object element;
            private final Converter elementConverter;

            public ElementConverter(GroupType repeatedType, Schema elementSchema, GenericData model) {
                Type elementType = repeatedType.getType(0);
                Schema nonNullElementSchema = AvroSchemaConverter.getNonNull(elementSchema);
                this.elementConverter = AvroRecordConverter.newConverter(nonNullElementSchema, elementType, model, new ParentValueContainer(){

                    @Override
                    public void add(Object value) {
                        ElementConverter.this.element = value;
                    }
                });
            }

            public Converter getConverter(int fieldIndex) {
                Preconditions.checkArgument((fieldIndex == 0 ? 1 : 0) != 0, (String)("Illegal field index: " + fieldIndex));
                return this.elementConverter;
            }

            public void start() {
                this.element = null;
            }

            public void end() {
                AvroCollectionConverter.this.container.add(this.element);
            }
        }
    }
}

