/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.cli.BaseCommand;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.internal.column.columnindex.ColumnIndex;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.io.InputFile;
import org.slf4j.Logger;

@Parameters(commandDescription="Prints the column and offset indexes of a Parquet file")
public class ShowColumnIndexCommand
extends BaseCommand {
    @Parameter(description="<parquet path>")
    List<String> files;
    @Parameter(names={"-c", "--column"}, description="Shows the column/offset indexes for the given column only")
    List<String> ColumnPaths;
    @Parameter(names={"-r", "--row-group"}, description="Shows the column/offset indexes for the given row-groups only; row-groups are referenced by their indexes from 0")
    List<String> rowGroupIndexes;
    @Parameter(names={"-i", "--column-index"}, description="Shows the column indexes; active by default unless -o is used")
    boolean showColumnIndex;
    @Parameter(names={"-o", "--offset-index"}, description="Shows the offset indexes; active by default unless -i is used")
    boolean showOffsetIndex;

    public ShowColumnIndexCommand(Logger console) {
        super(console);
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Show only column indexes for column 'col' from a Parquet file", "-c col -i sample.parquet"});
    }

    @Override
    public int run() throws IOException {
        Preconditions.checkArgument((this.files != null && this.files.size() >= 1 ? 1 : 0) != 0, (Object)"A Parquet file is required.");
        Preconditions.checkArgument((this.files.size() == 1 ? 1 : 0) != 0, (Object)"Cannot process multiple Parquet files.");
        HadoopInputFile in = HadoopInputFile.fromPath((Path)this.qualifiedPath(this.files.get(0)), (Configuration)this.getConf());
        if (!this.showColumnIndex && !this.showOffsetIndex) {
            this.showColumnIndex = true;
            this.showOffsetIndex = true;
        }
        HashSet<String> rowGroupIndexSet = new HashSet<String>();
        if (this.rowGroupIndexes != null) {
            rowGroupIndexSet.addAll(this.rowGroupIndexes);
        }
        try (ParquetFileReader reader = ParquetFileReader.open((InputFile)in);){
            boolean firstBlock = true;
            int rowGroupIndex = 0;
            for (BlockMetaData block : reader.getFooter().getBlocks()) {
                if (!rowGroupIndexSet.isEmpty() && !rowGroupIndexSet.contains(Integer.toString(rowGroupIndex))) {
                    ++rowGroupIndex;
                    continue;
                }
                if (!firstBlock) {
                    this.console.info("");
                }
                firstBlock = false;
                this.console.info("row-group {}:", (Object)rowGroupIndex);
                for (ColumnChunkMetaData column : this.getColumns(block)) {
                    String path = column.getPath().toDotString();
                    if (this.showColumnIndex) {
                        this.console.info("column index for column {}:", (Object)path);
                        ColumnIndex columnIndex = reader.readColumnIndex(column);
                        if (columnIndex == null) {
                            this.console.info("NONE");
                        } else {
                            this.console.info(columnIndex.toString());
                        }
                    }
                    if (!this.showOffsetIndex) continue;
                    this.console.info("offset index for column {}:", (Object)path);
                    OffsetIndex offsetIndex = reader.readOffsetIndex(column);
                    if (offsetIndex == null) {
                        this.console.info("NONE");
                        continue;
                    }
                    this.console.info(offsetIndex.toString());
                }
                ++rowGroupIndex;
            }
        }
        return 0;
    }

    private List<ColumnChunkMetaData> getColumns(BlockMetaData block) {
        List columns = block.getColumns();
        if (this.ColumnPaths == null || this.ColumnPaths.isEmpty()) {
            return columns;
        }
        HashMap<String, ColumnChunkMetaData> pathMap = new HashMap<String, ColumnChunkMetaData>();
        for (ColumnChunkMetaData column : columns) {
            pathMap.put(column.getPath().toDotString(), column);
        }
        ArrayList<ColumnChunkMetaData> filtered = new ArrayList<ColumnChunkMetaData>();
        for (String path : this.ColumnPaths) {
            ColumnChunkMetaData column = (ColumnChunkMetaData)pathMap.get(path);
            if (column == null) continue;
            filtered.add(column);
        }
        return filtered;
    }
}

