/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.cli.BaseCommand;
import org.apache.parquet.cli.util.RawUtils;
import org.apache.parquet.format.CliUtils;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;
import org.slf4j.Logger;
import shaded.parquet.org.apache.thrift.TBase;

@Parameters(commandDescription="Print the Parquet file footer in json format")
public class ShowFooterCommand
extends BaseCommand {
    @Parameter(description="<parquet path>", required=true)
    String target;
    @Parameter(names={"-r", "--raw"}, description="Print the raw thrift object of the footer")
    boolean raw = false;

    public ShowFooterCommand(Logger console) {
        super(console);
    }

    @Override
    public int run() throws IOException {
        HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)this.qualifiedPath(this.target), (Configuration)this.getConf());
        this.console.info(this.raw ? this.readRawFooter((InputFile)inputFile) : this.readFooter((InputFile)inputFile));
        return 0;
    }

    private String readFooter(InputFile inputFile) throws JsonProcessingException, IOException {
        String json;
        try (ParquetFileReader reader = ParquetFileReader.open((InputFile)inputFile);){
            ParquetMetadata footer = reader.getFooter();
            ObjectMapper mapper = RawUtils.createObjectMapper();
            mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)footer);
        }
        return json;
    }

    private String readRawFooter(InputFile file) throws IOException {
        int FOOTER_LENGTH_SIZE;
        long fileLen = file.getLength();
        if (fileLen < (long)(ParquetFileWriter.MAGIC.length + (FOOTER_LENGTH_SIZE = 4) + ParquetFileWriter.MAGIC.length)) {
            throw new RuntimeException("Not a Parquet file (length is too low: " + fileLen + ")");
        }
        try (SeekableInputStream f = file.newStream();){
            String string = RawUtils.prettifyJson(CliUtils.toJson((TBase)RawUtils.readFooter(f, fileLen)));
            return string;
        }
    }

    @Override
    public List<String> getExamples() {
        return Arrays.asList("# Print the parquet-mr interpreted footer of the specified Parquet file in json format", "sample.parquet", "# Print the raw thrift footer object of the specified Parquet file in json format", "sample.parquet --raw");
    }
}

