/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column;

import java.util.HashMap;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.EncodingStats;
import org.junit.Assert;
import org.junit.Test;

public class TestEncodingStats {
    @Test
    public void testReusedBuilder() {
        EncodingStats.Builder builder = new EncodingStats.Builder();
        builder.withV2Pages();
        builder.addDictEncoding(Encoding.PLAIN);
        builder.addDataEncoding(Encoding.RLE_DICTIONARY, 3);
        builder.addDataEncoding(Encoding.DELTA_BYTE_ARRAY);
        builder.addDataEncoding(Encoding.DELTA_BYTE_ARRAY);
        EncodingStats stats1 = builder.build();
        HashMap<Encoding, Integer> expectedDictStats1 = new HashMap<Encoding, Integer>();
        expectedDictStats1.put(Encoding.PLAIN, 1);
        HashMap<Encoding, Integer> expectedDataStats1 = new HashMap<Encoding, Integer>();
        expectedDataStats1.put(Encoding.RLE_DICTIONARY, 3);
        expectedDataStats1.put(Encoding.DELTA_BYTE_ARRAY, 2);
        builder.clear();
        builder.addDataEncoding(Encoding.PLAIN);
        builder.addDataEncoding(Encoding.PLAIN);
        builder.addDataEncoding(Encoding.PLAIN);
        builder.addDataEncoding(Encoding.PLAIN);
        EncodingStats stats2 = builder.build();
        HashMap expectedDictStats2 = new HashMap();
        HashMap<Encoding, Integer> expectedDataStats2 = new HashMap<Encoding, Integer>();
        expectedDataStats2.put(Encoding.PLAIN, 4);
        Assert.assertEquals((String)"Dictionary stats should be correct", expectedDictStats2, (Object)stats2.dictStats);
        Assert.assertEquals((String)"Data stats should be correct", expectedDataStats2, (Object)stats2.dataStats);
        Assert.assertEquals((String)"Dictionary stats should be correct after reuse", expectedDictStats1, (Object)stats1.dictStats);
        Assert.assertEquals((String)"Data stats should be correct after reuse", expectedDataStats1, (Object)stats1.dataStats);
    }

    @Test
    public void testNoPages() {
        EncodingStats.Builder builder = new EncodingStats.Builder();
        EncodingStats stats = builder.build();
        Assert.assertFalse((boolean)stats.usesV2Pages());
        Assert.assertFalse((String)"Should not have dictionary-encoded pages", (boolean)stats.hasDictionaryEncodedPages());
        Assert.assertFalse((String)"Should not have non-dictionary pages", (boolean)stats.hasNonDictionaryEncodedPages());
        Assert.assertFalse((String)"Should not have dictionary pages", (boolean)stats.hasDictionaryPages());
    }

    @Test
    public void testNoDataPages() {
        EncodingStats.Builder builder = new EncodingStats.Builder();
        builder.addDictEncoding(Encoding.PLAIN_DICTIONARY);
        EncodingStats stats = builder.build();
        Assert.assertFalse((boolean)stats.usesV2Pages());
        Assert.assertFalse((String)"Should not have dictionary-encoded pages", (boolean)stats.hasDictionaryEncodedPages());
        Assert.assertFalse((String)"Should not have non-dictionary pages", (boolean)stats.hasNonDictionaryEncodedPages());
        Assert.assertTrue((String)"Should have dictionary pages", (boolean)stats.hasDictionaryPages());
    }

    @Test
    public void testV1AllDictionary() {
        EncodingStats.Builder builder = new EncodingStats.Builder();
        builder.addDictEncoding(Encoding.PLAIN_DICTIONARY);
        builder.addDataEncoding(Encoding.PLAIN_DICTIONARY);
        builder.addDataEncoding(Encoding.PLAIN_DICTIONARY);
        EncodingStats stats = builder.build();
        Assert.assertFalse((boolean)stats.usesV2Pages());
        Assert.assertTrue((String)"Should have dictionary-encoded pages", (boolean)stats.hasDictionaryEncodedPages());
        Assert.assertFalse((String)"Should not have non-dictionary pages", (boolean)stats.hasNonDictionaryEncodedPages());
        Assert.assertTrue((String)"Should have dictionary pages", (boolean)stats.hasDictionaryPages());
    }

    @Test
    public void testV1NoDictionary() {
        EncodingStats.Builder builder = new EncodingStats.Builder();
        builder.addDataEncoding(Encoding.PLAIN);
        EncodingStats stats = builder.build();
        Assert.assertFalse((boolean)stats.usesV2Pages());
        Assert.assertFalse((String)"Should not have dictionary-encoded pages", (boolean)stats.hasDictionaryEncodedPages());
        Assert.assertTrue((String)"Should have non-dictionary pages", (boolean)stats.hasNonDictionaryEncodedPages());
        Assert.assertFalse((String)"Should not have dictionary pages", (boolean)stats.hasDictionaryPages());
    }

    @Test
    public void testV1Fallback() {
        EncodingStats.Builder builder = new EncodingStats.Builder();
        builder.addDictEncoding(Encoding.PLAIN_DICTIONARY);
        builder.addDataEncoding(Encoding.PLAIN_DICTIONARY);
        builder.addDataEncoding(Encoding.PLAIN_DICTIONARY);
        builder.addDataEncoding(Encoding.PLAIN);
        EncodingStats stats = builder.build();
        Assert.assertFalse((boolean)stats.usesV2Pages());
        Assert.assertTrue((String)"Should have dictionary-encoded pages", (boolean)stats.hasDictionaryEncodedPages());
        Assert.assertTrue((String)"Should have non-dictionary pages", (boolean)stats.hasNonDictionaryEncodedPages());
        Assert.assertTrue((String)"Should have dictionary pages", (boolean)stats.hasDictionaryPages());
    }

    @Test
    public void testV2AllDictionary() {
        EncodingStats.Builder builder = new EncodingStats.Builder();
        builder.withV2Pages();
        builder.addDictEncoding(Encoding.PLAIN);
        builder.addDataEncoding(Encoding.RLE_DICTIONARY);
        EncodingStats stats = builder.build();
        Assert.assertTrue((boolean)stats.usesV2Pages());
        Assert.assertTrue((String)"Should have dictionary-encoded pages", (boolean)stats.hasDictionaryEncodedPages());
        Assert.assertFalse((String)"Should not have non-dictionary pages", (boolean)stats.hasNonDictionaryEncodedPages());
        Assert.assertTrue((String)"Should have dictionary pages", (boolean)stats.hasDictionaryPages());
    }

    @Test
    public void testV2NoDictionary() {
        EncodingStats.Builder builder = new EncodingStats.Builder();
        builder.withV2Pages();
        builder.addDataEncoding(Encoding.DELTA_BINARY_PACKED);
        builder.addDataEncoding(Encoding.DELTA_BINARY_PACKED);
        EncodingStats stats = builder.build();
        Assert.assertTrue((boolean)stats.usesV2Pages());
        Assert.assertFalse((String)"Should not have dictionary-encoded pages", (boolean)stats.hasDictionaryEncodedPages());
        Assert.assertTrue((String)"Should have non-dictionary pages", (boolean)stats.hasNonDictionaryEncodedPages());
        Assert.assertFalse((String)"Should not have dictionary pages", (boolean)stats.hasDictionaryPages());
    }

    @Test
    public void testV2Fallback() {
        EncodingStats.Builder builder = new EncodingStats.Builder();
        builder.withV2Pages();
        builder.addDictEncoding(Encoding.PLAIN);
        builder.addDataEncoding(Encoding.RLE_DICTIONARY);
        builder.addDataEncoding(Encoding.DELTA_BYTE_ARRAY);
        builder.addDataEncoding(Encoding.DELTA_BYTE_ARRAY);
        EncodingStats stats = builder.build();
        Assert.assertTrue((boolean)stats.usesV2Pages());
        Assert.assertTrue((String)"Should have dictionary-encoded pages", (boolean)stats.hasDictionaryEncodedPages());
        Assert.assertTrue((String)"Should have non-dictionary pages", (boolean)stats.hasNonDictionaryEncodedPages());
        Assert.assertTrue((String)"Should have dictionary pages", (boolean)stats.hasDictionaryPages());
    }

    @Test
    public void testCounts() {
        EncodingStats.Builder builder = new EncodingStats.Builder();
        builder.withV2Pages();
        builder.addDictEncoding(Encoding.PLAIN);
        builder.addDataEncoding(Encoding.RLE_DICTIONARY, 4);
        builder.addDataEncoding(Encoding.RLE_DICTIONARY);
        builder.addDataEncoding(Encoding.DELTA_BYTE_ARRAY);
        builder.addDataEncoding(Encoding.DELTA_BYTE_ARRAY);
        EncodingStats stats = builder.build();
        Assert.assertEquals((String)"Count should match", (long)1L, (long)stats.getNumDictionaryPagesEncodedAs(Encoding.PLAIN));
        Assert.assertEquals((String)"Count should match", (long)0L, (long)stats.getNumDictionaryPagesEncodedAs(Encoding.PLAIN_DICTIONARY));
        Assert.assertEquals((String)"Count should match", (long)0L, (long)stats.getNumDictionaryPagesEncodedAs(Encoding.RLE));
        Assert.assertEquals((String)"Count should match", (long)0L, (long)stats.getNumDictionaryPagesEncodedAs(Encoding.BIT_PACKED));
        Assert.assertEquals((String)"Count should match", (long)0L, (long)stats.getNumDictionaryPagesEncodedAs(Encoding.DELTA_BYTE_ARRAY));
        Assert.assertEquals((String)"Count should match", (long)0L, (long)stats.getNumDictionaryPagesEncodedAs(Encoding.DELTA_BINARY_PACKED));
        Assert.assertEquals((String)"Count should match", (long)0L, (long)stats.getNumDictionaryPagesEncodedAs(Encoding.DELTA_LENGTH_BYTE_ARRAY));
        Assert.assertEquals((String)"Count should match", (long)5L, (long)stats.getNumDataPagesEncodedAs(Encoding.RLE_DICTIONARY));
        Assert.assertEquals((String)"Count should match", (long)2L, (long)stats.getNumDataPagesEncodedAs(Encoding.DELTA_BYTE_ARRAY));
        Assert.assertEquals((String)"Count should match", (long)0L, (long)stats.getNumDataPagesEncodedAs(Encoding.RLE));
        Assert.assertEquals((String)"Count should match", (long)0L, (long)stats.getNumDataPagesEncodedAs(Encoding.BIT_PACKED));
        Assert.assertEquals((String)"Count should match", (long)0L, (long)stats.getNumDataPagesEncodedAs(Encoding.PLAIN));
        Assert.assertEquals((String)"Count should match", (long)0L, (long)stats.getNumDataPagesEncodedAs(Encoding.PLAIN_DICTIONARY));
        Assert.assertEquals((String)"Count should match", (long)0L, (long)stats.getNumDataPagesEncodedAs(Encoding.DELTA_BINARY_PACKED));
        Assert.assertEquals((String)"Count should match", (long)0L, (long)stats.getNumDataPagesEncodedAs(Encoding.DELTA_LENGTH_BYTE_ARRAY));
    }
}

