/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.io;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.TypeConverter;
import org.junit.Assert;

public class ExpectationValidatingConverter
extends RecordMaterializer<Void> {
    private GroupConverter root;
    private final Deque<String> expectations;
    int count = 0;

    public void validate(String got) {
        Assert.assertEquals((String)("event #" + this.count), (Object)this.expectations.pop(), (Object)got);
        ++this.count;
    }

    public ExpectationValidatingConverter(String[] expectations, MessageType schema) {
        this(new ArrayDeque<String>(Arrays.asList(expectations)), schema);
    }

    public ExpectationValidatingConverter(Deque<String> expectations, MessageType schema) {
        this.expectations = expectations;
        this.root = (GroupConverter)schema.convertWith((TypeConverter)new TypeConverter<Converter>(){

            public Converter convertPrimitiveType(final List<GroupType> path, final PrimitiveType primitiveType) {
                return new PrimitiveConverter(){

                    private void validate(String message) {
                        ExpectationValidatingConverter.this.validate(ExpectationValidatingConverter.this.path(path, (Type)primitiveType) + message);
                    }

                    public void addBinary(Binary value) {
                        this.validate("addBinary(" + value.toStringUsingUTF8() + ")");
                    }

                    public void addBoolean(boolean value) {
                        this.validate("addBoolean(" + value + ")");
                    }

                    public void addDouble(double value) {
                        this.validate("addDouble(" + value + ")");
                    }

                    public void addFloat(float value) {
                        this.validate("addFloat(" + value + ")");
                    }

                    public void addInt(int value) {
                        this.validate("addInt(" + value + ")");
                    }

                    public void addLong(long value) {
                        this.validate("addLong(" + value + ")");
                    }
                };
            }

            public Converter convertGroupType(final List<GroupType> path, final GroupType groupType, final List<Converter> children) {
                return new GroupConverter(){

                    private void validate(String message) {
                        ExpectationValidatingConverter.this.validate(ExpectationValidatingConverter.this.path(path, (Type)groupType) + message);
                    }

                    public void start() {
                        this.validate("start()");
                    }

                    public void end() {
                        this.validate("end()");
                    }

                    public Converter getConverter(int fieldIndex) {
                        return (Converter)children.get(fieldIndex);
                    }
                };
            }

            public Converter convertMessageType(MessageType messageType, final List<Converter> children) {
                return new GroupConverter(){

                    public Converter getConverter(int fieldIndex) {
                        return (Converter)children.get(fieldIndex);
                    }

                    public void start() {
                        ExpectationValidatingConverter.this.validate("startMessage()");
                    }

                    public void end() {
                        ExpectationValidatingConverter.this.validate("endMessage()");
                    }
                };
            }
        });
    }

    public Void getCurrentRecord() {
        return null;
    }

    private String path(List<GroupType> path, Type type) {
        String pathString = "";
        if (path.size() > 0) {
            for (int i = 1; i < path.size(); ++i) {
                pathString = pathString + path.get(i).getName() + ".";
            }
        }
        pathString = pathString + type.getName() + ".";
        return pathString;
    }

    public GroupConverter getRootConverter() {
        return this.root;
    }
}

