/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.schema;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.PrimitiveStringifier;
import org.junit.Assert;
import org.junit.Test;

public class TestPrimitiveStringifier {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    @Test
    public void testDefaultStringifier() {
        PrimitiveStringifier stringifier = PrimitiveStringifier.DEFAULT_STRINGIFIER;
        Assert.assertEquals((Object)"true", (Object)stringifier.stringify(true));
        Assert.assertEquals((Object)"false", (Object)stringifier.stringify(false));
        Assert.assertEquals((Object)"0.0", (Object)stringifier.stringify(0.0));
        Assert.assertEquals((Object)"123456.7891234567", (Object)stringifier.stringify(123456.7891234567));
        Assert.assertEquals((Object)"-98765.43219876543", (Object)stringifier.stringify(-98765.43219876543));
        Assert.assertEquals((Object)"0.0", (Object)stringifier.stringify(0.0f));
        Assert.assertEquals((Object)"987.6543", (Object)stringifier.stringify(987.6543f));
        Assert.assertEquals((Object)"-123.4567", (Object)stringifier.stringify(-123.4567f));
        Assert.assertEquals((Object)"0", (Object)stringifier.stringify(0));
        Assert.assertEquals((Object)"1234567890", (Object)stringifier.stringify(1234567890));
        Assert.assertEquals((Object)"-987654321", (Object)stringifier.stringify(-987654321));
        Assert.assertEquals((Object)"0", (Object)stringifier.stringify(0L));
        Assert.assertEquals((Object)"1234567890123456789", (Object)stringifier.stringify(1234567890123456789L));
        Assert.assertEquals((Object)"-987654321987654321", (Object)stringifier.stringify(-987654321987654321L));
        Assert.assertEquals((Object)"null", (Object)stringifier.stringify(null));
        Assert.assertEquals((Object)"0x", (Object)stringifier.stringify(Binary.EMPTY));
        Assert.assertEquals((Object)"0x0123456789ABCDEF", (Object)stringifier.stringify(Binary.fromConstantByteArray((byte[])new byte[]{1, 35, 69, 103, -119, -85, -51, -17})));
    }

    @Test
    public void testUnsignedStringifier() {
        PrimitiveStringifier stringifier = PrimitiveStringifier.UNSIGNED_STRINGIFIER;
        Assert.assertEquals((Object)"0", (Object)stringifier.stringify(0));
        Assert.assertEquals((Object)"2147483647", (Object)stringifier.stringify(Integer.MAX_VALUE));
        Assert.assertEquals((Object)"4294967295", (Object)stringifier.stringify(-1));
        Assert.assertEquals((Object)"0", (Object)stringifier.stringify(0L));
        Assert.assertEquals((Object)"9223372036854775807", (Object)stringifier.stringify(Long.MAX_VALUE));
        Assert.assertEquals((Object)"18446744073709551615", (Object)stringifier.stringify(-1L));
        this.checkThrowingUnsupportedException(stringifier, Integer.TYPE, Long.TYPE);
    }

    @Test
    public void testUTF8Stringifier() {
        PrimitiveStringifier stringifier = PrimitiveStringifier.UTF8_STRINGIFIER;
        Assert.assertEquals((Object)"null", (Object)stringifier.stringify(null));
        Assert.assertEquals((Object)"", (Object)stringifier.stringify(Binary.EMPTY));
        Assert.assertEquals((Object)"This is a UTF-8 test", (Object)stringifier.stringify(Binary.fromString((String)"This is a UTF-8 test")));
        Assert.assertEquals((Object)"\u3053\u308c\u306fUTF-8\u306e\u30c6\u30b9\u30c8\u3067\u3059", (Object)stringifier.stringify(Binary.fromConstantByteArray((byte[])"\u3053\u308c\u306fUTF-8\u306e\u30c6\u30b9\u30c8\u3067\u3059".getBytes(StandardCharsets.UTF_8))));
        this.checkThrowingUnsupportedException(stringifier, Binary.class);
    }

    @Test
    public void testIntervalStringifier() {
        PrimitiveStringifier stringifier = PrimitiveStringifier.INTERVAL_STRINGIFIER;
        Assert.assertEquals((Object)"null", (Object)stringifier.stringify(null));
        Assert.assertEquals((Object)"<INVALID>", (Object)stringifier.stringify(Binary.EMPTY));
        Assert.assertEquals((Object)"<INVALID>", (Object)stringifier.stringify(Binary.fromConstantByteArray((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11})));
        Assert.assertEquals((Object)"<INVALID>", (Object)stringifier.stringify(Binary.fromReusedByteArray((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13})));
        ByteBuffer buffer = ByteBuffer.allocate(12);
        Assert.assertEquals((Object)"interval(0 months, 0 days, 0 millis)", (Object)stringifier.stringify(Binary.fromConstantByteBuffer((ByteBuffer)buffer)));
        buffer.putInt(0x3000000);
        buffer.putInt(0x6000000);
        buffer.putInt(0x9000000);
        buffer.flip();
        Assert.assertEquals((Object)"interval(3 months, 6 days, 9 millis)", (Object)stringifier.stringify(Binary.fromConstantByteBuffer((ByteBuffer)buffer)));
        buffer.clear();
        buffer.putInt(-1);
        buffer.putInt(-16777217);
        buffer.putInt(-33554433);
        buffer.flip();
        Assert.assertEquals((Object)"interval(4294967295 months, 4294967294 days, 4294967293 millis)", (Object)stringifier.stringify(Binary.fromReusedByteBuffer((ByteBuffer)buffer)));
        this.checkThrowingUnsupportedException(stringifier, Binary.class);
    }

    @Test
    public void testDateStringifier() {
        PrimitiveStringifier stringifier = PrimitiveStringifier.DATE_STRINGIFIER;
        Assert.assertEquals((Object)"1970-01-01", (Object)stringifier.stringify(0));
        Calendar cal = Calendar.getInstance(UTC);
        cal.clear();
        cal.set(2017, 11, 14);
        Assert.assertEquals((Object)"2017-12-14", (Object)stringifier.stringify((int)TimeUnit.MILLISECONDS.toDays(cal.getTimeInMillis())));
        cal.clear();
        cal.set(1492, 7, 3);
        Assert.assertEquals((Object)"1492-08-03", (Object)stringifier.stringify((int)TimeUnit.MILLISECONDS.toDays(cal.getTimeInMillis())));
        this.checkThrowingUnsupportedException(stringifier, Integer.TYPE);
    }

    @Test
    public void testTimestampMillisStringifier() {
        PrimitiveStringifier stringifier = PrimitiveStringifier.TIMESTAMP_MILLIS_STRINGIFIER;
        Assert.assertEquals((Object)"1970-01-01T00:00:00.000", (Object)stringifier.stringify(0L));
        Calendar cal = Calendar.getInstance(UTC);
        cal.clear();
        cal.set(2017, 11, 15, 10, 9, 54);
        cal.set(14, 120);
        Assert.assertEquals((Object)"2017-12-15T10:09:54.120", (Object)stringifier.stringify(cal.getTimeInMillis()));
        cal.clear();
        cal.set(1948, 10, 23, 20, 19, 1);
        cal.set(14, 9);
        Assert.assertEquals((Object)"1948-11-23T20:19:01.009", (Object)stringifier.stringify(cal.getTimeInMillis()));
        this.checkThrowingUnsupportedException(stringifier, Long.TYPE);
    }

    @Test
    public void testTimestampMicrosStringifier() {
        PrimitiveStringifier stringifier = PrimitiveStringifier.TIMESTAMP_MICROS_STRINGIFIER;
        Assert.assertEquals((Object)"1970-01-01T00:00:00.000000", (Object)stringifier.stringify(0L));
        Calendar cal = Calendar.getInstance(UTC);
        cal.clear();
        cal.set(2053, 6, 10, 22, 13, 24);
        cal.set(14, 84);
        long micros = cal.getTimeInMillis() * 1000L + 900L;
        Assert.assertEquals((Object)"2053-07-10T22:13:24.084900", (Object)stringifier.stringify(micros));
        cal.clear();
        cal.set(1848, 2, 15, 9, 23, 59);
        cal.set(14, 765);
        micros = cal.getTimeInMillis() * 1000L - 1L;
        Assert.assertEquals((Object)"1848-03-15T09:23:59.765001", (Object)stringifier.stringify(micros));
        this.checkThrowingUnsupportedException(stringifier, Long.TYPE);
    }

    @Test
    public void testTimeStringifier() {
        PrimitiveStringifier stringifier = PrimitiveStringifier.TIME_STRINGIFIER;
        Assert.assertEquals((Object)"00:00:00.000", (Object)stringifier.stringify(0));
        Assert.assertEquals((Object)"00:00:00.000000", (Object)stringifier.stringify(0L));
        Assert.assertEquals((Object)"12:34:56.789", (Object)stringifier.stringify((int)this.convert(TimeUnit.MILLISECONDS, 12L, 34L, 56L, 789L)));
        Assert.assertEquals((Object)"12:34:56.789012", (Object)stringifier.stringify(this.convert(TimeUnit.MICROSECONDS, 12L, 34L, 56L, 789012L)));
        Assert.assertEquals((Object)"-12:34:56.789", (Object)stringifier.stringify((int)this.convert(TimeUnit.MILLISECONDS, -12L, -34L, -56L, -789L)));
        Assert.assertEquals((Object)"-12:34:56.789012", (Object)stringifier.stringify(this.convert(TimeUnit.MICROSECONDS, -12L, -34L, -56L, -789012L)));
        Assert.assertEquals((Object)"123:12:34.567", (Object)stringifier.stringify((int)this.convert(TimeUnit.MILLISECONDS, 123L, 12L, 34L, 567L)));
        Assert.assertEquals((Object)"12345:12:34.056789", (Object)stringifier.stringify(this.convert(TimeUnit.MICROSECONDS, 12345L, 12L, 34L, 56789L)));
        Assert.assertEquals((Object)"-123:12:34.567", (Object)stringifier.stringify((int)this.convert(TimeUnit.MILLISECONDS, -123L, -12L, -34L, -567L)));
        Assert.assertEquals((Object)"-12345:12:34.056789", (Object)stringifier.stringify(this.convert(TimeUnit.MICROSECONDS, -12345L, -12L, -34L, -56789L)));
        this.checkThrowingUnsupportedException(stringifier, Integer.TYPE, Long.TYPE);
    }

    private long convert(TimeUnit unit, long hours, long minutes, long seconds, long rest) {
        return unit.convert(hours, TimeUnit.HOURS) + unit.convert(minutes, TimeUnit.MINUTES) + unit.convert(seconds, TimeUnit.SECONDS) + rest;
    }

    @Test
    public void testDecimalStringifier() {
        PrimitiveStringifier stringifier = PrimitiveStringifier.createDecimalStringifier((int)4);
        Assert.assertEquals((Object)"0.0000", (Object)stringifier.stringify(0));
        Assert.assertEquals((Object)"123456.7890", (Object)stringifier.stringify(1234567890));
        Assert.assertEquals((Object)"-98765.4321", (Object)stringifier.stringify(-987654321));
        Assert.assertEquals((Object)"0.0000", (Object)stringifier.stringify(0L));
        Assert.assertEquals((Object)"123456789012345.6789", (Object)stringifier.stringify(1234567890123456789L));
        Assert.assertEquals((Object)"-98765432109876.5432", (Object)stringifier.stringify(-987654321098765432L));
        Assert.assertEquals((Object)"null", (Object)stringifier.stringify(null));
        Assert.assertEquals((Object)"<INVALID>", (Object)stringifier.stringify(Binary.EMPTY));
        Assert.assertEquals((Object)"0.0000", (Object)stringifier.stringify(Binary.fromReusedByteArray((byte[])new byte[]{0})));
        Assert.assertEquals((Object)"9876543210987654321098765432109876543210987654.3210", (Object)stringifier.stringify(Binary.fromConstantByteArray((byte[])new BigInteger("98765432109876543210987654321098765432109876543210").toByteArray())));
        Assert.assertEquals((Object)"-1234567890123456789012345678901234567890123456.7890", (Object)stringifier.stringify(Binary.fromConstantByteArray((byte[])new BigInteger("-12345678901234567890123456789012345678901234567890").toByteArray())));
        this.checkThrowingUnsupportedException(stringifier, Integer.TYPE, Long.TYPE, Binary.class);
    }

    private void checkThrowingUnsupportedException(PrimitiveStringifier stringifier, Class<?> ... excludes) {
        HashSet set = new HashSet(Arrays.asList(excludes));
        if (!set.contains(Integer.TYPE)) {
            try {
                stringifier.stringify(0);
                Assert.fail((String)"An UnsupportedOperationException should have been thrown");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if (!set.contains(Long.TYPE)) {
            try {
                stringifier.stringify(0L);
                Assert.fail((String)"An UnsupportedOperationException should have been thrown");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if (!set.contains(Float.TYPE)) {
            try {
                stringifier.stringify(0.0f);
                Assert.fail((String)"An UnsupportedOperationException should have been thrown");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if (!set.contains(Double.TYPE)) {
            try {
                stringifier.stringify(0.0);
                Assert.fail((String)"An UnsupportedOperationException should have been thrown");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if (!set.contains(Boolean.TYPE)) {
            try {
                stringifier.stringify(false);
                Assert.fail((String)"An UnsupportedOperationException should have been thrown");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if (!set.contains(Binary.class)) {
            try {
                stringifier.stringify(Binary.EMPTY);
                Assert.fail((String)"An UnsupportedOperationException should have been thrown");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }
}

