/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.deltalengthbytearray;

import java.io.IOException;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.delta.DeltaBinaryPackingValuesReader;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeltaLengthByteArrayValuesReader
extends ValuesReader {
    private static final Logger LOG = LoggerFactory.getLogger(DeltaLengthByteArrayValuesReader.class);
    private ValuesReader lengthReader = new DeltaBinaryPackingValuesReader();
    private ByteBufferInputStream in;

    @Override
    public void initFromPage(int valueCount, ByteBufferInputStream stream) throws IOException {
        LOG.debug("init from page at offset {} for length {}", (Object)stream.position(), (Object)stream.available());
        this.lengthReader.initFromPage(valueCount, stream);
        this.in = stream.remainingStream();
    }

    @Override
    public Binary readBytes() {
        int length = this.lengthReader.readInteger();
        try {
            return Binary.fromConstantByteBuffer(this.in.slice(length));
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Failed to read " + length + " bytes");
        }
    }

    @Override
    public void skip() {
        int length = this.lengthReader.readInteger();
        try {
            this.in.skipFully((long)length);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Failed to skip " + length + " bytes");
        }
    }
}

