/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet;

import org.apache.parquet.CorruptStatistics;
import org.apache.parquet.schema.PrimitiveType;
import org.junit.Assert;
import org.junit.Test;

public class CorruptStatisticsTest {
    @Test
    public void testOnlyAppliesToBinary() {
        Assert.assertTrue((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.6.0 (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertTrue((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.6.0 (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY));
        Assert.assertFalse((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.6.0 (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE));
    }

    @Test
    public void testCorruptStatistics() {
        Assert.assertTrue((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.6.0 (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertTrue((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.4.2 (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertTrue((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.6.100 (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertTrue((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.7.999 (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertTrue((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.6.22rc99 (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertTrue((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.6.22rc99-SNAPSHOT (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertTrue((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.6.1-SNAPSHOT (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertTrue((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.6.0t-01-abcdefg (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertTrue((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"unparseable string", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertTrue((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertTrue((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version  (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertTrue((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.6.0 (build )", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertTrue((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.6.0 (build)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertTrue((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version (build)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertFalse((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"imapla version 1.6.0 (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertFalse((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"imapla version 1.10.0 (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertFalse((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.8.0 (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertFalse((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.8.1 (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertFalse((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.8.1rc3 (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertFalse((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.8.1rc3-SNAPSHOT (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertFalse((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.9.0 (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertFalse((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 2.0.0 (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertFalse((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.9.0t-01-abcdefg (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertFalse((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"impala version (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertFalse((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"impala version  (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertFalse((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"impala version 1.6.0 (build )", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertFalse((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"impala version 1.6.0 (build)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertFalse((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"impala version (build)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
    }

    @Test
    public void testDistributionCorruptStatistics() {
        Assert.assertTrue((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.5.0-cdh5.4.999 (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertFalse((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.5.0-cdh5.5.0-SNAPSHOT (build 956ed6c14c611b4c4eaaa1d6e5b9a9c6d4dfa336)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertFalse((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.5.0-cdh5.5.0 (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertFalse((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.5.0-cdh5.5.1 (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertFalse((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.5.0-cdh5.6.0 (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertTrue((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.4.10 (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertTrue((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.5.0 (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertTrue((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.5.1 (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertTrue((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.6.0 (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
        Assert.assertTrue((boolean)CorruptStatistics.shouldIgnoreStatistics((String)"parquet-mr version 1.7.0 (build abcd)", (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY));
    }
}

