/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.bitpacking;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.bitpacking.BitPacking;
import org.apache.parquet.column.values.bitpacking.BitPackingValuesReader;
import org.apache.parquet.column.values.bitpacking.ByteBitPackingValuesReader;
import org.apache.parquet.column.values.bitpacking.Packer;

public class BitPackingPerfTest {
    public static void main(String[] args) throws IOException {
        int COUNT = 800000;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BitPacking.BitPackingWriter w = BitPacking.getBitPackingWriter((int)1, (OutputStream)baos);
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < COUNT; ++i) {
            w.write(i % 2);
        }
        w.finish();
        long t1 = System.currentTimeMillis();
        System.out.println("written in " + (t1 - t0) + "ms");
        System.out.println();
        byte[] bytes = baos.toByteArray();
        System.out.println(bytes.length);
        int[] result = new int[COUNT];
        for (int l = 0; l < 5; ++l) {
            long s = BitPackingPerfTest.manual(bytes, result);
            long b = BitPackingPerfTest.generated(bytes, result);
            float ratio = (float)b / (float)s;
            System.out.println("                                             " + ratio + (ratio < 1.0f ? " < 1 => GOOD" : " >= 1 => BAD"));
        }
    }

    private static void verify(int[] result) {
        int error = 0;
        for (int i = 0; i < result.length; ++i) {
            if (result[i] == i % 2) continue;
            ++error;
        }
        if (error != 0) {
            throw new RuntimeException("errors: " + error + " / " + result.length);
        }
    }

    private static long manual(byte[] bytes, int[] result) throws IOException {
        return BitPackingPerfTest.readNTimes(bytes, result, (ValuesReader)new BitPackingValuesReader(1));
    }

    private static long generated(byte[] bytes, int[] result) throws IOException {
        return BitPackingPerfTest.readNTimes(bytes, result, (ValuesReader)new ByteBitPackingValuesReader(1, Packer.BIG_ENDIAN));
    }

    private static long readNTimes(byte[] bytes, int[] result, ValuesReader r) throws IOException {
        System.out.println();
        long t = 0L;
        int N = 10;
        System.gc();
        System.out.print("                                             " + r.getClass().getSimpleName());
        System.out.print(" no gc <");
        for (int k = 0; k < N; ++k) {
            long t2 = System.nanoTime();
            r.initFromPage(result.length, ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(bytes)}));
            for (int i = 0; i < result.length; ++i) {
                result[i] = r.readInteger();
            }
            long t3 = System.nanoTime();
            t += t3 - t2;
        }
        System.out.println("> read in " + t / 1000L + "\u00b5s " + (long)(N * result.length) / (t / 1000L) + " values per \u00b5s");
        BitPackingPerfTest.verify(result);
        return t;
    }
}

