/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.factory;

import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.column.values.bytestreamsplit.ByteStreamSplitValuesWriter;
import org.apache.parquet.column.values.delta.DeltaBinaryPackingValuesWriter;
import org.apache.parquet.column.values.delta.DeltaBinaryPackingValuesWriterForLong;
import org.apache.parquet.column.values.deltastrings.DeltaByteArrayWriter;
import org.apache.parquet.column.values.dictionary.DictionaryValuesWriter;
import org.apache.parquet.column.values.factory.DefaultValuesWriterFactory;
import org.apache.parquet.column.values.factory.ValuesWriterFactory;
import org.apache.parquet.column.values.fallback.FallbackValuesWriter;
import org.apache.parquet.column.values.plain.BooleanPlainValuesWriter;
import org.apache.parquet.column.values.plain.FixedLenByteArrayPlainValuesWriter;
import org.apache.parquet.column.values.plain.PlainValuesWriter;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridValuesWriter;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Test;

public class DefaultValuesWriterFactoryTest {
    @Test
    public void testBoolean() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.BOOLEAN, ParquetProperties.WriterVersion.PARQUET_1_0, true, false, false, BooleanPlainValuesWriter.class);
    }

    @Test
    public void testBoolean_V2() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.BOOLEAN, ParquetProperties.WriterVersion.PARQUET_2_0, true, false, false, RunLengthBitPackingHybridValuesWriter.class);
    }

    @Test
    public void testFixedLenByteArray() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, ParquetProperties.WriterVersion.PARQUET_1_0, true, false, false, FixedLenByteArrayPlainValuesWriter.class);
    }

    @Test
    public void testFixedLenByteArray_WithByteStreamSplit() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, ParquetProperties.WriterVersion.PARQUET_1_0, true, false, true, ByteStreamSplitValuesWriter.class);
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, ParquetProperties.WriterVersion.PARQUET_1_0, true, true, false, FixedLenByteArrayPlainValuesWriter.class);
    }

    @Test
    public void testFixedLenByteArray_V2() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, ParquetProperties.WriterVersion.PARQUET_2_0, true, false, false, DictionaryValuesWriter.class, DeltaByteArrayWriter.class);
    }

    @Test
    public void testFixedLenByteArray_V2_WithByteStreamSplit() {
        this.testExtendedByteStreamSplit(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, ParquetProperties.WriterVersion.PARQUET_2_0, DeltaByteArrayWriter.class);
    }

    @Test
    public void testFixedLenByteArray_V2_WithByteStreamSplit_NoDict() {
        this.testExtendedByteStreamSplit_NoDict(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, ParquetProperties.WriterVersion.PARQUET_2_0, DeltaByteArrayWriter.class);
    }

    @Test
    public void testFixedLenByteArray_V2_NoDict() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, ParquetProperties.WriterVersion.PARQUET_2_0, false, false, false, DeltaByteArrayWriter.class);
    }

    @Test
    public void testBinary() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.BINARY, ParquetProperties.WriterVersion.PARQUET_1_0, true, false, false, DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter.class, PlainValuesWriter.class);
    }

    @Test
    public void testBinary_NoDict() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.BINARY, ParquetProperties.WriterVersion.PARQUET_1_0, false, false, false, PlainValuesWriter.class);
    }

    @Test
    public void testBinary_V2() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.BINARY, ParquetProperties.WriterVersion.PARQUET_2_0, true, false, false, DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter.class, DeltaByteArrayWriter.class);
    }

    @Test
    public void testBinary_V2_NoDict() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.BINARY, ParquetProperties.WriterVersion.PARQUET_2_0, false, false, false, DeltaByteArrayWriter.class);
    }

    @Test
    public void testInt32() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.INT32, ParquetProperties.WriterVersion.PARQUET_1_0, true, false, false, DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter.class, PlainValuesWriter.class);
    }

    @Test
    public void testInt32_NoDict() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.INT32, ParquetProperties.WriterVersion.PARQUET_1_0, false, false, false, PlainValuesWriter.class);
    }

    @Test
    public void testInt32_ByteStreamSplit() {
        this.testExtendedByteStreamSplit(PrimitiveType.PrimitiveTypeName.INT32, ParquetProperties.WriterVersion.PARQUET_1_0, PlainValuesWriter.class);
    }

    @Test
    public void testInt32_ByteStreamSplit_NoDict() {
        this.testExtendedByteStreamSplit_NoDict(PrimitiveType.PrimitiveTypeName.INT32, ParquetProperties.WriterVersion.PARQUET_1_0, PlainValuesWriter.class);
    }

    @Test
    public void testInt32_V2() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.INT32, ParquetProperties.WriterVersion.PARQUET_2_0, true, false, false, DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter.class, DeltaBinaryPackingValuesWriter.class);
    }

    @Test
    public void testInt32_V2_NoDict() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.INT32, ParquetProperties.WriterVersion.PARQUET_2_0, false, false, false, DeltaBinaryPackingValuesWriter.class);
    }

    @Test
    public void testInt32_V2_ByteStreamSplit() {
        this.testExtendedByteStreamSplit(PrimitiveType.PrimitiveTypeName.INT32, ParquetProperties.WriterVersion.PARQUET_2_0, DeltaBinaryPackingValuesWriter.class);
    }

    @Test
    public void testInt32_V2_ByteStreamSplit_NoDict() {
        this.testExtendedByteStreamSplit_NoDict(PrimitiveType.PrimitiveTypeName.INT32, ParquetProperties.WriterVersion.PARQUET_2_0, DeltaBinaryPackingValuesWriter.class);
    }

    @Test
    public void testInt64() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.INT64, ParquetProperties.WriterVersion.PARQUET_1_0, true, false, false, DictionaryValuesWriter.PlainLongDictionaryValuesWriter.class, PlainValuesWriter.class);
    }

    @Test
    public void testInt64_NoDict() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.INT64, ParquetProperties.WriterVersion.PARQUET_1_0, false, false, false, PlainValuesWriter.class);
    }

    @Test
    public void testInt64_ByteStreamSplit() {
        this.testExtendedByteStreamSplit(PrimitiveType.PrimitiveTypeName.INT64, ParquetProperties.WriterVersion.PARQUET_1_0, PlainValuesWriter.class);
    }

    @Test
    public void testInt64_ByteStreamSplit_NoDict() {
        this.testExtendedByteStreamSplit_NoDict(PrimitiveType.PrimitiveTypeName.INT64, ParquetProperties.WriterVersion.PARQUET_1_0, PlainValuesWriter.class);
    }

    @Test
    public void testInt64_V2() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.INT64, ParquetProperties.WriterVersion.PARQUET_2_0, true, false, false, DictionaryValuesWriter.PlainLongDictionaryValuesWriter.class, DeltaBinaryPackingValuesWriterForLong.class);
    }

    @Test
    public void testInt64_V2_NoDict() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.INT64, ParquetProperties.WriterVersion.PARQUET_2_0, false, false, false, DeltaBinaryPackingValuesWriterForLong.class);
    }

    @Test
    public void testInt64_V2_ByteStreamSplit() {
        this.testExtendedByteStreamSplit(PrimitiveType.PrimitiveTypeName.INT64, ParquetProperties.WriterVersion.PARQUET_2_0, DeltaBinaryPackingValuesWriter.class);
    }

    @Test
    public void testInt64_V2_ByteStreamSplit_NoDict() {
        this.testExtendedByteStreamSplit_NoDict(PrimitiveType.PrimitiveTypeName.INT64, ParquetProperties.WriterVersion.PARQUET_2_0, DeltaBinaryPackingValuesWriter.class);
    }

    @Test
    public void testInt96() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.INT96, ParquetProperties.WriterVersion.PARQUET_1_0, true, false, false, DictionaryValuesWriter.PlainFixedLenArrayDictionaryValuesWriter.class, FixedLenByteArrayPlainValuesWriter.class);
    }

    @Test
    public void testInt96_NoDict() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.INT96, ParquetProperties.WriterVersion.PARQUET_1_0, false, false, false, FixedLenByteArrayPlainValuesWriter.class);
    }

    @Test
    public void testInt96_V2() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.INT96, ParquetProperties.WriterVersion.PARQUET_2_0, true, false, false, DictionaryValuesWriter.PlainFixedLenArrayDictionaryValuesWriter.class, FixedLenByteArrayPlainValuesWriter.class);
    }

    @Test
    public void testInt96_V2_NoDict() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.INT96, ParquetProperties.WriterVersion.PARQUET_2_0, false, false, false, FixedLenByteArrayPlainValuesWriter.class);
    }

    @Test
    public void testDouble() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.DOUBLE, ParquetProperties.WriterVersion.PARQUET_1_0, true, false, false, DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter.class, PlainValuesWriter.class);
    }

    @Test
    public void testDouble_NoDict() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.DOUBLE, ParquetProperties.WriterVersion.PARQUET_1_0, false, false, false, PlainValuesWriter.class);
    }

    @Test
    public void testDouble_V2() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.DOUBLE, ParquetProperties.WriterVersion.PARQUET_2_0, true, false, false, DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter.class, PlainValuesWriter.class);
    }

    @Test
    public void testDouble_V2_NoDict() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.DOUBLE, ParquetProperties.WriterVersion.PARQUET_2_0, false, false, false, PlainValuesWriter.class);
    }

    @Test
    public void testFloat() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.FLOAT, ParquetProperties.WriterVersion.PARQUET_1_0, true, false, false, DictionaryValuesWriter.PlainFloatDictionaryValuesWriter.class, PlainValuesWriter.class);
    }

    @Test
    public void testFloat_NoDict() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.FLOAT, ParquetProperties.WriterVersion.PARQUET_1_0, false, false, false, PlainValuesWriter.class);
    }

    @Test
    public void testFloat_V2() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.FLOAT, ParquetProperties.WriterVersion.PARQUET_2_0, true, false, false, DictionaryValuesWriter.PlainFloatDictionaryValuesWriter.class, PlainValuesWriter.class);
    }

    @Test
    public void testFloat_V2_NoDict() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.FLOAT, ParquetProperties.WriterVersion.PARQUET_2_0, false, false, false, PlainValuesWriter.class);
    }

    @Test
    public void testFloat_V1_WithByteStreamSplit() {
        this.testFloatingPoint_WithByteStreamSplit(PrimitiveType.PrimitiveTypeName.FLOAT, ParquetProperties.WriterVersion.PARQUET_1_0);
    }

    @Test
    public void testDouble_V1_WithByteStreamSplit() {
        this.testFloatingPoint_WithByteStreamSplit(PrimitiveType.PrimitiveTypeName.DOUBLE, ParquetProperties.WriterVersion.PARQUET_1_0);
    }

    @Test
    public void testFloat_V2_WithByteStreamSplit() {
        this.testFloatingPoint_WithByteStreamSplit(PrimitiveType.PrimitiveTypeName.FLOAT, ParquetProperties.WriterVersion.PARQUET_2_0);
    }

    @Test
    public void testDouble_V2_WithByteStreamSplit() {
        this.testFloatingPoint_WithByteStreamSplit(PrimitiveType.PrimitiveTypeName.DOUBLE, ParquetProperties.WriterVersion.PARQUET_2_0);
    }

    @Test
    public void testFloat_V1_WithByteStreamSplitAndDictionary() {
        this.testFloatingPoint_WithByteStreamSplitAndDictionary(PrimitiveType.PrimitiveTypeName.FLOAT, ParquetProperties.WriterVersion.PARQUET_1_0);
    }

    @Test
    public void testDouble_V1_WithByteStreamSplitAndDictionary() {
        this.testFloatingPoint_WithByteStreamSplitAndDictionary(PrimitiveType.PrimitiveTypeName.DOUBLE, ParquetProperties.WriterVersion.PARQUET_1_0);
    }

    @Test
    public void testFloat_V2_WithByteStreamSplitAndDictionary() {
        this.testFloatingPoint_WithByteStreamSplitAndDictionary(PrimitiveType.PrimitiveTypeName.FLOAT, ParquetProperties.WriterVersion.PARQUET_2_0);
    }

    @Test
    public void testDouble_V2_WithByteStreamSplitAndDictionary() {
        this.testFloatingPoint_WithByteStreamSplitAndDictionary(PrimitiveType.PrimitiveTypeName.DOUBLE, ParquetProperties.WriterVersion.PARQUET_2_0);
    }

    @Test
    public void testColumnWiseDictionaryWithFalseDefault() {
        ValuesWriterFactory factory = this.getDefaultFactory(ParquetProperties.WriterVersion.PARQUET_2_0, false, "binary_dict", "boolean_dict", "float_dict", "int32_dict");
        this.validateFactory(factory, PrimitiveType.PrimitiveTypeName.BINARY, "binary_dict", DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter.class, DeltaByteArrayWriter.class);
        this.validateFactory(factory, PrimitiveType.PrimitiveTypeName.BINARY, "binary_no_dict", DeltaByteArrayWriter.class);
        this.validateFactory(factory, PrimitiveType.PrimitiveTypeName.BOOLEAN, "boolean_dict", RunLengthBitPackingHybridValuesWriter.class);
        this.validateFactory(factory, PrimitiveType.PrimitiveTypeName.BOOLEAN, "boolean_no_dict", RunLengthBitPackingHybridValuesWriter.class);
        this.validateFactory(factory, PrimitiveType.PrimitiveTypeName.FLOAT, "float_dict", DictionaryValuesWriter.PlainFloatDictionaryValuesWriter.class, PlainValuesWriter.class);
        this.validateFactory(factory, PrimitiveType.PrimitiveTypeName.FLOAT, "float_no_dict", PlainValuesWriter.class);
        this.validateFactory(factory, PrimitiveType.PrimitiveTypeName.INT32, "int32_dict", DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter.class, DeltaBinaryPackingValuesWriter.class);
        this.validateFactory(factory, PrimitiveType.PrimitiveTypeName.INT32, "int32_no_dict", DeltaBinaryPackingValuesWriter.class);
    }

    @Test
    public void testColumnWiseDictionaryWithTrueDefault() {
        ValuesWriterFactory factory = this.getDefaultFactory(ParquetProperties.WriterVersion.PARQUET_2_0, true, "binary_no_dict", "boolean_no_dict", "float_no_dict", "int32_no_dict");
        this.validateFactory(factory, PrimitiveType.PrimitiveTypeName.BINARY, "binary_dict", DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter.class, DeltaByteArrayWriter.class);
        this.validateFactory(factory, PrimitiveType.PrimitiveTypeName.BINARY, "binary_no_dict", DeltaByteArrayWriter.class);
        this.validateFactory(factory, PrimitiveType.PrimitiveTypeName.BOOLEAN, "boolean_dict", RunLengthBitPackingHybridValuesWriter.class);
        this.validateFactory(factory, PrimitiveType.PrimitiveTypeName.BOOLEAN, "boolean_no_dict", RunLengthBitPackingHybridValuesWriter.class);
        this.validateFactory(factory, PrimitiveType.PrimitiveTypeName.FLOAT, "float_dict", DictionaryValuesWriter.PlainFloatDictionaryValuesWriter.class, PlainValuesWriter.class);
        this.validateFactory(factory, PrimitiveType.PrimitiveTypeName.FLOAT, "float_no_dict", PlainValuesWriter.class);
        this.validateFactory(factory, PrimitiveType.PrimitiveTypeName.INT32, "int32_dict", DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter.class, DeltaBinaryPackingValuesWriter.class);
        this.validateFactory(factory, PrimitiveType.PrimitiveTypeName.INT32, "int32_no_dict", DeltaBinaryPackingValuesWriter.class);
    }

    private void testExtendedByteStreamSplit(PrimitiveType.PrimitiveTypeName typeName, ParquetProperties.WriterVersion writerVersion, Class<? extends ValuesWriter> defaultFallbackWriterClass) {
        this.doTestValueWriter(this.createColumnDescriptor(typeName), ParquetProperties.builder().withWriterVersion(writerVersion).withExtendedByteStreamSplitEncoding(true).build(), DictionaryValuesWriter.class, ByteStreamSplitValuesWriter.class);
        this.doTestValueWriter(this.createColumnDescriptor(typeName), ParquetProperties.builder().withWriterVersion(writerVersion).withByteStreamSplitEncoding(true).build(), DictionaryValuesWriter.class, defaultFallbackWriterClass);
        ParquetProperties properties = ParquetProperties.builder().withWriterVersion(writerVersion).withByteStreamSplitEncoding("colA", true).build();
        this.doTestValueWriter(this.createColumnDescriptor(typeName, "colA"), properties, DictionaryValuesWriter.class, ByteStreamSplitValuesWriter.class);
        this.doTestValueWriter(this.createColumnDescriptor(typeName, "colB"), properties, DictionaryValuesWriter.class, defaultFallbackWriterClass);
    }

    private void testExtendedByteStreamSplit_NoDict(PrimitiveType.PrimitiveTypeName typeName, ParquetProperties.WriterVersion writerVersion, Class<? extends ValuesWriter> defaultWriterClass) {
        this.doTestValueWriter(this.createColumnDescriptor(typeName), ParquetProperties.builder().withWriterVersion(writerVersion).withDictionaryEncoding(false).withExtendedByteStreamSplitEncoding(true).build(), ByteStreamSplitValuesWriter.class);
        this.doTestValueWriter(this.createColumnDescriptor(typeName), ParquetProperties.builder().withWriterVersion(writerVersion).withDictionaryEncoding(false).withByteStreamSplitEncoding(true).build(), defaultWriterClass);
        ParquetProperties properties = ParquetProperties.builder().withWriterVersion(writerVersion).withDictionaryEncoding(false).withByteStreamSplitEncoding("colA", true).build();
        this.doTestValueWriter(this.createColumnDescriptor(typeName, "colA"), properties, ByteStreamSplitValuesWriter.class);
        this.doTestValueWriter(this.createColumnDescriptor(typeName, "colB"), properties, defaultWriterClass);
    }

    private void testFloatingPoint_WithByteStreamSplit(PrimitiveType.PrimitiveTypeName typeName, ParquetProperties.WriterVersion writerVersion) {
        this.doTestValueWriter(this.createColumnDescriptor(typeName), ParquetProperties.builder().withWriterVersion(writerVersion).withDictionaryEncoding(false).withByteStreamSplitEncoding(true).build(), ByteStreamSplitValuesWriter.class);
        this.doTestValueWriter(this.createColumnDescriptor(typeName), ParquetProperties.builder().withWriterVersion(writerVersion).withDictionaryEncoding(false).withExtendedByteStreamSplitEncoding(true).build(), ByteStreamSplitValuesWriter.class);
        ParquetProperties properties = ParquetProperties.builder().withWriterVersion(writerVersion).withDictionaryEncoding(false).withByteStreamSplitEncoding("colA", true).build();
        this.doTestValueWriter(this.createColumnDescriptor(typeName, "colA"), properties, ByteStreamSplitValuesWriter.class);
        this.doTestValueWriter(this.createColumnDescriptor(typeName, "colB"), properties, PlainValuesWriter.class);
    }

    private void testFloatingPoint_WithByteStreamSplitAndDictionary(PrimitiveType.PrimitiveTypeName typeName, ParquetProperties.WriterVersion writerVersion) {
        this.doTestValueWriter(this.createColumnDescriptor(typeName), ParquetProperties.builder().withWriterVersion(writerVersion).withByteStreamSplitEncoding(true).build(), DictionaryValuesWriter.class, ByteStreamSplitValuesWriter.class);
        this.doTestValueWriter(this.createColumnDescriptor(typeName), ParquetProperties.builder().withWriterVersion(writerVersion).withExtendedByteStreamSplitEncoding(true).build(), DictionaryValuesWriter.class, ByteStreamSplitValuesWriter.class);
        ParquetProperties properties = ParquetProperties.builder().withWriterVersion(writerVersion).withByteStreamSplitEncoding("colA", true).build();
        this.doTestValueWriter(this.createColumnDescriptor(typeName, "colA"), properties, DictionaryValuesWriter.class, ByteStreamSplitValuesWriter.class);
        this.doTestValueWriter(this.createColumnDescriptor(typeName, "colB"), properties, DictionaryValuesWriter.class, PlainValuesWriter.class);
    }

    private void validateFactory(ValuesWriterFactory factory, PrimitiveType.PrimitiveTypeName typeName, String colName, Class<? extends ValuesWriter> initialWriterClass, Class<? extends ValuesWriter> fallbackWriterClass) {
        ColumnDescriptor column = this.createColumnDescriptor(typeName, colName);
        ValuesWriter writer = factory.newValuesWriter(column);
        this.validateFallbackWriter(writer, initialWriterClass, fallbackWriterClass);
    }

    private void validateFactory(ValuesWriterFactory factory, PrimitiveType.PrimitiveTypeName typeName, String colName, Class<? extends ValuesWriter> expectedWriterClass) {
        ColumnDescriptor column = this.createColumnDescriptor(typeName, colName);
        ValuesWriter writer = factory.newValuesWriter(column);
        this.validateWriterType(writer, expectedWriterClass);
    }

    private void doTestValueWriter(PrimitiveType.PrimitiveTypeName typeName, ParquetProperties.WriterVersion version, boolean enableDictionary, boolean enableByteStreamSplit, boolean enableExtendedByteStreamSplit, Class<? extends ValuesWriter> expectedValueWriterClass) {
        ColumnDescriptor mockPath = this.createColumnDescriptor(typeName);
        this.doTestValueWriter(mockPath, version, enableDictionary, enableByteStreamSplit, enableExtendedByteStreamSplit, expectedValueWriterClass);
    }

    private void doTestValueWriter(ColumnDescriptor path, ParquetProperties.WriterVersion version, boolean enableDictionary, boolean enableByteStreamSplit, boolean enableExtendedByteStreamSplit, Class<? extends ValuesWriter> expectedValueWriterClass) {
        ValuesWriterFactory factory = this.getDefaultFactory(version, enableDictionary, enableByteStreamSplit, enableExtendedByteStreamSplit);
        ValuesWriter writer = factory.newValuesWriter(path);
        this.validateWriterType(writer, expectedValueWriterClass);
    }

    private void doTestValueWriter(PrimitiveType.PrimitiveTypeName typeName, ParquetProperties.WriterVersion version, boolean enableDictionary, boolean enableByteStreamSplit, boolean enableExtendedByteStreamSplit, Class<? extends ValuesWriter> initialValueWriterClass, Class<? extends ValuesWriter> fallbackValueWriterClass) {
        ColumnDescriptor mockPath = this.createColumnDescriptor(typeName);
        this.doTestValueWriter(mockPath, version, enableDictionary, enableByteStreamSplit, enableExtendedByteStreamSplit, initialValueWriterClass, fallbackValueWriterClass);
    }

    private void doTestValueWriter(ColumnDescriptor path, ParquetProperties.WriterVersion version, boolean enableDictionary, boolean enableByteStreamSplit, boolean enableExtendedByteStreamSplit, Class<? extends ValuesWriter> initialValueWriterClass, Class<? extends ValuesWriter> fallbackValueWriterClass) {
        ValuesWriterFactory factory = this.getDefaultFactory(version, enableDictionary, enableByteStreamSplit, enableExtendedByteStreamSplit);
        ValuesWriter writer = factory.newValuesWriter(path);
        this.validateFallbackWriter(writer, initialValueWriterClass, fallbackValueWriterClass);
    }

    private void doTestValueWriter(ColumnDescriptor path, ParquetProperties properties, Class<? extends ValuesWriter> initialValueWriterClass, Class<? extends ValuesWriter> fallbackValueWriterClass) {
        ValuesWriterFactory factory = this.getDefaultFactory(properties);
        ValuesWriter writer = factory.newValuesWriter(path);
        this.validateFallbackWriter(writer, initialValueWriterClass, fallbackValueWriterClass);
    }

    private void doTestValueWriter(ColumnDescriptor path, ParquetProperties properties, Class<? extends ValuesWriter> expectedValueWriterClass) {
        ValuesWriterFactory factory = this.getDefaultFactory(properties);
        ValuesWriter writer = factory.newValuesWriter(path);
        this.validateWriterType(writer, expectedValueWriterClass);
    }

    private ColumnDescriptor createColumnDescriptor(PrimitiveType.PrimitiveTypeName typeName) {
        return this.createColumnDescriptor(typeName, (LogicalTypeAnnotation)null);
    }

    private ColumnDescriptor createColumnDescriptor(PrimitiveType.PrimitiveTypeName typeName, LogicalTypeAnnotation logicalType) {
        return this.createColumnDescriptor(typeName, "fake_" + typeName.name().toLowerCase() + "_col", logicalType);
    }

    private ColumnDescriptor createColumnDescriptor(PrimitiveType.PrimitiveTypeName typeName, String name) {
        return this.createColumnDescriptor(typeName, name, null);
    }

    private ColumnDescriptor createColumnDescriptor(PrimitiveType.PrimitiveTypeName typeName, String name, LogicalTypeAnnotation logicalType) {
        PrimitiveType type = ((PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)typeName).length(1)).named(name)).withLogicalTypeAnnotation(logicalType);
        return new ColumnDescriptor(new String[]{name}, type, 0, 0);
    }

    private ValuesWriterFactory getDefaultFactory(ParquetProperties.WriterVersion writerVersion, boolean enableDictionary, boolean enableByteStreamSplit, boolean enableExtendedByteStreamSplit) {
        DefaultValuesWriterFactory factory = new DefaultValuesWriterFactory();
        ParquetProperties.builder().withDictionaryEncoding(enableDictionary).withByteStreamSplitEncoding(enableByteStreamSplit).withExtendedByteStreamSplitEncoding(enableExtendedByteStreamSplit).withWriterVersion(writerVersion).withValuesWriterFactory((ValuesWriterFactory)factory).build();
        return factory;
    }

    private ValuesWriterFactory getDefaultFactory(ParquetProperties properties) {
        DefaultValuesWriterFactory factory = new DefaultValuesWriterFactory();
        factory.initialize(properties);
        return factory;
    }

    private ValuesWriterFactory getDefaultFactory(ParquetProperties.WriterVersion writerVersion, boolean dictEnabledDefault, String ... dictInverseColumns) {
        DefaultValuesWriterFactory factory = new DefaultValuesWriterFactory();
        ParquetProperties.Builder builder = ParquetProperties.builder().withDictionaryEncoding(dictEnabledDefault).withWriterVersion(writerVersion).withValuesWriterFactory((ValuesWriterFactory)factory);
        for (String column : dictInverseColumns) {
            builder.withDictionaryEncoding(column, !dictEnabledDefault);
        }
        builder.build();
        return factory;
    }

    private void validateWriterType(ValuesWriter writer, Class<? extends ValuesWriter> valuesWriterClass) {
        Assert.assertTrue((String)("Not instance of " + valuesWriterClass.getName() + ": actual class is " + writer.getClass().getName()), (boolean)valuesWriterClass.isInstance(writer));
    }

    private void validateFallbackWriter(ValuesWriter writer, Class<? extends ValuesWriter> initialWriterClass, Class<? extends ValuesWriter> fallbackWriterClass) {
        this.validateWriterType(writer, FallbackValuesWriter.class);
        FallbackValuesWriter wr = (FallbackValuesWriter)writer;
        this.validateWriterType(wr.initialWriter, initialWriterClass);
        this.validateWriterType(wr.fallBackWriter, fallbackWriterClass);
    }
}

