/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.schema;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.Float16;
import org.apache.parquet.schema.PrimitiveComparator;
import org.junit.Assert;
import org.junit.Test;

public class TestPrimitiveComparator {
    @Test
    public void testBooleanComparator() {
        Boolean[] valuesInAscendingOrder = new Boolean[]{null, false, true};
        for (int i = 0; i < valuesInAscendingOrder.length; ++i) {
            for (int j = 0; j < valuesInAscendingOrder.length; ++j) {
                Boolean vi = valuesInAscendingOrder[i];
                Boolean vj = valuesInAscendingOrder[j];
                int exp = i - j;
                this.assertSignumEquals(vi, vj, exp, PrimitiveComparator.BOOLEAN_COMPARATOR.compare((Object)vi, (Object)vj));
                if (vi == null || vj == null) continue;
                this.assertSignumEquals(vi, vj, exp, PrimitiveComparator.BOOLEAN_COMPARATOR.compare(vi.booleanValue(), vj.booleanValue()));
            }
        }
        this.checkThrowingUnsupportedException(PrimitiveComparator.BOOLEAN_COMPARATOR, Boolean.TYPE);
    }

    @Test
    public void testSignedInt32Comparator() {
        this.testInt32Comparator((PrimitiveComparator<Integer>)PrimitiveComparator.SIGNED_INT32_COMPARATOR, null, Integer.MIN_VALUE, -12345, -1, 0, 1, 12345, Integer.MAX_VALUE);
    }

    @Test
    public void testUnsignedInt32Comparator() {
        this.testInt32Comparator((PrimitiveComparator<Integer>)PrimitiveComparator.UNSIGNED_INT32_COMPARATOR, null, 0, 1, 12345, Integer.MAX_VALUE, Integer.MIN_VALUE, -12345, -1);
    }

    private void testInt32Comparator(PrimitiveComparator<Integer> comparator, Integer ... valuesInAscendingOrder) {
        for (int i = 0; i < valuesInAscendingOrder.length; ++i) {
            for (int j = 0; j < valuesInAscendingOrder.length; ++j) {
                Integer vi = valuesInAscendingOrder[i];
                Integer vj = valuesInAscendingOrder[j];
                int exp = i - j;
                this.assertSignumEquals(vi, vj, exp, comparator.compare((Object)vi, (Object)vj));
                if (vi == null || vj == null) continue;
                this.assertSignumEquals(vi, vj, exp, comparator.compare(vi.intValue(), vj.intValue()));
            }
        }
        this.checkThrowingUnsupportedException(comparator, Integer.TYPE);
    }

    @Test
    public void testSignedInt64Comparator() {
        this.testInt64Comparator((PrimitiveComparator<Long>)PrimitiveComparator.SIGNED_INT64_COMPARATOR, null, Long.MIN_VALUE, -12345678901L, -1L, 0L, 1L, 12345678901L, Long.MAX_VALUE);
    }

    @Test
    public void testUnsignedInt64Comparator() {
        this.testInt64Comparator((PrimitiveComparator<Long>)PrimitiveComparator.UNSIGNED_INT64_COMPARATOR, null, 0L, 1L, 12345678901L, Long.MAX_VALUE, Long.MIN_VALUE, -12345678901L, -1L);
    }

    private void testInt64Comparator(PrimitiveComparator<Long> comparator, Long ... valuesInAscendingOrder) {
        for (int i = 0; i < valuesInAscendingOrder.length; ++i) {
            for (int j = 0; j < valuesInAscendingOrder.length; ++j) {
                Long vi = valuesInAscendingOrder[i];
                Long vj = valuesInAscendingOrder[j];
                int exp = i - j;
                this.assertSignumEquals(vi, vj, exp, comparator.compare((Object)vi, (Object)vj));
                if (vi == null || vj == null) continue;
                this.assertSignumEquals(vi, vj, exp, comparator.compare(vi.longValue(), vj.longValue()));
            }
        }
        this.checkThrowingUnsupportedException(comparator, Long.TYPE);
    }

    @Test
    public void testFloatComparator() {
        Float[] valuesInAscendingOrder = new Float[]{null, Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(-3.4028235E38f), Float.valueOf(-1234.5677f), Float.valueOf(-1.4E-45f), Float.valueOf(0.0f), Float.valueOf(Float.MIN_VALUE), Float.valueOf(1234.5677f), Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.POSITIVE_INFINITY)};
        for (int i = 0; i < valuesInAscendingOrder.length; ++i) {
            for (int j = 0; j < valuesInAscendingOrder.length; ++j) {
                Float vi = valuesInAscendingOrder[i];
                Float vj = valuesInAscendingOrder[j];
                int exp = i - j;
                this.assertSignumEquals(vi, vj, exp, PrimitiveComparator.FLOAT_COMPARATOR.compare((Object)vi, (Object)vj));
                if (vi == null || vj == null) continue;
                this.assertSignumEquals(vi, vj, exp, PrimitiveComparator.FLOAT_COMPARATOR.compare(vi.floatValue(), vj.floatValue()));
            }
        }
        this.checkThrowingUnsupportedException(PrimitiveComparator.FLOAT_COMPARATOR, Float.TYPE);
    }

    @Test
    public void testDoubleComparator() {
        Double[] valuesInAscendingOrder = new Double[]{null, Double.NEGATIVE_INFINITY, -1.7976931348623157E308, -123456.78901234567, -4.9E-324, 0.0, Double.MIN_VALUE, 123456.78901234567, Double.MAX_VALUE, Double.POSITIVE_INFINITY};
        for (int i = 0; i < valuesInAscendingOrder.length; ++i) {
            for (int j = 0; j < valuesInAscendingOrder.length; ++j) {
                Double vi = valuesInAscendingOrder[i];
                Double vj = valuesInAscendingOrder[j];
                int exp = i - j;
                this.assertSignumEquals(vi, vj, exp, PrimitiveComparator.DOUBLE_COMPARATOR.compare((Object)vi, (Object)vj));
                if (vi == null || vj == null) continue;
                this.assertSignumEquals(vi, vj, exp, PrimitiveComparator.DOUBLE_COMPARATOR.compare(vi.doubleValue(), vj.doubleValue()));
            }
        }
        this.checkThrowingUnsupportedException(PrimitiveComparator.DOUBLE_COMPARATOR, Double.TYPE);
    }

    @Test
    public void testLexicographicalBinaryComparator() {
        this.testObjectComparator(PrimitiveComparator.UNSIGNED_LEXICOGRAPHICAL_BINARY_COMPARATOR, null, Binary.fromConstantByteArray((byte[])new byte[0]), Binary.fromConstantByteArray((byte[])new byte[]{127, 127, 0, 127}, (int)2, (int)1), Binary.fromCharSequence((CharSequence)"aaa"), Binary.fromString((String)"aaaa"), Binary.fromReusedByteArray((byte[])"aaab".getBytes()), Binary.fromReusedByteArray((byte[])"azzza".getBytes(), (int)1, (int)3), Binary.fromReusedByteBuffer((ByteBuffer)ByteBuffer.wrap("zzzzzz".getBytes())), Binary.fromReusedByteBuffer((ByteBuffer)ByteBuffer.wrap("aazzzzzzaa".getBytes(), 2, 7)), Binary.fromConstantByteBuffer((ByteBuffer)ByteBuffer.wrap(new byte[]{-128, -128, -128})), Binary.fromConstantByteBuffer((ByteBuffer)ByteBuffer.wrap(new byte[]{-128, -128, -1}, 1, 2)));
    }

    @Test
    public void testBinaryAsSignedIntegerComparator() {
        this.testObjectComparator(PrimitiveComparator.BINARY_AS_SIGNED_INTEGER_COMPARATOR, null, Binary.fromConstantByteArray((byte[])new BigInteger("-9999999999999999999999999999999999999999").toByteArray()), Binary.fromReusedByteArray((byte[])new BigInteger("-9999999999999999999999999999999999999998").toByteArray()), Binary.fromConstantByteArray((byte[])BigInteger.valueOf(Long.MIN_VALUE).subtract(BigInteger.ONE).toByteArray()), Binary.fromConstantByteArray((byte[])BigInteger.valueOf(Long.MIN_VALUE).toByteArray()), Binary.fromConstantByteArray((byte[])BigInteger.valueOf(Long.MIN_VALUE).add(BigInteger.ONE).toByteArray()), Binary.fromReusedByteArray((byte[])new byte[]{-1, -1, -1, -2}, (int)1, (int)3), Binary.fromReusedByteArray((byte[])new BigInteger("-1").toByteArray()), Binary.fromConstantByteBuffer((ByteBuffer)ByteBuffer.wrap(new BigInteger("0").toByteArray())), Binary.fromReusedByteBuffer((ByteBuffer)ByteBuffer.wrap(new byte[]{0, 0, 0, 1})), Binary.fromConstantByteBuffer((ByteBuffer)ByteBuffer.wrap(new byte[]{0, 0, 0, 2}), (int)2, (int)2), Binary.fromConstantByteBuffer((ByteBuffer)ByteBuffer.wrap(BigInteger.valueOf(Long.MAX_VALUE).subtract(BigInteger.ONE).toByteArray())), Binary.fromConstantByteBuffer((ByteBuffer)ByteBuffer.wrap(BigInteger.valueOf(Long.MAX_VALUE).toByteArray())), Binary.fromConstantByteBuffer((ByteBuffer)ByteBuffer.wrap(BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE).toByteArray())), Binary.fromConstantByteBuffer((ByteBuffer)ByteBuffer.wrap(new BigInteger("999999999999999999999999999999999999999").toByteArray())), Binary.fromReusedByteBuffer((ByteBuffer)ByteBuffer.wrap(new BigInteger("9999999999999999999999999999999999999998").toByteArray())), Binary.fromConstantByteBuffer((ByteBuffer)ByteBuffer.wrap(new BigInteger("9999999999999999999999999999999999999999").toByteArray())));
    }

    @Test
    public void testBinaryAsSignedIntegerComparatorWithEquals() {
        ArrayList<Binary> valuesToCompare = new ArrayList<Binary>();
        valuesToCompare.add(Binary.fromConstantByteBuffer((ByteBuffer)ByteBuffer.wrap(new byte[]{0, 0, -108})));
        valuesToCompare.add(Binary.fromConstantByteBuffer((ByteBuffer)ByteBuffer.wrap(new byte[]{0, 0, 0, 0, 0, -108})));
        valuesToCompare.add(Binary.fromConstantByteBuffer((ByteBuffer)ByteBuffer.wrap(new byte[]{0, 0, 0, -108})));
        valuesToCompare.add(Binary.fromConstantByteBuffer((ByteBuffer)ByteBuffer.wrap(new byte[]{0, 0, 0, 0, -108})));
        valuesToCompare.add(Binary.fromConstantByteBuffer((ByteBuffer)ByteBuffer.wrap(new byte[]{0, -108})));
        for (Binary v1 : valuesToCompare) {
            for (Binary v2 : valuesToCompare) {
                Assert.assertEquals((String)String.format("Wrong result of comparison %s and %s", v1, v2), (long)0L, (long)PrimitiveComparator.BINARY_AS_SIGNED_INTEGER_COMPARATOR.compare((Object)v1, (Object)v2));
            }
        }
    }

    @Test
    public void testFloat16Comparator() {
        Binary[] valuesInAscendingOrder = new Binary[]{Binary.fromConstantByteArray((byte[])new byte[]{0, -4}), Binary.fromConstantByteArray((byte[])new byte[]{0, -64}), Binary.fromConstantByteArray((byte[])new byte[]{1, -124}), Binary.fromConstantByteArray((byte[])new byte[]{0, -128}), Binary.fromConstantByteArray((byte[])new byte[]{0, 0}), Binary.fromConstantByteArray((byte[])new byte[]{1, 0}), Binary.fromConstantByteArray((byte[])new byte[]{-1, 123}), Binary.fromConstantByteArray((byte[])new byte[]{0, 124})};
        for (int i = 0; i < valuesInAscendingOrder.length; ++i) {
            for (int j = 0; j < valuesInAscendingOrder.length; ++j) {
                Binary bi = valuesInAscendingOrder[i];
                Binary bj = valuesInAscendingOrder[j];
                float fi = Float16.toFloat((Binary)bi);
                float fj = Float16.toFloat((Binary)bj);
                Assert.assertEquals((long)Float.compare(fi, fj), (long)PrimitiveComparator.BINARY_AS_FLOAT16_COMPARATOR.compare((Object)bi, (Object)bj));
                if (i >= j) continue;
                Assert.assertEquals((long)-1L, (long)Float.compare(fi, fj));
            }
        }
    }

    private <T> void testObjectComparator(PrimitiveComparator<T> comparator, T ... valuesInAscendingOrder) {
        for (int i = 0; i < valuesInAscendingOrder.length; ++i) {
            for (int j = 0; j < valuesInAscendingOrder.length; ++j) {
                T vi = valuesInAscendingOrder[i];
                T vj = valuesInAscendingOrder[j];
                int exp = i - j;
                this.assertSignumEquals(vi, vj, exp, comparator.compare(vi, vj));
            }
        }
        this.checkThrowingUnsupportedException(comparator, null);
    }

    private <T> void assertSignumEquals(T v1, T v2, int expected, int actual) {
        String sign = expected < 0 ? " < " : (expected > 0 ? " > " : " = ");
        Assert.assertEquals((String)("expected: " + v1 + sign + v2), (long)this.signum(expected), (long)this.signum(actual));
    }

    private int signum(int i) {
        return i < 0 ? -1 : (i > 0 ? 1 : 0);
    }

    private void checkThrowingUnsupportedException(PrimitiveComparator<?> comparator, Class<?> exclude) {
        if (Integer.TYPE != exclude) {
            try {
                comparator.compare(0, 0);
                Assert.fail((String)"An UnsupportedOperationException should have been thrown");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if (Long.TYPE != exclude) {
            try {
                comparator.compare(0L, 0L);
                Assert.fail((String)"An UnsupportedOperationException should have been thrown");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if (Float.TYPE != exclude) {
            try {
                comparator.compare(0.0f, 0.0f);
                Assert.fail((String)"An UnsupportedOperationException should have been thrown");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if (Double.TYPE != exclude) {
            try {
                comparator.compare(0.0, 0.0);
                Assert.fail((String)"An UnsupportedOperationException should have been thrown");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if (Boolean.TYPE != exclude) {
            try {
                comparator.compare(false, false);
                Assert.fail((String)"An UnsupportedOperationException should have been thrown");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }
}

