/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.impl;

import java.util.List;
import org.apache.parquet.VersionParser;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.impl.ColumnReaderImpl;
import org.apache.parquet.column.impl.ColumnWriterV2;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.column.page.PageWriter;
import org.apache.parquet.column.page.mem.MemPageReader;
import org.apache.parquet.column.page.mem.MemPageWriter;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.junit.Assert;
import org.junit.Test;

public class TestColumnReaderImpl {
    private int rows = 13001;

    @Test
    public void test() throws Exception {
        ColumnDescriptor col = TestColumnReaderImpl.requiredBinaryColumn();
        MemPageWriter pageWriter = this.writeBinaryDictColumn(col);
        List<DataPage> pages = pageWriter.getPages();
        int valueCount = 0;
        int rowCount = 0;
        for (DataPage dataPage : pages) {
            valueCount += dataPage.getValueCount();
            rowCount += ((DataPageV2)dataPage).getRowCount();
        }
        junit.framework.Assert.assertEquals((int)this.rows, (int)rowCount);
        junit.framework.Assert.assertEquals((int)this.rows, (int)valueCount);
        MemPageReader pageReader = this.toReader(pageWriter);
        this.validateExpectedValuesAndCount(col, pageReader);
    }

    private static ColumnDescriptor requiredBinaryColumn() {
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required binary foo; }");
        ColumnDescriptor col = (ColumnDescriptor)schema.getColumns().get(0);
        return col;
    }

    private MemPageWriter writeBinaryDictColumn(ColumnDescriptor col) {
        MemPageWriter pageWriter = new MemPageWriter();
        ColumnWriterV2 columnWriterV2 = new ColumnWriterV2(col, (PageWriter)pageWriter, ParquetProperties.builder().withDictionaryPageSize(1024).withWriterVersion(ParquetProperties.WriterVersion.PARQUET_2_0).withPageSize(2048).build());
        for (int i = 0; i < this.rows; ++i) {
            columnWriterV2.write(Binary.fromString((String)("bar" + i % 10)), 0, 0);
            if ((i + 1) % 1000 != 0) continue;
            columnWriterV2.writePage();
        }
        columnWriterV2.writePage();
        columnWriterV2.finalizeColumnChunk();
        return pageWriter;
    }

    private MemPageReader toReader(MemPageWriter pageWriter) {
        return new MemPageReader(this.rows, pageWriter.getPages().iterator(), pageWriter.getDictionaryPage());
    }

    private void validateExpectedValuesAndCount(ColumnDescriptor col, MemPageReader pageReader) throws VersionParser.VersionParseException {
        ValidatingConverter converter = new ValidatingConverter();
        ColumnReaderImpl columnReader = new ColumnReaderImpl(col, (PageReader)pageReader, (PrimitiveConverter)converter, VersionParser.parse((String)"parquet-mr version 1.16.0 (build 402c3810c372d29603e181771acebfecc71bef61)"));
        for (int i = 0; i < this.rows; ++i) {
            junit.framework.Assert.assertEquals((int)0, (int)columnReader.getCurrentRepetitionLevel());
            junit.framework.Assert.assertEquals((int)0, (int)columnReader.getCurrentDefinitionLevel());
            columnReader.writeCurrentValueToConverter();
            columnReader.consume();
        }
        junit.framework.Assert.assertEquals((int)this.rows, (int)converter.count);
    }

    @Test
    public void testOptional() throws Exception {
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { optional binary foo; }");
        ColumnDescriptor col = (ColumnDescriptor)schema.getColumns().get(0);
        MemPageWriter pageWriter = new MemPageWriter();
        ColumnWriterV2 columnWriterV2 = new ColumnWriterV2(col, (PageWriter)pageWriter, ParquetProperties.builder().withDictionaryPageSize(1024).withWriterVersion(ParquetProperties.WriterVersion.PARQUET_2_0).withPageSize(2048).build());
        for (int i = 0; i < this.rows; ++i) {
            columnWriterV2.writeNull(0, 0);
            if ((i + 1) % 1000 != 0) continue;
            columnWriterV2.writePage();
        }
        columnWriterV2.writePage();
        columnWriterV2.finalizeColumnChunk();
        List<DataPage> pages = pageWriter.getPages();
        int valueCount = 0;
        int rowCount = 0;
        for (DataPage dataPage : pages) {
            valueCount += dataPage.getValueCount();
            rowCount += ((DataPageV2)dataPage).getRowCount();
        }
        junit.framework.Assert.assertEquals((int)this.rows, (int)rowCount);
        junit.framework.Assert.assertEquals((int)this.rows, (int)valueCount);
        MemPageReader pageReader = this.toReader(pageWriter);
        ValidatingConverter converter = new ValidatingConverter();
        ColumnReaderImpl columnReader = new ColumnReaderImpl(col, (PageReader)pageReader, (PrimitiveConverter)converter, VersionParser.parse((String)"parquet-mr version 1.16.0 (build 402c3810c372d29603e181771acebfecc71bef61)"));
        for (int i = 0; i < this.rows; ++i) {
            junit.framework.Assert.assertEquals((int)0, (int)columnReader.getCurrentRepetitionLevel());
            junit.framework.Assert.assertEquals((int)0, (int)columnReader.getCurrentDefinitionLevel());
            columnReader.consume();
        }
        junit.framework.Assert.assertEquals((int)0, (int)converter.count);
    }

    @Test
    public void testDeduplicatedDecodedDictionary() throws Exception {
        ColumnDescriptor col = TestColumnReaderImpl.requiredBinaryColumn();
        MemPageWriter pageWriter = this.writeBinaryDictColumn(col);
        DictionaryPage dictionaryPage = pageWriter.getDictionaryPage();
        Assert.assertNotNull((String)"Expected a dictionary", (Object)dictionaryPage);
        final Dictionary dict = dictionaryPage.decode(col);
        MemPageReader pageReader = new MemPageReader(this.rows, pageWriter.getPages().iterator(), new DictionaryPage(BytesInput.empty(), dictionaryPage.getDictionarySize(), dictionaryPage.getEncoding()){

            public Dictionary decode(ColumnDescriptor path) {
                return dict;
            }
        });
        this.validateExpectedValuesAndCount(col, pageReader);
    }

    private static final class ValidatingConverter
    extends PrimitiveConverter {
        int count;

        private ValidatingConverter() {
        }

        public void addBinary(Binary value) {
            junit.framework.Assert.assertEquals((String)("bar" + this.count % 10), (String)value.toStringUsingUTF8());
            ++this.count;
        }
    }
}

