/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.statistics;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.apache.parquet.column.statistics.SizeStatistics;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestSizeStatistics {
    @Test
    public void testAddBinaryType() {
        PrimitiveType type = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("a");
        int maxRepetitionLevel = 2;
        int maxDefinitionLevel = 2;
        SizeStatistics.Builder builder = SizeStatistics.newBuilder((PrimitiveType)type, (int)2, (int)2);
        builder.add(0, 2, Binary.fromString((String)"a"));
        builder.add(1, 2, Binary.fromString((String)""));
        builder.add(2, 2, Binary.fromString((String)"bb"));
        builder.add(0, 0);
        builder.add(0, 1);
        builder.add(1, 0);
        builder.add(1, 1);
        SizeStatistics statistics = builder.build();
        Assert.assertEquals(Optional.of(3L), (Object)statistics.getUnencodedByteArrayDataBytes());
        Assert.assertEquals(Arrays.asList(3L, 3L, 1L), (Object)statistics.getRepetitionLevelHistogram());
        Assert.assertEquals(Arrays.asList(2L, 2L, 3L), (Object)statistics.getDefinitionLevelHistogram());
    }

    @Test
    public void testAddNonBinaryType() {
        PrimitiveType type = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(2)).named("a");
        boolean maxRepetitionLevel = true;
        boolean maxDefinitionLevel = true;
        SizeStatistics.Builder builder = SizeStatistics.newBuilder((PrimitiveType)type, (int)1, (int)1);
        builder.add(0, 1, Binary.fromString((String)"aa"));
        builder.add(0, 1, Binary.fromString((String)"aa"));
        builder.add(1, 1, Binary.fromString((String)"aa"));
        builder.add(1, 0);
        builder.add(1, 0);
        builder.add(1, 0);
        SizeStatistics statistics = builder.build();
        Assert.assertEquals(Optional.empty(), (Object)statistics.getUnencodedByteArrayDataBytes());
        Assert.assertEquals(Arrays.asList(2L, 4L), (Object)statistics.getRepetitionLevelHistogram());
        Assert.assertEquals(Collections.emptyList(), (Object)statistics.getDefinitionLevelHistogram());
    }

    @Test
    public void testMergeStatistics() {
        PrimitiveType type = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("a");
        int maxRepetitionLevel = 2;
        int maxDefinitionLevel = 2;
        SizeStatistics.Builder builder1 = SizeStatistics.newBuilder((PrimitiveType)type, (int)2, (int)2);
        builder1.add(0, 0, Binary.fromString((String)"a"));
        builder1.add(1, 1, Binary.fromString((String)"b"));
        builder1.add(2, 2, Binary.fromString((String)"c"));
        SizeStatistics statistics1 = builder1.build();
        SizeStatistics.Builder builder2 = SizeStatistics.newBuilder((PrimitiveType)type, (int)2, (int)2);
        builder2.add(0, 1, Binary.fromString((String)"d"));
        builder2.add(0, 1, Binary.fromString((String)"e"));
        SizeStatistics statistics2 = builder2.build();
        statistics1.mergeStatistics(statistics2);
        Assert.assertEquals(Optional.of(5L), (Object)statistics1.getUnencodedByteArrayDataBytes());
        Assert.assertEquals(Arrays.asList(3L, 1L, 1L), (Object)statistics1.getRepetitionLevelHistogram());
        Assert.assertEquals(Arrays.asList(1L, 3L, 1L), (Object)statistics1.getDefinitionLevelHistogram());
    }

    @Test
    public void testMergeThrowException() {
        PrimitiveType type1 = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("a");
        PrimitiveType type2 = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("a");
        SizeStatistics.Builder builder1 = SizeStatistics.newBuilder((PrimitiveType)type1, (int)1, (int)1);
        SizeStatistics.Builder builder2 = SizeStatistics.newBuilder((PrimitiveType)type2, (int)1, (int)1);
        SizeStatistics statistics1 = builder1.build();
        SizeStatistics statistics2 = builder2.build();
        Assert.assertThrows(IllegalArgumentException.class, () -> statistics1.mergeStatistics(statistics2));
    }

    @Test
    public void testCopyStatistics() {
        PrimitiveType type = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("a");
        int maxRepetitionLevel = 2;
        int maxDefinitionLevel = 2;
        SizeStatistics.Builder builder = SizeStatistics.newBuilder((PrimitiveType)type, (int)2, (int)2);
        builder.add(0, 0, Binary.fromString((String)"a"));
        builder.add(1, 1, Binary.fromString((String)"b"));
        builder.add(2, 2, Binary.fromString((String)"c"));
        SizeStatistics statistics = builder.build();
        SizeStatistics copy = statistics.copy();
        Assert.assertEquals(Optional.of(3L), (Object)copy.getUnencodedByteArrayDataBytes());
        Assert.assertEquals(Arrays.asList(1L, 1L, 1L), (Object)copy.getRepetitionLevelHistogram());
        Assert.assertEquals(Arrays.asList(1L, 1L, 1L), (Object)copy.getDefinitionLevelHistogram());
    }

    @Test
    public void testOmittedHistogram() {
        PrimitiveType type = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("a");
        SizeStatistics statistics = new SizeStatistics(type, 1024L, null, null);
        Assert.assertEquals(Optional.of(1024L), (Object)statistics.getUnencodedByteArrayDataBytes());
        Assert.assertEquals(Collections.emptyList(), (Object)statistics.getRepetitionLevelHistogram());
        Assert.assertEquals(Collections.emptyList(), (Object)statistics.getDefinitionLevelHistogram());
        SizeStatistics copy = statistics.copy();
        Assert.assertEquals(Optional.of(1024L), (Object)copy.getUnencodedByteArrayDataBytes());
        Assert.assertEquals(Collections.emptyList(), (Object)copy.getRepetitionLevelHistogram());
        Assert.assertEquals(Collections.emptyList(), (Object)copy.getDefinitionLevelHistogram());
    }
}

