/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.statistics.geospatial;

import org.apache.parquet.column.statistics.geospatial.BoundingBox;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;

public class TestBoundingBox {
    @Test
    public void testUpdate() {
        GeometryFactory geometryFactory = new GeometryFactory();
        BoundingBox boundingBox = new BoundingBox();
        Point point2D = geometryFactory.createPoint(new Coordinate(10.0, 20.0));
        boundingBox.update((Geometry)point2D);
        Assert.assertTrue((boolean)boundingBox.isValid());
        Assert.assertEquals((double)10.0, (double)boundingBox.getXMin(), (double)0.0);
        Assert.assertEquals((double)10.0, (double)boundingBox.getXMax(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)boundingBox.getYMin(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)boundingBox.getYMax(), (double)0.0);
    }

    @Test
    public void testEmptyGeometry() {
        GeometryFactory geometryFactory = new GeometryFactory();
        BoundingBox boundingBox = new BoundingBox();
        Point emptyPoint = geometryFactory.createPoint();
        boundingBox.update((Geometry)emptyPoint);
        Assert.assertTrue((boolean)boundingBox.isValid());
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)boundingBox.getXMin(), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)boundingBox.getXMax(), (double)0.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)boundingBox.getYMin(), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)boundingBox.getYMax(), (double)0.0);
        Point point = geometryFactory.createPoint(new Coordinate(10.0, 20.0));
        boundingBox.update((Geometry)point);
        Assert.assertTrue((boolean)boundingBox.isValid());
        Assert.assertEquals((double)10.0, (double)boundingBox.getXMin(), (double)0.0);
        Assert.assertEquals((double)10.0, (double)boundingBox.getXMax(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)boundingBox.getYMin(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)boundingBox.getYMax(), (double)0.0);
        boundingBox.update((Geometry)emptyPoint);
        Assert.assertTrue((boolean)boundingBox.isValid());
        Assert.assertEquals((double)10.0, (double)boundingBox.getXMin(), (double)0.0);
        Assert.assertEquals((double)10.0, (double)boundingBox.getXMax(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)boundingBox.getYMin(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)boundingBox.getYMax(), (double)0.0);
    }

    @Test
    public void testNaNCoordinates() {
        GeometryFactory geometryFactory = new GeometryFactory();
        BoundingBox boundingBox = new BoundingBox();
        Point nanPoint = geometryFactory.createPoint(new Coordinate(Double.NaN, Double.NaN));
        boundingBox.update((Geometry)nanPoint);
        Assert.assertTrue((boolean)boundingBox.isValid());
        Assert.assertTrue((boolean)boundingBox.isXYEmpty());
        boundingBox = new BoundingBox();
        Point mixedPoint = geometryFactory.createPoint(new Coordinate(15.0, Double.NaN));
        boundingBox.update((Geometry)mixedPoint);
        Assert.assertTrue((boolean)boundingBox.isValid());
        Assert.assertTrue((boolean)boundingBox.isXYEmpty());
    }

    @Test
    public void testNaNZAndMValues() {
        GeometryFactory geometryFactory = new GeometryFactory();
        BoundingBox boundingBox = new BoundingBox();
        Coordinate coord = new Coordinate(10.0, 20.0);
        coord.setZ(Double.NaN);
        Point nanZPoint = geometryFactory.createPoint(coord);
        boundingBox.update((Geometry)nanZPoint);
        Assert.assertTrue((boolean)boundingBox.isValid());
        Assert.assertEquals((double)10.0, (double)boundingBox.getXMin(), (double)0.0);
        Assert.assertEquals((double)10.0, (double)boundingBox.getXMax(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)boundingBox.getYMin(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)boundingBox.getYMax(), (double)0.0);
        Coordinate coord2 = new Coordinate(15.0, 25.0, 30.0);
        Point validZPoint = geometryFactory.createPoint(coord2);
        boundingBox.update((Geometry)validZPoint);
        Assert.assertTrue((boolean)boundingBox.isValid());
        Assert.assertEquals((double)10.0, (double)boundingBox.getXMin(), (double)0.0);
        Assert.assertEquals((double)15.0, (double)boundingBox.getXMax(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)boundingBox.getYMin(), (double)0.0);
        Assert.assertEquals((double)25.0, (double)boundingBox.getYMax(), (double)0.0);
        Assert.assertEquals((double)30.0, (double)boundingBox.getZMin(), (double)0.0);
        Assert.assertEquals((double)30.0, (double)boundingBox.getZMax(), (double)0.0);
        boundingBox.reset();
        CoordinateXYZM coordNanM = new CoordinateXYZM(10.0, 20.0, 30.0, Double.NaN);
        Point nanMPoint = geometryFactory.createPoint((Coordinate)coordNanM);
        boundingBox.update((Geometry)nanMPoint);
        Assert.assertTrue((boolean)boundingBox.isValid());
        Assert.assertEquals((double)10.0, (double)boundingBox.getXMin(), (double)0.0);
        Assert.assertEquals((double)10.0, (double)boundingBox.getXMax(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)boundingBox.getYMin(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)boundingBox.getYMax(), (double)0.0);
        Assert.assertEquals((double)30.0, (double)boundingBox.getZMin(), (double)0.0);
        Assert.assertEquals((double)30.0, (double)boundingBox.getZMax(), (double)0.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)boundingBox.getMMin(), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)boundingBox.getMMax(), (double)0.0);
        CoordinateXYZM coordValidM = new CoordinateXYZM(15.0, 25.0, 35.0, 40.0);
        Point validMPoint = geometryFactory.createPoint((Coordinate)coordValidM);
        boundingBox.update((Geometry)validMPoint);
        Assert.assertTrue((boolean)boundingBox.isValid());
        Assert.assertEquals((double)10.0, (double)boundingBox.getXMin(), (double)0.0);
        Assert.assertEquals((double)15.0, (double)boundingBox.getXMax(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)boundingBox.getYMin(), (double)0.0);
        Assert.assertEquals((double)25.0, (double)boundingBox.getYMax(), (double)0.0);
        Assert.assertEquals((double)30.0, (double)boundingBox.getZMin(), (double)0.0);
        Assert.assertEquals((double)35.0, (double)boundingBox.getZMax(), (double)0.0);
        Assert.assertEquals((double)40.0, (double)boundingBox.getMMin(), (double)0.0);
        Assert.assertEquals((double)40.0, (double)boundingBox.getMMax(), (double)0.0);
    }

    @Test
    public void testAbort() {
        GeometryFactory geometryFactory = new GeometryFactory();
        BoundingBox boundingBox = new BoundingBox();
        Point validPoint = geometryFactory.createPoint(new Coordinate(10.0, 20.0));
        boundingBox.update((Geometry)validPoint);
        Assert.assertTrue((boolean)boundingBox.isValid());
        Assert.assertEquals((double)10.0, (double)boundingBox.getXMin(), (double)0.0);
        Assert.assertEquals((double)10.0, (double)boundingBox.getXMax(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)boundingBox.getYMin(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)boundingBox.getYMax(), (double)0.0);
        boundingBox.abort();
        Assert.assertFalse((boolean)boundingBox.isValid());
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)boundingBox.getXMin(), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)boundingBox.getXMax(), (double)0.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)boundingBox.getYMin(), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)boundingBox.getYMax(), (double)0.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)boundingBox.getZMin(), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)boundingBox.getZMax(), (double)0.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)boundingBox.getMMin(), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)boundingBox.getMMax(), (double)0.0);
    }

    @Test
    public void testEmptyBoundingBox() {
        BoundingBox boundingBox = new BoundingBox();
        Assert.assertTrue((boolean)boundingBox.isValid());
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)boundingBox.getXMin(), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)boundingBox.getXMax(), (double)0.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)boundingBox.getYMin(), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)boundingBox.getYMax(), (double)0.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)boundingBox.getZMin(), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)boundingBox.getZMax(), (double)0.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)boundingBox.getMMin(), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)boundingBox.getMMax(), (double)0.0);
    }

    @Test
    public void testMergeBoundingBoxes() {
        BoundingBox boundingBox1 = new BoundingBox(0.0, 10.0, 0.0, 20.0, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        BoundingBox boundingBox2 = new BoundingBox(5.0, 15.0, 10.0, 30.0, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        boundingBox1.merge(boundingBox2);
        Assert.assertTrue((boolean)boundingBox1.isValid());
        Assert.assertEquals((double)0.0, (double)boundingBox1.getXMin(), (double)0.0);
        Assert.assertEquals((double)15.0, (double)boundingBox1.getXMax(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)boundingBox1.getYMin(), (double)0.0);
        Assert.assertEquals((double)30.0, (double)boundingBox1.getYMax(), (double)0.0);
        Assert.assertTrue((boolean)Double.isNaN(boundingBox1.getZMin()));
        Assert.assertTrue((boolean)Double.isNaN(boundingBox1.getZMax()));
        Assert.assertTrue((boolean)Double.isNaN(boundingBox1.getMMin()));
        Assert.assertTrue((boolean)Double.isNaN(boundingBox1.getMMax()));
    }

    @Test
    public void testMergeWithEmptyBoundingBox() {
        BoundingBox boundingBox1 = new BoundingBox(0.0, 10.0, 0.0, 20.0, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        BoundingBox emptyBoundingBox = new BoundingBox();
        boundingBox1.merge(emptyBoundingBox);
        Assert.assertTrue((boolean)boundingBox1.isValid());
        Assert.assertEquals((double)0.0, (double)boundingBox1.getXMin(), (double)0.0);
        Assert.assertEquals((double)10.0, (double)boundingBox1.getXMax(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)boundingBox1.getYMin(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)boundingBox1.getYMax(), (double)0.0);
        Assert.assertTrue((boolean)Double.isNaN(boundingBox1.getZMin()));
        Assert.assertTrue((boolean)Double.isNaN(boundingBox1.getZMax()));
        Assert.assertTrue((boolean)Double.isNaN(boundingBox1.getMMin()));
        Assert.assertTrue((boolean)Double.isNaN(boundingBox1.getMMax()));
    }

    @Test
    public void testUpdateWithNullGeometry() {
        BoundingBox boundingBox = new BoundingBox();
        boundingBox.update(null);
        Assert.assertTrue((boolean)boundingBox.isValid());
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)boundingBox.getXMin(), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)boundingBox.getXMax(), (double)0.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)boundingBox.getYMin(), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)boundingBox.getYMax(), (double)0.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)boundingBox.getZMin(), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)boundingBox.getZMax(), (double)0.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)boundingBox.getMMin(), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)boundingBox.getMMax(), (double)0.0);
    }

    @Test
    public void testMergeWithNaNValues() {
        BoundingBox box1 = new BoundingBox(0.0, 10.0, 0.0, 10.0, 0.0, 10.0, 0.0, 10.0);
        BoundingBox box2 = new BoundingBox(5.0, 15.0, Double.NaN, Double.NaN, 5.0, 15.0, Double.NaN, Double.NaN);
        box1.merge(box2);
        Assert.assertFalse((String)"Box1 should be invalid after the merge", (boolean)box1.isValid());
    }

    @Test
    public void testUpdateWithAllNaNCoordinatesAfterValid() {
        GeometryFactory gf = new GeometryFactory();
        BoundingBox box = new BoundingBox();
        box.update((Geometry)gf.createPoint(new Coordinate(10.0, 20.0)));
        Assert.assertTrue((boolean)box.isValid());
        Assert.assertEquals((double)10.0, (double)box.getXMin(), (double)0.0);
        Assert.assertEquals((double)10.0, (double)box.getXMax(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)box.getYMin(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)box.getYMax(), (double)0.0);
        Point nanPoint = gf.createPoint(new Coordinate(Double.NaN, Double.NaN));
        box.update((Geometry)nanPoint);
        Assert.assertFalse((String)"Box should be empty after the merge", (boolean)box.isXYEmpty());
        Assert.assertTrue((String)"Box should be valid after the merge", (boolean)box.isValid());
    }

    @Test
    public void testUpdate3DPoint() {
        GeometryFactory gf = new GeometryFactory();
        BoundingBox box = new BoundingBox();
        Coordinate coord = new Coordinate(10.0, 20.0, 30.0);
        Point point3D = gf.createPoint(coord);
        box.update((Geometry)point3D);
        Assert.assertTrue((boolean)box.isValid());
        Assert.assertEquals((double)10.0, (double)box.getXMin(), (double)0.0);
        Assert.assertEquals((double)10.0, (double)box.getXMax(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)box.getYMin(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)box.getYMax(), (double)0.0);
        Assert.assertEquals((double)30.0, (double)box.getZMin(), (double)0.0);
        Assert.assertEquals((double)30.0, (double)box.getZMax(), (double)0.0);
        box.update((Geometry)gf.createPoint(new Coordinate(15.0, 25.0, 10.0)));
        Assert.assertTrue((boolean)box.isValid());
        Assert.assertEquals((double)10.0, (double)box.getXMin(), (double)0.0);
        Assert.assertEquals((double)15.0, (double)box.getXMax(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)box.getYMin(), (double)0.0);
        Assert.assertEquals((double)25.0, (double)box.getYMax(), (double)0.0);
        Assert.assertEquals((double)10.0, (double)box.getZMin(), (double)0.0);
        Assert.assertEquals((double)30.0, (double)box.getZMax(), (double)0.0);
    }

    @Test
    public void testUpdateWithMeasureValue() {
        GeometryFactory gf = new GeometryFactory();
        BoundingBox box = new BoundingBox();
        CoordinateXYZM coord = new CoordinateXYZM(10.0, 20.0, Double.NaN, 5.0);
        Point pointWithM = gf.createPoint((Coordinate)coord);
        box.update((Geometry)pointWithM);
        Assert.assertTrue((boolean)box.isValid());
        Assert.assertEquals((double)10.0, (double)box.getXMin(), (double)0.0);
        Assert.assertEquals((double)10.0, (double)box.getXMax(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)box.getYMin(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)box.getYMax(), (double)0.0);
        Assert.assertEquals((double)5.0, (double)box.getMMin(), (double)0.0);
        Assert.assertEquals((double)5.0, (double)box.getMMax(), (double)0.0);
        CoordinateXYZM coord2 = new CoordinateXYZM(15.0, 25.0, Double.NaN, 10.0);
        box.update((Geometry)gf.createPoint((Coordinate)coord2));
        Assert.assertTrue((boolean)box.isValid());
        Assert.assertEquals((double)10.0, (double)box.getXMin(), (double)0.0);
        Assert.assertEquals((double)15.0, (double)box.getXMax(), (double)0.0);
        Assert.assertEquals((double)20.0, (double)box.getYMin(), (double)0.0);
        Assert.assertEquals((double)25.0, (double)box.getYMax(), (double)0.0);
        Assert.assertEquals((double)5.0, (double)box.getMMin(), (double)0.0);
        Assert.assertEquals((double)10.0, (double)box.getMMax(), (double)0.0);
    }

    @Test
    public void testResetAfterUpdate() {
        GeometryFactory gf = new GeometryFactory();
        BoundingBox box = new BoundingBox();
        box.update((Geometry)gf.createPoint(new Coordinate(10.0, 20.0)));
        Assert.assertTrue((boolean)box.isValid());
        Assert.assertEquals((double)10.0, (double)box.getXMin(), (double)0.0);
        box.reset();
        Assert.assertTrue((boolean)box.isValid());
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)box.getXMin(), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)box.getXMax(), (double)0.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)box.getYMin(), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)box.getYMax(), (double)0.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)box.getZMin(), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)box.getZMax(), (double)0.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)box.getMMin(), (double)0.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)box.getMMax(), (double)0.0);
        box.update((Geometry)gf.createPoint(new Coordinate(30.0, 40.0)));
        Assert.assertTrue((boolean)box.isValid());
        Assert.assertEquals((double)30.0, (double)box.getXMin(), (double)0.0);
        Assert.assertEquals((double)30.0, (double)box.getXMax(), (double)0.0);
        Assert.assertEquals((double)40.0, (double)box.getYMin(), (double)0.0);
        Assert.assertEquals((double)40.0, (double)box.getYMax(), (double)0.0);
    }

    @Test
    public void testCopy() {
        BoundingBox original = new BoundingBox(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0);
        BoundingBox copy = original.copy();
        Assert.assertTrue((boolean)original.isValid());
        Assert.assertEquals((double)original.getXMin(), (double)copy.getXMin(), (double)0.0);
        Assert.assertEquals((double)original.getXMax(), (double)copy.getXMax(), (double)0.0);
        Assert.assertEquals((double)original.getYMin(), (double)copy.getYMin(), (double)0.0);
        Assert.assertEquals((double)original.getYMax(), (double)copy.getYMax(), (double)0.0);
        Assert.assertEquals((double)original.getZMin(), (double)copy.getZMin(), (double)0.0);
        Assert.assertEquals((double)original.getZMax(), (double)copy.getZMax(), (double)0.0);
        Assert.assertEquals((double)original.getMMin(), (double)copy.getMMin(), (double)0.0);
        Assert.assertEquals((double)original.getMMax(), (double)copy.getMMax(), (double)0.0);
        copy.reset();
        Assert.assertTrue((boolean)original.isValid());
        Assert.assertEquals((double)1.0, (double)original.getXMin(), (double)0.0);
    }

    @Test
    public void testMergeWithAllNaNBox() {
        BoundingBox box1 = new BoundingBox(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0);
        BoundingBox box2 = new BoundingBox();
        box1.merge(box2);
        Assert.assertTrue((boolean)box1.isValid());
        Assert.assertEquals((double)1.0, (double)box1.getXMin(), (double)0.0);
        Assert.assertEquals((double)2.0, (double)box1.getXMax(), (double)0.0);
        Assert.assertEquals((double)3.0, (double)box1.getYMin(), (double)0.0);
        Assert.assertEquals((double)4.0, (double)box1.getYMax(), (double)0.0);
        Assert.assertEquals((double)5.0, (double)box1.getZMin(), (double)0.0);
        Assert.assertEquals((double)6.0, (double)box1.getZMax(), (double)0.0);
        Assert.assertEquals((double)7.0, (double)box1.getMMin(), (double)0.0);
        Assert.assertEquals((double)8.0, (double)box1.getMMax(), (double)0.0);
        BoundingBox box3 = new BoundingBox();
        box3.merge(box1);
        Assert.assertTrue((boolean)box1.isValid());
        Assert.assertEquals((double)1.0, (double)box3.getXMin(), (double)0.0);
        Assert.assertEquals((double)2.0, (double)box3.getXMax(), (double)0.0);
        Assert.assertEquals((double)3.0, (double)box3.getYMin(), (double)0.0);
        Assert.assertEquals((double)4.0, (double)box3.getYMax(), (double)0.0);
    }

    @Test
    public void testLineStringWithNaNCoordinates() {
        GeometryFactory gf = new GeometryFactory();
        BoundingBox box = new BoundingBox();
        Coordinate[] coords = new Coordinate[]{new Coordinate(0.0, 1.0), new Coordinate(Double.NaN, Double.NaN), new Coordinate(2.0, 3.0)};
        box.update((Geometry)gf.createLineString(coords));
        Assert.assertTrue((boolean)box.isValid());
        Assert.assertEquals((double)0.0, (double)box.getXMin(), (double)0.0);
        Assert.assertEquals((double)2.0, (double)box.getXMax(), (double)0.0);
        Assert.assertEquals((double)1.0, (double)box.getYMin(), (double)0.0);
        Assert.assertEquals((double)3.0, (double)box.getYMax(), (double)0.0);
        BoundingBox box2 = new BoundingBox();
        Coordinate[] coords2 = new Coordinate[]{new Coordinate(5.0, 6.0), new Coordinate(Double.NaN, Double.NaN), new Coordinate(Double.NaN, Double.NaN)};
        box2.update((Geometry)gf.createLineString(coords2));
        Assert.assertTrue((boolean)box2.isValid());
        Assert.assertEquals((double)5.0, (double)box2.getXMin(), (double)0.0);
        Assert.assertEquals((double)5.0, (double)box2.getXMax(), (double)0.0);
        Assert.assertEquals((double)6.0, (double)box2.getYMin(), (double)0.0);
        Assert.assertEquals((double)6.0, (double)box2.getYMax(), (double)0.0);
        BoundingBox box3 = new BoundingBox();
        Coordinate[] coords3 = new Coordinate[]{new Coordinate(Double.NaN, Double.NaN), new Coordinate(Double.NaN, Double.NaN)};
        box3.update((Geometry)gf.createLineString(coords3));
        Assert.assertTrue((boolean)box3.isValid());
        Assert.assertTrue((boolean)box3.isXYEmpty());
    }

    @Test
    public void testLineStringWithPartialNaNCoordinates() {
        GeometryFactory gf = new GeometryFactory();
        BoundingBox box = new BoundingBox();
        Coordinate[] coords = new Coordinate[]{new Coordinate(0.0, 1.0), new Coordinate(1.0, Double.NaN), new Coordinate(2.0, 3.0)};
        box.update((Geometry)gf.createLineString(coords));
        Assert.assertTrue((boolean)box.isValid());
        Assert.assertEquals((double)0.0, (double)box.getXMin(), (double)0.0);
        Assert.assertEquals((double)2.0, (double)box.getXMax(), (double)0.0);
        Assert.assertEquals((double)1.0, (double)box.getYMin(), (double)0.0);
        Assert.assertEquals((double)3.0, (double)box.getYMax(), (double)0.0);
        BoundingBox box2 = new BoundingBox();
        Coordinate[] coords2 = new Coordinate[]{new Coordinate(Double.NaN, 5.0), new Coordinate(6.0, Double.NaN), new Coordinate(7.0, 8.0)};
        box2.update((Geometry)gf.createLineString(coords2));
        Assert.assertTrue((boolean)box2.isValid());
        Assert.assertTrue((boolean)box2.isXYEmpty());
    }

    @Test
    public void testMergingRowGroupBoundingBoxes() {
        GeometryFactory gf = new GeometryFactory();
        BoundingBox fileBBox = new BoundingBox();
        BoundingBox rowGroup1 = new BoundingBox();
        rowGroup1.update((Geometry)gf.createPoint(new Coordinate(1.0, 100.0)));
        rowGroup1.update((Geometry)gf.createPoint(new Coordinate(2.0, Double.NaN)));
        Assert.assertTrue((boolean)rowGroup1.isValid());
        Assert.assertEquals((double)1.0, (double)rowGroup1.getXMin(), (double)0.0);
        Assert.assertEquals((double)2.0, (double)rowGroup1.getXMax(), (double)0.0);
        Assert.assertEquals((double)100.0, (double)rowGroup1.getYMin(), (double)0.0);
        Assert.assertEquals((double)100.0, (double)rowGroup1.getYMax(), (double)0.0);
        Assert.assertTrue((boolean)rowGroup1.isValid());
        BoundingBox rowGroup2 = new BoundingBox();
        rowGroup2.update((Geometry)gf.createPoint(new Coordinate(3.0, 300.0)));
        Coordinate nanCoord = new Coordinate(Double.NaN, Double.NaN);
        rowGroup2.update((Geometry)gf.createPoint(nanCoord));
        Assert.assertTrue((boolean)rowGroup2.isValid());
        Assert.assertEquals((double)3.0, (double)rowGroup2.getXMin(), (double)0.0);
        Assert.assertEquals((double)3.0, (double)rowGroup2.getXMax(), (double)0.0);
        Assert.assertEquals((double)300.0, (double)rowGroup2.getYMin(), (double)0.0);
        Assert.assertEquals((double)300.0, (double)rowGroup2.getYMax(), (double)0.0);
        Assert.assertTrue((boolean)rowGroup2.isValid());
        BoundingBox rowGroup3 = new BoundingBox();
        rowGroup3.update((Geometry)gf.createPoint(new Coordinate(5.0, Double.NaN)));
        rowGroup3.update((Geometry)gf.createPoint(new Coordinate(6.0, Double.NaN)));
        Assert.assertTrue((boolean)rowGroup3.isXYEmpty());
        BoundingBox rowGroup4 = new BoundingBox();
        rowGroup4.update((Geometry)gf.createPoint(new Coordinate(7.0, 700.0)));
        rowGroup4.update((Geometry)gf.createPoint(new Coordinate(8.0, 800.0)));
        Assert.assertTrue((boolean)rowGroup4.isValid());
        Assert.assertEquals((double)7.0, (double)rowGroup4.getXMin(), (double)0.0);
        Assert.assertEquals((double)8.0, (double)rowGroup4.getXMax(), (double)0.0);
        Assert.assertEquals((double)700.0, (double)rowGroup4.getYMin(), (double)0.0);
        Assert.assertEquals((double)800.0, (double)rowGroup4.getYMax(), (double)0.0);
        Assert.assertTrue((boolean)rowGroup4.isValid());
        BoundingBox rowGroup5 = new BoundingBox();
        rowGroup5.update((Geometry)gf.createPoint(nanCoord));
        rowGroup5.update((Geometry)gf.createPoint(nanCoord));
        Assert.assertTrue((boolean)rowGroup5.isXYEmpty());
        BoundingBox rowGroup6 = new BoundingBox();
        LineString emptyLineString = gf.createLineString(new Coordinate[0]);
        Coordinate pointCoord = new Coordinate(9.0, 900.0);
        Point validPoint = gf.createPoint(pointCoord);
        rowGroup6.update((Geometry)emptyLineString);
        rowGroup6.update((Geometry)validPoint);
        Assert.assertTrue((boolean)rowGroup6.isValid());
        Assert.assertEquals((double)9.0, (double)rowGroup6.getXMin(), (double)0.0);
        Assert.assertEquals((double)9.0, (double)rowGroup6.getXMax(), (double)0.0);
        Assert.assertEquals((double)900.0, (double)rowGroup6.getYMin(), (double)0.0);
        Assert.assertEquals((double)900.0, (double)rowGroup6.getYMax(), (double)0.0);
        fileBBox.merge(rowGroup1);
        fileBBox.merge(rowGroup2);
        fileBBox.merge(rowGroup3);
        fileBBox.merge(rowGroup4);
        fileBBox.merge(rowGroup5);
        fileBBox.merge(rowGroup6);
        Assert.assertTrue((boolean)fileBBox.isValid());
        Assert.assertEquals((double)1.0, (double)fileBBox.getXMin(), (double)0.0);
        Assert.assertEquals((double)9.0, (double)fileBBox.getXMax(), (double)0.0);
        Assert.assertEquals((double)100.0, (double)fileBBox.getYMin(), (double)0.0);
        Assert.assertEquals((double)900.0, (double)fileBBox.getYMax(), (double)0.0);
        Assert.assertTrue((boolean)fileBBox.isValid());
        BoundingBox reverseMergeBox = new BoundingBox();
        reverseMergeBox.merge(rowGroup6);
        reverseMergeBox.merge(rowGroup5);
        reverseMergeBox.merge(rowGroup4);
        reverseMergeBox.merge(rowGroup3);
        reverseMergeBox.merge(rowGroup2);
        reverseMergeBox.merge(rowGroup1);
        Assert.assertTrue((boolean)reverseMergeBox.isValid());
        Assert.assertEquals((double)1.0, (double)reverseMergeBox.getXMin(), (double)0.0);
        Assert.assertEquals((double)9.0, (double)reverseMergeBox.getXMax(), (double)0.0);
        Assert.assertEquals((double)100.0, (double)reverseMergeBox.getYMin(), (double)0.0);
        Assert.assertEquals((double)900.0, (double)reverseMergeBox.getYMax(), (double)0.0);
        Assert.assertTrue((boolean)reverseMergeBox.isValid());
    }

    @Test
    public void testIsXValidAndIsYValid() {
        BoundingBox validBox = new BoundingBox(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0);
        Assert.assertTrue((boolean)validBox.isXValid());
        Assert.assertTrue((boolean)validBox.isYValid());
        Assert.assertTrue((boolean)validBox.isXYValid());
        Assert.assertTrue((boolean)validBox.isZValid());
        Assert.assertTrue((boolean)validBox.isMValid());
        BoundingBox invalidXBox = new BoundingBox(Double.NaN, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0);
        Assert.assertFalse((boolean)invalidXBox.isXValid());
        Assert.assertTrue((boolean)invalidXBox.isYValid());
        Assert.assertFalse((boolean)invalidXBox.isXYValid());
        Assert.assertTrue((boolean)invalidXBox.isZValid());
        Assert.assertTrue((boolean)invalidXBox.isMValid());
        BoundingBox invalidYBox = new BoundingBox(1.0, 2.0, Double.NaN, 4.0, 5.0, 6.0, 7.0, 8.0);
        Assert.assertTrue((boolean)invalidYBox.isXValid());
        Assert.assertFalse((boolean)invalidYBox.isYValid());
        Assert.assertFalse((boolean)invalidXBox.isXYValid());
        Assert.assertTrue((boolean)invalidXBox.isZValid());
        Assert.assertTrue((boolean)invalidXBox.isMValid());
        BoundingBox invalidXYBox = new BoundingBox(Double.NaN, Double.NaN, Double.NaN, Double.NaN, 5.0, 6.0, 7.0, 8.0);
        Assert.assertFalse((boolean)invalidXYBox.isXValid());
        Assert.assertFalse((boolean)invalidXYBox.isYValid());
        Assert.assertFalse((boolean)invalidXYBox.isXYValid());
        Assert.assertTrue((boolean)invalidXBox.isZValid());
        Assert.assertTrue((boolean)invalidXBox.isMValid());
    }

    @Test
    public void testIsXEmptyAndIsYEmpty() {
        BoundingBox emptyBox = new BoundingBox();
        Assert.assertTrue((boolean)emptyBox.isXEmpty());
        Assert.assertTrue((boolean)emptyBox.isYEmpty());
        Assert.assertTrue((boolean)emptyBox.isXYEmpty());
        BoundingBox nonEmptyBox = new BoundingBox(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0);
        Assert.assertFalse((boolean)nonEmptyBox.isXEmpty());
        Assert.assertFalse((boolean)nonEmptyBox.isYEmpty());
        Assert.assertFalse((boolean)nonEmptyBox.isXYEmpty());
        GeometryFactory gf = new GeometryFactory();
        BoundingBox emptyXBox = new BoundingBox();
        emptyXBox.update((Geometry)gf.createPoint(new Coordinate(Double.NaN, 5.0)));
        Assert.assertTrue((boolean)emptyXBox.isXEmpty());
        Assert.assertFalse((boolean)emptyXBox.isYEmpty());
        Assert.assertTrue((boolean)emptyXBox.isXYEmpty());
        BoundingBox emptyYBox = new BoundingBox();
        emptyYBox.update((Geometry)gf.createPoint(new Coordinate(10.0, Double.NaN)));
        Assert.assertFalse((boolean)emptyYBox.isXEmpty());
        Assert.assertTrue((boolean)emptyYBox.isYEmpty());
        Assert.assertTrue((boolean)emptyYBox.isXYEmpty());
    }

    @Test
    public void testIsXWraparound() {
        BoundingBox normalBox = new BoundingBox(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0);
        Assert.assertFalse((boolean)normalBox.isXWraparound());
        BoundingBox wraparoundBox = new BoundingBox(170.0, 20.0, 10.0, 20.0, 0.0, 0.0, 0.0, 0.0);
        Assert.assertTrue((boolean)wraparoundBox.isXWraparound());
        BoundingBox equalBoundsBox = new BoundingBox(10.0, 10.0, 20.0, 20.0, 0.0, 0.0, 0.0, 0.0);
        Assert.assertFalse((boolean)equalBoundsBox.isXWraparound());
        Assert.assertTrue((boolean)BoundingBox.isWraparound((double)180.0, (double)-180.0));
        Assert.assertFalse((boolean)BoundingBox.isWraparound((double)-180.0, (double)180.0));
        Assert.assertFalse((boolean)BoundingBox.isWraparound((double)Double.POSITIVE_INFINITY, (double)Double.NEGATIVE_INFINITY));
        Assert.assertFalse((boolean)BoundingBox.isWraparound((double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY));
        Assert.assertFalse((boolean)BoundingBox.isWraparound((double)Double.POSITIVE_INFINITY, (double)Double.POSITIVE_INFINITY));
        Assert.assertFalse((boolean)BoundingBox.isWraparound((double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY));
        Assert.assertFalse((boolean)BoundingBox.isWraparound((double)0.0, (double)Double.POSITIVE_INFINITY));
        Assert.assertFalse((boolean)BoundingBox.isWraparound((double)Double.NEGATIVE_INFINITY, (double)0.0));
    }

    @Test
    public void testWraparoundHandlingInMerge() {
        BoundingBox box1 = new BoundingBox(10.0, 20.0, 10.0, 20.0, 0.0, 0.0, 0.0, 0.0);
        BoundingBox box2 = new BoundingBox(15.0, 25.0, 15.0, 25.0, 0.0, 0.0, 0.0, 0.0);
        box1.merge(box2);
        Assert.assertTrue((boolean)box1.isValid());
        Assert.assertEquals((double)10.0, (double)box1.getXMin(), (double)0.0);
        Assert.assertEquals((double)25.0, (double)box1.getXMax(), (double)0.0);
        BoundingBox normalBox = new BoundingBox(0.0, 10.0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0);
        BoundingBox wraparoundBox = new BoundingBox(170.0, -170.0, 5.0, 15.0, 0.0, 0.0, 0.0, 0.0);
        normalBox.merge(wraparoundBox);
        Assert.assertFalse((boolean)normalBox.isValid());
        Assert.assertTrue((boolean)Double.isNaN(normalBox.getXMin()));
        Assert.assertTrue((boolean)Double.isNaN(normalBox.getXMax()));
        Assert.assertEquals((double)0.0, (double)normalBox.getYMin(), (double)0.0);
        Assert.assertEquals((double)15.0, (double)normalBox.getYMax(), (double)0.0);
    }

    @Test
    public void testWraparoundBoxMergingNormalBox() {
        BoundingBox normalBox = new BoundingBox(0.0, 10.0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0);
        BoundingBox wraparoundBox = new BoundingBox(170.0, -170.0, 5.0, 15.0, 0.0, 0.0, 0.0, 0.0);
        wraparoundBox.merge(normalBox);
        Assert.assertFalse((boolean)wraparoundBox.isValid());
        Assert.assertTrue((boolean)Double.isNaN(wraparoundBox.getXMin()));
        Assert.assertTrue((boolean)Double.isNaN(wraparoundBox.getXMax()));
        Assert.assertEquals((double)0.0, (double)wraparoundBox.getYMin(), (double)0.0);
        Assert.assertEquals((double)15.0, (double)wraparoundBox.getYMax(), (double)0.0);
    }
}

