/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.statistics.geospatial;

import org.apache.parquet.column.statistics.geospatial.GeospatialStatistics;
import org.apache.parquet.column.statistics.geospatial.GeospatialTypes;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTReader;

public class TestGeospatialStatistics {
    @Test
    public void testAddGeospatialData() throws ParseException {
        PrimitiveType type = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.geometryType(null))).named("a");
        GeospatialStatistics.Builder builder = GeospatialStatistics.newBuilder((PrimitiveType)type);
        WKTReader wktReader = new WKTReader();
        WKBWriter wkbWriter = new WKBWriter();
        builder.update(Binary.fromConstantByteArray((byte[])wkbWriter.write(wktReader.read("POINT (1 1)"))));
        builder.update(Binary.fromConstantByteArray((byte[])wkbWriter.write(wktReader.read("POINT (2 2)"))));
        GeospatialStatistics statistics = builder.build();
        Assert.assertTrue((boolean)statistics.isValid());
        Assert.assertNotNull((Object)statistics.getBoundingBox());
        Assert.assertNotNull((Object)statistics.getGeospatialTypes());
    }

    @Test
    public void testMergeGeospatialStatistics() throws ParseException {
        PrimitiveType type = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.geometryType(null))).named("a");
        WKTReader wktReader = new WKTReader();
        WKBWriter wkbWriter = new WKBWriter();
        GeospatialStatistics.Builder builder1 = GeospatialStatistics.newBuilder((PrimitiveType)type);
        builder1.update(Binary.fromConstantByteArray((byte[])wkbWriter.write(wktReader.read("POINT (1 1)"))));
        GeospatialStatistics statistics1 = builder1.build();
        GeospatialStatistics.Builder builder2 = GeospatialStatistics.newBuilder((PrimitiveType)type);
        builder2.update(Binary.fromConstantByteArray((byte[])wkbWriter.write(wktReader.read("POINT (2 2)"))));
        GeospatialStatistics statistics2 = builder2.build();
        statistics1.merge(statistics2);
        Assert.assertTrue((boolean)statistics1.isValid());
        Assert.assertNotNull((Object)statistics1.getBoundingBox());
        Assert.assertNotNull((Object)statistics1.getGeospatialTypes());
    }

    @Test
    public void testMergeNullGeospatialStatistics() {
        PrimitiveType type = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.geometryType(null))).named("a");
        WKTReader wktReader = new WKTReader();
        WKBWriter wkbWriter = new WKBWriter();
        GeospatialStatistics.Builder validBuilder = GeospatialStatistics.newBuilder((PrimitiveType)type);
        try {
            validBuilder.update(Binary.fromConstantByteArray((byte[])wkbWriter.write(wktReader.read("POINT (1 1)"))));
        }
        catch (ParseException e) {
            Assert.fail((String)("Failed to parse valid WKT: " + e.getMessage()));
        }
        GeospatialStatistics validStats = validBuilder.build();
        Assert.assertTrue((boolean)validStats.isValid());
        GeospatialStatistics nullStats = new GeospatialStatistics(null, null);
        Assert.assertFalse((boolean)nullStats.isValid());
        GeospatialStatistics validCopy = validStats.copy();
        validCopy.merge(nullStats);
        Assert.assertFalse((boolean)validCopy.isValid());
        Assert.assertNotNull((Object)validCopy.getBoundingBox());
        Assert.assertNotNull((Object)validCopy.getGeospatialTypes());
        nullStats = new GeospatialStatistics(null, null);
        nullStats.merge(validStats);
        Assert.assertFalse((boolean)nullStats.isValid());
        Assert.assertNull((Object)nullStats.getBoundingBox());
        Assert.assertNull((Object)nullStats.getGeospatialTypes());
        GeospatialStatistics nullBboxStats = new GeospatialStatistics(null, new GeospatialTypes());
        Assert.assertTrue((boolean)nullBboxStats.isValid());
        validCopy = validStats.copy();
        validCopy.merge(nullBboxStats);
        Assert.assertTrue((boolean)validCopy.isValid());
        Assert.assertNotNull((Object)validCopy.getBoundingBox());
        Assert.assertNotNull((Object)validCopy.getGeospatialTypes());
    }

    @Test
    public void testCopyGeospatialStatistics() {
        PrimitiveType type = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.geometryType(null))).named("a");
        GeospatialStatistics.Builder builder = GeospatialStatistics.newBuilder((PrimitiveType)type);
        builder.update(Binary.fromString((String)"POINT (1 1)"));
        GeospatialStatistics statistics = builder.build();
        GeospatialStatistics copy = statistics.copy();
        Assert.assertTrue((boolean)copy.isValid());
        Assert.assertNotNull((Object)copy.getBoundingBox());
        Assert.assertNotNull((Object)copy.getGeospatialTypes());
    }

    @Test
    public void testInvalidGeometryMakesStatisticsInvalid() {
        PrimitiveType type = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.geometryType(null))).named("a");
        GeospatialStatistics.Builder builder = GeospatialStatistics.newBuilder((PrimitiveType)type);
        WKTReader wktReader = new WKTReader();
        WKBWriter wkbWriter = new WKBWriter();
        try {
            builder.update(Binary.fromConstantByteArray((byte[])wkbWriter.write(wktReader.read("POINT (1 1)"))));
        }
        catch (ParseException e) {
            Assert.fail((String)("Failed to parse valid WKT: " + e.getMessage()));
        }
        GeospatialStatistics validStats = builder.build();
        Assert.assertTrue((boolean)validStats.isValid());
        byte[] invalidBytes = new byte[]{1, 2, 3};
        builder.update(Binary.fromConstantByteArray((byte[])invalidBytes));
        GeospatialStatistics invalidStats = builder.build();
        Assert.assertTrue((boolean)invalidStats.isValid());
    }

    @Test
    public void testNoopBuilder() {
        GeospatialStatistics.Builder builder = GeospatialStatistics.noopBuilder();
        GeospatialStatistics statistics = builder.build();
        Assert.assertFalse((boolean)statistics.isValid());
    }
}

