/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.statistics.geospatial;

import java.util.HashSet;
import org.apache.parquet.column.statistics.geospatial.GeospatialTypes;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class TestGeospatialTypes {
    @Test
    public void testUpdateWithDifferentGeometryTypes() {
        GeometryFactory gf = new GeometryFactory();
        GeospatialTypes geospatialTypes = new GeospatialTypes();
        Point point = gf.createPoint(new Coordinate(1.0, 1.0));
        geospatialTypes.update((Geometry)point);
        Assert.assertTrue((boolean)geospatialTypes.getTypes().contains(1));
        Assert.assertEquals((long)1L, (long)geospatialTypes.getTypes().size());
        Coordinate[] lineCoords = new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0)};
        LineString line = gf.createLineString(lineCoords);
        geospatialTypes.update((Geometry)line);
        Assert.assertTrue((boolean)geospatialTypes.getTypes().contains(1));
        Assert.assertTrue((boolean)geospatialTypes.getTypes().contains(2));
        Assert.assertEquals((long)2L, (long)geospatialTypes.getTypes().size());
        Coordinate[] polygonCoords = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(1.0, 0.0), new Coordinate(1.0, 1.0), new Coordinate(0.0, 1.0), new Coordinate(0.0, 0.0)};
        LinearRing shell = gf.createLinearRing(polygonCoords);
        Polygon polygon = gf.createPolygon(shell);
        geospatialTypes.update((Geometry)polygon);
        Assert.assertTrue((boolean)geospatialTypes.getTypes().contains(1));
        Assert.assertTrue((boolean)geospatialTypes.getTypes().contains(2));
        Assert.assertTrue((boolean)geospatialTypes.getTypes().contains(3));
        Assert.assertEquals((long)3L, (long)geospatialTypes.getTypes().size());
    }

    @Test
    public void testUpdateWithComplexGeometries() {
        GeometryFactory gf = new GeometryFactory();
        GeospatialTypes geospatialTypes = new GeospatialTypes();
        Point[] points = new Point[]{gf.createPoint(new Coordinate(1.0, 1.0)), gf.createPoint(new Coordinate(2.0, 2.0))};
        MultiPoint multiPoint = gf.createMultiPoint(points);
        geospatialTypes.update((Geometry)multiPoint);
        Assert.assertTrue((boolean)geospatialTypes.getTypes().contains(4));
        Assert.assertEquals((long)1L, (long)geospatialTypes.getTypes().size());
        LineString[] lines = new LineString[]{gf.createLineString(new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0)}), gf.createLineString(new Coordinate[]{new Coordinate(3.0, 3.0), new Coordinate(4.0, 4.0)})};
        MultiLineString multiLine = gf.createMultiLineString(lines);
        geospatialTypes.update((Geometry)multiLine);
        Assert.assertTrue((boolean)geospatialTypes.getTypes().contains(4));
        Assert.assertTrue((boolean)geospatialTypes.getTypes().contains(5));
        Assert.assertEquals((long)2L, (long)geospatialTypes.getTypes().size());
        Polygon[] polygons = new Polygon[]{gf.createPolygon(gf.createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(1.0, 0.0), new Coordinate(1.0, 1.0), new Coordinate(0.0, 1.0), new Coordinate(0.0, 0.0)}))};
        MultiPolygon multiPolygon = gf.createMultiPolygon(polygons);
        geospatialTypes.update((Geometry)multiPolygon);
        Assert.assertTrue((boolean)geospatialTypes.getTypes().contains(4));
        Assert.assertTrue((boolean)geospatialTypes.getTypes().contains(5));
        Assert.assertTrue((boolean)geospatialTypes.getTypes().contains(6));
        Assert.assertEquals((long)3L, (long)geospatialTypes.getTypes().size());
        GeometryCollection collection = gf.createGeometryCollection(new Geometry[]{multiPoint, multiLine, multiPolygon});
        geospatialTypes.update((Geometry)collection);
        Assert.assertTrue((boolean)geospatialTypes.getTypes().contains(4));
        Assert.assertTrue((boolean)geospatialTypes.getTypes().contains(5));
        Assert.assertTrue((boolean)geospatialTypes.getTypes().contains(6));
        Assert.assertTrue((boolean)geospatialTypes.getTypes().contains(7));
        Assert.assertEquals((long)4L, (long)geospatialTypes.getTypes().size());
    }

    @Test
    public void testUpdateWithZCoordinates() {
        GeometryFactory gf = new GeometryFactory();
        GeospatialTypes geospatialTypes = new GeospatialTypes();
        Point pointXYZ = gf.createPoint(new Coordinate(1.0, 1.0, 1.0));
        geospatialTypes.update((Geometry)pointXYZ);
        Assert.assertTrue((boolean)geospatialTypes.getTypes().contains(1001));
        Assert.assertEquals((long)1L, (long)geospatialTypes.getTypes().size());
    }

    @Test
    public void testUpdateWithMCoordinates() {
        GeometryFactory gf = new GeometryFactory();
        GeospatialTypes geospatialTypes = new GeospatialTypes();
        CoordinateXYZM coord = new CoordinateXYZM(1.0, 1.0, Double.NaN, 10.0);
        Point pointXYM = gf.createPoint((Coordinate)coord);
        geospatialTypes.update((Geometry)pointXYM);
        Assert.assertTrue((boolean)geospatialTypes.getTypes().contains(2001));
        Assert.assertEquals((long)1L, (long)geospatialTypes.getTypes().size());
    }

    @Test
    public void testUpdateWithZMCoordinates() {
        GeometryFactory gf = new GeometryFactory();
        GeospatialTypes geospatialTypes = new GeospatialTypes();
        CoordinateXYZM coord = new CoordinateXYZM(1.0, 1.0, 1.0, 10.0);
        Point pointXYZM = gf.createPoint((Coordinate)coord);
        geospatialTypes.update((Geometry)pointXYZM);
        Assert.assertTrue((boolean)geospatialTypes.getTypes().contains(3001));
        Assert.assertEquals((long)1L, (long)geospatialTypes.getTypes().size());
    }

    @Test
    public void testMergeGeospatialTypes() {
        GeometryFactory gf = new GeometryFactory();
        GeospatialTypes types1 = new GeospatialTypes();
        types1.update((Geometry)gf.createPoint(new Coordinate(1.0, 1.0)));
        GeospatialTypes types2 = new GeospatialTypes();
        Coordinate[] lineCoords = new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0)};
        types2.update((Geometry)gf.createLineString(lineCoords));
        types1.merge(types2);
        Assert.assertTrue((boolean)types1.getTypes().contains(1));
        Assert.assertTrue((boolean)types1.getTypes().contains(2));
        Assert.assertEquals((long)2L, (long)types1.getTypes().size());
        GeospatialTypes types3 = new GeospatialTypes();
        types3.update((Geometry)gf.createPoint(new Coordinate(1.0, 1.0, 1.0)));
        types1.merge(types3);
        Assert.assertTrue((boolean)types1.getTypes().contains(1));
        Assert.assertTrue((boolean)types1.getTypes().contains(2));
        Assert.assertTrue((boolean)types1.getTypes().contains(1001));
        Assert.assertEquals((long)3L, (long)types1.getTypes().size());
    }

    @Test
    public void testMergeWithEmptyGeospatialTypes() {
        GeometryFactory gf = new GeometryFactory();
        GeospatialTypes types1 = new GeospatialTypes();
        types1.update((Geometry)gf.createPoint(new Coordinate(1.0, 1.0)));
        Assert.assertEquals((long)1L, (long)types1.getTypes().size());
        GeospatialTypes emptyTypes = new GeospatialTypes();
        Assert.assertEquals((long)0L, (long)emptyTypes.getTypes().size());
        types1.merge(emptyTypes);
        Assert.assertEquals((long)1L, (long)types1.getTypes().size());
        Assert.assertTrue((boolean)types1.getTypes().contains(1));
        emptyTypes.merge(types1);
        Assert.assertEquals((long)1L, (long)emptyTypes.getTypes().size());
        Assert.assertTrue((boolean)emptyTypes.getTypes().contains(1));
    }

    @Test
    public void testUpdateWithNullOrEmptyGeometry() {
        GeospatialTypes geospatialTypes = new GeospatialTypes();
        geospatialTypes.update(null);
        Assert.assertEquals((long)0L, (long)geospatialTypes.getTypes().size());
        GeometryFactory gf = new GeometryFactory();
        Point emptyPoint = gf.createPoint((Coordinate)null);
        geospatialTypes.update((Geometry)emptyPoint);
        Assert.assertEquals((long)0L, (long)geospatialTypes.getTypes().size());
        LineString emptyLine = gf.createLineString((Coordinate[])null);
        geospatialTypes.update((Geometry)emptyLine);
        Assert.assertEquals((long)0L, (long)geospatialTypes.getTypes().size());
    }

    @Test
    public void testReset() {
        GeometryFactory gf = new GeometryFactory();
        GeospatialTypes geospatialTypes = new GeospatialTypes();
        geospatialTypes.update((Geometry)gf.createPoint(new Coordinate(1.0, 1.0)));
        geospatialTypes.update((Geometry)gf.createLineString(new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0)}));
        Assert.assertEquals((long)2L, (long)geospatialTypes.getTypes().size());
        geospatialTypes.reset();
        Assert.assertEquals((long)0L, (long)geospatialTypes.getTypes().size());
        geospatialTypes.update((Geometry)gf.createPoint(new Coordinate(3.0, 3.0, 3.0)));
        Assert.assertEquals((long)1L, (long)geospatialTypes.getTypes().size());
        Assert.assertTrue((boolean)geospatialTypes.getTypes().contains(1001));
    }

    @Test
    public void testAbort() {
        GeometryFactory gf = new GeometryFactory();
        GeospatialTypes geospatialTypes = new GeospatialTypes();
        geospatialTypes.update((Geometry)gf.createPoint(new Coordinate(1.0, 1.0)));
        Assert.assertTrue((boolean)geospatialTypes.isValid());
        Assert.assertEquals((long)1L, (long)geospatialTypes.getTypes().size());
        geospatialTypes.abort();
        Assert.assertFalse((boolean)geospatialTypes.isValid());
        Assert.assertEquals((long)0L, (long)geospatialTypes.getTypes().size());
        geospatialTypes.update((Geometry)gf.createPoint(new Coordinate(2.0, 2.0)));
        Assert.assertEquals((long)0L, (long)geospatialTypes.getTypes().size());
        Assert.assertFalse((boolean)geospatialTypes.isValid());
    }

    @Test
    public void testCopy() {
        GeometryFactory gf = new GeometryFactory();
        GeospatialTypes original = new GeospatialTypes();
        original.update((Geometry)gf.createPoint(new Coordinate(1.0, 1.0)));
        original.update((Geometry)gf.createLineString(new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0)}));
        GeospatialTypes copy = original.copy();
        Assert.assertEquals((long)original.getTypes().size(), (long)copy.getTypes().size());
        for (Integer typeId : original.getTypes()) {
            Assert.assertTrue((boolean)copy.getTypes().contains(typeId));
        }
        copy.update((Geometry)gf.createPoint(new Coordinate(3.0, 3.0, 3.0)));
        Assert.assertEquals((long)2L, (long)original.getTypes().size());
        Assert.assertEquals((long)3L, (long)copy.getTypes().size());
        Assert.assertTrue((boolean)copy.getTypes().contains(1001));
        Assert.assertFalse((boolean)original.getTypes().contains(1001));
    }

    @Test
    public void testMergeWithNullGeospatialTypes() {
        GeometryFactory gf = new GeometryFactory();
        GeospatialTypes types = new GeospatialTypes();
        types.update((Geometry)gf.createPoint(new Coordinate(1.0, 1.0)));
        Assert.assertEquals((long)1L, (long)types.getTypes().size());
        Assert.assertTrue((boolean)types.isValid());
        types.merge(null);
        Assert.assertEquals((long)0L, (long)types.getTypes().size());
        Assert.assertFalse((boolean)types.isValid());
    }

    @Test
    public void testMergeWithInvalidGeospatialTypes() {
        GeometryFactory gf = new GeometryFactory();
        GeospatialTypes validTypes = new GeospatialTypes();
        validTypes.update((Geometry)gf.createPoint(new Coordinate(1.0, 1.0)));
        Assert.assertTrue((boolean)validTypes.isValid());
        Assert.assertEquals((long)1L, (long)validTypes.getTypes().size());
        GeospatialTypes invalidTypes = new GeospatialTypes();
        invalidTypes.abort();
        Assert.assertFalse((boolean)invalidTypes.isValid());
        validTypes.merge(invalidTypes);
        Assert.assertFalse((boolean)validTypes.isValid());
        Assert.assertEquals((long)0L, (long)validTypes.getTypes().size());
        GeospatialTypes newValidTypes = new GeospatialTypes();
        newValidTypes.update((Geometry)gf.createPoint(new Coordinate(2.0, 2.0)));
        invalidTypes.merge(newValidTypes);
        Assert.assertFalse((boolean)invalidTypes.isValid());
        Assert.assertEquals((long)0L, (long)invalidTypes.getTypes().size());
    }

    @Test
    public void testConstructorWithTypes() {
        HashSet<Integer> typeSet = new HashSet<Integer>();
        typeSet.add(1);
        typeSet.add(1001);
        typeSet.add(2);
        GeospatialTypes types = new GeospatialTypes(typeSet);
        Assert.assertEquals((long)3L, (long)types.getTypes().size());
        Assert.assertTrue((boolean)types.getTypes().contains(1));
        Assert.assertTrue((boolean)types.getTypes().contains(1001));
        Assert.assertTrue((boolean)types.getTypes().contains(2));
        Assert.assertTrue((boolean)types.isValid());
    }

    @Test
    public void testUpdateWithMixedDimensionGeometries() {
        GeometryFactory gf = new GeometryFactory();
        GeospatialTypes types = new GeospatialTypes();
        types.update((Geometry)gf.createPoint(new Coordinate(1.0, 1.0)));
        Assert.assertTrue((boolean)types.getTypes().contains(1));
        types.update((Geometry)gf.createPoint(new Coordinate(2.0, 2.0, 2.0)));
        Assert.assertTrue((boolean)types.getTypes().contains(1));
        Assert.assertTrue((boolean)types.getTypes().contains(1001));
        Assert.assertEquals((long)2L, (long)types.getTypes().size());
        CoordinateXYZM coordXYM = new CoordinateXYZM(3.0, 3.0, Double.NaN, 10.0);
        types.update((Geometry)gf.createPoint((Coordinate)coordXYM));
        Assert.assertTrue((boolean)types.getTypes().contains(1));
        Assert.assertTrue((boolean)types.getTypes().contains(1001));
        Assert.assertTrue((boolean)types.getTypes().contains(2001));
        Assert.assertEquals((long)3L, (long)types.getTypes().size());
        CoordinateXYZM coordXYZM = new CoordinateXYZM(4.0, 4.0, 4.0, 10.0);
        types.update((Geometry)gf.createPoint((Coordinate)coordXYZM));
        Assert.assertTrue((boolean)types.getTypes().contains(1));
        Assert.assertTrue((boolean)types.getTypes().contains(1001));
        Assert.assertTrue((boolean)types.getTypes().contains(2001));
        Assert.assertTrue((boolean)types.getTypes().contains(3001));
        Assert.assertEquals((long)4L, (long)types.getTypes().size());
    }

    @Test
    public void testRowGroupTypeMerging() {
        GeometryFactory gf = new GeometryFactory();
        GeospatialTypes fileTypes = new GeospatialTypes();
        GeospatialTypes rowGroup1 = new GeospatialTypes();
        rowGroup1.update((Geometry)gf.createPoint(new Coordinate(1.0, 1.0)));
        rowGroup1.update((Geometry)gf.createPoint(new Coordinate(2.0, 2.0, 2.0)));
        Assert.assertEquals((long)2L, (long)rowGroup1.getTypes().size());
        Assert.assertTrue((boolean)rowGroup1.getTypes().contains(1));
        Assert.assertTrue((boolean)rowGroup1.getTypes().contains(1001));
        GeospatialTypes rowGroup2 = new GeospatialTypes();
        LineString lineXY = gf.createLineString(new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0)});
        rowGroup2.update((Geometry)lineXY);
        Assert.assertEquals((long)1L, (long)rowGroup2.getTypes().size());
        Assert.assertTrue((boolean)rowGroup2.getTypes().contains(2));
        GeospatialTypes rowGroup3 = new GeospatialTypes();
        rowGroup3.abort();
        Assert.assertFalse((boolean)rowGroup3.isValid());
        fileTypes.merge(rowGroup1);
        fileTypes.merge(rowGroup2);
        fileTypes.merge(rowGroup3);
        Assert.assertFalse((boolean)fileTypes.isValid());
        Assert.assertEquals((long)0L, (long)fileTypes.getTypes().size());
        fileTypes = new GeospatialTypes();
        fileTypes.merge(rowGroup1);
        fileTypes.merge(rowGroup3);
        fileTypes.merge(rowGroup2);
        Assert.assertFalse((boolean)fileTypes.isValid());
        Assert.assertEquals((long)0L, (long)fileTypes.getTypes().size());
        fileTypes = new GeospatialTypes();
        fileTypes.merge(rowGroup1);
        fileTypes.merge(rowGroup2);
        Assert.assertTrue((boolean)fileTypes.isValid());
        Assert.assertEquals((long)3L, (long)fileTypes.getTypes().size());
        Assert.assertTrue((boolean)fileTypes.getTypes().contains(1));
        Assert.assertTrue((boolean)fileTypes.getTypes().contains(1001));
        Assert.assertTrue((boolean)fileTypes.getTypes().contains(2));
    }

    @Test
    public void testGeometryTypeCodeAssignment() {
        GeometryFactory gf = new GeometryFactory();
        GeospatialTypes geospatialTypes = new GeospatialTypes();
        Point point = gf.createPoint(new Coordinate(1.0, 1.0));
        geospatialTypes.update((Geometry)point);
        Assert.assertEquals((long)1L, (long)geospatialTypes.getTypes().size());
        Assert.assertTrue((boolean)geospatialTypes.getTypes().contains(1));
        geospatialTypes.reset();
        LineString line = gf.createLineString(new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0)});
        geospatialTypes.update((Geometry)line);
        Assert.assertEquals((long)1L, (long)geospatialTypes.getTypes().size());
        Assert.assertTrue((boolean)geospatialTypes.getTypes().contains(2));
        geospatialTypes.reset();
        LinearRing shell = gf.createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(1.0, 0.0), new Coordinate(1.0, 1.0), new Coordinate(0.0, 1.0), new Coordinate(0.0, 0.0)});
        Polygon polygon = gf.createPolygon(shell);
        geospatialTypes.update((Geometry)polygon);
        Assert.assertEquals((long)1L, (long)geospatialTypes.getTypes().size());
        Assert.assertTrue((boolean)geospatialTypes.getTypes().contains(3));
        geospatialTypes.reset();
        MultiPoint multiPoint = gf.createMultiPoint(new Point[]{gf.createPoint(new Coordinate(1.0, 1.0)), gf.createPoint(new Coordinate(2.0, 2.0))});
        geospatialTypes.update((Geometry)multiPoint);
        Assert.assertEquals((long)1L, (long)geospatialTypes.getTypes().size());
        Assert.assertTrue((boolean)geospatialTypes.getTypes().contains(4));
        geospatialTypes.reset();
        MultiLineString multiLine = gf.createMultiLineString(new LineString[]{gf.createLineString(new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0)}), gf.createLineString(new Coordinate[]{new Coordinate(3.0, 3.0), new Coordinate(4.0, 4.0)})});
        geospatialTypes.update((Geometry)multiLine);
        Assert.assertEquals((long)1L, (long)geospatialTypes.getTypes().size());
        Assert.assertTrue((boolean)geospatialTypes.getTypes().contains(5));
        geospatialTypes.reset();
        MultiPolygon multiPolygon = gf.createMultiPolygon(new Polygon[]{gf.createPolygon(shell)});
        geospatialTypes.update((Geometry)multiPolygon);
        Assert.assertEquals((long)1L, (long)geospatialTypes.getTypes().size());
        Assert.assertTrue((boolean)geospatialTypes.getTypes().contains(6));
        geospatialTypes.reset();
        GeometryCollection collection = gf.createGeometryCollection(new Geometry[]{point, line});
        geospatialTypes.update((Geometry)collection);
        Assert.assertEquals((long)1L, (long)geospatialTypes.getTypes().size());
        Assert.assertTrue((boolean)geospatialTypes.getTypes().contains(7));
    }

    @Test
    public void testGeometryTypeDimensionCodes() {
        GeometryFactory gf = new GeometryFactory();
        GeospatialTypes types2D = new GeospatialTypes();
        types2D.update((Geometry)gf.createPoint(new Coordinate(1.0, 1.0)));
        Assert.assertTrue((boolean)types2D.getTypes().contains(1));
        GeospatialTypes types3D = new GeospatialTypes();
        types3D.update((Geometry)gf.createPoint(new Coordinate(1.0, 1.0, 1.0)));
        Assert.assertTrue((boolean)types3D.getTypes().contains(1001));
        GeospatialTypes typesXYM = new GeospatialTypes();
        CoordinateXYZM coordXYM = new CoordinateXYZM(1.0, 1.0, Double.NaN, 10.0);
        typesXYM.update((Geometry)gf.createPoint((Coordinate)coordXYM));
        Assert.assertTrue((boolean)typesXYM.getTypes().contains(2001));
        GeospatialTypes typesXYZM = new GeospatialTypes();
        CoordinateXYZM coordXYZM = new CoordinateXYZM(1.0, 1.0, 1.0, 10.0);
        typesXYZM.update((Geometry)gf.createPoint((Coordinate)coordXYZM));
        Assert.assertTrue((boolean)typesXYZM.getTypes().contains(3001));
    }
}

