/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.filter2.recordlevel;

import java.util.Arrays;
import java.util.List;
import org.apache.parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicate;
import org.apache.parquet.filter2.recordlevel.TestIncrementallyUpdatedFilterPredicateEvaluator;
import org.junit.Assert;
import org.junit.Test;

public class TestValueInspector {
    @Test
    public void testLifeCycle() {
        IncrementallyUpdatedFilterPredicate.ValueInspector v = TestIncrementallyUpdatedFilterPredicateEvaluator.intIsEven();
        Assert.assertFalse((boolean)v.isKnown());
        try {
            v.getResult();
            Assert.fail((String)"this should throw");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"getResult() called on a ValueInspector whose result is not yet known!", (Object)e.getMessage());
        }
        v.update(10);
        Assert.assertTrue((boolean)v.isKnown());
        Assert.assertTrue((boolean)v.getResult());
        try {
            v.update(11);
            Assert.fail((String)"this should throw");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"setResult() called on a ValueInspector whose result is already known! Did you forget to call reset()?", (Object)e.getMessage());
        }
        v.reset();
        Assert.assertFalse((boolean)v.isKnown());
        try {
            v.getResult();
            Assert.fail((String)"this should throw");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"getResult() called on a ValueInspector whose result is not yet known!", (Object)e.getMessage());
        }
        v.update(11);
        Assert.assertTrue((boolean)v.isKnown());
        Assert.assertFalse((boolean)v.getResult());
    }

    @Test
    public void testReusable() {
        List<Integer> values = Arrays.asList(2, 4, 7, 3, 8, 8, 11, 200);
        IncrementallyUpdatedFilterPredicate.ValueInspector v = TestIncrementallyUpdatedFilterPredicateEvaluator.intIsEven();
        for (Integer x : values) {
            v.update(x.intValue());
            Assert.assertEquals((Object)(x % 2 == 0 ? 1 : 0), (Object)v.getResult());
            v.reset();
        }
    }
}

