/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.schema;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.apache.parquet.column.schema.EdgeInterpolationAlgorithm;
import org.apache.parquet.schema.ColumnOrder;
import org.apache.parquet.schema.DecimalMetadata;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestTypeBuilders {
    @Test
    public void testPaperExample() {
        MessageType expected = new MessageType("Document", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "DocId"), new GroupType(Type.Repetition.OPTIONAL, "Links", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.INT64, "Backward"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.INT64, "Forward")}), new GroupType(Type.Repetition.REPEATED, "Name", new Type[]{new GroupType(Type.Repetition.REPEATED, "Language", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Code"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Country")}), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "Url")})});
        MessageType builderType = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT64).named("DocId")).optionalGroup().repeated(PrimitiveType.PrimitiveTypeName.INT64).named("Backward")).repeated(PrimitiveType.PrimitiveTypeName.INT64).named("Forward")).named("Links")).repeatedGroup().repeatedGroup().required(PrimitiveType.PrimitiveTypeName.BINARY).named("Code")).required(PrimitiveType.PrimitiveTypeName.BINARY).named("Country")).named("Language")).optional(PrimitiveType.PrimitiveTypeName.BINARY).named("Url")).named("Name")).named("Document");
        Assert.assertEquals((Object)expected, (Object)builderType);
    }

    @Test
    public void testGroupTypeConstruction() {
        PrimitiveType f1 = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("f1");
        PrimitiveType f2 = (PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("f2");
        PrimitiveType f3 = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("f3");
        String name = "group";
        for (Type.Repetition repetition : Type.Repetition.values()) {
            GroupType expected = new GroupType(repetition, name, new Type[]{f1, new GroupType(repetition, "g1", new Type[]{f2, f3})});
            GroupType built = (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)repetition).addField((Type)f1)).group(repetition).addFields(new Type[]{f2, f3})).named("g1")).named(name);
            Assert.assertEquals((Object)expected, (Object)built);
            switch (repetition) {
                case REQUIRED: {
                    built = (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.requiredGroup().addField((Type)f1)).requiredGroup().addFields(new Type[]{f2, f3})).named("g1")).named(name);
                    break;
                }
                case OPTIONAL: {
                    built = (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.optionalGroup().addField((Type)f1)).optionalGroup().addFields(new Type[]{f2, f3})).named("g1")).named(name);
                    break;
                }
                case REPEATED: {
                    built = (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.repeatedGroup().addField((Type)f1)).repeatedGroup().addFields(new Type[]{f2, f3})).named("g1")).named(name);
                }
            }
            Assert.assertEquals((Object)expected, (Object)built);
        }
    }

    @Test
    public void testPrimitiveTypeConstruction() {
        PrimitiveType.PrimitiveTypeName[] types;
        for (PrimitiveType.PrimitiveTypeName type : types = new PrimitiveType.PrimitiveTypeName[]{PrimitiveType.PrimitiveTypeName.BOOLEAN, PrimitiveType.PrimitiveTypeName.INT32, PrimitiveType.PrimitiveTypeName.INT64, PrimitiveType.PrimitiveTypeName.INT96, PrimitiveType.PrimitiveTypeName.FLOAT, PrimitiveType.PrimitiveTypeName.DOUBLE, PrimitiveType.PrimitiveTypeName.BINARY}) {
            String name = type.toString() + "_";
            for (Type.Repetition repetition : Type.Repetition.values()) {
                PrimitiveType expected = new PrimitiveType(repetition, type, name);
                PrimitiveType built = (PrimitiveType)Types.primitive((PrimitiveType.PrimitiveTypeName)type, (Type.Repetition)repetition).named(name);
                Assert.assertEquals((Object)expected, (Object)built);
                switch (repetition) {
                    case REQUIRED: {
                        built = (PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)type).named(name);
                        break;
                    }
                    case OPTIONAL: {
                        built = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)type).named(name);
                        break;
                    }
                    case REPEATED: {
                        built = (PrimitiveType)Types.repeated((PrimitiveType.PrimitiveTypeName)type).named(name);
                    }
                }
                Assert.assertEquals((Object)expected, (Object)built);
            }
        }
    }

    @Test
    public void testFixedTypeConstruction() {
        String name = "fixed_";
        int len = 5;
        for (Type.Repetition repetition : Type.Repetition.values()) {
            PrimitiveType expected = new PrimitiveType(repetition, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, len, name);
            PrimitiveType built = (PrimitiveType)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).length(len)).named(name);
            Assert.assertEquals((Object)expected, (Object)built);
            switch (repetition) {
                case REQUIRED: {
                    built = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(len)).named(name);
                    break;
                }
                case OPTIONAL: {
                    built = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(len)).named(name);
                    break;
                }
                case REPEATED: {
                    built = (PrimitiveType)((Types.PrimitiveBuilder)Types.repeated((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(len)).named(name);
                }
            }
            Assert.assertEquals((Object)expected, (Object)built);
        }
    }

    @Test
    public void testEmptyGroup() {
        Assert.assertEquals((String)"Should not complain about an empty required group", (Object)Types.requiredGroup().named("g"), (Object)new GroupType(Type.Repetition.REQUIRED, "g", new Type[0]));
        Assert.assertEquals((String)"Should not complain about an empty required group", (Object)Types.optionalGroup().named("g"), (Object)new GroupType(Type.Repetition.OPTIONAL, "g", new Type[0]));
        Assert.assertEquals((String)"Should not complain about an empty required group", (Object)Types.repeatedGroup().named("g"), (Object)new GroupType(Type.Repetition.REPEATED, "g", new Type[0]));
    }

    @Test
    public void testEmptyMessage() {
        Assert.assertEquals((String)"Should not complain about an empty required group", (Object)Types.buildMessage().named("m"), (Object)new MessageType("m", new Type[0]));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFixedWithoutLength() {
        Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).named("fixed");
    }

    @Test
    public void testFixedWithLength() {
        PrimitiveType expected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, 7, "fixed");
        PrimitiveType fixed = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(7)).named("fixed");
        Assert.assertEquals((Object)expected, (Object)fixed);
    }

    @Test
    public void testFixedLengthEquals() {
        Type f4 = (Type)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(4)).named("f4");
        Type f8 = (Type)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(8)).named("f8");
        Assert.assertFalse((String)"Types with different lengths should not be equal", (boolean)f4.equals(f8));
    }

    @Test
    public void testDecimalAnnotation() {
        MessageType expected = new MessageType("DecimalMessage", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, 0, "aDecimal", OriginalType.DECIMAL, new DecimalMetadata(9, 2), null)});
        MessageType builderType = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.DECIMAL)).precision(9)).scale(2)).named("aDecimal")).named("DecimalMessage");
        Assert.assertEquals((Object)expected, (Object)builderType);
        expected = new MessageType("DecimalMessage", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, 0, "aDecimal", OriginalType.DECIMAL, new DecimalMetadata(18, 2), null)});
        builderType = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT64).as(OriginalType.DECIMAL)).precision(18)).scale(2)).named("aDecimal")).named("DecimalMessage");
        Assert.assertEquals((Object)expected, (Object)builderType);
        expected = new MessageType("DecimalMessage", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, 0, "aDecimal", OriginalType.DECIMAL, new DecimalMetadata(9, 2), null)});
        builderType = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.DECIMAL)).precision(9)).scale(2)).named("aDecimal")).named("DecimalMessage");
        Assert.assertEquals((Object)expected, (Object)builderType);
        expected = new MessageType("DecimalMessage", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, 4, "aDecimal", OriginalType.DECIMAL, new DecimalMetadata(9, 2), null)});
        builderType = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(4)).as(OriginalType.DECIMAL)).precision(9)).scale(2)).named("aDecimal")).named("DecimalMessage");
        Assert.assertEquals((Object)expected, (Object)builderType);
    }

    @Test
    public void testDecimalAnnotationMissingScale() {
        MessageType expected = new MessageType("DecimalMessage", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, 0, "aDecimal", OriginalType.DECIMAL, new DecimalMetadata(9, 0), null)});
        MessageType builderType = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.DECIMAL)).precision(9)).named("aDecimal")).named("DecimalMessage");
        Assert.assertEquals((Object)expected, (Object)builderType);
        expected = new MessageType("DecimalMessage", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, 0, "aDecimal", OriginalType.DECIMAL, new DecimalMetadata(9, 0), null)});
        builderType = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT64).as(OriginalType.DECIMAL)).precision(9)).named("aDecimal")).named("DecimalMessage");
        Assert.assertEquals((Object)expected, (Object)builderType);
        expected = new MessageType("DecimalMessage", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, 0, "aDecimal", OriginalType.DECIMAL, new DecimalMetadata(9, 0), null)});
        builderType = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.DECIMAL)).precision(9)).named("aDecimal")).named("DecimalMessage");
        Assert.assertEquals((Object)expected, (Object)builderType);
        expected = new MessageType("DecimalMessage", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, 7, "aDecimal", OriginalType.DECIMAL, new DecimalMetadata(9, 0), null)});
        builderType = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(7)).as(OriginalType.DECIMAL)).precision(9)).named("aDecimal")).named("DecimalMessage");
        Assert.assertEquals((Object)expected, (Object)builderType);
    }

    @Test
    public void testDecimalAnnotationMissingPrecision() {
        TestTypeBuilders.assertThrows("Should reject decimal annotation without precision", IllegalArgumentException.class, () -> (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.DECIMAL)).scale(2)).named("aDecimal")).named("DecimalMessage"));
        TestTypeBuilders.assertThrows("Should reject decimal annotation without precision", IllegalArgumentException.class, () -> (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT64).as(OriginalType.DECIMAL)).scale(2)).named("aDecimal")).named("DecimalMessage"));
        TestTypeBuilders.assertThrows("Should reject decimal annotation without precision", IllegalArgumentException.class, () -> (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.DECIMAL)).scale(2)).named("aDecimal")).named("DecimalMessage"));
        TestTypeBuilders.assertThrows("Should reject decimal annotation without precision", IllegalArgumentException.class, () -> (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(7)).as(OriginalType.DECIMAL)).scale(2)).named("aDecimal")).named("DecimalMessage"));
    }

    @Test
    public void testDecimalAnnotationPrecisionScaleBound() {
        TestTypeBuilders.assertThrows("Should reject scale greater than precision", IllegalArgumentException.class, () -> (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.DECIMAL)).precision(3)).scale(4)).named("aDecimal")).named("DecimalMessage"));
        TestTypeBuilders.assertThrows("Should reject scale greater than precision", IllegalArgumentException.class, () -> (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT64).as(OriginalType.DECIMAL)).precision(3)).scale(4)).named("aDecimal")).named("DecimalMessage"));
        TestTypeBuilders.assertThrows("Should reject scale greater than precision", IllegalArgumentException.class, () -> (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.DECIMAL)).precision(3)).scale(4)).named("aDecimal")).named("DecimalMessage"));
        TestTypeBuilders.assertThrows("Should reject scale greater than precision", IllegalArgumentException.class, () -> (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(7)).as(OriginalType.DECIMAL)).precision(3)).scale(4)).named("aDecimal")).named("DecimalMessage"));
    }

    @Test
    public void testDecimalAnnotationLengthCheck() {
        TestTypeBuilders.assertThrows("should reject precision 10 with length 4", IllegalStateException.class, () -> (PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(4)).as(OriginalType.DECIMAL)).precision(10)).scale(2)).named("aDecimal"));
        TestTypeBuilders.assertThrows("should reject precision 10 with length 4", IllegalStateException.class, () -> (PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.DECIMAL)).precision(10)).scale(2)).named("aDecimal"));
        TestTypeBuilders.assertThrows("should reject precision 19 with length 8", IllegalStateException.class, () -> (PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(8)).as(OriginalType.DECIMAL)).precision(19)).scale(4)).named("aDecimal"));
        TestTypeBuilders.assertThrows("should reject precision 19 with length 8", IllegalStateException.class, () -> (PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).length(8)).as(OriginalType.DECIMAL)).precision(19)).scale(4)).named("aDecimal"));
    }

    @Test
    public void testDECIMALAnnotationRejectsUnsupportedTypes() {
        PrimitiveType.PrimitiveTypeName[] unsupported;
        for (PrimitiveType.PrimitiveTypeName type : unsupported = new PrimitiveType.PrimitiveTypeName[]{PrimitiveType.PrimitiveTypeName.BOOLEAN, PrimitiveType.PrimitiveTypeName.INT96, PrimitiveType.PrimitiveTypeName.DOUBLE, PrimitiveType.PrimitiveTypeName.FLOAT}) {
            TestTypeBuilders.assertThrows("Should reject non-binary type: " + type, IllegalStateException.class, () -> (PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)type).as(OriginalType.DECIMAL)).precision(9)).scale(2)).named("d"));
        }
    }

    @Test
    public void testBinaryAnnotations() {
        OriginalType[] types;
        for (OriginalType logicalType : types = new OriginalType[]{OriginalType.UTF8, OriginalType.JSON, OriginalType.BSON}) {
            PrimitiveType expected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "col", logicalType);
            PrimitiveType string = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(logicalType)).named("col");
            Assert.assertEquals((Object)expected, (Object)string);
        }
    }

    @Test
    public void testBinaryAnnotationsRejectsNonBinary() {
        OriginalType[] types;
        for (OriginalType logicalType : types = new OriginalType[]{OriginalType.UTF8, OriginalType.JSON, OriginalType.BSON}) {
            PrimitiveType.PrimitiveTypeName[] nonBinary;
            for (PrimitiveType.PrimitiveTypeName type : nonBinary = new PrimitiveType.PrimitiveTypeName[]{PrimitiveType.PrimitiveTypeName.BOOLEAN, PrimitiveType.PrimitiveTypeName.INT32, PrimitiveType.PrimitiveTypeName.INT64, PrimitiveType.PrimitiveTypeName.INT96, PrimitiveType.PrimitiveTypeName.DOUBLE, PrimitiveType.PrimitiveTypeName.FLOAT}) {
                TestTypeBuilders.assertThrows("Should reject non-binary type: " + type, IllegalStateException.class, () -> (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)type).as(logicalType)).named("col"));
            }
            TestTypeBuilders.assertThrows("Should reject non-binary type: FIXED_LEN_BYTE_ARRAY", IllegalStateException.class, () -> (PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(1)).as(logicalType)).named("col"));
        }
    }

    @Test
    public void testInt32Annotations() {
        OriginalType[] types;
        for (OriginalType logicalType : types = new OriginalType[]{OriginalType.DATE, OriginalType.TIME_MILLIS, OriginalType.UINT_8, OriginalType.UINT_16, OriginalType.UINT_32, OriginalType.INT_8, OriginalType.INT_16, OriginalType.INT_32}) {
            PrimitiveType expected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, "col", logicalType);
            PrimitiveType date = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as(logicalType)).named("col");
            Assert.assertEquals((Object)expected, (Object)date);
        }
    }

    @Test
    public void testInt32AnnotationsRejectNonInt32() {
        OriginalType[] types;
        for (OriginalType logicalType : types = new OriginalType[]{OriginalType.DATE, OriginalType.TIME_MILLIS, OriginalType.UINT_8, OriginalType.UINT_16, OriginalType.UINT_32, OriginalType.INT_8, OriginalType.INT_16, OriginalType.INT_32}) {
            PrimitiveType.PrimitiveTypeName[] nonInt32;
            for (PrimitiveType.PrimitiveTypeName type : nonInt32 = new PrimitiveType.PrimitiveTypeName[]{PrimitiveType.PrimitiveTypeName.BOOLEAN, PrimitiveType.PrimitiveTypeName.INT64, PrimitiveType.PrimitiveTypeName.INT96, PrimitiveType.PrimitiveTypeName.DOUBLE, PrimitiveType.PrimitiveTypeName.FLOAT, PrimitiveType.PrimitiveTypeName.BINARY}) {
                TestTypeBuilders.assertThrows("Should reject non-int32 type: " + type, IllegalStateException.class, () -> (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)type).as(logicalType)).named("col"));
            }
            TestTypeBuilders.assertThrows("Should reject non-int32 type: FIXED_LEN_BYTE_ARRAY", IllegalStateException.class, () -> (PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(1)).as(logicalType)).named("col"));
        }
    }

    @Test
    public void testInt64Annotations() {
        OriginalType[] types;
        for (OriginalType logicalType : types = new OriginalType[]{OriginalType.TIME_MICROS, OriginalType.TIMESTAMP_MILLIS, OriginalType.TIMESTAMP_MICROS, OriginalType.UINT_64, OriginalType.INT_64}) {
            PrimitiveType expected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "col", logicalType);
            PrimitiveType date = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as(logicalType)).named("col");
            Assert.assertEquals((Object)expected, (Object)date);
        }
    }

    @Test
    public void testInt64AnnotationsRejectNonInt64() {
        OriginalType[] types;
        for (OriginalType logicalType : types = new OriginalType[]{OriginalType.TIME_MICROS, OriginalType.TIMESTAMP_MILLIS, OriginalType.TIMESTAMP_MICROS, OriginalType.UINT_64, OriginalType.INT_64}) {
            PrimitiveType.PrimitiveTypeName[] nonInt64;
            for (PrimitiveType.PrimitiveTypeName type : nonInt64 = new PrimitiveType.PrimitiveTypeName[]{PrimitiveType.PrimitiveTypeName.BOOLEAN, PrimitiveType.PrimitiveTypeName.INT32, PrimitiveType.PrimitiveTypeName.INT96, PrimitiveType.PrimitiveTypeName.DOUBLE, PrimitiveType.PrimitiveTypeName.FLOAT, PrimitiveType.PrimitiveTypeName.BINARY}) {
                TestTypeBuilders.assertThrows("Should reject non-int64 type: " + type, IllegalStateException.class, () -> (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)type).as(logicalType)).named("col"));
            }
            TestTypeBuilders.assertThrows("Should reject non-int64 type: FIXED_LEN_BYTE_ARRAY", IllegalStateException.class, () -> (PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(1)).as(logicalType)).named("col"));
        }
    }

    @Test
    public void testIntervalAnnotation() {
        PrimitiveType expected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, 12, "interval", OriginalType.INTERVAL);
        PrimitiveType string = (PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(12)).as(OriginalType.INTERVAL)).named("interval");
        Assert.assertEquals((Object)expected, (Object)string);
    }

    @Test
    public void testIntervalAnnotationRejectsNonFixed() {
        PrimitiveType.PrimitiveTypeName[] nonFixed;
        for (PrimitiveType.PrimitiveTypeName type : nonFixed = new PrimitiveType.PrimitiveTypeName[]{PrimitiveType.PrimitiveTypeName.BOOLEAN, PrimitiveType.PrimitiveTypeName.INT32, PrimitiveType.PrimitiveTypeName.INT64, PrimitiveType.PrimitiveTypeName.INT96, PrimitiveType.PrimitiveTypeName.DOUBLE, PrimitiveType.PrimitiveTypeName.FLOAT, PrimitiveType.PrimitiveTypeName.BINARY}) {
            TestTypeBuilders.assertThrows("Should reject non-fixed type: " + type, IllegalStateException.class, () -> (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)type).as(OriginalType.INTERVAL)).named("interval"));
        }
    }

    @Test
    public void testIntervalAnnotationRejectsNonFixed12() {
        TestTypeBuilders.assertThrows("Should reject fixed with length != 12: 11", IllegalStateException.class, () -> (PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(11)).as(OriginalType.INTERVAL)).named("interval"));
    }

    @Test
    public void testRequiredMap() {
        ArrayList<PrimitiveType> typeList = new ArrayList<PrimitiveType>();
        typeList.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "key"));
        typeList.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "value"));
        GroupType expected = new GroupType(Type.Repetition.REQUIRED, "myMap", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", typeList)});
        GroupType actual = (GroupType)Types.requiredMap().key(PrimitiveType.PrimitiveTypeName.INT64).requiredValue(PrimitiveType.PrimitiveTypeName.INT64).named("myMap");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testOptionalMap() {
        ArrayList<PrimitiveType> typeList = new ArrayList<PrimitiveType>();
        typeList.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "key"));
        typeList.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "value"));
        GroupType expected = new GroupType(Type.Repetition.OPTIONAL, "myMap", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", typeList)});
        GroupType actual = (GroupType)Types.optionalMap().key(PrimitiveType.PrimitiveTypeName.INT64).requiredValue(PrimitiveType.PrimitiveTypeName.INT64).named("myMap");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMapWithRequiredValue() {
        ArrayList<PrimitiveType> typeList = new ArrayList<PrimitiveType>();
        typeList.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "key"));
        typeList.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "value"));
        GroupType map = new GroupType(Type.Repetition.REQUIRED, "myMap", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", typeList)});
        MessageType expected = new MessageType("mapParent", new Type[]{map});
        GroupType actual = (GroupType)((Types.GroupBuilder)Types.buildMessage().requiredMap().key(PrimitiveType.PrimitiveTypeName.INT64).requiredValue(PrimitiveType.PrimitiveTypeName.INT64).named("myMap")).named("mapParent");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMapWithOptionalValue() {
        ArrayList<PrimitiveType> typeList = new ArrayList<PrimitiveType>();
        typeList.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "key"));
        typeList.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "value"));
        GroupType map = new GroupType(Type.Repetition.REQUIRED, "myMap", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", typeList)});
        MessageType expected = new MessageType("mapParent", new Type[]{map});
        GroupType actual = (GroupType)((Types.GroupBuilder)Types.buildMessage().requiredMap().key(PrimitiveType.PrimitiveTypeName.INT64).optionalValue(PrimitiveType.PrimitiveTypeName.INT64).named("myMap")).named("mapParent");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMapWithGroupKeyAndOptionalGroupValue() {
        ArrayList<GroupType> typeList = new ArrayList<GroupType>();
        ArrayList<PrimitiveType> keyFields = new ArrayList<PrimitiveType>();
        keyFields.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "first"));
        keyFields.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.DOUBLE, "second"));
        typeList.add(new GroupType(Type.Repetition.REQUIRED, "key", keyFields));
        ArrayList<PrimitiveType> valueFields = new ArrayList<PrimitiveType>();
        valueFields.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.DOUBLE, "one"));
        valueFields.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "two"));
        typeList.add(new GroupType(Type.Repetition.OPTIONAL, "value", valueFields));
        GroupType map = new GroupType(Type.Repetition.OPTIONAL, "myMap", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", typeList)});
        GroupType actual = (GroupType)((Types.BaseMapBuilder.GroupValueBuilder)((Types.BaseMapBuilder.GroupValueBuilder)((Types.BaseMapBuilder.GroupKeyBuilder)((Types.BaseMapBuilder.GroupKeyBuilder)Types.optionalMap().groupKey().optional(PrimitiveType.PrimitiveTypeName.INT64).named("first")).optional(PrimitiveType.PrimitiveTypeName.DOUBLE).named("second")).optionalGroupValue().optional(PrimitiveType.PrimitiveTypeName.DOUBLE).named("one")).optional(PrimitiveType.PrimitiveTypeName.INT32).named("two")).named("myMap");
        Assert.assertEquals((Object)map, (Object)actual);
    }

    @Test
    public void testMapWithGroupKeyAndRequiredGroupValue() {
        ArrayList<GroupType> typeList = new ArrayList<GroupType>();
        ArrayList<PrimitiveType> keyFields = new ArrayList<PrimitiveType>();
        keyFields.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "first"));
        keyFields.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.DOUBLE, "second"));
        typeList.add(new GroupType(Type.Repetition.REQUIRED, "key", keyFields));
        ArrayList<PrimitiveType> valueFields = new ArrayList<PrimitiveType>();
        valueFields.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.DOUBLE, "one"));
        valueFields.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "two"));
        typeList.add(new GroupType(Type.Repetition.REQUIRED, "value", valueFields));
        GroupType map = new GroupType(Type.Repetition.OPTIONAL, "myMap", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", typeList)});
        MessageType expected = new MessageType("mapParent", new Type[]{map});
        GroupType actual = (GroupType)((Types.GroupBuilder)((Types.BaseMapBuilder.GroupValueBuilder)((Types.BaseMapBuilder.GroupValueBuilder)((Types.BaseMapBuilder.GroupKeyBuilder)((Types.BaseMapBuilder.GroupKeyBuilder)Types.buildMessage().optionalMap().groupKey().optional(PrimitiveType.PrimitiveTypeName.INT64).named("first")).optional(PrimitiveType.PrimitiveTypeName.DOUBLE).named("second")).requiredGroupValue().optional(PrimitiveType.PrimitiveTypeName.DOUBLE).named("one")).optional(PrimitiveType.PrimitiveTypeName.INT32).named("two")).named("myMap")).named("mapParent");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMapWithGroupKeyAndOptionalValue() {
        ArrayList<Object> typeList = new ArrayList<Object>();
        ArrayList<PrimitiveType> keyFields = new ArrayList<PrimitiveType>();
        keyFields.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "first"));
        keyFields.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.DOUBLE, "second"));
        typeList.add(new GroupType(Type.Repetition.REQUIRED, "key", keyFields));
        typeList.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.DOUBLE, "value"));
        GroupType map = new GroupType(Type.Repetition.OPTIONAL, "myMap", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", typeList)});
        MessageType expected = new MessageType("mapParent", new Type[]{map});
        GroupType actual = (GroupType)((Types.GroupBuilder)((Types.BaseMapBuilder.GroupKeyBuilder)((Types.BaseMapBuilder.GroupKeyBuilder)Types.buildMessage().optionalMap().groupKey().optional(PrimitiveType.PrimitiveTypeName.INT64).named("first")).optional(PrimitiveType.PrimitiveTypeName.DOUBLE).named("second")).optionalValue(PrimitiveType.PrimitiveTypeName.DOUBLE).named("myMap")).named("mapParent");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMapWithGroupKeyAndRequiredValue() {
        ArrayList<Object> typeList = new ArrayList<Object>();
        ArrayList<PrimitiveType> keyFields = new ArrayList<PrimitiveType>();
        keyFields.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "first"));
        keyFields.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.DOUBLE, "second"));
        typeList.add(new GroupType(Type.Repetition.REQUIRED, "key", keyFields));
        typeList.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.DOUBLE, "value"));
        GroupType map = new GroupType(Type.Repetition.OPTIONAL, "myMap", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", typeList)});
        MessageType expected = new MessageType("mapParent", new Type[]{map});
        GroupType actual = (GroupType)((Types.GroupBuilder)((Types.BaseMapBuilder.GroupKeyBuilder)((Types.BaseMapBuilder.GroupKeyBuilder)Types.buildMessage().optionalMap().groupKey().optional(PrimitiveType.PrimitiveTypeName.INT64).named("first")).optional(PrimitiveType.PrimitiveTypeName.DOUBLE).named("second")).requiredValue(PrimitiveType.PrimitiveTypeName.DOUBLE).named("myMap")).named("mapParent");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMapWithOptionalGroupValue() {
        ArrayList<Object> typeList = new ArrayList<Object>();
        ArrayList<PrimitiveType> keyFields = new ArrayList<PrimitiveType>();
        keyFields.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "first"));
        keyFields.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.DOUBLE, "second"));
        typeList.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "key"));
        ArrayList<PrimitiveType> valueFields = new ArrayList<PrimitiveType>();
        valueFields.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.DOUBLE, "one"));
        valueFields.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "two"));
        typeList.add(new GroupType(Type.Repetition.OPTIONAL, "value", valueFields));
        GroupType map = new GroupType(Type.Repetition.OPTIONAL, "myMap", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", typeList)});
        MessageType expected = new MessageType("mapParent", new Type[]{map});
        GroupType actual = (GroupType)((Types.GroupBuilder)((Types.BaseMapBuilder.GroupValueBuilder)((Types.BaseMapBuilder.GroupValueBuilder)Types.buildMessage().optionalMap().key(PrimitiveType.PrimitiveTypeName.INT64).optionalGroupValue().optional(PrimitiveType.PrimitiveTypeName.DOUBLE).named("one")).optional(PrimitiveType.PrimitiveTypeName.INT32).named("two")).named("myMap")).named("mapParent");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMapWithRequiredGroupValue() {
        ArrayList<Object> typeList = new ArrayList<Object>();
        typeList.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "key"));
        ArrayList<PrimitiveType> valueFields = new ArrayList<PrimitiveType>();
        valueFields.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.DOUBLE, "one"));
        valueFields.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "two"));
        typeList.add(new GroupType(Type.Repetition.REQUIRED, "value", valueFields));
        GroupType map = new GroupType(Type.Repetition.OPTIONAL, "myMap", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", typeList)});
        MessageType expected = new MessageType("mapParent", new Type[]{map});
        GroupType actual = (GroupType)((Types.GroupBuilder)((Types.BaseMapBuilder.GroupValueBuilder)((Types.BaseMapBuilder.GroupValueBuilder)Types.buildMessage().optionalMap().key(PrimitiveType.PrimitiveTypeName.INT64).requiredGroupValue().optional(PrimitiveType.PrimitiveTypeName.DOUBLE).named("one")).optional(PrimitiveType.PrimitiveTypeName.INT32).named("two")).named("myMap")).named("mapParent");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMapWithNestedGroupKeyAndNestedGroupValue() {
        ArrayList<GroupType> typeList = new ArrayList<GroupType>();
        ArrayList<PrimitiveType> innerFields = new ArrayList<PrimitiveType>();
        innerFields.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.FLOAT, "inner_key_1"));
        innerFields.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "inner_key_2"));
        ArrayList<Object> keyFields = new ArrayList<Object>();
        keyFields.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "first"));
        keyFields.add(new GroupType(Type.Repetition.REQUIRED, "second", innerFields));
        typeList.add(new GroupType(Type.Repetition.REQUIRED, "key", keyFields));
        ArrayList<Object> valueFields = new ArrayList<Object>();
        valueFields.add(new GroupType(Type.Repetition.OPTIONAL, "one", innerFields));
        valueFields.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "two"));
        typeList.add(new GroupType(Type.Repetition.OPTIONAL, "value", valueFields));
        GroupType map = new GroupType(Type.Repetition.REQUIRED, "myMap", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", typeList)});
        MessageType expected = new MessageType("mapParent", new Type[]{map});
        GroupType actual = (GroupType)((Types.GroupBuilder)((Types.BaseMapBuilder.GroupValueBuilder)((Types.BaseMapBuilder.GroupValueBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.BaseMapBuilder.GroupKeyBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.BaseMapBuilder.GroupKeyBuilder)Types.buildMessage().requiredMap().groupKey().optional(PrimitiveType.PrimitiveTypeName.INT64).named("first")).requiredGroup().required(PrimitiveType.PrimitiveTypeName.FLOAT).named("inner_key_1")).optional(PrimitiveType.PrimitiveTypeName.INT32).named("inner_key_2")).named("second")).optionalGroupValue().optionalGroup().required(PrimitiveType.PrimitiveTypeName.FLOAT).named("inner_key_1")).optional(PrimitiveType.PrimitiveTypeName.INT32).named("inner_key_2")).named("one")).optional(PrimitiveType.PrimitiveTypeName.INT32).named("two")).named("myMap")).named("mapParent");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMapWithRequiredListValue() {
        ArrayList<Object> typeList = new ArrayList<Object>();
        typeList.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "key"));
        typeList.add(new GroupType(Type.Repetition.REQUIRED, "value", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.REPEATED, "list", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "element")})}));
        GroupType map = new GroupType(Type.Repetition.OPTIONAL, "myMap", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", typeList)});
        MessageType expected = new MessageType("mapParent", new Type[]{map});
        GroupType actual = (GroupType)((Types.GroupBuilder)Types.buildMessage().optionalMap().key(PrimitiveType.PrimitiveTypeName.INT64).requiredListValue().optionalElement(PrimitiveType.PrimitiveTypeName.INT64).named("myMap")).named("mapParent");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMapWithOptionalListValue() {
        ArrayList<Object> typeList = new ArrayList<Object>();
        typeList.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "key"));
        typeList.add(new GroupType(Type.Repetition.OPTIONAL, "value", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.REPEATED, "list", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "element")})}));
        GroupType map = new GroupType(Type.Repetition.OPTIONAL, "myMap", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", typeList)});
        MessageType expected = new MessageType("mapParent", new Type[]{map});
        GroupType actual = (GroupType)((Types.GroupBuilder)Types.buildMessage().optionalMap().key(PrimitiveType.PrimitiveTypeName.INT64).optionalListValue().optionalElement(PrimitiveType.PrimitiveTypeName.INT64).named("myMap")).named("mapParent");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMapWithRequiredMapValue() {
        ArrayList<Object> typeList = new ArrayList<Object>();
        ArrayList<PrimitiveType> innerMapTypeList = new ArrayList<PrimitiveType>();
        innerMapTypeList.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "key"));
        innerMapTypeList.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "value"));
        typeList.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "key"));
        typeList.add(new GroupType(Type.Repetition.REQUIRED, "value", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", innerMapTypeList)}));
        GroupType map = new GroupType(Type.Repetition.OPTIONAL, "myMap", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", typeList)});
        MessageType expected = new MessageType("mapParent", new Type[]{map});
        GroupType actual = (GroupType)((Types.GroupBuilder)Types.buildMessage().optionalMap().key(PrimitiveType.PrimitiveTypeName.INT64).requiredMapValue().key(PrimitiveType.PrimitiveTypeName.INT64).requiredValue(PrimitiveType.PrimitiveTypeName.INT64).named("myMap")).named("mapParent");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMapWithOptionalMapValue() {
        ArrayList<Object> typeList = new ArrayList<Object>();
        ArrayList<PrimitiveType> innerMapTypeList = new ArrayList<PrimitiveType>();
        innerMapTypeList.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "key"));
        innerMapTypeList.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "value"));
        typeList.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "key"));
        typeList.add(new GroupType(Type.Repetition.OPTIONAL, "value", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", innerMapTypeList)}));
        GroupType map = new GroupType(Type.Repetition.OPTIONAL, "myMap", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", typeList)});
        MessageType expected = new MessageType("mapParent", new Type[]{map});
        GroupType actual = (GroupType)((Types.GroupBuilder)Types.buildMessage().optionalMap().key(PrimitiveType.PrimitiveTypeName.INT64).optionalMapValue().key(PrimitiveType.PrimitiveTypeName.INT64).requiredValue(PrimitiveType.PrimitiveTypeName.INT64).named("myMap")).named("mapParent");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMapWithGroupKeyAndRequiredListValue() {
        ArrayList<GroupType> typeList = new ArrayList<GroupType>();
        typeList.add(new GroupType(Type.Repetition.REQUIRED, "key", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "first")}));
        typeList.add(new GroupType(Type.Repetition.REQUIRED, "value", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.REPEATED, "list", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "element")})}));
        GroupType map = new GroupType(Type.Repetition.OPTIONAL, "myMap", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", typeList)});
        MessageType expected = new MessageType("mapParent", new Type[]{map});
        GroupType actual = (GroupType)((Types.GroupBuilder)((Types.BaseMapBuilder.GroupKeyBuilder)Types.buildMessage().optionalMap().groupKey().required(PrimitiveType.PrimitiveTypeName.INT64).named("first")).requiredListValue().optionalElement(PrimitiveType.PrimitiveTypeName.INT64).named("myMap")).named("mapParent");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMapWithGroupKeyAndOptionalListValue() {
        ArrayList<GroupType> typeList = new ArrayList<GroupType>();
        typeList.add(new GroupType(Type.Repetition.REQUIRED, "key", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "first")}));
        typeList.add(new GroupType(Type.Repetition.OPTIONAL, "value", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.REPEATED, "list", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "element")})}));
        GroupType map = new GroupType(Type.Repetition.OPTIONAL, "myMap", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", typeList)});
        MessageType expected = new MessageType("mapParent", new Type[]{map});
        GroupType actual = (GroupType)((Types.GroupBuilder)((Types.BaseMapBuilder.GroupKeyBuilder)Types.buildMessage().optionalMap().groupKey().required(PrimitiveType.PrimitiveTypeName.INT64).named("first")).optionalListValue().optionalElement(PrimitiveType.PrimitiveTypeName.INT64).named("myMap")).named("mapParent");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMapWithGroupKeyAndRequiredMapValue() {
        ArrayList<GroupType> typeList = new ArrayList<GroupType>();
        ArrayList<PrimitiveType> innerMapTypeList = new ArrayList<PrimitiveType>();
        innerMapTypeList.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "key"));
        innerMapTypeList.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "value"));
        typeList.add(new GroupType(Type.Repetition.REQUIRED, "key", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "first")}));
        typeList.add(new GroupType(Type.Repetition.REQUIRED, "value", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", innerMapTypeList)}));
        GroupType map = new GroupType(Type.Repetition.OPTIONAL, "myMap", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", typeList)});
        MessageType expected = new MessageType("mapParent", new Type[]{map});
        GroupType actual = (GroupType)((Types.GroupBuilder)((Types.BaseMapBuilder.GroupKeyBuilder)Types.buildMessage().optionalMap().groupKey().required(PrimitiveType.PrimitiveTypeName.INT64).named("first")).requiredMapValue().key(PrimitiveType.PrimitiveTypeName.INT64).requiredValue(PrimitiveType.PrimitiveTypeName.INT64).named("myMap")).named("mapParent");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMapWithGroupKeyAndOptionalMapValue() {
        ArrayList<GroupType> typeList = new ArrayList<GroupType>();
        ArrayList<PrimitiveType> innerMapTypeList = new ArrayList<PrimitiveType>();
        innerMapTypeList.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "key"));
        innerMapTypeList.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "value"));
        typeList.add(new GroupType(Type.Repetition.REQUIRED, "key", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "first")}));
        typeList.add(new GroupType(Type.Repetition.OPTIONAL, "value", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", innerMapTypeList)}));
        GroupType map = new GroupType(Type.Repetition.OPTIONAL, "myMap", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", typeList)});
        MessageType expected = new MessageType("mapParent", new Type[]{map});
        GroupType actual = (GroupType)((Types.GroupBuilder)((Types.BaseMapBuilder.GroupKeyBuilder)Types.buildMessage().optionalMap().groupKey().required(PrimitiveType.PrimitiveTypeName.INT64).named("first")).optionalMapValue().key(PrimitiveType.PrimitiveTypeName.INT64).requiredValue(PrimitiveType.PrimitiveTypeName.INT64).named("myMap")).named("mapParent");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMapWithNullValue() {
        ArrayList<PrimitiveType> typeList = new ArrayList<PrimitiveType>();
        typeList.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "key"));
        GroupType map = new GroupType(Type.Repetition.OPTIONAL, "myMap", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", typeList)});
        MessageType expected = new MessageType("mapParent", new Type[]{map});
        GroupType actual = (GroupType)((Types.GroupBuilder)Types.buildMessage().optionalMap().key(PrimitiveType.PrimitiveTypeName.INT64).named("myMap")).named("mapParent");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMapWithDefaultKeyAndNullValue() {
        ArrayList<PrimitiveType> typeList = new ArrayList<PrimitiveType>();
        typeList.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "key", OriginalType.UTF8));
        GroupType map = new GroupType(Type.Repetition.OPTIONAL, "myMap", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", typeList)});
        MessageType expected = new MessageType("mapParent", new Type[]{map});
        GroupType actual = (GroupType)((Types.GroupBuilder)Types.buildMessage().optionalMap().named("myMap")).named("mapParent");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMapWithPreBuiltKeyAndValueTypes() {
        Type keyType = (Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named("key");
        Type valueType = (Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN).named("value");
        GroupType map = new GroupType(Type.Repetition.REQUIRED, "myMap", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", new Type[]{keyType, valueType})});
        MessageType expected = new MessageType("mapParent", new Type[]{map});
        GroupType actual = (GroupType)((Types.GroupBuilder)((Types.MapBuilder)((Types.MapBuilder)Types.buildMessage().requiredMap().key(keyType)).value(valueType)).named("myMap")).named("mapParent");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testListWithRequiredPreBuiltElement() {
        GroupType expected = new GroupType(Type.Repetition.REQUIRED, "myList", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.REPEATED, "list", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "element")})});
        Type element = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).named("element");
        Type actual = (Type)Types.requiredList().element(element).named("myList");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testRequiredList() {
        GroupType expected = new GroupType(Type.Repetition.REQUIRED, "myList", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.REPEATED, "list", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "element")})});
        Type actual = (Type)Types.requiredList().optionalElement(PrimitiveType.PrimitiveTypeName.INT64).named("myList");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testOptionalList() {
        GroupType expected = new GroupType(Type.Repetition.OPTIONAL, "myList", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.REPEATED, "list", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "element")})});
        Type actual = (Type)Types.optionalList().optionalElement(PrimitiveType.PrimitiveTypeName.INT64).named("myList");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testListOfReqGroup() {
        ArrayList<PrimitiveType> fields = new ArrayList<PrimitiveType>();
        fields.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BOOLEAN, "field"));
        GroupType expected = new GroupType(Type.Repetition.REQUIRED, "myList", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.REPEATED, "list", new Type[]{new GroupType(Type.Repetition.REQUIRED, "element", fields)})});
        Type actual = (Type)((Types.BaseListBuilder.GroupElementBuilder)Types.requiredList().requiredGroupElement().optional(PrimitiveType.PrimitiveTypeName.BOOLEAN).named("field")).named("myList");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testListOfOptionalGroup() {
        ArrayList<PrimitiveType> fields = new ArrayList<PrimitiveType>();
        fields.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BOOLEAN, "field"));
        GroupType expected = new GroupType(Type.Repetition.REQUIRED, "myList", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.REPEATED, "list", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "element", fields)})});
        Type actual = (Type)((Types.BaseListBuilder.GroupElementBuilder)Types.requiredList().optionalGroupElement().optional(PrimitiveType.PrimitiveTypeName.BOOLEAN).named("field")).named("myList");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testRequiredNestedList() {
        ArrayList<GroupType> fields = new ArrayList<GroupType>();
        fields.add(new GroupType(Type.Repetition.REQUIRED, "element", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.REPEATED, "list", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.DOUBLE, "element")})}));
        GroupType expected = new GroupType(Type.Repetition.OPTIONAL, "myList", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.REPEATED, "list", fields)});
        Type actual = (Type)Types.optionalList().requiredListElement().optionalElement(PrimitiveType.PrimitiveTypeName.DOUBLE).named("myList");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testOptionalNestedList() {
        ArrayList<GroupType> fields = new ArrayList<GroupType>();
        fields.add(new GroupType(Type.Repetition.OPTIONAL, "element", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.REPEATED, "list", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.DOUBLE, "element")})}));
        GroupType expected = new GroupType(Type.Repetition.OPTIONAL, "myList", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.REPEATED, "list", fields)});
        Type actual = (Type)Types.optionalList().optionalListElement().optionalElement(PrimitiveType.PrimitiveTypeName.DOUBLE).named("myList");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testRequiredListWithinGroup() {
        ArrayList<GroupType> fields = new ArrayList<GroupType>();
        fields.add(new GroupType(Type.Repetition.REQUIRED, "element", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.REPEATED, "list", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "element")})}));
        GroupType expected = new GroupType(Type.Repetition.REQUIRED, "topGroup", fields);
        Type actual = (Type)((Types.GroupBuilder)Types.requiredGroup().requiredList().optionalElement(PrimitiveType.PrimitiveTypeName.INT64).named("element")).named("topGroup");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testOptionalListWithinGroup() {
        ArrayList<GroupType> fields = new ArrayList<GroupType>();
        fields.add(new GroupType(Type.Repetition.OPTIONAL, "element", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.REPEATED, "list", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "element")})}));
        GroupType expected = new GroupType(Type.Repetition.REQUIRED, "topGroup", fields);
        Type actual = (Type)((Types.GroupBuilder)Types.requiredGroup().optionalList().optionalElement(PrimitiveType.PrimitiveTypeName.INT64).named("element")).named("topGroup");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testOptionalListWithinGroupWithReqElement() {
        ArrayList<GroupType> fields = new ArrayList<GroupType>();
        fields.add(new GroupType(Type.Repetition.OPTIONAL, "element", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.REPEATED, "list", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "element")})}));
        GroupType expected = new GroupType(Type.Repetition.REQUIRED, "topGroup", fields);
        Type actual = (Type)((Types.GroupBuilder)Types.requiredGroup().optionalList().requiredElement(PrimitiveType.PrimitiveTypeName.INT64).named("element")).named("topGroup");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testRequiredMapWithinList() {
        ArrayList<PrimitiveType> innerFields = new ArrayList<PrimitiveType>();
        innerFields.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.DOUBLE, "key"));
        innerFields.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, "value"));
        ArrayList<GroupType> fields = new ArrayList<GroupType>();
        fields.add(new GroupType(Type.Repetition.REQUIRED, "element", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", innerFields)}));
        GroupType expected = new GroupType(Type.Repetition.OPTIONAL, "myList", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.REPEATED, "list", fields)});
        Type actual = (Type)Types.optionalList().requiredMapElement().key(PrimitiveType.PrimitiveTypeName.DOUBLE).requiredValue(PrimitiveType.PrimitiveTypeName.INT32).named("myList");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testOptionalMapWithinList() {
        ArrayList<PrimitiveType> innerFields = new ArrayList<PrimitiveType>();
        innerFields.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.DOUBLE, "key"));
        innerFields.add(new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, "value"));
        ArrayList<GroupType> fields = new ArrayList<GroupType>();
        fields.add(new GroupType(Type.Repetition.OPTIONAL, "element", OriginalType.MAP, new Type[]{new GroupType(Type.Repetition.REPEATED, "key_value", innerFields)}));
        GroupType expected = new GroupType(Type.Repetition.OPTIONAL, "myList", OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.REPEATED, "list", fields)});
        Type actual = (Type)Types.optionalList().optionalMapElement().key(PrimitiveType.PrimitiveTypeName.DOUBLE).requiredValue(PrimitiveType.PrimitiveTypeName.INT32).named("myList");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testTypeConstructionWithUndefinedColumnOrder() {
        PrimitiveType.PrimitiveTypeName[] types;
        for (PrimitiveType.PrimitiveTypeName type : types = new PrimitiveType.PrimitiveTypeName[]{PrimitiveType.PrimitiveTypeName.BOOLEAN, PrimitiveType.PrimitiveTypeName.INT32, PrimitiveType.PrimitiveTypeName.INT64, PrimitiveType.PrimitiveTypeName.INT96, PrimitiveType.PrimitiveTypeName.FLOAT, PrimitiveType.PrimitiveTypeName.DOUBLE, PrimitiveType.PrimitiveTypeName.BINARY, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY}) {
            String name = type.toString() + "_";
            int len = type == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY ? 42 : 0;
            PrimitiveType expected = new PrimitiveType(Type.Repetition.OPTIONAL, type, len, name, null, null, null, ColumnOrder.undefined());
            PrimitiveType built = (PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)type).length(len)).columnOrder(ColumnOrder.undefined())).named(name);
            Assert.assertEquals((Object)expected, (Object)built);
        }
    }

    @Test
    public void testTypeConstructionWithTypeDefinedColumnOrder() {
        PrimitiveType.PrimitiveTypeName[] types;
        for (PrimitiveType.PrimitiveTypeName type : types = new PrimitiveType.PrimitiveTypeName[]{PrimitiveType.PrimitiveTypeName.BOOLEAN, PrimitiveType.PrimitiveTypeName.INT32, PrimitiveType.PrimitiveTypeName.INT64, PrimitiveType.PrimitiveTypeName.FLOAT, PrimitiveType.PrimitiveTypeName.DOUBLE, PrimitiveType.PrimitiveTypeName.BINARY, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY}) {
            String name = type.toString() + "_";
            int len = type == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY ? 42 : 0;
            PrimitiveType expected = new PrimitiveType(Type.Repetition.OPTIONAL, type, len, name, null, null, null, ColumnOrder.typeDefined());
            PrimitiveType built = (PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)type).length(len)).columnOrder(ColumnOrder.typeDefined())).named(name);
            Assert.assertEquals((Object)expected, (Object)built);
        }
    }

    @Test
    public void testTypeConstructionWithUnsupportedColumnOrder() {
        TestTypeBuilders.assertThrows(null, IllegalArgumentException.class, () -> (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96).columnOrder(ColumnOrder.typeDefined())).named("int96_unsupported"));
        TestTypeBuilders.assertThrows(null, IllegalArgumentException.class, () -> (PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(12)).as(OriginalType.INTERVAL)).columnOrder(ColumnOrder.typeDefined())).named("interval_unsupported"));
    }

    @Test
    public void testDecimalLogicalType() {
        PrimitiveType expected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "aDecimal", (LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)3, (int)4));
        PrimitiveType actual = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)3, (int)4))).named("aDecimal");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testDecimalLogicalTypeWithDeprecatedScale() {
        PrimitiveType expected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "aDecimal", (LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)3, (int)4));
        PrimitiveType actual = (PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)3, (int)4))).scale(3)).named("aDecimal");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testDecimalLogicalTypeWithDeprecatedPrecision() {
        PrimitiveType expected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "aDecimal", (LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)3, (int)4));
        PrimitiveType actual = (PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)3, (int)4))).precision(4)).named("aDecimal");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testTimestampLogicalTypeWithUTCParameter() {
        PrimitiveType utcMillisExpected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "aTimestamp", (LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS));
        PrimitiveType nonUtcMillisExpected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "aTimestamp", (LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS));
        PrimitiveType utcMicrosExpected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "aTimestamp", (LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS));
        PrimitiveType nonUtcMicrosExpected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "aTimestamp", (LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS));
        PrimitiveType utcMillisActual = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named("aTimestamp");
        PrimitiveType nonUtcMillisActual = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named("aTimestamp");
        PrimitiveType utcMicrosActual = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS))).named("aTimestamp");
        PrimitiveType nonUtcMicrosActual = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS))).named("aTimestamp");
        Assert.assertEquals((Object)utcMillisExpected, (Object)utcMillisActual);
        Assert.assertEquals((Object)nonUtcMillisExpected, (Object)nonUtcMillisActual);
        Assert.assertEquals((Object)utcMicrosExpected, (Object)utcMicrosActual);
        Assert.assertEquals((Object)nonUtcMicrosExpected, (Object)nonUtcMicrosActual);
    }

    @Test
    public void testVariantLogicalType() {
        byte specVersion = 1;
        String name = "variant_field";
        GroupType variantExpected = new GroupType(Type.Repetition.REQUIRED, name, (LogicalTypeAnnotation)LogicalTypeAnnotation.variantType((byte)specVersion), new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "metadata"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "value")});
        GroupType variantActual = (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.REQUIRED).addFields(new Type[]{(Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("metadata"), (Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("value")})).as((LogicalTypeAnnotation)LogicalTypeAnnotation.variantType((byte)specVersion))).named(name);
        Assert.assertEquals((Object)variantExpected, (Object)variantActual);
    }

    @Test
    public void testVariantLogicalTypeWithShredded() {
        byte specVersion = 1;
        String name = "variant_field";
        GroupType variantExpected = new GroupType(Type.Repetition.REQUIRED, name, (LogicalTypeAnnotation)LogicalTypeAnnotation.variantType((byte)specVersion), new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "metadata"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "value"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "typed_value", (LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())});
        GroupType variantActual = (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.REQUIRED).addFields(new Type[]{(Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("metadata"), (Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("value"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("typed_value")})).as((LogicalTypeAnnotation)LogicalTypeAnnotation.variantType((byte)specVersion))).named(name);
        Assert.assertEquals((Object)variantExpected, (Object)variantActual);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDecimalLogicalTypeWithDeprecatedScaleMismatch() {
        ((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)3, (int)4))).scale(4)).named("aDecimal");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDecimalLogicalTypeWithDeprecatedPrecisionMismatch() {
        ((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)3, (int)4))).precision(5)).named("aDecimal");
    }

    @Test
    public void testGeometryLogicalType() {
        PrimitiveType defaultCrsExpected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "aGeometry", (LogicalTypeAnnotation)LogicalTypeAnnotation.geometryType((String)"OGC:CRS84"));
        PrimitiveType defaultCrsActual = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.geometryType((String)"OGC:CRS84"))).named("aGeometry");
        Assert.assertEquals((Object)defaultCrsExpected, (Object)defaultCrsActual);
        PrimitiveType customCrsExpected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "aGeometry", (LogicalTypeAnnotation)LogicalTypeAnnotation.geometryType((String)"EPSG:4326"));
        PrimitiveType customCrsActual = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.geometryType((String)"EPSG:4326"))).named("aGeometry");
        Assert.assertEquals((Object)customCrsExpected, (Object)customCrsActual);
        PrimitiveType optionalGeometryExpected = new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "aGeometry", (LogicalTypeAnnotation)LogicalTypeAnnotation.geometryType((String)"OGC:CRS84"));
        PrimitiveType optionalGeometryActual = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.geometryType((String)"OGC:CRS84"))).named("aGeometry");
        Assert.assertEquals((Object)optionalGeometryExpected, (Object)optionalGeometryActual);
    }

    @Test
    public void testGeographyLogicalType() {
        PrimitiveType defaultCrsExpected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "aGeography", (LogicalTypeAnnotation)LogicalTypeAnnotation.geographyType((String)"OGC:CRS84", null));
        PrimitiveType defaultCrsActual = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.geographyType((String)"OGC:CRS84", null))).named("aGeography");
        Assert.assertEquals((Object)defaultCrsExpected, (Object)defaultCrsActual);
        PrimitiveType customCrsExpected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "aGeography", (LogicalTypeAnnotation)LogicalTypeAnnotation.geographyType((String)"EPSG:4326", null));
        PrimitiveType customCrsActual = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.geographyType((String)"EPSG:4326", null))).named("aGeography");
        Assert.assertEquals((Object)customCrsExpected, (Object)customCrsActual);
        EdgeInterpolationAlgorithm greatCircle = EdgeInterpolationAlgorithm.SPHERICAL;
        PrimitiveType customCrsWithEdgeAlgorithmExpected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "aGeography", (LogicalTypeAnnotation)LogicalTypeAnnotation.geographyType((String)"EPSG:4326", (EdgeInterpolationAlgorithm)greatCircle));
        PrimitiveType customCrsWithEdgeAlgorithmActual = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.geographyType((String)"EPSG:4326", (EdgeInterpolationAlgorithm)greatCircle))).named("aGeography");
        Assert.assertEquals((Object)customCrsWithEdgeAlgorithmExpected, (Object)customCrsWithEdgeAlgorithmActual);
        PrimitiveType optionalGeographyExpected = new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "aGeography", (LogicalTypeAnnotation)LogicalTypeAnnotation.geographyType((String)"OGC:CRS84", null));
        PrimitiveType optionalGeographyActual = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.geographyType((String)"OGC:CRS84", null))).named("aGeography");
        Assert.assertEquals((Object)optionalGeographyExpected, (Object)optionalGeographyActual);
    }

    @Test
    public void testGeographyLogicalTypeWithoutEdgeInterpolationAlgorithm() {
        PrimitiveType defaultCrsExpected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "aGeography", (LogicalTypeAnnotation)LogicalTypeAnnotation.geographyType());
        PrimitiveType defaultCrsActual = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.geographyType())).named("aGeography");
        Assert.assertEquals((Object)defaultCrsExpected, (Object)defaultCrsActual);
        PrimitiveType customCrsExpected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "aGeography", (LogicalTypeAnnotation)LogicalTypeAnnotation.geographyType((String)"EPSG:4326", null));
        PrimitiveType customCrsActual = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.geographyType((String)"EPSG:4326", null))).named("aGeography");
        Assert.assertEquals((Object)customCrsExpected, (Object)customCrsActual);
        PrimitiveType customCrsWithEdgeAlgorithmExpected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "aGeography", (LogicalTypeAnnotation)LogicalTypeAnnotation.geographyType((String)"EPSG:4326", null));
        PrimitiveType customCrsWithEdgeAlgorithmActual = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.geographyType((String)"EPSG:4326", null))).named("aGeography");
        Assert.assertEquals((Object)customCrsWithEdgeAlgorithmExpected, (Object)customCrsWithEdgeAlgorithmActual);
        PrimitiveType optionalGeographyExpected = new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "aGeography", (LogicalTypeAnnotation)LogicalTypeAnnotation.geographyType());
        PrimitiveType optionalGeographyActual = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.geographyType())).named("aGeography");
        Assert.assertEquals((Object)optionalGeographyExpected, (Object)optionalGeographyActual);
    }

    public static void assertThrows(String message, Class<? extends Exception> expected, Callable callable) {
        try {
            callable.call();
            Assert.fail((String)("No exception was thrown (" + message + "), expected: " + expected.getName()));
        }
        catch (Exception actual) {
            Assert.assertEquals((String)message, expected, actual.getClass());
        }
    }
}

