/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.mem;

import org.apache.parquet.Log;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ColumnReader;
import org.apache.parquet.column.ColumnWriter;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.impl.ColumnReadStoreImpl;
import org.apache.parquet.column.impl.ColumnWriteStoreV1;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.column.page.PageWriteStore;
import org.apache.parquet.column.page.mem.MemPageStore;
import org.apache.parquet.example.DummyRecordConverter;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.junit.Assert;
import org.junit.Test;

public class TestMemColumn {
    private static final Log LOG = Log.getLog(TestMemColumn.class);

    @Test
    public void testMemColumn() throws Exception {
        MessageType schema = MessageTypeParser.parseMessageType((String)"message msg { required group foo { required int64 bar; } }");
        ColumnDescriptor path = schema.getColumnDescription(new String[]{"foo", "bar"});
        MemPageStore memPageStore = new MemPageStore(10L);
        ColumnWriteStoreV1 memColumnsStore = this.newColumnWriteStoreImpl(memPageStore);
        ColumnWriter columnWriter = memColumnsStore.getColumnWriter(path);
        columnWriter.write(42L, 0, 0);
        memColumnsStore.flush();
        ColumnReader columnReader = this.getColumnReader(memPageStore, path, schema);
        int i = 0;
        while ((long)i < columnReader.getTotalValueCount()) {
            Assert.assertEquals((long)columnReader.getCurrentRepetitionLevel(), (long)0L);
            Assert.assertEquals((long)columnReader.getCurrentDefinitionLevel(), (long)0L);
            Assert.assertEquals((long)columnReader.getLong(), (long)42L);
            columnReader.consume();
            ++i;
        }
    }

    private ColumnWriter getColumnWriter(ColumnDescriptor path, MemPageStore memPageStore) {
        ColumnWriteStoreV1 memColumnsStore = this.newColumnWriteStoreImpl(memPageStore);
        ColumnWriter columnWriter = memColumnsStore.getColumnWriter(path);
        return columnWriter;
    }

    private ColumnReader getColumnReader(MemPageStore memPageStore, ColumnDescriptor path, MessageType schema) {
        return new ColumnReadStoreImpl((PageReadStore)memPageStore, new DummyRecordConverter(schema).getRootConverter(), schema, null).getColumnReader(path);
    }

    @Test
    public void testMemColumnBinary() throws Exception {
        ColumnDescriptor path1;
        MessageType mt = MessageTypeParser.parseMessageType((String)"message msg { required group foo { required binary bar; } }");
        String[] col = new String[]{"foo", "bar"};
        MemPageStore memPageStore = new MemPageStore(10L);
        ColumnWriteStoreV1 memColumnsStore = this.newColumnWriteStoreImpl(memPageStore);
        ColumnDescriptor path = path1 = mt.getColumnDescription(col);
        ColumnWriter columnWriter = memColumnsStore.getColumnWriter(path);
        columnWriter.write(Binary.fromString((String)"42"), 0, 0);
        memColumnsStore.flush();
        ColumnReader columnReader = this.getColumnReader(memPageStore, path, mt);
        int i = 0;
        while ((long)i < columnReader.getTotalValueCount()) {
            Assert.assertEquals((long)columnReader.getCurrentRepetitionLevel(), (long)0L);
            Assert.assertEquals((long)columnReader.getCurrentDefinitionLevel(), (long)0L);
            Assert.assertEquals((Object)columnReader.getBinary().toStringUsingUTF8(), (Object)"42");
            columnReader.consume();
            ++i;
        }
    }

    @Test
    public void testMemColumnSeveralPages() throws Exception {
        ColumnDescriptor path1;
        MessageType mt = MessageTypeParser.parseMessageType((String)"message msg { required group foo { required int64 bar; } }");
        String[] col = new String[]{"foo", "bar"};
        MemPageStore memPageStore = new MemPageStore(10L);
        ColumnWriteStoreV1 memColumnsStore = this.newColumnWriteStoreImpl(memPageStore);
        ColumnDescriptor path = path1 = mt.getColumnDescription(col);
        ColumnWriter columnWriter = memColumnsStore.getColumnWriter(path);
        for (int i = 0; i < 2000; ++i) {
            columnWriter.write(42L, 0, 0);
        }
        memColumnsStore.flush();
        ColumnReader columnReader = this.getColumnReader(memPageStore, path, mt);
        int i = 0;
        while ((long)i < columnReader.getTotalValueCount()) {
            Assert.assertEquals((long)columnReader.getCurrentRepetitionLevel(), (long)0L);
            Assert.assertEquals((long)columnReader.getCurrentDefinitionLevel(), (long)0L);
            Assert.assertEquals((long)columnReader.getLong(), (long)42L);
            columnReader.consume();
            ++i;
        }
    }

    @Test
    public void testMemColumnSeveralPagesRepeated() throws Exception {
        ColumnDescriptor path1;
        MessageType mt = MessageTypeParser.parseMessageType((String)"message msg { repeated group foo { repeated int64 bar; } }");
        String[] col = new String[]{"foo", "bar"};
        MemPageStore memPageStore = new MemPageStore(10L);
        ColumnWriteStoreV1 memColumnsStore = this.newColumnWriteStoreImpl(memPageStore);
        ColumnDescriptor path = path1 = mt.getColumnDescription(col);
        ColumnWriter columnWriter = memColumnsStore.getColumnWriter(path);
        int[] rs = new int[]{0, 0, 0, 1, 1, 1, 2, 2, 2};
        int[] ds = new int[]{0, 1, 2, 0, 1, 2, 0, 1, 2};
        for (int i = 0; i < 837; ++i) {
            int r = rs[i % rs.length];
            int d = ds[i % ds.length];
            LOG.debug((Object)("write i: " + i));
            if (d == 2) {
                columnWriter.write((long)i, r, d);
                continue;
            }
            columnWriter.writeNull(r, d);
        }
        memColumnsStore.flush();
        ColumnReader columnReader = this.getColumnReader(memPageStore, path, mt);
        int i = 0;
        int j = 0;
        while ((long)j < columnReader.getTotalValueCount()) {
            int r = rs[i % rs.length];
            int d = ds[i % ds.length];
            LOG.debug((Object)("read i: " + i));
            Assert.assertEquals((String)("r row " + i), (long)r, (long)columnReader.getCurrentRepetitionLevel());
            Assert.assertEquals((String)("d row " + i), (long)d, (long)columnReader.getCurrentDefinitionLevel());
            if (d == 2) {
                Assert.assertEquals((String)("data row " + i), (long)i, (long)columnReader.getLong());
            }
            columnReader.consume();
            ++i;
            ++j;
        }
    }

    private ColumnWriteStoreV1 newColumnWriteStoreImpl(MemPageStore memPageStore) {
        return new ColumnWriteStoreV1((PageWriteStore)memPageStore, ParquetProperties.builder().withPageSize(2048).withDictionaryEncoding(false).build());
    }
}

