/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.page.mem;

import java.util.Iterator;
import org.apache.parquet.Log;
import org.apache.parquet.Preconditions;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.io.ParquetDecodingException;

public class MemPageReader
implements PageReader {
    private static final Log LOG = Log.getLog(MemPageReader.class);
    private final long totalValueCount;
    private final Iterator<DataPage> pages;
    private final DictionaryPage dictionaryPage;

    public MemPageReader(long totalValueCount, Iterator<DataPage> pages, DictionaryPage dictionaryPage) {
        Preconditions.checkNotNull(pages, (String)"pages");
        this.totalValueCount = totalValueCount;
        this.pages = pages;
        this.dictionaryPage = dictionaryPage;
    }

    public long getTotalValueCount() {
        return this.totalValueCount;
    }

    public DataPage readPage() {
        if (this.pages.hasNext()) {
            DataPage next = this.pages.next();
            if (Log.DEBUG) {
                LOG.debug((Object)("read page " + next));
            }
            return next;
        }
        throw new ParquetDecodingException("after last page");
    }

    public DictionaryPage readDictionaryPage() {
        return this.dictionaryPage;
    }
}

