/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.statistics;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.parquet.column.statistics.BinaryStatistics;
import org.apache.parquet.column.statistics.BooleanStatistics;
import org.apache.parquet.column.statistics.DoubleStatistics;
import org.apache.parquet.column.statistics.FloatStatistics;
import org.apache.parquet.column.statistics.IntStatistics;
import org.apache.parquet.column.statistics.LongStatistics;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.io.api.Binary;
import org.junit.Assert;
import org.junit.Test;

public class TestStatistics {
    private int[] integerArray;
    private long[] longArray;
    private float[] floatArray;
    private double[] doubleArray;
    private String[] stringArray;
    private boolean[] booleanArray;

    @Test
    public void testNumNulls() {
        IntStatistics stats = new IntStatistics();
        Assert.assertEquals((long)stats.getNumNulls(), (long)0L);
        stats.incrementNumNulls();
        stats.incrementNumNulls();
        stats.incrementNumNulls();
        stats.incrementNumNulls();
        Assert.assertEquals((long)stats.getNumNulls(), (long)4L);
        stats.incrementNumNulls(5L);
        Assert.assertEquals((long)stats.getNumNulls(), (long)9L);
        stats.setNumNulls(22L);
        Assert.assertEquals((long)stats.getNumNulls(), (long)22L);
    }

    @Test
    public void testIntMinMax() {
        this.integerArray = new int[]{1, 3, 14, 54, 66, 8, 0, 23, 54};
        IntStatistics stats = new IntStatistics();
        for (int i : this.integerArray) {
            stats.updateStats(i);
        }
        Assert.assertEquals((long)stats.getMax(), (long)66L);
        Assert.assertEquals((long)stats.getMin(), (long)0L);
        this.integerArray = new int[]{-11, 3, -14, 54, -66, 8, 0, -23, 54};
        IntStatistics statsNeg = new IntStatistics();
        for (int i : this.integerArray) {
            statsNeg.updateStats(i);
        }
        Assert.assertEquals((long)statsNeg.getMax(), (long)54L);
        Assert.assertEquals((long)statsNeg.getMin(), (long)-66L);
        byte[] intMaxBytes = statsNeg.getMaxBytes();
        byte[] intMinBytes = statsNeg.getMinBytes();
        Assert.assertEquals((long)ByteBuffer.wrap(intMaxBytes).order(ByteOrder.LITTLE_ENDIAN).getInt(), (long)54L);
        Assert.assertEquals((long)ByteBuffer.wrap(intMinBytes).order(ByteOrder.LITTLE_ENDIAN).getInt(), (long)-66L);
        IntStatistics statsFromBytes = new IntStatistics();
        statsFromBytes.setMinMaxFromBytes(intMinBytes, intMaxBytes);
        Assert.assertEquals((long)statsFromBytes.getMax(), (long)54L);
        Assert.assertEquals((long)statsFromBytes.getMin(), (long)-66L);
        this.integerArray = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE};
        IntStatistics minMaxValues = new IntStatistics();
        for (int i : this.integerArray) {
            minMaxValues.updateStats(i);
        }
        Assert.assertEquals((long)minMaxValues.getMax(), (long)Integer.MAX_VALUE);
        Assert.assertEquals((long)minMaxValues.getMin(), (long)Integer.MIN_VALUE);
        byte[] intMaxBytesMinMax = minMaxValues.getMaxBytes();
        byte[] intMinBytesMinMax = minMaxValues.getMinBytes();
        Assert.assertEquals((long)ByteBuffer.wrap(intMaxBytesMinMax).order(ByteOrder.LITTLE_ENDIAN).getInt(), (long)Integer.MAX_VALUE);
        Assert.assertEquals((long)ByteBuffer.wrap(intMinBytesMinMax).order(ByteOrder.LITTLE_ENDIAN).getInt(), (long)Integer.MIN_VALUE);
        IntStatistics statsFromBytesMinMax = new IntStatistics();
        statsFromBytesMinMax.setMinMaxFromBytes(intMinBytesMinMax, intMaxBytesMinMax);
        Assert.assertEquals((long)statsFromBytesMinMax.getMax(), (long)Integer.MAX_VALUE);
        Assert.assertEquals((long)statsFromBytesMinMax.getMin(), (long)Integer.MIN_VALUE);
        Assert.assertEquals((Object)stats.toString(), (Object)"min: 0, max: 66, num_nulls: 0");
    }

    @Test
    public void testLongMinMax() {
        this.longArray = new long[]{9L, 39L, 99L, 3L, 0L, 12L, 1000L, 65L, 542L};
        LongStatistics stats = new LongStatistics();
        for (long l : this.longArray) {
            stats.updateStats(l);
        }
        Assert.assertEquals((long)stats.getMax(), (long)1000L);
        Assert.assertEquals((long)stats.getMin(), (long)0L);
        this.longArray = new long[]{-101L, 993L, -9914L, 54L, -9L, 89L, 0L, -23L, 90L};
        LongStatistics statsNeg = new LongStatistics();
        for (long l : this.longArray) {
            statsNeg.updateStats(l);
        }
        Assert.assertEquals((long)statsNeg.getMax(), (long)993L);
        Assert.assertEquals((long)statsNeg.getMin(), (long)-9914L);
        byte[] longMaxBytes = statsNeg.getMaxBytes();
        byte[] longMinBytes = statsNeg.getMinBytes();
        Assert.assertEquals((long)ByteBuffer.wrap(longMaxBytes).order(ByteOrder.LITTLE_ENDIAN).getLong(), (long)993L);
        Assert.assertEquals((long)ByteBuffer.wrap(longMinBytes).order(ByteOrder.LITTLE_ENDIAN).getLong(), (long)-9914L);
        LongStatistics statsFromBytes = new LongStatistics();
        statsFromBytes.setMinMaxFromBytes(longMinBytes, longMaxBytes);
        Assert.assertEquals((long)statsFromBytes.getMax(), (long)993L);
        Assert.assertEquals((long)statsFromBytes.getMin(), (long)-9914L);
        this.longArray = new long[]{Long.MAX_VALUE, Long.MIN_VALUE};
        LongStatistics minMaxValues = new LongStatistics();
        for (long l : this.longArray) {
            minMaxValues.updateStats(l);
        }
        Assert.assertEquals((long)minMaxValues.getMax(), (long)Long.MAX_VALUE);
        Assert.assertEquals((long)minMaxValues.getMin(), (long)Long.MIN_VALUE);
        byte[] longMaxBytesMinMax = minMaxValues.getMaxBytes();
        byte[] longMinBytesMinMax = minMaxValues.getMinBytes();
        Assert.assertEquals((long)ByteBuffer.wrap(longMaxBytesMinMax).order(ByteOrder.LITTLE_ENDIAN).getLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((long)ByteBuffer.wrap(longMinBytesMinMax).order(ByteOrder.LITTLE_ENDIAN).getLong(), (long)Long.MIN_VALUE);
        LongStatistics statsFromBytesMinMax = new LongStatistics();
        statsFromBytesMinMax.setMinMaxFromBytes(longMinBytesMinMax, longMaxBytesMinMax);
        Assert.assertEquals((long)statsFromBytesMinMax.getMax(), (long)Long.MAX_VALUE);
        Assert.assertEquals((long)statsFromBytesMinMax.getMin(), (long)Long.MIN_VALUE);
        Assert.assertEquals((Object)stats.toString(), (Object)"min: 0, max: 1000, num_nulls: 0");
    }

    @Test
    public void testFloatMinMax() {
        this.floatArray = new float[]{1.5f, 44.5f, 412.99f, 0.65f, 5.6f, 100.6f, 1.0E-4f, 23.0f, 553.6f};
        FloatStatistics stats = new FloatStatistics();
        for (float f : this.floatArray) {
            stats.updateStats(f);
        }
        Assert.assertEquals((double)stats.getMax(), (double)553.6f, (double)1.0E-10);
        Assert.assertEquals((double)stats.getMin(), (double)1.0E-4f, (double)1.0E-10);
        this.floatArray = new float[]{-1.5f, -44.5f, -412.99f, 0.65f, -5.6f, -100.6f, 1.0E-4f, -23.0f, -3.6f};
        FloatStatistics statsNeg = new FloatStatistics();
        for (float f : this.floatArray) {
            statsNeg.updateStats(f);
        }
        Assert.assertEquals((double)statsNeg.getMax(), (double)0.65f, (double)1.0E-10);
        Assert.assertEquals((double)statsNeg.getMin(), (double)-412.99f, (double)1.0E-10);
        byte[] floatMaxBytes = statsNeg.getMaxBytes();
        byte[] floatMinBytes = statsNeg.getMinBytes();
        Assert.assertEquals((double)ByteBuffer.wrap(floatMaxBytes).order(ByteOrder.LITTLE_ENDIAN).getFloat(), (double)0.65f, (double)1.0E-10);
        Assert.assertEquals((double)ByteBuffer.wrap(floatMinBytes).order(ByteOrder.LITTLE_ENDIAN).getFloat(), (double)-412.99f, (double)1.0E-10);
        FloatStatistics statsFromBytes = new FloatStatistics();
        statsFromBytes.setMinMaxFromBytes(floatMinBytes, floatMaxBytes);
        Assert.assertEquals((double)statsFromBytes.getMax(), (double)0.65f, (double)1.0E-10);
        Assert.assertEquals((double)statsFromBytes.getMin(), (double)-412.99f, (double)1.0E-10);
        this.floatArray = new float[]{Float.MAX_VALUE, Float.MIN_VALUE};
        FloatStatistics minMaxValues = new FloatStatistics();
        for (float f : this.floatArray) {
            minMaxValues.updateStats(f);
        }
        Assert.assertEquals((double)minMaxValues.getMax(), (double)3.4028234663852886E38, (double)1.0E-10);
        Assert.assertEquals((double)minMaxValues.getMin(), (double)1.4E-45f, (double)1.0E-10);
        byte[] floatMaxBytesMinMax = minMaxValues.getMaxBytes();
        byte[] floatMinBytesMinMax = minMaxValues.getMinBytes();
        Assert.assertEquals((double)ByteBuffer.wrap(floatMaxBytesMinMax).order(ByteOrder.LITTLE_ENDIAN).getFloat(), (double)3.4028234663852886E38, (double)1.0E-10);
        Assert.assertEquals((double)ByteBuffer.wrap(floatMinBytesMinMax).order(ByteOrder.LITTLE_ENDIAN).getFloat(), (double)1.4E-45f, (double)1.0E-10);
        FloatStatistics statsFromBytesMinMax = new FloatStatistics();
        statsFromBytesMinMax.setMinMaxFromBytes(floatMinBytesMinMax, floatMaxBytesMinMax);
        Assert.assertEquals((double)statsFromBytesMinMax.getMax(), (double)3.4028234663852886E38, (double)1.0E-10);
        Assert.assertEquals((double)statsFromBytesMinMax.getMin(), (double)1.4E-45f, (double)1.0E-10);
        Assert.assertEquals((Object)stats.toString(), (Object)"min: 0.00010, max: 553.59998, num_nulls: 0");
    }

    @Test
    public void testDoubleMinMax() {
        this.doubleArray = new double[]{81.5, 944.5, 2.002, 334.5, 5.6, 0.001, 1.0E-5, 23.0, 553.6};
        DoubleStatistics stats = new DoubleStatistics();
        for (double d : this.doubleArray) {
            stats.updateStats(d);
        }
        Assert.assertEquals((double)stats.getMax(), (double)944.5, (double)1.0E-10);
        Assert.assertEquals((double)stats.getMin(), (double)1.0E-5, (double)1.0E-10);
        this.doubleArray = new double[]{-81.5, -944.5, 2.002, -334.5, -5.6, -0.001, -1.0E-5, 23.0, -3.6};
        DoubleStatistics statsNeg = new DoubleStatistics();
        for (double d : this.doubleArray) {
            statsNeg.updateStats(d);
        }
        Assert.assertEquals((double)statsNeg.getMax(), (double)23.0, (double)1.0E-10);
        Assert.assertEquals((double)statsNeg.getMin(), (double)-944.5, (double)1.0E-10);
        byte[] doubleMaxBytes = statsNeg.getMaxBytes();
        byte[] doubleMinBytes = statsNeg.getMinBytes();
        Assert.assertEquals((double)ByteBuffer.wrap(doubleMaxBytes).order(ByteOrder.LITTLE_ENDIAN).getDouble(), (double)23.0, (double)1.0E-10);
        Assert.assertEquals((double)ByteBuffer.wrap(doubleMinBytes).order(ByteOrder.LITTLE_ENDIAN).getDouble(), (double)-944.5, (double)1.0E-10);
        DoubleStatistics statsFromBytes = new DoubleStatistics();
        statsFromBytes.setMinMaxFromBytes(doubleMinBytes, doubleMaxBytes);
        Assert.assertEquals((double)statsFromBytes.getMax(), (double)23.0, (double)1.0E-10);
        Assert.assertEquals((double)statsFromBytes.getMin(), (double)-944.5, (double)1.0E-10);
        this.doubleArray = new double[]{Double.MAX_VALUE, Double.MIN_VALUE};
        DoubleStatistics minMaxValues = new DoubleStatistics();
        for (double d : this.doubleArray) {
            minMaxValues.updateStats(d);
        }
        Assert.assertEquals((double)minMaxValues.getMax(), (double)Double.MAX_VALUE, (double)1.0E-10);
        Assert.assertEquals((double)minMaxValues.getMin(), (double)Double.MIN_VALUE, (double)1.0E-10);
        byte[] doubleMaxBytesMinMax = minMaxValues.getMaxBytes();
        byte[] doubleMinBytesMinMax = minMaxValues.getMinBytes();
        Assert.assertEquals((double)ByteBuffer.wrap(doubleMaxBytesMinMax).order(ByteOrder.LITTLE_ENDIAN).getDouble(), (double)Double.MAX_VALUE, (double)1.0E-10);
        Assert.assertEquals((double)ByteBuffer.wrap(doubleMinBytesMinMax).order(ByteOrder.LITTLE_ENDIAN).getDouble(), (double)Double.MIN_VALUE, (double)1.0E-10);
        DoubleStatistics statsFromBytesMinMax = new DoubleStatistics();
        statsFromBytesMinMax.setMinMaxFromBytes(doubleMinBytesMinMax, doubleMaxBytesMinMax);
        Assert.assertEquals((double)statsFromBytesMinMax.getMax(), (double)Double.MAX_VALUE, (double)1.0E-10);
        Assert.assertEquals((double)statsFromBytesMinMax.getMin(), (double)Double.MIN_VALUE, (double)1.0E-10);
        Assert.assertEquals((Object)stats.toString(), (Object)"min: 0.00001, max: 944.50000, num_nulls: 0");
    }

    @Test
    public void testBooleanMinMax() {
        this.booleanArray = new boolean[]{true, true, true};
        BooleanStatistics statsTrue = new BooleanStatistics();
        for (boolean i : this.booleanArray) {
            statsTrue.updateStats(i);
        }
        Assert.assertTrue((boolean)statsTrue.getMax());
        Assert.assertTrue((boolean)statsTrue.getMin());
        this.booleanArray = new boolean[]{false, false, false};
        BooleanStatistics statsFalse = new BooleanStatistics();
        for (boolean i : this.booleanArray) {
            statsFalse.updateStats(i);
        }
        Assert.assertFalse((boolean)statsFalse.getMax());
        Assert.assertFalse((boolean)statsFalse.getMin());
        this.booleanArray = new boolean[]{false, true, false};
        BooleanStatistics statsBoth = new BooleanStatistics();
        for (boolean i : this.booleanArray) {
            statsBoth.updateStats(i);
        }
        Assert.assertTrue((boolean)statsBoth.getMax());
        Assert.assertFalse((boolean)statsBoth.getMin());
        byte[] boolMaxBytes = statsBoth.getMaxBytes();
        byte[] boolMinBytes = statsBoth.getMinBytes();
        Assert.assertEquals((long)(boolMaxBytes[0] & 0xFF), (long)1L);
        Assert.assertEquals((long)(boolMinBytes[0] & 0xFF), (long)0L);
        BooleanStatistics statsFromBytes = new BooleanStatistics();
        statsFromBytes.setMinMaxFromBytes(boolMinBytes, boolMaxBytes);
        Assert.assertTrue((boolean)statsFromBytes.getMax());
        Assert.assertFalse((boolean)statsFromBytes.getMin());
        Assert.assertEquals((Object)statsBoth.toString(), (Object)"min: false, max: true, num_nulls: 0");
    }

    @Test
    public void testBinaryMinMax() {
        this.stringArray = new String[]{"hello", "world", "this", "is", "a", "test", "of", "the", "stats", "class"};
        BinaryStatistics stats = new BinaryStatistics();
        for (String s : this.stringArray) {
            stats.updateStats(Binary.fromString((String)s));
        }
        Assert.assertEquals((Object)stats.getMax(), (Object)Binary.fromString((String)"world"));
        Assert.assertEquals((Object)stats.getMin(), (Object)Binary.fromString((String)"a"));
        this.stringArray = new String[]{"", "", "", "", ""};
        BinaryStatistics statsEmpty = new BinaryStatistics();
        for (String s : this.stringArray) {
            statsEmpty.updateStats(Binary.fromString((String)s));
        }
        Assert.assertEquals((Object)statsEmpty.getMax(), (Object)Binary.fromString((String)""));
        Assert.assertEquals((Object)statsEmpty.getMin(), (Object)Binary.fromString((String)""));
        byte[] stringMaxBytes = stats.getMaxBytes();
        byte[] stringMinBytes = stats.getMinBytes();
        Assert.assertEquals((Object)new String(stringMaxBytes), (Object)"world");
        Assert.assertEquals((Object)new String(stringMinBytes), (Object)"a");
        BinaryStatistics statsFromBytes = new BinaryStatistics();
        statsFromBytes.setMinMaxFromBytes(stringMinBytes, stringMaxBytes);
        Assert.assertEquals((Object)statsFromBytes.getMax(), (Object)Binary.fromString((String)"world"));
        Assert.assertEquals((Object)statsFromBytes.getMin(), (Object)Binary.fromString((String)"a"));
        Assert.assertEquals((Object)stats.toString(), (Object)"min: a, max: world, num_nulls: 0");
    }

    @Test
    public void testBinaryMinMaxForReusedBackingByteArray() {
        BinaryStatistics stats = new BinaryStatistics();
        byte[] bytes = new byte[]{10};
        Binary value = Binary.fromReusedByteArray((byte[])bytes);
        stats.updateStats(value);
        bytes[0] = 20;
        stats.updateStats(value);
        bytes[0] = 15;
        stats.updateStats(value);
        Assert.assertArrayEquals((byte[])new byte[]{20}, (byte[])stats.getMaxBytes());
        Assert.assertArrayEquals((byte[])new byte[]{10}, (byte[])stats.getMinBytes());
    }

    @Test
    public void testMergingStatistics() {
        this.testMergingIntStats();
        this.testMergingLongStats();
        this.testMergingFloatStats();
        this.testMergingDoubleStats();
        this.testMergingBooleanStats();
        this.testMergingStringStats();
    }

    private void testMergingIntStats() {
        this.integerArray = new int[]{1, 2, 3, 4, 5};
        IntStatistics intStats = new IntStatistics();
        for (int s : this.integerArray) {
            intStats.updateStats(s);
        }
        this.integerArray = new int[]{0, 3, 3};
        IntStatistics intStats2 = new IntStatistics();
        for (int s : this.integerArray) {
            intStats2.updateStats(s);
        }
        intStats.mergeStatistics((Statistics)intStats2);
        Assert.assertEquals((long)intStats.getMax(), (long)5L);
        Assert.assertEquals((long)intStats.getMin(), (long)0L);
        this.integerArray = new int[]{-1, -100, 100};
        IntStatistics intStats3 = new IntStatistics();
        for (int s : this.integerArray) {
            intStats3.updateStats(s);
        }
        intStats.mergeStatistics((Statistics)intStats3);
        Assert.assertEquals((long)intStats.getMax(), (long)100L);
        Assert.assertEquals((long)intStats.getMin(), (long)-100L);
    }

    private void testMergingLongStats() {
        this.longArray = new long[]{1L, 2L, 3L, 4L, 5L};
        LongStatistics longStats = new LongStatistics();
        for (long s : this.longArray) {
            longStats.updateStats(s);
        }
        this.longArray = new long[]{0L, 3L, 3L};
        LongStatistics longStats2 = new LongStatistics();
        for (long s : this.longArray) {
            longStats2.updateStats(s);
        }
        longStats.mergeStatistics((Statistics)longStats2);
        Assert.assertEquals((long)longStats.getMax(), (long)5L);
        Assert.assertEquals((long)longStats.getMin(), (long)0L);
        this.longArray = new long[]{-1L, -100L, 100L};
        LongStatistics longStats3 = new LongStatistics();
        for (long s : this.longArray) {
            longStats3.updateStats(s);
        }
        longStats.mergeStatistics((Statistics)longStats3);
        Assert.assertEquals((long)longStats.getMax(), (long)100L);
        Assert.assertEquals((long)longStats.getMin(), (long)-100L);
    }

    private void testMergingFloatStats() {
        this.floatArray = new float[]{1.44f, 12.2f, 98.3f, 1.4f, 0.05f};
        FloatStatistics floatStats = new FloatStatistics();
        for (float s : this.floatArray) {
            floatStats.updateStats(s);
        }
        this.floatArray = new float[]{1.0E-4f, 9.9f, 3.1f};
        FloatStatistics floatStats2 = new FloatStatistics();
        for (float s : this.floatArray) {
            floatStats2.updateStats(s);
        }
        floatStats.mergeStatistics((Statistics)floatStats2);
        Assert.assertEquals((double)floatStats.getMax(), (double)98.3f, (double)1.0E-10);
        Assert.assertEquals((double)floatStats.getMin(), (double)1.0E-4f, (double)1.0E-10);
        this.floatArray = new float[]{-1.91f, -100.9f, 100.54f};
        FloatStatistics floatStats3 = new FloatStatistics();
        for (float s : this.floatArray) {
            floatStats3.updateStats(s);
        }
        floatStats.mergeStatistics((Statistics)floatStats3);
        Assert.assertEquals((double)floatStats.getMax(), (double)100.54f, (double)1.0E-10);
        Assert.assertEquals((double)floatStats.getMin(), (double)-100.9f, (double)1.0E-10);
    }

    private void testMergingDoubleStats() {
        this.doubleArray = new double[]{1.44, 12.2, 98.3, 1.4, 0.05};
        DoubleStatistics doubleStats = new DoubleStatistics();
        for (double s : this.doubleArray) {
            doubleStats.updateStats(s);
        }
        this.doubleArray = new double[]{1.0E-4, 9.9, 3.1};
        DoubleStatistics doubleStats2 = new DoubleStatistics();
        for (double s : this.doubleArray) {
            doubleStats2.updateStats(s);
        }
        doubleStats.mergeStatistics((Statistics)doubleStats2);
        Assert.assertEquals((double)doubleStats.getMax(), (double)98.3, (double)1.0E-10);
        Assert.assertEquals((double)doubleStats.getMin(), (double)1.0E-4, (double)1.0E-10);
        this.doubleArray = new double[]{-1.91, -100.9, 100.54};
        DoubleStatistics doubleStats3 = new DoubleStatistics();
        for (double s : this.doubleArray) {
            doubleStats3.updateStats(s);
        }
        doubleStats.mergeStatistics((Statistics)doubleStats3);
        Assert.assertEquals((double)doubleStats.getMax(), (double)100.54, (double)1.0E-10);
        Assert.assertEquals((double)doubleStats.getMin(), (double)-100.9, (double)1.0E-10);
    }

    private void testMergingBooleanStats() {
        this.booleanArray = new boolean[]{true, true, true};
        BooleanStatistics booleanStats = new BooleanStatistics();
        for (boolean s : this.booleanArray) {
            booleanStats.updateStats(s);
        }
        this.booleanArray = new boolean[]{true, false};
        BooleanStatistics booleanStats2 = new BooleanStatistics();
        for (boolean s : this.booleanArray) {
            booleanStats2.updateStats(s);
        }
        booleanStats.mergeStatistics((Statistics)booleanStats2);
        Assert.assertEquals((Object)booleanStats.getMax(), (Object)true);
        Assert.assertEquals((Object)booleanStats.getMin(), (Object)false);
        this.booleanArray = new boolean[]{false, false, false, false};
        BooleanStatistics booleanStats3 = new BooleanStatistics();
        for (boolean s : this.booleanArray) {
            booleanStats3.updateStats(s);
        }
        booleanStats.mergeStatistics((Statistics)booleanStats3);
        Assert.assertEquals((Object)booleanStats.getMax(), (Object)true);
        Assert.assertEquals((Object)booleanStats.getMin(), (Object)false);
    }

    private void testMergingStringStats() {
        this.stringArray = new String[]{"hello", "world", "this", "is", "a", "test", "of", "the", "stats", "class"};
        BinaryStatistics stats = new BinaryStatistics();
        for (String s : this.stringArray) {
            stats.updateStats(Binary.fromString((String)s));
        }
        this.stringArray = new String[]{"zzzz", "asdf", "testing"};
        BinaryStatistics stats2 = new BinaryStatistics();
        for (String s : this.stringArray) {
            stats2.updateStats(Binary.fromString((String)s));
        }
        stats.mergeStatistics((Statistics)stats2);
        Assert.assertEquals((Object)stats.getMax(), (Object)Binary.fromString((String)"zzzz"));
        Assert.assertEquals((Object)stats.getMin(), (Object)Binary.fromString((String)"a"));
        this.stringArray = new String[]{"", "good", "testing"};
        BinaryStatistics stats3 = new BinaryStatistics();
        for (String s : this.stringArray) {
            stats3.updateStats(Binary.fromString((String)s));
        }
        stats.mergeStatistics((Statistics)stats3);
        Assert.assertEquals((Object)stats.getMax(), (Object)Binary.fromString((String)"zzzz"));
        Assert.assertEquals((Object)stats.getMin(), (Object)Binary.fromString((String)""));
    }
}

