/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.parquet.column.values.RandomStr;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.io.api.Binary;

public class Utils {
    private static Random randomLen = new Random();
    private static RandomStr randomStr = new RandomStr(randomLen);

    public static String[] getRandomStringSamples(int numSamples, int maxLength) {
        String[] samples = new String[numSamples];
        for (int i = 0; i < numSamples; ++i) {
            int len = randomLen.nextInt(maxLength);
            samples[i] = randomStr.get(len);
        }
        return samples;
    }

    public static void writeInts(ValuesWriter writer, int[] ints) throws IOException {
        for (int i = 0; i < ints.length; ++i) {
            writer.writeInteger(ints[i]);
        }
    }

    public static void writeData(ValuesWriter writer, String[] strings) throws IOException {
        for (int i = 0; i < strings.length; ++i) {
            writer.writeBytes(Binary.fromString((String)strings[i]));
        }
    }

    public static Binary[] readData(ValuesReader reader, byte[] data, int offset, int length) throws IOException {
        Binary[] bins = new Binary[length];
        reader.initFromPage(length, ByteBuffer.wrap(data), 0);
        for (int i = 0; i < length; ++i) {
            bins[i] = reader.readBytes();
        }
        return bins;
    }

    public static Binary[] readData(ValuesReader reader, byte[] data, int length) throws IOException {
        return Utils.readData(reader, data, 0, length);
    }

    public static int[] readInts(ValuesReader reader, byte[] data, int offset, int length) throws IOException {
        int[] ints = new int[length];
        reader.initFromPage(length, ByteBuffer.wrap(data), offset);
        for (int i = 0; i < length; ++i) {
            ints[i] = reader.readInteger();
        }
        return ints;
    }

    public static int[] readInts(ValuesReader reader, byte[] data, int length) throws IOException {
        return Utils.readInts(reader, data, 0, length);
    }
}

