/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.bitpacking;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.parquet.Log;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.DirectByteBufferAllocator;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.column.values.bitpacking.BitPackingValuesReader;
import org.apache.parquet.column.values.bitpacking.BitPackingValuesWriter;
import org.apache.parquet.column.values.bitpacking.ByteBitPackingValuesReader;
import org.apache.parquet.column.values.bitpacking.ByteBitPackingValuesWriter;
import org.apache.parquet.column.values.bitpacking.Packer;
import org.apache.parquet.column.values.bitpacking.TestBitPacking;
import org.junit.Assert;
import org.junit.Test;

public class TestBitPackingColumn {
    private static final Log LOG = Log.getLog(TestBitPackingColumn.class);

    @Test
    public void testZero() throws IOException {
        int bitLength = 0;
        int[] vals = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        String expected = "";
        this.validateEncodeDecode(bitLength, vals, expected);
    }

    @Test
    public void testOne_0() throws IOException {
        int[] vals = new int[]{0};
        String expected = "00000000";
        this.validateEncodeDecode(1, vals, expected);
    }

    @Test
    public void testOne_1() throws IOException {
        int[] vals = new int[]{1};
        String expected = "10000000";
        this.validateEncodeDecode(1, vals, expected);
    }

    @Test
    public void testOne_0_0() throws IOException {
        int[] vals = new int[]{0, 0};
        String expected = "00000000";
        this.validateEncodeDecode(1, vals, expected);
    }

    @Test
    public void testOne_1_1() throws IOException {
        int[] vals = new int[]{1, 1};
        String expected = "11000000";
        this.validateEncodeDecode(1, vals, expected);
    }

    @Test
    public void testOne_9_1s() throws IOException {
        int[] vals = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1};
        String expected = "11111111 10000000";
        this.validateEncodeDecode(1, vals, expected);
    }

    @Test
    public void testOne_9_0s() throws IOException {
        int[] vals = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        String expected = "00000000 00000000";
        this.validateEncodeDecode(1, vals, expected);
    }

    @Test
    public void testOne_7_0s_1_1() throws IOException {
        int[] vals = new int[]{0, 0, 0, 0, 0, 0, 0, 1};
        String expected = "00000001";
        this.validateEncodeDecode(1, vals, expected);
    }

    @Test
    public void testOne_9_0s_1_1() throws IOException {
        int[] vals = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        String expected = "00000000 01000000";
        this.validateEncodeDecode(1, vals, expected);
    }

    @Test
    public void testOne() throws IOException {
        int[] vals = new int[]{0, 1, 0, 0, 1, 1, 1, 0, 0, 1};
        String expected = "01001110 01000000";
        this.validateEncodeDecode(1, vals, expected);
    }

    @Test
    public void testTwo() throws IOException {
        int[] vals = new int[]{0, 1, 2, 3, 3, 3, 2, 1, 1, 0, 0, 0, 1};
        String expected = "00011011 11111001 01000000 01000000";
        this.validateEncodeDecode(2, vals, expected);
    }

    @Test
    public void testThree() throws IOException {
        int[] vals = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 1};
        String expected = "00000101 00111001 01110111 00100000";
        this.validateEncodeDecode(3, vals, expected);
    }

    @Test
    public void testFour() throws IOException {
        int[] vals = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 1};
        String expected = "00000001 00100011 01000101 01100111 10001001 10101011 11001101 11101111 00010000";
        this.validateEncodeDecode(4, vals, expected);
    }

    @Test
    public void testFive() throws IOException {
        int[] vals = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 1};
        String expected = "00000000 01000100 00110010 00010100 11000111 01000010 01010100 10110110 00110101 11001111 10000100 01100101 00111010 01010110 11010111 11000110 01110101 10111110 01110111 11011111 00001000";
        this.validateEncodeDecode(5, vals, expected);
    }

    @Test
    public void testSix() throws IOException {
        int[] vals = new int[]{0, 28, 34, 35, 63, 1};
        String expected = "00000001 11001000 10100011 11111100 00010000";
        this.validateEncodeDecode(6, vals, expected);
    }

    @Test
    public void testSeven() throws IOException {
        int[] vals = new int[]{0, 28, 34, 35, 63, 1, 125, 1, 1};
        String expected = "00000000 01110001 00010010 00110111 11100000 01111110 10000001 00000010";
        this.validateEncodeDecode(7, vals, expected);
    }

    private void validateEncodeDecode(int bitLength, int[] vals, String expected) throws IOException {
        for (PACKING_TYPE type : PACKING_TYPE.values()) {
            LOG.debug((Object)type);
            int bound = (int)Math.pow(2.0, bitLength) - 1;
            ValuesWriter w = type.getWriter(bound);
            for (int i : vals) {
                w.writeInteger(i);
            }
            byte[] bytes = w.getBytes().toByteArray();
            LOG.debug((Object)("vals (" + bitLength + "): " + TestBitPacking.toString((int[])vals)));
            LOG.debug((Object)("bytes: " + TestBitPacking.toString((byte[])bytes)));
            Assert.assertEquals((String)type.toString(), (Object)expected, (Object)TestBitPacking.toString((byte[])bytes));
            ValuesReader r = type.getReader(bound);
            r.initFromPage(vals.length, ByteBuffer.wrap(bytes), 0);
            int[] result = new int[vals.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = r.readInteger();
            }
            LOG.debug((Object)("result: " + TestBitPacking.toString((int[])result)));
            Assert.assertArrayEquals((String)((Object)((Object)type) + " result: " + TestBitPacking.toString((int[])result)), (int[])vals, (int[])result);
        }
    }

    private static enum PACKING_TYPE {
        BYTE_BASED_MANUAL{

            @Override
            public ValuesReader getReader(int bound) {
                return new BitPackingValuesReader(bound);
            }

            @Override
            public ValuesWriter getWriter(int bound) {
                return new BitPackingValuesWriter(bound, 32768, 65536, (ByteBufferAllocator)new DirectByteBufferAllocator());
            }
        }
        ,
        BYTE_BASED_GENERATED{

            @Override
            public ValuesReader getReader(int bound) {
                return new ByteBitPackingValuesReader(bound, Packer.BIG_ENDIAN);
            }

            @Override
            public ValuesWriter getWriter(int bound) {
                return new ByteBitPackingValuesWriter(bound, Packer.BIG_ENDIAN);
            }
        };


        public abstract ValuesReader getReader(int var1);

        public abstract ValuesWriter getWriter(int var1);
    }
}

