/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.deltalengthbytearray.benchmark;

import com.carrotsearch.junitbenchmarks.BenchmarkOptions;
import com.carrotsearch.junitbenchmarks.BenchmarkRule;
import com.carrotsearch.junitbenchmarks.annotation.AxisRange;
import com.carrotsearch.junitbenchmarks.annotation.BenchmarkMethodChart;
import java.io.IOException;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.DirectByteBufferAllocator;
import org.apache.parquet.column.values.Utils;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.column.values.deltalengthbytearray.DeltaLengthByteArrayValuesReader;
import org.apache.parquet.column.values.deltalengthbytearray.DeltaLengthByteArrayValuesWriter;
import org.apache.parquet.column.values.plain.BinaryPlainValuesReader;
import org.apache.parquet.column.values.plain.PlainValuesWriter;
import org.apache.parquet.io.api.Binary;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@AxisRange(min=0.0, max=1.0)
@BenchmarkMethodChart(filePrefix="benchmark-encoding-writing-random")
public class BenchmarkDeltaLengthByteArray {
    @Rule
    public TestRule benchmarkRun = new BenchmarkRule();
    String[] values = Utils.getRandomStringSamples(1000000, 32);

    @BenchmarkOptions(benchmarkRounds=20, warmupRounds=4)
    @Test
    public void benchmarkRandomStringsWithPlainValuesWriter() throws IOException {
        PlainValuesWriter writer = new PlainValuesWriter(65536, 65536, (ByteBufferAllocator)new DirectByteBufferAllocator());
        BinaryPlainValuesReader reader = new BinaryPlainValuesReader();
        Utils.writeData((ValuesWriter)writer, this.values);
        byte[] data = writer.getBytes().toByteArray();
        Binary[] bin = Utils.readData((ValuesReader)reader, data, this.values.length);
        System.out.println("size " + data.length);
    }

    @BenchmarkOptions(benchmarkRounds=20, warmupRounds=4)
    @Test
    public void benchmarkRandomStringsWithDeltaLengthByteArrayValuesWriter() throws IOException {
        DeltaLengthByteArrayValuesWriter writer = new DeltaLengthByteArrayValuesWriter(65536, 65536, (ByteBufferAllocator)new DirectByteBufferAllocator());
        DeltaLengthByteArrayValuesReader reader = new DeltaLengthByteArrayValuesReader();
        Utils.writeData((ValuesWriter)writer, this.values);
        byte[] data = writer.getBytes().toByteArray();
        Binary[] bin = Utils.readData((ValuesReader)reader, data, this.values.length);
        System.out.println("size " + data.length);
    }
}

