/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.rle;

import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.DirectByteBufferAllocator;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import org.junit.Assert;
import org.junit.Test;

public class RunLengthBitPackingHybridIntegrationTest {
    @Test
    public void integrationTest() throws Exception {
        for (int i = 0; i <= 32; ++i) {
            this.doIntegrationTest(i);
        }
    }

    private void doIntegrationTest(int bitWidth) throws Exception {
        int i;
        int i2;
        long modValue = 1L << bitWidth;
        RunLengthBitPackingHybridEncoder encoder = new RunLengthBitPackingHybridEncoder(bitWidth, 1000, 64000, (ByteBufferAllocator)new DirectByteBufferAllocator());
        int numValues = 0;
        for (i2 = 0; i2 < 100; ++i2) {
            encoder.writeInt((int)((long)i2 % modValue));
        }
        numValues += 100;
        for (i2 = 0; i2 < 100; ++i2) {
            encoder.writeInt((int)(77L % modValue));
        }
        numValues += 100;
        for (i2 = 0; i2 < 100; ++i2) {
            encoder.writeInt((int)(88L % modValue));
        }
        numValues += 100;
        for (i2 = 0; i2 < 1000; ++i2) {
            encoder.writeInt((int)((long)i2 % modValue));
            encoder.writeInt((int)((long)i2 % modValue));
            encoder.writeInt((int)((long)i2 % modValue));
        }
        numValues += 3000;
        for (i2 = 0; i2 < 1000; ++i2) {
            encoder.writeInt((int)(17L % modValue));
        }
        numValues += 1000;
        ByteBuffer encodedBytes = encoder.toBytes().toByteBuffer();
        ByteBufferInputStream in = new ByteBufferInputStream(encodedBytes);
        RunLengthBitPackingHybridDecoder decoder = new RunLengthBitPackingHybridDecoder(bitWidth, (InputStream)in);
        for (i = 0; i < 100; ++i) {
            Assert.assertEquals((long)((long)i % modValue), (long)decoder.readInt());
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertEquals((long)(77L % modValue), (long)decoder.readInt());
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertEquals((long)(88L % modValue), (long)decoder.readInt());
        }
        for (i = 0; i < 1000; ++i) {
            Assert.assertEquals((long)((long)i % modValue), (long)decoder.readInt());
            Assert.assertEquals((long)((long)i % modValue), (long)decoder.readInt());
            Assert.assertEquals((long)((long)i % modValue), (long)decoder.readInt());
        }
        for (i = 0; i < 1000; ++i) {
            Assert.assertEquals((long)(17L % modValue), (long)decoder.readInt());
        }
    }
}

