/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet;

import java.util.Arrays;
import java.util.List;
import org.apache.parquet.SemanticVersion;
import org.junit.Assert;
import org.junit.Test;

public class SemanticVersionTest {
    @Test
    public void testCompare() {
        Assert.assertTrue((new SemanticVersion(1, 8, 1).compareTo(new SemanticVersion(1, 8, 1)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((new SemanticVersion(1, 8, 0).compareTo(new SemanticVersion(1, 8, 1)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((new SemanticVersion(1, 8, 2).compareTo(new SemanticVersion(1, 8, 1)) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((new SemanticVersion(1, 8, 1).compareTo(new SemanticVersion(1, 8, 1)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((new SemanticVersion(1, 8, 0).compareTo(new SemanticVersion(1, 8, 1)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((new SemanticVersion(1, 8, 2).compareTo(new SemanticVersion(1, 8, 1)) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((new SemanticVersion(1, 7, 0).compareTo(new SemanticVersion(1, 8, 0)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((new SemanticVersion(1, 9, 0).compareTo(new SemanticVersion(1, 8, 0)) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((new SemanticVersion(0, 0, 0).compareTo(new SemanticVersion(1, 0, 0)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((new SemanticVersion(2, 0, 0).compareTo(new SemanticVersion(1, 0, 0)) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((new SemanticVersion(1, 8, 100).compareTo(new SemanticVersion(1, 9, 0)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((new SemanticVersion(1, 8, 0).compareTo(new SemanticVersion(1, 8, 0, true)) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((new SemanticVersion(1, 8, 0, true).compareTo(new SemanticVersion(1, 8, 0, true)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((new SemanticVersion(1, 8, 0, true).compareTo(new SemanticVersion(1, 8, 0)) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSemverPrereleaseExamples() throws Exception {
        List<String> examples = Arrays.asList("1.0.0-alpha", "1.0.0-alpha.1", "1.0.0-alpha.beta", "1.0.0-beta", "1.0.0-beta.2", "1.0.0-beta.11", "1.0.0-rc.1", "1.0.0");
        for (int i = 0; i < examples.size() - 1; ++i) {
            SemanticVersionTest.assertLessThan(examples.get(i), examples.get(i + 1));
            SemanticVersionTest.assertEqualTo(examples.get(i), examples.get(i));
        }
        SemanticVersionTest.assertEqualTo(examples.get(examples.size() - 1), examples.get(examples.size() - 1));
    }

    @Test
    public void testSemverBuildInfoExamples() throws Exception {
        SemanticVersionTest.assertEqualTo("1.0.0-alpha+001", "1.0.0-alpha+001");
        SemanticVersionTest.assertEqualTo("1.0.0-alpha", "1.0.0-alpha+001");
        SemanticVersionTest.assertEqualTo("1.0.0+20130313144700", "1.0.0+20130313144700");
        SemanticVersionTest.assertEqualTo("1.0.0", "1.0.0+20130313144700");
        SemanticVersionTest.assertEqualTo("1.0.0-beta+exp.sha.5114f85", "1.0.0-beta+exp.sha.5114f85");
        SemanticVersionTest.assertEqualTo("1.0.0-beta", "1.0.0-beta+exp.sha.5114f85");
    }

    @Test
    public void testUnknownComparisons() throws Exception {
        SemanticVersionTest.assertLessThan("1.0.0rc0-alpha+001", "1.0.0-alpha");
    }

    @Test
    public void testDistributionVersions() throws Exception {
        SemanticVersionTest.assertEqualTo("1.5.0-cdh5.5.0", "1.5.0-cdh5.5.0");
        SemanticVersionTest.assertLessThan("1.5.0-cdh5.5.0", "1.5.0-cdh5.5.1");
        SemanticVersionTest.assertLessThan("1.5.0-cdh5.5.0", "1.5.0-cdh5.5.1-SNAPSHOT");
        SemanticVersionTest.assertLessThan("1.5.0-cdh5.5.0", "1.5.0-cdh5.6.0");
        SemanticVersionTest.assertLessThan("1.5.0-cdh5.5.0", "1.5.0-cdh6.0.0");
        SemanticVersionTest.assertLessThan("1.5.0-cdh5.5.0", "1.5.0");
        SemanticVersionTest.assertLessThan("1.5.0-cdh5.5.0", "1.5.0-cdh5.5.0-SNAPSHOT");
    }

    @Test
    public void testParse() throws Exception {
        Assert.assertEquals((Object)new SemanticVersion(1, 8, 0), (Object)SemanticVersion.parse((String)"1.8.0"));
        Assert.assertEquals((Object)new SemanticVersion(1, 8, 0, true), (Object)SemanticVersion.parse((String)"1.8.0rc3"));
        Assert.assertEquals((Object)new SemanticVersion(1, 8, 0, "rc3", "SNAPSHOT", null), (Object)SemanticVersion.parse((String)"1.8.0rc3-SNAPSHOT"));
        Assert.assertEquals((Object)new SemanticVersion(1, 8, 0, null, "SNAPSHOT", null), (Object)SemanticVersion.parse((String)"1.8.0-SNAPSHOT"));
        Assert.assertEquals((Object)new SemanticVersion(1, 5, 0, null, "cdh5.5.0", null), (Object)SemanticVersion.parse((String)"1.5.0-cdh5.5.0"));
    }

    private static void assertLessThan(String a, String b) throws SemanticVersion.SemanticVersionParseException {
        Assert.assertTrue((String)(a + " should be < " + b), (SemanticVersion.parse((String)a).compareTo(SemanticVersion.parse((String)b)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)(b + " should be > " + a), (SemanticVersion.parse((String)b).compareTo(SemanticVersion.parse((String)a)) > 0 ? 1 : 0) != 0);
    }

    private static void assertEqualTo(String a, String b) throws SemanticVersion.SemanticVersionParseException {
        Assert.assertTrue((String)(a + " should equal " + b), (SemanticVersion.parse((String)a).compareTo(SemanticVersion.parse((String)b)) == 0 ? 1 : 0) != 0);
    }
}

