/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.parquet.io.LocalInputFile;
import org.apache.parquet.io.LocalOutputFile;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.PositionOutputStream;
import org.apache.parquet.io.SeekableInputStream;
import org.junit.Assert;
import org.junit.Test;

public class TestLocalInputOutput {
    @Test
    public void outputFileOverwritesFile() throws IOException {
        Path path = Paths.get(this.createTempFile().getPath(), new String[0]);
        LocalOutputFile write = new LocalOutputFile(path);
        try (PositionOutputStream stream = write.createOrOverwrite(512L);){
            stream.write(124);
        }
        stream = write.createOrOverwrite(512L);
        var4_4 = null;
        try {
            stream.write(124);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (var4_4 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
        LocalInputFile read = new LocalInputFile(path);
        try (SeekableInputStream stream = read.newStream();){
            Assert.assertEquals((long)stream.read(), (long)124L);
            Assert.assertEquals((long)stream.read(), (long)-1L);
        }
    }

    @Test
    public void outputFileCreateFailsAsFileAlreadyExists() throws IOException {
        Path path = Paths.get(this.createTempFile().getPath(), new String[0]);
        LocalOutputFile write = new LocalOutputFile(path);
        write.create(512L).close();
        Assert.assertThrows(FileAlreadyExistsException.class, () -> TestLocalInputOutput.lambda$outputFileCreateFailsAsFileAlreadyExists$0((OutputFile)write));
    }

    @Test
    public void outputFileCreatesFileWithOverwrite() throws IOException {
        Path path = Paths.get(this.createTempFile().getPath(), new String[0]);
        LocalOutputFile write = new LocalOutputFile(path);
        try (PositionOutputStream stream = write.createOrOverwrite(512L);){
            stream.write(255);
        }
        LocalInputFile read = new LocalInputFile(path);
        try (SeekableInputStream stream = read.newStream();){
            Assert.assertEquals((long)stream.read(), (long)255L);
            Assert.assertEquals((long)stream.read(), (long)-1L);
        }
    }

    @Test
    public void outputFileCreatesFile() throws IOException {
        Path path = Paths.get(this.createTempFile().getPath(), new String[0]);
        LocalOutputFile write = new LocalOutputFile(path);
        try (PositionOutputStream stream = write.createOrOverwrite(512L);){
            stream.write(2);
        }
        LocalInputFile read = new LocalInputFile(path);
        try (SeekableInputStream stream = read.newStream();){
            Assert.assertEquals((long)stream.read(), (long)2L);
            Assert.assertEquals((long)stream.read(), (long)-1L);
        }
    }

    private File createTempFile() throws IOException {
        File tmp = File.createTempFile(this.getClass().getSimpleName(), ".tmp");
        tmp.deleteOnExit();
        tmp.delete();
        return tmp;
    }

    private static /* synthetic */ void lambda$outputFileCreateFailsAsFileAlreadyExists$0(OutputFile write) throws Throwable {
        write.create(512L).close();
    }
}

