/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.bytes;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.MultiBufferInputStream;
import org.apache.parquet.bytes.TestByteBufferInputStreams;
import org.junit.Assert;
import org.junit.Test;

public class TestMultiBufferInputStream
extends TestByteBufferInputStreams {
    private static final List<ByteBuffer> DATA = Arrays.asList(ByteBuffer.wrap(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8}), ByteBuffer.wrap(new byte[]{9, 10, 11, 12}), ByteBuffer.wrap(new byte[0]), ByteBuffer.wrap(new byte[]{13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24}), ByteBuffer.wrap(new byte[]{25}), ByteBuffer.wrap(new byte[]{26, 27, 28, 29, 30, 31, 32}), ByteBuffer.wrap(new byte[]{33, 34}));

    @Override
    protected ByteBufferInputStream newStream() {
        return new MultiBufferInputStream(DATA);
    }

    @Override
    protected void checkOriginalData() {
        for (ByteBuffer buffer : DATA) {
            Assert.assertEquals((String)"Position should not change", (long)0L, (long)buffer.position());
            Assert.assertEquals((String)"Limit should not change", (long)buffer.array().length, (long)buffer.limit());
        }
    }

    @Test
    public void testSliceData() throws Exception {
        int i;
        ByteBufferInputStream stream = this.newStream();
        int length = stream.available();
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        while (stream.available() > 0) {
            int bytesToSlice = Math.min(stream.available(), 8);
            buffers.add(stream.slice(bytesToSlice));
        }
        Assert.assertEquals((String)"Position should be at end", (long)length, (long)stream.position());
        Assert.assertEquals((String)"Should produce 5 buffers", (long)5L, (long)buffers.size());
        ByteBuffer one = (ByteBuffer)buffers.get(0);
        Assert.assertSame((String)"Should be a duplicate of the first array", (Object)one.array(), (Object)DATA.get(0).array());
        Assert.assertEquals((long)8L, (long)one.remaining());
        Assert.assertEquals((long)0L, (long)one.position());
        Assert.assertEquals((long)8L, (long)one.limit());
        Assert.assertEquals((long)9L, (long)one.capacity());
        for (i = 0; i < 8; ++i) {
            Assert.assertEquals((String)"Should produce correct values", (long)i, (long)one.get());
        }
        ByteBuffer two = (ByteBuffer)buffers.get(1);
        Assert.assertEquals((long)8L, (long)two.remaining());
        Assert.assertEquals((long)0L, (long)two.position());
        Assert.assertEquals((long)8L, (long)two.limit());
        Assert.assertEquals((long)8L, (long)two.capacity());
        while (i < 16) {
            Assert.assertEquals((String)"Should produce correct values", (long)i, (long)two.get());
            ++i;
        }
        ByteBuffer three = (ByteBuffer)buffers.get(2);
        Assert.assertSame((String)"Should be a duplicate of the fourth array", (Object)three.array(), (Object)DATA.get(3).array());
        Assert.assertEquals((long)8L, (long)three.remaining());
        Assert.assertEquals((long)3L, (long)three.position());
        Assert.assertEquals((long)11L, (long)three.limit());
        Assert.assertEquals((long)12L, (long)three.capacity());
        while (i < 24) {
            Assert.assertEquals((String)"Should produce correct values", (long)i, (long)three.get());
            ++i;
        }
        ByteBuffer four = (ByteBuffer)buffers.get(3);
        Assert.assertEquals((long)8L, (long)four.remaining());
        Assert.assertEquals((long)0L, (long)four.position());
        Assert.assertEquals((long)8L, (long)four.limit());
        Assert.assertEquals((long)8L, (long)four.capacity());
        while (i < 32) {
            Assert.assertEquals((String)"Should produce correct values", (long)i, (long)four.get());
            ++i;
        }
        ByteBuffer five = (ByteBuffer)buffers.get(4);
        Assert.assertEquals((long)3L, (long)five.remaining());
        Assert.assertEquals((long)0L, (long)five.position());
        Assert.assertEquals((long)3L, (long)five.limit());
        Assert.assertEquals((long)3L, (long)five.capacity());
        while (i < 35) {
            Assert.assertEquals((String)"Should produce correct values", (long)i, (long)five.get());
            ++i;
        }
    }

    @Test
    public void testSliceBuffersData() throws Exception {
        ByteBufferInputStream stream = this.newStream();
        List buffers = stream.sliceBuffers((long)stream.available());
        ArrayList<ByteBuffer> nonEmptyBuffers = new ArrayList<ByteBuffer>();
        for (ByteBuffer buffer : DATA) {
            if (buffer.remaining() <= 0) continue;
            nonEmptyBuffers.add(buffer);
        }
        Assert.assertEquals((String)"Should return duplicates of all non-empty buffers", nonEmptyBuffers, (Object)buffers);
    }
}

