/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.filter2;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class IncrementallyUpdatedFilterPredicateGenerator {
    private final FileWriter writer;
    private static final TypeInfo[] TYPES = new TypeInfo[]{new TypeInfo("Integer", "int", true), new TypeInfo("Long", "long", true), new TypeInfo("Boolean", "boolean", false), new TypeInfo("Float", "float", true), new TypeInfo("Double", "double", true), new TypeInfo("Binary", "Binary", true)};

    public static void main(String[] args) throws IOException {
        File srcFile = new File(args[0] + "/org/apache/parquet/filter2/recordlevel/IncrementallyUpdatedFilterPredicateBuilder.java");
        File parent = (srcFile = srcFile.getAbsoluteFile()).getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("Couldn't mkdirs for " + parent);
        }
        new IncrementallyUpdatedFilterPredicateGenerator(srcFile).run();
    }

    public IncrementallyUpdatedFilterPredicateGenerator(File file) throws IOException {
        this.writer = new FileWriter(file);
    }

    public void run() throws IOException {
        this.add("package org.apache.parquet.filter2.recordlevel;\n\nimport java.util.List;\n\nimport org.apache.parquet.hadoop.metadata.ColumnPath;\nimport org.apache.parquet.filter2.predicate.Operators.Eq;\nimport org.apache.parquet.filter2.predicate.Operators.Gt;\nimport org.apache.parquet.filter2.predicate.Operators.GtEq;\nimport org.apache.parquet.filter2.predicate.Operators.LogicalNotUserDefined;\nimport org.apache.parquet.filter2.predicate.Operators.Lt;\nimport org.apache.parquet.filter2.predicate.Operators.LtEq;\nimport org.apache.parquet.filter2.predicate.Operators.NotEq;\nimport org.apache.parquet.filter2.predicate.Operators.UserDefined;\nimport org.apache.parquet.filter2.predicate.UserDefinedPredicate;\nimport org.apache.parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicate.ValueInspector;\nimport org.apache.parquet.io.api.Binary;\nimport org.apache.parquet.io.PrimitiveColumnIO;\nimport org.apache.parquet.schema.PrimitiveComparator;\n\n/**\n * This class is auto-generated by org.apache.parquet.filter2.IncrementallyUpdatedFilterPredicateGenerator\n * Do not manually edit!\n * See {@link IncrementallyUpdatedFilterPredicateBuilderBase}\n */\n");
        this.add("public class IncrementallyUpdatedFilterPredicateBuilder extends IncrementallyUpdatedFilterPredicateBuilderBase {\n\n");
        this.add("  public IncrementallyUpdatedFilterPredicateBuilder(List<PrimitiveColumnIO> leaves) {\n    super(leaves);\n  }\n\n");
        this.addVisitBegin("Eq");
        for (TypeInfo info : TYPES) {
            this.addEqNotEqCase(info, true);
        }
        this.addVisitEnd();
        this.addVisitBegin("NotEq");
        for (TypeInfo info : TYPES) {
            this.addEqNotEqCase(info, false);
        }
        this.addVisitEnd();
        this.addVisitBegin("Lt");
        for (TypeInfo info : TYPES) {
            this.addInequalityCase(info, "<");
        }
        this.addVisitEnd();
        this.addVisitBegin("LtEq");
        for (TypeInfo info : TYPES) {
            this.addInequalityCase(info, "<=");
        }
        this.addVisitEnd();
        this.addVisitBegin("Gt");
        for (TypeInfo info : TYPES) {
            this.addInequalityCase(info, ">");
        }
        this.addVisitEnd();
        this.addVisitBegin("GtEq");
        for (TypeInfo info : TYPES) {
            this.addInequalityCase(info, ">=");
        }
        this.addVisitEnd();
        this.add("  @Override\n  public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> IncrementallyUpdatedFilterPredicate visit(UserDefined<T, U> pred) {\n");
        this.addUdpBegin();
        for (TypeInfo info : TYPES) {
            this.addUdpCase(info, false);
        }
        this.addVisitEnd();
        this.add("  @Override\n  public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> IncrementallyUpdatedFilterPredicate visit(LogicalNotUserDefined<T, U> notPred) {\n    UserDefined<T, U> pred = notPred.getUserDefined();\n");
        this.addUdpBegin();
        for (TypeInfo info : TYPES) {
            this.addUdpCase(info, true);
        }
        this.addVisitEnd();
        this.add("}\n");
        this.writer.close();
    }

    private void addVisitBegin(String inVar) throws IOException {
        this.add("  @Override\n  public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(" + inVar + "<T> pred) {\n    ColumnPath columnPath = pred.getColumn().getColumnPath();\n    Class<T> clazz = pred.getColumn().getColumnType();\n\n    ValueInspector valueInspector = null;\n\n");
    }

    private void addVisitEnd() throws IOException {
        this.add("    if (valueInspector == null) {\n      throw new IllegalArgumentException(\"Encountered unknown type \" + clazz);\n    }\n\n    addValueInspector(columnPath, valueInspector);\n    return valueInspector;\n  }\n\n");
    }

    private void addEqNotEqCase(TypeInfo info, boolean isEq) throws IOException {
        this.add("    if (clazz.equals(" + info.className + ".class)) {\n      if (pred.getValue() == null) {\n        valueInspector = new ValueInspector() {\n          @Override\n          public void updateNull() {\n            setResult(" + isEq + ");\n          }\n\n          @Override\n          public void update(" + info.primitiveName + " value) {\n            setResult(" + !isEq + ");\n          }\n        };\n      } else {\n        final " + info.primitiveName + " target = (" + info.className + ") (Object) pred.getValue();\n        final PrimitiveComparator<" + info.className + "> comparator = getComparator(columnPath);\n\n        valueInspector = new ValueInspector() {\n          @Override\n          public void updateNull() {\n            setResult(" + !isEq + ");\n          }\n\n          @Override\n          public void update(" + info.primitiveName + " value) {\n");
        this.add("            setResult(" + this.compareEquality("value", "target", isEq) + ");\n");
        this.add("          }\n        };\n      }\n    }\n\n");
    }

    private void addInequalityCase(TypeInfo info, String op) throws IOException {
        if (!info.supportsInequality) {
            this.add("    if (clazz.equals(" + info.className + ".class)) {\n");
            this.add("      throw new IllegalArgumentException(\"Operator " + op + " not supported for " + info.className + "\");\n");
            this.add("    }\n\n");
            return;
        }
        this.add("    if (clazz.equals(" + info.className + ".class)) {\n      final " + info.primitiveName + " target = (" + info.className + ") (Object) pred.getValue();\n      final PrimitiveComparator<" + info.className + "> comparator = getComparator(columnPath);\n\n      valueInspector = new ValueInspector() {\n        @Override\n        public void updateNull() {\n          setResult(false);\n        }\n\n        @Override\n        public void update(" + info.primitiveName + " value) {\n");
        this.add("          setResult(comparator.compare(value, target) " + op + " 0);\n");
        this.add("        }\n      };\n    }\n\n");
    }

    private void addUdpBegin() throws IOException {
        this.add("    ColumnPath columnPath = pred.getColumn().getColumnPath();\n    Class<T> clazz = pred.getColumn().getColumnType();\n\n    ValueInspector valueInspector = null;\n\n    final U udp = pred.getUserDefinedPredicate();\n\n");
    }

    private void addUdpCase(TypeInfo info, boolean invert) throws IOException {
        this.add("    if (clazz.equals(" + info.className + ".class)) {\n      valueInspector = new ValueInspector() {\n        @Override\n        public void updateNull() {\n          setResult(" + (invert ? "!" : "") + "udp.keep(null));\n        }\n\n        @SuppressWarnings(\"unchecked\")\n        @Override\n        public void update(" + info.primitiveName + " value) {\n          setResult(" + (invert ? "!" : "") + "udp.keep((T) (Object) value));\n        }\n      };\n    }\n\n");
    }

    private String compareEquality(String var, String target, boolean eq) {
        return "comparator.compare(" + var + ", " + target + ")" + (eq ? " == 0 " : " != 0");
    }

    private void add(String s) throws IOException {
        this.writer.write(s);
    }

    private static class TypeInfo {
        public final String className;
        public final String primitiveName;
        public final boolean supportsInequality;

        private TypeInfo(String className, String primitiveName, boolean supportsInequality) {
            this.className = className;
            this.primitiveName = primitiveName;
            this.supportsInequality = supportsInequality;
        }
    }
}

