/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.filter2;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class IncrementallyUpdatedFilterPredicateGenerator {
    private final FileWriter writer;
    private static final TypeInfo[] TYPES = new TypeInfo[]{new TypeInfo("Integer", "int", true), new TypeInfo("Long", "long", true), new TypeInfo("Boolean", "boolean", false), new TypeInfo("Float", "float", true), new TypeInfo("Double", "double", true), new TypeInfo("Binary", "Binary", true)};

    public static void main(String[] args) throws IOException {
        File srcFile = new File(args[0] + "/org/apache/parquet/filter2/recordlevel/IncrementallyUpdatedFilterPredicateBuilder.java");
        File parent = (srcFile = srcFile.getAbsoluteFile()).getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("Couldn't mkdirs for " + parent);
        }
        new IncrementallyUpdatedFilterPredicateGenerator(srcFile).run();
    }

    public IncrementallyUpdatedFilterPredicateGenerator(File file) throws IOException {
        this.writer = new FileWriter(file);
    }

    public void run() throws IOException {
        this.add("package org.apache.parquet.filter2.recordlevel;\n\nimport java.util.Iterator;\nimport java.util.List;\nimport java.util.Set;\n\nimport org.apache.parquet.hadoop.metadata.ColumnPath;\nimport org.apache.parquet.filter2.predicate.FilterPredicate;\nimport org.apache.parquet.filter2.predicate.Operators;\nimport org.apache.parquet.filter2.predicate.Operators.Contains;\nimport org.apache.parquet.filter2.predicate.Operators.Eq;\nimport org.apache.parquet.filter2.predicate.Operators.Gt;\nimport org.apache.parquet.filter2.predicate.Operators.GtEq;\nimport org.apache.parquet.filter2.predicate.Operators.In;\nimport org.apache.parquet.filter2.predicate.Operators.LogicalNotUserDefined;\nimport org.apache.parquet.filter2.predicate.Operators.Lt;\nimport org.apache.parquet.filter2.predicate.Operators.LtEq;\nimport org.apache.parquet.filter2.predicate.Operators.NotEq;\nimport org.apache.parquet.filter2.predicate.Operators.NotIn;\nimport org.apache.parquet.filter2.predicate.Operators.UserDefined;\nimport org.apache.parquet.filter2.predicate.UserDefinedPredicate;\nimport org.apache.parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicate.ValueInspector;\nimport org.apache.parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicate.DelegatingValueInspector;\nimport org.apache.parquet.io.api.Binary;\nimport org.apache.parquet.io.PrimitiveColumnIO;\nimport org.apache.parquet.schema.PrimitiveComparator;\n\n/**\n * This class is auto-generated by org.apache.parquet.filter2.IncrementallyUpdatedFilterPredicateGenerator\n * Do not manually edit!\n * See {@link IncrementallyUpdatedFilterPredicateBuilderBase}\n */\n");
        this.add("public class IncrementallyUpdatedFilterPredicateBuilder extends IncrementallyUpdatedFilterPredicateBuilderBase {\n\n");
        this.add("  public IncrementallyUpdatedFilterPredicateBuilder(List<PrimitiveColumnIO> leaves) {\n    super(leaves);\n  }\n\n");
        this.addVisitBegin("Eq");
        for (TypeInfo info : TYPES) {
            this.addEqNotEqCase(info, true, false);
        }
        this.addVisitEnd();
        this.addVisitBegin("NotEq");
        for (TypeInfo info : TYPES) {
            this.addEqNotEqCase(info, false, false);
        }
        this.addVisitEnd();
        this.addVisitBegin("In");
        for (TypeInfo info : TYPES) {
            this.addInNotInCase(info, true, false);
        }
        this.addVisitEnd();
        this.addVisitBegin("NotIn");
        for (TypeInfo info : TYPES) {
            this.addInNotInCase(info, false, false);
        }
        this.addVisitEnd();
        this.addContainsBegin();
        this.addVisitBegin("Contains");
        this.addContainsCase();
        this.addContainsEnd();
        this.addVisitEnd();
        this.addVisitBegin("Lt");
        for (TypeInfo info : TYPES) {
            this.addInequalityCase(info, "<", false);
        }
        this.addVisitEnd();
        this.addVisitBegin("LtEq");
        for (TypeInfo info : TYPES) {
            this.addInequalityCase(info, "<=", false);
        }
        this.addVisitEnd();
        this.addVisitBegin("Gt");
        for (TypeInfo info : TYPES) {
            this.addInequalityCase(info, ">", false);
        }
        this.addVisitEnd();
        this.addVisitBegin("GtEq");
        for (TypeInfo info : TYPES) {
            this.addInequalityCase(info, ">=", false);
        }
        this.addVisitEnd();
        this.add("  @Override\n  public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> IncrementallyUpdatedFilterPredicate visit(UserDefined<T, U> pred) {\n");
        this.addUdpBegin();
        for (TypeInfo info : TYPES) {
            this.addUdpCase(info, false);
        }
        this.addVisitEnd();
        this.add("  @Override\n  public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> IncrementallyUpdatedFilterPredicate visit(LogicalNotUserDefined<T, U> notPred) {\n    UserDefined<T, U> pred = notPred.getUserDefined();\n");
        this.addUdpBegin();
        for (TypeInfo info : TYPES) {
            this.addUdpCase(info, true);
        }
        this.addVisitEnd();
        this.add("}\n");
        this.writer.close();
    }

    private void addVisitBegin(String inVar) throws IOException {
        this.add("  @Override\n  public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(" + inVar + "<T> pred) {\n    ColumnPath columnPath = pred.getColumn().getColumnPath();\n    Class<T> clazz = pred.getColumn().getColumnType();\n\n    ValueInspector valueInspector = null;\n\n");
    }

    private void addVisitEnd() throws IOException {
        this.add("    if (valueInspector == null) {\n      throw new IllegalArgumentException(\"Encountered unknown type \" + clazz);\n    }\n\n    addValueInspector(columnPath, valueInspector);\n    return valueInspector;\n  }\n\n");
    }

    private void addEqNotEqCase(TypeInfo info, boolean isEq, boolean expectMultipleResults) throws IOException {
        this.add("    if (clazz.equals(" + info.className + ".class)) {\n");
        if (!expectMultipleResults) {
            this.add("      if (pred.getValue() == null) {\n        valueInspector = new ValueInspector() {\n          @Override\n          public void updateNull() {\n            setResult(" + isEq + ");\n          }\n\n          @Override\n          public void update(" + info.primitiveName + " value) {\n            setResult(" + !isEq + ");\n          }\n        };\n      } else {\n");
        }
        this.add("        final " + info.primitiveName + " target = (" + info.className + ") (Object) pred.getValue();\n        final PrimitiveComparator<" + info.className + "> comparator = getComparator(columnPath);\n\n        valueInspector = new ValueInspector() {\n          @Override\n          public void updateNull() {\n            setResult(" + !isEq + ");\n          }\n\n          @Override\n          public void update(" + info.primitiveName + " value) {\n");
        if (!expectMultipleResults) {
            this.add("            setResult(" + this.compareEquality("value", "target", isEq) + ");\n");
        } else {
            this.add("            if (!isKnown() && " + this.compareEquality("value", "target", isEq) + ") { setResult(true); }\n");
        }
        this.add("          }\n        };\n");
        if (!expectMultipleResults) {
            this.add("      }\n");
        }
        this.add("    }\n\n");
    }

    private void addInequalityCase(TypeInfo info, String op, boolean expectMultipleResults) throws IOException {
        if (!info.supportsInequality) {
            this.add("    if (clazz.equals(" + info.className + ".class)) {\n");
            this.add("      throw new IllegalArgumentException(\"Operator " + op + " not supported for " + info.className + "\");\n");
            this.add("    }\n\n");
            return;
        }
        this.add("    if (clazz.equals(" + info.className + ".class)) {\n      final " + info.primitiveName + " target = (" + info.className + ") (Object) pred.getValue();\n      final PrimitiveComparator<" + info.className + "> comparator = getComparator(columnPath);\n\n      valueInspector = new ValueInspector() {\n        @Override\n        public void updateNull() {\n          setResult(false);\n        }\n\n        @Override\n        public void update(" + info.primitiveName + " value) {\n");
        if (!expectMultipleResults) {
            this.add("          setResult(comparator.compare(value, target) " + op + " 0);\n");
        } else {
            this.add("            if (!isKnown() && comparator.compare(value, target) " + op + " 0) { setResult(true); }\n");
        }
        this.add("        }\n      };\n    }\n\n");
    }

    private void addInNotInCase(TypeInfo info, boolean isEq, boolean expectMultipleResults) throws IOException {
        this.add("    if (clazz.equals(" + info.className + ".class)) {\n      if (pred.getValues().contains(null)) {\n        valueInspector = new ValueInspector() {\n          @Override\n          public void updateNull() {\n            setResult(" + isEq + ");\n          }\n\n          @Override\n          public void update(" + info.primitiveName + " value) {\n            setResult(" + !isEq + ");\n          }\n        };\n      } else {\n        final Set<" + info.className + "> target = (Set<" + info.className + ">) pred.getValues();\n        final PrimitiveComparator<" + info.className + "> comparator = getComparator(columnPath);\n\n        valueInspector = new ValueInspector() {\n          @Override\n          public void updateNull() {\n            setResult(" + !isEq + ");\n          }\n\n          @Override\n          public void update(" + info.primitiveName + " value) {\n");
        if (expectMultipleResults) {
            this.add("            if (isKnown()) return;\n");
        }
        this.add("            for (" + info.primitiveName + " i : target) {\n");
        this.add("              if(" + this.compareEquality("value", "i", isEq) + ") {\n");
        this.add("                 setResult(true);\n                 return;\n");
        this.add("               }\n");
        this.add("             }\n");
        if (!expectMultipleResults) {
            this.add("             setResult(false);\n");
        }
        this.add("           }\n");
        this.add("         };\n       }\n    }\n\n");
    }

    private void addUdpBegin() throws IOException {
        this.add("    ColumnPath columnPath = pred.getColumn().getColumnPath();\n    Class<T> clazz = pred.getColumn().getColumnType();\n\n    ValueInspector valueInspector = null;\n\n    final U udp = pred.getUserDefinedPredicate();\n\n");
    }

    private void addContainsInspectorVisitor(String op) throws IOException {
        this.add("    @Override\n    public <T extends Comparable<T>> ContainsPredicate visit(" + op + "<T> pred) {\n      ColumnPath columnPath = pred.getColumn().getColumnPath();\n      Class<T> clazz = pred.getColumn().getColumnType();\n      ValueInspector valueInspector = null;\n");
        block20: for (TypeInfo info : TYPES) {
            switch (op) {
                case "Eq": {
                    this.addEqNotEqCase(info, true, true);
                    continue block20;
                }
                case "NotEq": {
                    this.addEqNotEqCase(info, false, true);
                    continue block20;
                }
                case "Lt": {
                    this.addInequalityCase(info, "<", true);
                    continue block20;
                }
                case "LtEq": {
                    this.addInequalityCase(info, "<=", true);
                    continue block20;
                }
                case "Gt": {
                    this.addInequalityCase(info, ">", true);
                    continue block20;
                }
                case "GtEq": {
                    this.addInequalityCase(info, ">=", true);
                    continue block20;
                }
                case "In": {
                    this.addInNotInCase(info, true, true);
                    continue block20;
                }
                case "NotIn": {
                    this.addInNotInCase(info, false, true);
                    continue block20;
                }
                default: {
                    throw new UnsupportedOperationException("Op " + op + " not implemented for Contains filter");
                }
            }
        }
        this.add("      return new ContainsSinglePredicate(valueInspector, false);\n    }\n");
    }

    private void addContainsBegin() throws IOException {
        this.add("  private abstract static class ContainsPredicate extends DelegatingValueInspector {\n    ContainsPredicate(ValueInspector... delegates) {\n      super(delegates);\n    }\n\n    abstract ContainsPredicate not();\n  }\n\n  private static class ContainsSinglePredicate extends ContainsPredicate {\n    private final boolean isNot;\n \n    private ContainsSinglePredicate(ValueInspector inspector, boolean isNot) {\n      super(inspector);\n      this.isNot = isNot;\n    }\n\n    @Override\n    ContainsPredicate not() {\n      return new ContainsSinglePredicate(getDelegates().iterator().next(), true);\n    }\n\n    @Override\n    void onUpdate() {\n      if (isKnown()) {\n        return;\n      }\n\n      for (ValueInspector inspector : getDelegates()) {\n        if (inspector.isKnown() && inspector.getResult()) {\n          setResult(!isNot);\n          return;\n        }\n      }\n    }\n\n    @Override\n    void onNull() {\n      setResult(isNot);\n    }\n  }\n\n");
        this.add("  private static class ContainsAndPredicate extends ContainsPredicate {\n    private ContainsAndPredicate(ContainsPredicate left, ContainsPredicate right) {\n      super(left, right);\n    }\n\n    @Override\n    void onUpdate() {\n      if (isKnown()) { return; }\n\n      boolean allKnown = true;\n      for (ValueInspector delegate : getDelegates()) {\n        if (delegate.isKnown() && !delegate.getResult()) {\n          setResult(false);\n          return;\n        }\n        allKnown = allKnown && delegate.isKnown();\n      }\n      \n      if (allKnown) {\n        setResult(true);\n      }\n    }\n\n    @Override\n    void onNull() {\n      for (ValueInspector delegate : getDelegates()) {\n        if (!delegate.getResult()) {\n          setResult(false);\n          return;\n        }\n      }\n      setResult(true);\n    }\n\n    @Override\n    ContainsPredicate not() {\n      Iterator<ValueInspector> it = getDelegates().iterator();\n      return new ContainsAndPredicate(((ContainsPredicate) it.next()).not(), ((ContainsPredicate) it.next()).not());\n    }\n  }\n\n");
        this.add("  private static class ContainsOrPredicate extends ContainsPredicate {\n    private ContainsOrPredicate(ContainsPredicate left, ContainsPredicate right) {\n      super(left, right);\n    }\n\n    @Override\n    void onUpdate() {\n      if (isKnown()) { return; }\n\n      for (ValueInspector delegate : getDelegates()) {\n        if (delegate.isKnown() && delegate.getResult()) {\n          setResult(true);\n        }\n      }\n    }\n\n    @Override\n    void onNull() {\n      for (ValueInspector delegate : getDelegates()) {\n        if (delegate.getResult()) {\n          setResult(true);\n          return;\n        }\n      }\n      setResult(false);\n    }\n\n    @Override\n    ContainsPredicate not() {\n      Iterator<ValueInspector> it = getDelegates().iterator();\n      return new ContainsOrPredicate(((ContainsPredicate) it.next()).not(), ((ContainsPredicate) it.next()).not());\n    }\n  }\n\n");
        this.add("  private class ContainsInspectorVisitor implements FilterPredicate.Visitor<ContainsPredicate> {\n\n    @Override\n    public <T extends Comparable<T>> ContainsPredicate visit(Contains<T> contains) {\n      return contains.filter(this, ContainsAndPredicate::new, ContainsOrPredicate::new, ContainsPredicate::not);\n    }\n");
        this.addContainsInspectorVisitor("Eq");
        this.addContainsInspectorVisitor("NotEq");
        this.addContainsInspectorVisitor("Lt");
        this.addContainsInspectorVisitor("LtEq");
        this.addContainsInspectorVisitor("Gt");
        this.addContainsInspectorVisitor("GtEq");
        this.addContainsInspectorVisitor("In");
        this.addContainsInspectorVisitor("NotIn");
        this.add("    @Override\n    public ContainsPredicate visit(Operators.And pred) {\n      throw new UnsupportedOperationException(\"Operators.And not supported for Contains predicate\");\n    }\n\n    @Override\n    public ContainsPredicate visit(Operators.Or pred) {\n      throw new UnsupportedOperationException(\"Operators.Or not supported for Contains predicate\");\n    }\n\n    @Override\n    public ContainsPredicate visit(Operators.Not pred) {\n      throw new UnsupportedOperationException(\"Operators.Not not supported for Contains predicate\");\n    }    @Override\n    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> ContainsPredicate visit(\n        UserDefined<T, U> pred) {\n      throw new UnsupportedOperationException(\"UserDefinedPredicate not supported for Contains predicate\");\n    }\n\n    @Override\n    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> ContainsPredicate visit(\n        LogicalNotUserDefined<T, U> pred) {\n      throw new UnsupportedOperationException(\"LogicalNotUserDefined not supported for Contains predicate\");\n    }\n  }\n\n");
    }

    private void addContainsCase() throws IOException {
        this.add("    valueInspector = new ContainsInspectorVisitor().visit(pred);\n");
    }

    private void addContainsEnd() {
    }

    private void addUdpCase(TypeInfo info, boolean invert) throws IOException {
        this.add("    if (clazz.equals(" + info.className + ".class)) {\n      valueInspector = new ValueInspector() {\n        @Override\n        public void updateNull() {\n          setResult(" + (invert ? "!" : "") + "udp.acceptsNullValue());\n        }\n\n        @SuppressWarnings(\"unchecked\")\n        @Override\n        public void update(" + info.primitiveName + " value) {\n          setResult(" + (invert ? "!" : "") + "udp.keep((T) (Object) value));\n        }\n      };\n    }\n\n");
    }

    private String compareEquality(String var, String target, boolean eq) {
        return "comparator.compare(" + var + ", " + target + ")" + (eq ? " == 0 " : " != 0");
    }

    private void add(String s) throws IOException {
        this.writer.write(s);
    }

    private static class TypeInfo {
        public final String className;
        public final String primitiveName;
        public final boolean supportsInequality;

        private TypeInfo(String className, String primitiveName, boolean supportsInequality) {
            this.className = className;
            this.primitiveName = primitiveName;
            this.supportsInequality = supportsInequality;
        }
    }
}

