/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.rewrite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.Preconditions;
import org.apache.parquet.conf.HadoopParquetConfiguration;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.crypto.FileEncryptionProperties;
import org.apache.parquet.hadoop.IndexCache;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.rewrite.MaskMode;
import org.apache.parquet.hadoop.util.ConfigurationUtil;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.hadoop.util.HadoopOutputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.OutputFile;

public class RewriteOptions {
    private final ParquetConfiguration conf;
    private final List<InputFile> inputFiles;
    private final OutputFile outputFile;
    private final List<String> pruneColumns;
    private final CompressionCodecName newCodecName;
    private final Map<String, MaskMode> maskColumns;
    private final List<String> encryptColumns;
    private final FileEncryptionProperties fileEncryptionProperties;
    private final IndexCache.CacheStrategy indexCacheStrategy;

    private RewriteOptions(ParquetConfiguration conf, List<InputFile> inputFiles, OutputFile outputFile, List<String> pruneColumns, CompressionCodecName newCodecName, Map<String, MaskMode> maskColumns, List<String> encryptColumns, FileEncryptionProperties fileEncryptionProperties, IndexCache.CacheStrategy indexCacheStrategy) {
        this.conf = conf;
        this.inputFiles = inputFiles;
        this.outputFile = outputFile;
        this.pruneColumns = pruneColumns;
        this.newCodecName = newCodecName;
        this.maskColumns = maskColumns;
        this.encryptColumns = encryptColumns;
        this.fileEncryptionProperties = fileEncryptionProperties;
        this.indexCacheStrategy = indexCacheStrategy;
    }

    public Configuration getConf() {
        return ConfigurationUtil.createHadoopConfiguration(this.conf);
    }

    public ParquetConfiguration getParquetConfiguration() {
        return this.conf;
    }

    public List<Path> getInputFiles() {
        return this.inputFiles.stream().map(f -> {
            if (f instanceof HadoopOutputFile) {
                HadoopOutputFile hadoopOutputFile = (HadoopOutputFile)((Object)f);
                return new Path(hadoopOutputFile.getPath());
            }
            throw new RuntimeException("The input files do not all have an associated Hadoop Path.");
        }).collect(Collectors.toList());
    }

    public List<InputFile> getParquetInputFiles() {
        return this.inputFiles;
    }

    public Path getOutputFile() {
        if (this.outputFile instanceof HadoopOutputFile) {
            HadoopOutputFile hadoopOutputFile = (HadoopOutputFile)this.outputFile;
            return new Path(hadoopOutputFile.getPath());
        }
        throw new RuntimeException("The output file does not have an associated Hadoop Path.");
    }

    public OutputFile getParquetOutputFile() {
        return this.outputFile;
    }

    public List<String> getPruneColumns() {
        return this.pruneColumns;
    }

    public CompressionCodecName getNewCodecName() {
        return this.newCodecName;
    }

    public Map<String, MaskMode> getMaskColumns() {
        return this.maskColumns;
    }

    public List<String> getEncryptColumns() {
        return this.encryptColumns;
    }

    public FileEncryptionProperties getFileEncryptionProperties() {
        return this.fileEncryptionProperties;
    }

    public IndexCache.CacheStrategy getIndexCacheStrategy() {
        return this.indexCacheStrategy;
    }

    public static class Builder {
        private final ParquetConfiguration conf;
        private final List<InputFile> inputFiles;
        private final OutputFile outputFile;
        private List<String> pruneColumns;
        private CompressionCodecName newCodecName;
        private Map<String, MaskMode> maskColumns;
        private List<String> encryptColumns;
        private FileEncryptionProperties fileEncryptionProperties;
        private IndexCache.CacheStrategy indexCacheStrategy = IndexCache.CacheStrategy.NONE;

        public Builder(Configuration conf, Path inputFile, Path outputFile) {
            this((ParquetConfiguration)new HadoopParquetConfiguration(conf), HadoopInputFile.fromPathUnchecked(inputFile, conf), (OutputFile)HadoopOutputFile.fromPathUnchecked(outputFile, conf));
        }

        public Builder(ParquetConfiguration conf, InputFile inputFile, OutputFile outputFile) {
            this(conf, Collections.singletonList(inputFile), outputFile);
        }

        public Builder(Configuration conf, List<Path> inputFiles, Path outputFile) {
            this.conf = new HadoopParquetConfiguration(conf);
            this.inputFiles = new ArrayList<InputFile>(inputFiles.size());
            for (Path inputFile : inputFiles) {
                this.inputFiles.add(HadoopInputFile.fromPathUnchecked(inputFile, conf));
            }
            this.outputFile = HadoopOutputFile.fromPathUnchecked(outputFile, conf);
        }

        public Builder(ParquetConfiguration conf, List<InputFile> inputFiles, OutputFile outputFile) {
            this.conf = conf;
            this.inputFiles = inputFiles;
            this.outputFile = outputFile;
        }

        public Builder prune(List<String> columns) {
            this.pruneColumns = columns;
            return this;
        }

        public Builder transform(CompressionCodecName newCodecName) {
            this.newCodecName = newCodecName;
            return this;
        }

        public Builder mask(Map<String, MaskMode> maskColumns) {
            this.maskColumns = maskColumns;
            return this;
        }

        public Builder encrypt(List<String> encryptColumns) {
            this.encryptColumns = encryptColumns;
            return this;
        }

        public Builder encryptionProperties(FileEncryptionProperties fileEncryptionProperties) {
            this.fileEncryptionProperties = fileEncryptionProperties;
            return this;
        }

        public Builder addInputFile(Path path) {
            this.inputFiles.add(HadoopInputFile.fromPathUnchecked(path, ConfigurationUtil.createHadoopConfiguration(this.conf)));
            return this;
        }

        public Builder addInputFile(InputFile inputFile) {
            this.inputFiles.add(inputFile);
            return this;
        }

        public Builder indexCacheStrategy(IndexCache.CacheStrategy cacheStrategy) {
            this.indexCacheStrategy = cacheStrategy;
            return this;
        }

        public RewriteOptions build() {
            Preconditions.checkArgument(this.inputFiles != null && !this.inputFiles.isEmpty(), "Input file is required");
            Preconditions.checkArgument(this.outputFile != null, "Output file is required");
            if (this.pruneColumns != null) {
                if (this.maskColumns != null) {
                    for (String pruneColumn : this.pruneColumns) {
                        Preconditions.checkArgument(!this.maskColumns.containsKey(pruneColumn), "Cannot prune and mask same column");
                    }
                }
                if (this.encryptColumns != null) {
                    for (String pruneColumn : this.pruneColumns) {
                        Preconditions.checkArgument(!this.encryptColumns.contains(pruneColumn), "Cannot prune and encrypt same column");
                    }
                }
            }
            if (this.encryptColumns != null && !this.encryptColumns.isEmpty()) {
                Preconditions.checkArgument(this.fileEncryptionProperties != null, "FileEncryptionProperties is required when encrypting columns");
            }
            if (this.fileEncryptionProperties != null) {
                Preconditions.checkArgument(this.encryptColumns != null && !this.encryptColumns.isEmpty(), "Encrypt columns is required when FileEncryptionProperties is set");
            }
            return new RewriteOptions(this.conf, this.inputFiles, this.outputFile, this.pruneColumns, this.newCodecName, this.maskColumns, this.encryptColumns, this.fileEncryptionProperties, this.indexCacheStrategy);
        }
    }
}

