/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.dictionary;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryValuesReader
extends ValuesReader {
    private static final Logger LOG = LoggerFactory.getLogger(DictionaryValuesReader.class);
    private ByteArrayInputStream in;
    private Dictionary dictionary;
    private RunLengthBitPackingHybridDecoder decoder;

    public DictionaryValuesReader(Dictionary dictionary) {
        this.dictionary = dictionary;
    }

    @Override
    public void initFromPage(int valueCount, byte[] page, int offset) throws IOException {
        this.in = new ByteArrayInputStream(page, offset, page.length - offset);
        if (page.length - offset > 0) {
            LOG.debug("init from page at offset {} for length {}", (Object)offset, (Object)(page.length - offset));
            int bitWidth = BytesUtils.readIntLittleEndianOnOneByte(this.in);
            LOG.debug("bit width {}", (Object)bitWidth);
            this.decoder = new RunLengthBitPackingHybridDecoder(bitWidth, this.in);
        } else {
            this.decoder = new RunLengthBitPackingHybridDecoder(1, this.in){

                @Override
                public int readInt() throws IOException {
                    throw new IOException("Attempt to read from empty page");
                }
            };
        }
    }

    @Override
    public int readValueDictionaryId() {
        try {
            return this.decoder.readInt();
        }
        catch (IOException e) {
            throw new ParquetDecodingException(e);
        }
    }

    @Override
    public Binary readBytes() {
        try {
            return this.dictionary.decodeToBinary(this.decoder.readInt());
        }
        catch (IOException e) {
            throw new ParquetDecodingException(e);
        }
    }

    @Override
    public float readFloat() {
        try {
            return this.dictionary.decodeToFloat(this.decoder.readInt());
        }
        catch (IOException e) {
            throw new ParquetDecodingException(e);
        }
    }

    @Override
    public double readDouble() {
        try {
            return this.dictionary.decodeToDouble(this.decoder.readInt());
        }
        catch (IOException e) {
            throw new ParquetDecodingException(e);
        }
    }

    @Override
    public int readInteger() {
        try {
            return this.dictionary.decodeToInt(this.decoder.readInt());
        }
        catch (IOException e) {
            throw new ParquetDecodingException(e);
        }
    }

    @Override
    public long readLong() {
        try {
            return this.dictionary.decodeToLong(this.decoder.readInt());
        }
        catch (IOException e) {
            throw new ParquetDecodingException(e);
        }
    }

    @Override
    public void skip() {
        try {
            this.decoder.readInt();
        }
        catch (IOException e) {
            throw new ParquetDecodingException(e);
        }
    }
}

