/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.util;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.parquet.io.SeekableInputStream;

class H2SeekableInputStream
extends SeekableInputStream {
    private final FSDataInputStream stream;
    private final Reader reader;

    public H2SeekableInputStream(FSDataInputStream stream) {
        this.stream = stream;
        this.reader = new H2Reader();
    }

    @Override
    public long getPos() throws IOException {
        return this.stream.getPos();
    }

    @Override
    public void seek(long newPos) throws IOException {
        this.stream.seek(newPos);
    }

    @Override
    public int read() throws IOException {
        return this.stream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.stream.read(b, off, len);
    }

    @Override
    public void readFully(byte[] bytes) throws IOException {
        this.stream.readFully(bytes, 0, bytes.length);
    }

    @Override
    public void readFully(byte[] bytes, int start, int len) throws IOException {
        this.stream.readFully(bytes);
    }

    @Override
    public int read(ByteBuffer buf) throws IOException {
        return this.stream.read(buf);
    }

    @Override
    public void readFully(ByteBuffer buf) throws IOException {
        H2SeekableInputStream.readFully(this.reader, buf);
    }

    public static void readFully(Reader reader, ByteBuffer buf) throws IOException {
        while (buf.hasRemaining()) {
            int readCount = reader.read(buf);
            if (readCount != -1) continue;
            throw new EOFException("Reached the end of stream. Still have: " + buf.remaining() + " bytes left");
        }
    }

    private class H2Reader
    implements Reader {
        private H2Reader() {
        }

        @Override
        public int read(ByteBuffer buf) throws IOException {
            return H2SeekableInputStream.this.stream.read(buf);
        }
    }

    static interface Reader {
        public int read(ByteBuffer var1) throws IOException;
    }
}

