/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.HeapByteBufferAllocator;
import org.apache.parquet.bytes.LittleEndianDataInputStream;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.column.page.PageWriter;
import org.apache.parquet.column.statistics.BinaryStatistics;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.ColumnChunkPageWriteStore;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestColumnChunkPageWriteStore {
    private int pageSize = 1024;
    private int initialSize = 1024;
    private Configuration conf;

    @Before
    public void initConfiguration() {
        this.conf = new Configuration();
    }

    @Test
    public void test() throws Exception {
        Path file = new Path("target/test/TestColumnChunkPageWriteStore/test.parquet");
        Path root = file.getParent();
        FileSystem fs = file.getFileSystem(this.conf);
        if (fs.exists(root)) {
            fs.delete(root, true);
        }
        fs.mkdirs(root);
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { repeated binary bar; }");
        ColumnDescriptor col = (ColumnDescriptor)schema.getColumns().get(0);
        Encoding dataEncoding = Encoding.PLAIN;
        int valueCount = 10;
        int d = 1;
        int r = 2;
        int v = 3;
        BytesInput definitionLevels = BytesInput.fromInt((int)d);
        BytesInput repetitionLevels = BytesInput.fromInt((int)r);
        Statistics statistics = Statistics.getBuilderForReading((PrimitiveType)((PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("test_binary"))).build();
        BytesInput data = BytesInput.fromInt((int)v);
        int rowCount = 5;
        int nullCount = 1;
        ParquetFileWriter writer = new ParquetFileWriter(this.conf, schema, file);
        writer.start();
        writer.startBlock((long)rowCount);
        ColumnChunkPageWriteStore store = new ColumnChunkPageWriteStore(this.compressor(CompressionCodecName.GZIP), schema, (ByteBufferAllocator)new HeapByteBufferAllocator());
        PageWriter pageWriter = store.getPageWriter(col);
        pageWriter.writePageV2(rowCount, nullCount, valueCount, repetitionLevels, definitionLevels, dataEncoding, data, statistics);
        store.flushToFileWriter(writer);
        writer.endBlock();
        writer.end(new HashMap());
        ParquetMetadata footer = ParquetFileReader.readFooter((Configuration)this.conf, (Path)file, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        ParquetFileReader reader = new ParquetFileReader(this.conf, footer.getFileMetaData(), file, footer.getBlocks(), schema.getColumns());
        PageReadStore rowGroup = reader.readNextRowGroup();
        PageReader pageReader = rowGroup.getPageReader(col);
        DataPageV2 page = (DataPageV2)pageReader.readPage();
        Assert.assertEquals((long)rowCount, (long)page.getRowCount());
        Assert.assertEquals((long)nullCount, (long)page.getNullCount());
        Assert.assertEquals((long)valueCount, (long)page.getValueCount());
        Assert.assertEquals((long)d, (long)this.intValue(page.getDefinitionLevels()));
        Assert.assertEquals((long)r, (long)this.intValue(page.getRepetitionLevels()));
        Assert.assertEquals((Object)dataEncoding, (Object)page.getDataEncoding());
        Assert.assertEquals((long)v, (long)this.intValue(page.getData()));
        Assert.assertEquals((Object)statistics.toString(), (Object)page.getStatistics().toString());
        reader.close();
    }

    private int intValue(BytesInput in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        in.writeAllTo((OutputStream)baos);
        LittleEndianDataInputStream os = new LittleEndianDataInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        int i = os.readInt();
        os.close();
        return i;
    }

    @Test
    public void testColumnOrderV1() throws IOException {
        ParquetFileWriter mockFileWriter = (ParquetFileWriter)Mockito.mock(ParquetFileWriter.class);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockFileWriter});
        MessageType schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("a_string")).required(PrimitiveType.PrimitiveTypeName.INT32).named("an_int")).required(PrimitiveType.PrimitiveTypeName.INT64).named("a_long")).required(PrimitiveType.PrimitiveTypeName.FLOAT).named("a_float")).required(PrimitiveType.PrimitiveTypeName.DOUBLE).named("a_double")).named("order_test");
        BytesInput fakeData = BytesInput.fromInt((int)34);
        int fakeCount = 3;
        BinaryStatistics fakeStats = new BinaryStatistics();
        ColumnChunkPageWriteStore store = new ColumnChunkPageWriteStore(this.compressor(CompressionCodecName.UNCOMPRESSED), schema, (ByteBufferAllocator)new HeapByteBufferAllocator());
        for (ColumnDescriptor col : schema.getColumns()) {
            PageWriter pageWriter = store.getPageWriter(col);
            pageWriter.writePage(fakeData, fakeCount, (Statistics)fakeStats, Encoding.RLE, Encoding.RLE, Encoding.PLAIN);
        }
        store.flushToFileWriter(mockFileWriter);
        for (ColumnDescriptor col : schema.getColumns()) {
            ((ParquetFileWriter)inOrder.verify((Object)mockFileWriter)).startColumn((ColumnDescriptor)Matchers.eq((Object)col), Matchers.eq((long)fakeCount), (CompressionCodecName)Matchers.eq((Object)CompressionCodecName.UNCOMPRESSED));
        }
    }

    private CodecFactory.BytesCompressor compressor(CompressionCodecName codec) {
        return new CodecFactory(this.conf, this.pageSize).getCompressor(codec);
    }
}

