/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ColumnReader;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.statistics.BinaryStatistics;
import org.apache.parquet.column.statistics.IntStatistics;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.filter.RecordFilter;
import org.apache.parquet.filter.UnboundRecordFilter;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.hadoop.ClientSideMetadataSplitStrategy;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.PrimitiveType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestInputFormat {
    List<BlockMetaData> blocks;
    BlockLocation[] hdfsBlocks;
    FileStatus fileStatus;
    MessageType schema;
    FileMetaData fileMetaData;
    private static final Map<String, String> extramd;

    @Before
    public void setUp() {
        this.blocks = new ArrayList<BlockMetaData>();
        for (int i = 0; i < 10; ++i) {
            this.blocks.add(this.newBlock(i * 10, 10L));
        }
        this.schema = MessageTypeParser.parseMessageType((String)"message doc { required binary foo; }");
        this.fileMetaData = new FileMetaData(this.schema, new HashMap(), "parquet-mr");
    }

    @Test
    public void testThrowExceptionWhenMaxSplitSizeIsSmallerThanMinSplitSize() throws IOException {
        try {
            this.generateSplitByMinMaxSize(50L, 49L);
            Assert.fail((String)"should throw exception when max split size is smaller than the min split size");
        }
        catch (ParquetDecodingException e) {
            Assert.assertEquals((Object)"maxSplitSize and minSplitSize should be positive and max should be greater or equal to the minSplitSize: maxSplitSize = 49; minSplitSize is 50", (Object)e.getMessage());
        }
    }

    @Test
    public void testThrowExceptionWhenMaxSplitSizeIsNegative() throws IOException {
        try {
            this.generateSplitByMinMaxSize(-100L, -50L);
            Assert.fail((String)"should throw exception when max split size is negative");
        }
        catch (ParquetDecodingException e) {
            Assert.assertEquals((Object)"maxSplitSize and minSplitSize should be positive and max should be greater or equal to the minSplitSize: maxSplitSize = -50; minSplitSize is -100", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetFilter() throws IOException {
        Operators.IntColumn intColumn = FilterApi.intColumn((String)"foo");
        FilterPredicate p = FilterApi.or((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(7)), (FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(12)));
        Configuration conf = new Configuration();
        ParquetInputFormat.setFilterPredicate((Configuration)conf, (FilterPredicate)p);
        FilterCompat.Filter read = ParquetInputFormat.getFilter((Configuration)conf);
        Assert.assertTrue((boolean)(read instanceof FilterCompat.FilterPredicateCompat));
        Assert.assertEquals((Object)p, (Object)((FilterCompat.FilterPredicateCompat)read).getFilterPredicate());
        conf = new Configuration();
        ParquetInputFormat.setFilterPredicate((Configuration)conf, (FilterPredicate)FilterApi.not((FilterPredicate)p));
        read = ParquetInputFormat.getFilter((Configuration)conf);
        Assert.assertTrue((boolean)(read instanceof FilterCompat.FilterPredicateCompat));
        Assert.assertEquals((Object)FilterApi.and((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(7)), (FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(12))), (Object)((FilterCompat.FilterPredicateCompat)read).getFilterPredicate());
        Assert.assertEquals((Object)FilterCompat.NOOP, (Object)ParquetInputFormat.getFilter((Configuration)new Configuration()));
    }

    @Test
    public void testGenerateSplitsAlignedWithHDFSBlock() throws IOException {
        this.withHDFSBlockSize(50L, 50L);
        List<ParquetInputSplit> splits = this.generateSplitByMinMaxSize(50L, 50L);
        this.shouldSplitBlockSizeBe(splits, 5, 5);
        this.shouldSplitLocationBe(splits, 0, 1);
        this.shouldSplitLengthBe(splits, 50, 50);
        splits = this.generateSplitByMinMaxSize(0L, Long.MAX_VALUE);
        this.shouldSplitBlockSizeBe(splits, 5, 5);
        this.shouldSplitLocationBe(splits, 0, 1);
        this.shouldSplitLengthBe(splits, 50, 50);
    }

    @Test
    public void testRowGroupNotAlignToHDFSBlock() throws IOException {
        this.withHDFSBlockSize(51L, 51L);
        List<ParquetInputSplit> splits = this.generateSplitByMinMaxSize(50L, 50L);
        this.shouldSplitBlockSizeBe(splits, 5, 5);
        this.shouldSplitLocationBe(splits, 0, 0);
        this.shouldSplitLengthBe(splits, 50, 50);
        this.withHDFSBlockSize(49L, 49L);
        splits = this.generateSplitByMinMaxSize(50L, 50L);
        this.shouldSplitBlockSizeBe(splits, 5, 5);
        this.shouldSplitLocationBe(splits, 0, 1);
        this.shouldSplitLengthBe(splits, 50, 50);
        this.withHDFSBlockSize(44L, 44L, 44L);
        splits = this.generateSplitByMinMaxSize(40L, 50L);
        this.shouldSplitBlockSizeBe(splits, 4, 5, 1);
        this.shouldSplitLocationBe(splits, 0, 0, 2);
        this.shouldSplitLengthBe(splits, 40, 50, 10);
    }

    @Test
    public void testGenerateSplitsNotAlignedWithHDFSBlock() throws IOException, InterruptedException {
        this.withHDFSBlockSize(50L, 50L);
        List<ParquetInputSplit> splits = this.generateSplitByMinMaxSize(55L, 56L);
        this.shouldSplitBlockSizeBe(splits, 6, 4);
        this.shouldSplitLocationBe(splits, 0, 1);
        this.shouldSplitLengthBe(splits, 60, 40);
        this.withHDFSBlockSize(51L, 51L);
        splits = this.generateSplitByMinMaxSize(55L, 56L);
        this.shouldSplitBlockSizeBe(splits, 6, 4);
        this.shouldSplitLocationBe(splits, 0, 1);
        this.shouldSplitLengthBe(splits, 60, 40);
        this.withHDFSBlockSize(49L, 49L, 49L);
        splits = this.generateSplitByMinMaxSize(55L, 56L);
        this.shouldSplitBlockSizeBe(splits, 6, 4);
        this.shouldSplitLocationBe(splits, 0, 1);
        this.shouldSplitLengthBe(splits, 60, 40);
    }

    @Test
    public void testGenerateSplitsSmallerThanMaxSizeAndAlignToHDFS() throws Exception {
        this.withHDFSBlockSize(50L, 50L);
        List<ParquetInputSplit> splits = this.generateSplitByMinMaxSize(18L, 30L);
        this.shouldSplitBlockSizeBe(splits, 3, 2, 3, 2);
        this.shouldSplitLocationBe(splits, 0, 0, 1, 1);
        this.shouldSplitLengthBe(splits, 30, 20, 30, 20);
        this.withHDFSBlockSize(51L, 51L);
        splits = this.generateSplitByMinMaxSize(18L, 30L);
        this.shouldSplitBlockSizeBe(splits, 3, 2, 3, 2);
        this.shouldSplitLocationBe(splits, 0, 0, 0, 1);
        this.shouldSplitLengthBe(splits, 30, 20, 30, 20);
        this.withHDFSBlockSize(49L, 49L, 49L);
        splits = this.generateSplitByMinMaxSize(18L, 30L);
        this.shouldSplitBlockSizeBe(splits, 3, 2, 3, 2);
        this.shouldSplitLocationBe(splits, 0, 0, 1, 1);
        this.shouldSplitLengthBe(splits, 30, 20, 30, 20);
    }

    @Test
    public void testGenerateSplitsCrossHDFSBlockBoundaryToSatisfyMinSize() throws Exception {
        this.withHDFSBlockSize(50L, 50L);
        List<ParquetInputSplit> splits = this.generateSplitByMinMaxSize(25L, 30L);
        this.shouldSplitBlockSizeBe(splits, 3, 3, 3, 1);
        this.shouldSplitLocationBe(splits, 0, 0, 1, 1);
        this.shouldSplitLengthBe(splits, 30, 30, 30, 10);
    }

    @Test
    public void testMultipleRowGroupsInABlockToAlignHDFSBlock() throws Exception {
        this.withHDFSBlockSize(50L, 50L);
        List<ParquetInputSplit> splits = this.generateSplitByMinMaxSize(10L, 18L);
        this.shouldSplitBlockSizeBe(splits, 2, 2, 1, 2, 2, 1);
        this.shouldSplitLocationBe(splits, 0, 0, 0, 1, 1, 1);
        this.shouldSplitLengthBe(splits, 20, 20, 10, 20, 20, 10);
        this.withHDFSBlockSize(51L, 51L);
        splits = this.generateSplitByMinMaxSize(10L, 18L);
        this.shouldSplitBlockSizeBe(splits, 2, 2, 1, 2, 2, 1);
        this.shouldSplitLocationBe(splits, 0, 0, 0, 0, 1, 1);
        this.shouldSplitLengthBe(splits, 20, 20, 10, 20, 20, 10);
        this.withHDFSBlockSize(49L, 49L);
        splits = this.generateSplitByMinMaxSize(10L, 18L);
        this.shouldSplitBlockSizeBe(splits, 2, 2, 1, 2, 2, 1);
        this.shouldSplitLocationBe(splits, 0, 0, 0, 1, 1, 1);
        this.shouldSplitLengthBe(splits, 20, 20, 10, 20, 20, 10);
    }

    @Test
    public void testOnlyOneKindOfFilterSupported() throws Exception {
        Operators.IntColumn foo = FilterApi.intColumn((String)"foo");
        FilterPredicate p = FilterApi.or((FilterPredicate)FilterApi.eq((Operators.Column)foo, (Comparable)Integer.valueOf(10)), (FilterPredicate)FilterApi.eq((Operators.Column)foo, (Comparable)Integer.valueOf(11)));
        Job job = new Job();
        Configuration conf = job.getConfiguration();
        ParquetInputFormat.setUnboundRecordFilter((Job)job, DummyUnboundRecordFilter.class);
        try {
            ParquetInputFormat.setFilterPredicate((Configuration)conf, (FilterPredicate)p);
            Assert.fail((String)"this should throw");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"You cannot provide a FilterPredicate after providing an UnboundRecordFilter", (Object)e.getMessage());
        }
        job = new Job();
        conf = job.getConfiguration();
        ParquetInputFormat.setFilterPredicate((Configuration)conf, (FilterPredicate)p);
        try {
            ParquetInputFormat.setUnboundRecordFilter((Job)job, DummyUnboundRecordFilter.class);
            Assert.fail((String)"this should throw");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"You cannot provide an UnboundRecordFilter after providing a FilterPredicate", (Object)e.getMessage());
        }
    }

    public static BlockMetaData makeBlockFromStats(IntStatistics stats, long valueCount) {
        BlockMetaData blockMetaData = new BlockMetaData();
        ColumnChunkMetaData column = ColumnChunkMetaData.get((ColumnPath)ColumnPath.get((String[])new String[]{"foo"}), (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (CompressionCodecName)CompressionCodecName.GZIP, new HashSet<Encoding>(Arrays.asList(Encoding.PLAIN)), (Statistics)stats, (long)100L, (long)100L, (long)valueCount, (long)100L, (long)100L);
        blockMetaData.addColumn(column);
        blockMetaData.setTotalByteSize(200L);
        blockMetaData.setRowCount(valueCount);
        return blockMetaData;
    }

    @Test
    public void testFooterCacheValueIsCurrent() throws IOException, InterruptedException {
        File tempFile = this.getTempFile();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)new Configuration());
        ParquetInputFormat.FootersCacheValue cacheValue = this.getDummyCacheValue(tempFile, (FileSystem)fs);
        Assert.assertTrue((boolean)tempFile.setLastModified(tempFile.lastModified() + 5000L));
        Assert.assertFalse((boolean)cacheValue.isCurrent(new ParquetInputFormat.FileStatusWrapper(fs.getFileStatus(new Path(tempFile.getAbsolutePath())))));
    }

    @Test
    public void testFooterCacheValueIsNewer() throws IOException {
        File tempFile = this.getTempFile();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)new Configuration());
        ParquetInputFormat.FootersCacheValue cacheValue = this.getDummyCacheValue(tempFile, (FileSystem)fs);
        Assert.assertTrue((boolean)cacheValue.isNewerThan(null));
        Assert.assertFalse((boolean)cacheValue.isNewerThan(cacheValue));
        Assert.assertTrue((boolean)tempFile.setLastModified(tempFile.lastModified() + 5000L));
        ParquetInputFormat.FootersCacheValue newerCacheValue = this.getDummyCacheValue(tempFile, (FileSystem)fs);
        Assert.assertTrue((boolean)newerCacheValue.isNewerThan(cacheValue));
        Assert.assertFalse((boolean)cacheValue.isNewerThan(newerCacheValue));
    }

    @Test
    public void testDeprecatedConstructorOfParquetInputSplit() throws Exception {
        this.withHDFSBlockSize(50L, 50L);
        List<ParquetInputSplit> splits = this.generateSplitByDeprecatedConstructor(50L, 50L);
        this.shouldSplitBlockSizeBe(splits, 5, 5);
        this.shouldOneSplitRowGroupOffsetBe(splits.get(0), 0, 10, 20, 30, 40);
        this.shouldOneSplitRowGroupOffsetBe(splits.get(1), 50, 60, 70, 80, 90);
        this.shouldSplitLengthBe(splits, 50, 50);
        this.shouldSplitStartBe(splits, 0L, 50L);
    }

    @Test
    public void testGetFootersReturnsInPredictableOrder() throws IOException {
        File tempDir = Files.createTempDir();
        tempDir.deleteOnExit();
        int numFiles = 10;
        String url = "";
        for (int i = 0; i < numFiles; ++i) {
            File file = new File(tempDir, String.format("part-%05d.parquet", i));
            this.createParquetFile(file);
            if (i > 0) {
                url = url + ",";
            }
            url = url + "file:" + file.getAbsolutePath();
        }
        Job job = new Job();
        FileInputFormat.setInputPaths((Job)job, (String)url);
        List footers = new ParquetInputFormat().getFooters((JobContext)job);
        for (int i = 0; i < numFiles; ++i) {
            Footer footer = (Footer)footers.get(i);
            File file = new File(tempDir, String.format("part-%05d.parquet", i));
            Assert.assertEquals((Object)("file:" + file.getAbsolutePath()), (Object)footer.getFile().toString());
        }
    }

    private void createParquetFile(File file) throws IOException {
        Path path = new Path(file.toURI());
        Configuration configuration = new Configuration();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message m { required group a {required binary b;}}");
        String[] columnPath = new String[]{"a", "b"};
        ColumnDescriptor c1 = schema.getColumnDescription(columnPath);
        byte[] bytes1 = new byte[]{0, 1, 2, 3};
        byte[] bytes2 = new byte[]{2, 3, 4, 5};
        CompressionCodecName codec = CompressionCodecName.UNCOMPRESSED;
        BinaryStatistics stats = new BinaryStatistics();
        ParquetFileWriter w = new ParquetFileWriter(configuration, schema, path);
        w.start();
        w.startBlock(3L);
        w.startColumn(c1, 5L, codec);
        w.writeDataPage(2, 4, BytesInput.from((byte[])bytes1), (Statistics)stats, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.writeDataPage(3, 4, BytesInput.from((byte[])bytes1), (Statistics)stats, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        w.endBlock();
        w.startBlock(4L);
        w.startColumn(c1, 7L, codec);
        w.writeDataPage(7, 4, BytesInput.from((byte[])bytes2), (Statistics)stats, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        w.endBlock();
        w.end(new HashMap());
    }

    private File getTempFile() throws IOException {
        File tempFile = File.createTempFile("footer_", ".txt");
        tempFile.deleteOnExit();
        return tempFile;
    }

    private ParquetInputFormat.FootersCacheValue getDummyCacheValue(File file, FileSystem fs) throws IOException {
        Path path = new Path(file.getPath());
        FileStatus status = fs.getFileStatus(path);
        ParquetInputFormat.FileStatusWrapper statusWrapper = new ParquetInputFormat.FileStatusWrapper(status);
        ParquetMetadata mockMetadata = (ParquetMetadata)Mockito.mock(ParquetMetadata.class);
        ParquetInputFormat.FootersCacheValue cacheValue = new ParquetInputFormat.FootersCacheValue(statusWrapper, new Footer(path, mockMetadata));
        Assert.assertTrue((boolean)cacheValue.isCurrent(statusWrapper));
        return cacheValue;
    }

    private List<ParquetInputSplit> generateSplitByMinMaxSize(long min, long max) throws IOException {
        return ClientSideMetadataSplitStrategy.generateSplits(this.blocks, (BlockLocation[])this.hdfsBlocks, (FileStatus)this.fileStatus, (String)this.schema.toString(), extramd, (long)min, (long)max);
    }

    private List<ParquetInputSplit> generateSplitByDeprecatedConstructor(long min, long max) throws IOException {
        ArrayList<ParquetInputSplit> splits = new ArrayList<ParquetInputSplit>();
        List splitInfos = ClientSideMetadataSplitStrategy.generateSplitInfo(this.blocks, (BlockLocation[])this.hdfsBlocks, (long)min, (long)max);
        for (ClientSideMetadataSplitStrategy.SplitInfo splitInfo : splitInfos) {
            ParquetInputSplit split = new ParquetInputSplit(this.fileStatus.getPath(), splitInfo.hdfsBlock.getOffset(), splitInfo.hdfsBlock.getLength(), splitInfo.hdfsBlock.getHosts(), splitInfo.rowGroups, this.schema.toString(), null, null, extramd);
            splits.add(split);
        }
        return splits;
    }

    private void shouldSplitStartBe(List<ParquetInputSplit> splits, long ... offsets) {
        Assert.assertEquals((String)this.message(splits), (long)offsets.length, (long)splits.size());
        for (int i = 0; i < offsets.length; ++i) {
            Assert.assertEquals((String)(this.message(splits) + i), (long)offsets[i], (long)splits.get(i).getStart());
        }
    }

    private void shouldSplitBlockSizeBe(List<ParquetInputSplit> splits, int ... sizes) {
        Assert.assertEquals((String)this.message(splits), (long)sizes.length, (long)splits.size());
        for (int i = 0; i < sizes.length; ++i) {
            Assert.assertEquals((String)(this.message(splits) + i), (long)sizes[i], (long)splits.get(i).getRowGroupOffsets().length);
        }
    }

    private void shouldSplitLocationBe(List<ParquetInputSplit> splits, int ... locations) throws IOException {
        Assert.assertEquals((String)this.message(splits), (long)locations.length, (long)splits.size());
        for (int i = 0; i < locations.length; ++i) {
            int loc = locations[i];
            ParquetInputSplit split = splits.get(i);
            Assert.assertEquals((String)(this.message(splits) + i), (Object)("[foo" + loc + ".datanode, bar" + loc + ".datanode]"), (Object)Arrays.toString(split.getLocations()));
        }
    }

    private void shouldOneSplitRowGroupOffsetBe(ParquetInputSplit split, int ... rowGroupOffsets) {
        Assert.assertEquals((String)split.toString(), (long)rowGroupOffsets.length, (long)split.getRowGroupOffsets().length);
        for (int i = 0; i < rowGroupOffsets.length; ++i) {
            Assert.assertEquals((String)split.toString(), (long)rowGroupOffsets[i], (long)split.getRowGroupOffsets()[i]);
        }
    }

    private String message(List<ParquetInputSplit> splits) {
        return String.valueOf(splits) + " " + Arrays.toString(this.hdfsBlocks) + "\n";
    }

    private void shouldSplitLengthBe(List<ParquetInputSplit> splits, int ... lengths) {
        Assert.assertEquals((String)this.message(splits), (long)lengths.length, (long)splits.size());
        for (int i = 0; i < lengths.length; ++i) {
            Assert.assertEquals((String)(this.message(splits) + i), (long)lengths[i], (long)splits.get(i).getLength());
        }
    }

    private void withHDFSBlockSize(long ... blockSizes) {
        this.hdfsBlocks = new BlockLocation[blockSizes.length];
        long offset = 0L;
        for (int i = 0; i < blockSizes.length; ++i) {
            long blockSize = blockSizes[i];
            this.hdfsBlocks[i] = new BlockLocation(new String[0], new String[]{"foo" + i + ".datanode", "bar" + i + ".datanode"}, offset, blockSize);
            offset += blockSize;
        }
        this.fileStatus = new FileStatus(offset, false, 2, 50L, 0L, new Path("hdfs://foo.namenode:1234/bar"));
    }

    private BlockMetaData newBlock(long start, long compressedBlockSize) {
        BlockMetaData blockMetaData = new BlockMetaData();
        long uncompressedSize = compressedBlockSize * 2L;
        ColumnChunkMetaData column = ColumnChunkMetaData.get((ColumnPath)ColumnPath.get((String[])new String[]{"foo"}), (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (CompressionCodecName)CompressionCodecName.GZIP, new HashSet<Encoding>(Arrays.asList(Encoding.PLAIN)), (Statistics)new BinaryStatistics(), (long)start, (long)0L, (long)0L, (long)compressedBlockSize, (long)uncompressedSize);
        blockMetaData.addColumn(column);
        blockMetaData.setTotalByteSize(uncompressedSize);
        return blockMetaData;
    }

    static {
        HashMap<String, String> md = new HashMap<String, String>();
        md.put("specific", "foo");
        extramd = Collections.unmodifiableMap(md);
    }

    public static final class DummyUnboundRecordFilter
    implements UnboundRecordFilter {
        public RecordFilter bind(Iterable<ColumnReader> readers) {
            return null;
        }
    }
}

