/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestMergeMetadataFiles {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private static final MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required binary binary_field; required int32 int32_field; required int64 int64_field; required boolean boolean_field; required float float_field; required double double_field; required fixed_len_byte_array(3) flba_field; required int96 int96_field; } ");
    private static final MessageType schema2 = MessageTypeParser.parseMessageType((String)"message test { required binary binary_field; required int32 int32_field; required int64 int64_field; required boolean boolean_field; required float float_field; required double double_field; required fixed_len_byte_array(3) flba_field; } ");

    private static void writeFile(File out, Configuration conf, boolean useSchema2) throws IOException {
        if (!useSchema2) {
            GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        } else {
            GroupWriteSupport.setSchema((MessageType)schema2, (Configuration)conf);
        }
        SimpleGroupFactory f = new SimpleGroupFactory(schema);
        HashMap<String, String> extraMetaData = new HashMap<String, String>();
        extraMetaData.put("schema_num", useSchema2 ? "2" : "1");
        ParquetWriter writer = ((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)new Path(out.getAbsolutePath())).withConf(conf)).withExtraMetaData(extraMetaData).build();
        for (int i = 0; i < 1000; ++i) {
            Group g = f.newGroup().append("binary_field", "test" + i).append("int32_field", i).append("int64_field", (long)i).append("boolean_field", i % 2 == 0).append("float_field", (float)i).append("double_field", (double)i).append("flba_field", "foo");
            if (!useSchema2) {
                g = g.append("int96_field", Binary.fromConstantByteArray((byte[])new byte[12]));
            }
            writer.write((Object)g);
        }
        writer.close();
    }

    private WrittenFileInfo writeFiles(boolean mixedSchemas) throws Exception {
        Configuration conf;
        WrittenFileInfo info = new WrittenFileInfo();
        info.conf = conf = new Configuration();
        File root1 = new File(this.temp.getRoot(), "out1");
        File root2 = new File(this.temp.getRoot(), "out2");
        Path rootPath1 = new Path(root1.getAbsolutePath());
        Path rootPath2 = new Path(root2.getAbsolutePath());
        for (int i = 0; i < 10; ++i) {
            TestMergeMetadataFiles.writeFile(new File(root1, i + ".parquet"), conf, true);
        }
        List footers = ParquetFileReader.readFooters((Configuration)conf, (FileStatus)rootPath1.getFileSystem(conf).getFileStatus(rootPath1), (boolean)false);
        ParquetFileWriter.writeMetadataFile((Configuration)conf, (Path)rootPath1, (List)footers, (ParquetOutputFormat.JobSummaryLevel)ParquetOutputFormat.JobSummaryLevel.ALL);
        for (int i = 0; i < 7; ++i) {
            TestMergeMetadataFiles.writeFile(new File(root2, i + ".parquet"), conf, !mixedSchemas);
        }
        footers = ParquetFileReader.readFooters((Configuration)conf, (FileStatus)rootPath2.getFileSystem(conf).getFileStatus(rootPath2), (boolean)false);
        ParquetFileWriter.writeMetadataFile((Configuration)conf, (Path)rootPath2, (List)footers, (ParquetOutputFormat.JobSummaryLevel)ParquetOutputFormat.JobSummaryLevel.ALL);
        info.commonMetaPath1 = new Path(new File(root1, "_common_metadata").getAbsolutePath());
        info.commonMetaPath2 = new Path(new File(root2, "_common_metadata").getAbsolutePath());
        info.metaPath1 = new Path(new File(root1, "_metadata").getAbsolutePath());
        info.metaPath2 = new Path(new File(root2, "_metadata").getAbsolutePath());
        return info;
    }

    @Test
    public void testMergeMetadataFiles() throws Exception {
        WrittenFileInfo info = this.writeFiles(false);
        ParquetMetadata commonMeta1 = ParquetFileReader.readFooter((Configuration)info.conf, (Path)info.commonMetaPath1, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        ParquetMetadata commonMeta2 = ParquetFileReader.readFooter((Configuration)info.conf, (Path)info.commonMetaPath2, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        ParquetMetadata meta1 = ParquetFileReader.readFooter((Configuration)info.conf, (Path)info.metaPath1, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        ParquetMetadata meta2 = ParquetFileReader.readFooter((Configuration)info.conf, (Path)info.metaPath2, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        Assert.assertTrue((boolean)commonMeta1.getBlocks().isEmpty());
        Assert.assertTrue((boolean)commonMeta2.getBlocks().isEmpty());
        Assert.assertEquals((Object)commonMeta1.getFileMetaData().getSchema(), (Object)commonMeta2.getFileMetaData().getSchema());
        Assert.assertFalse((boolean)meta1.getBlocks().isEmpty());
        Assert.assertFalse((boolean)meta2.getBlocks().isEmpty());
        Assert.assertEquals((Object)meta1.getFileMetaData().getSchema(), (Object)meta2.getFileMetaData().getSchema());
        Assert.assertEquals((Object)commonMeta1.getFileMetaData().getKeyValueMetaData(), (Object)commonMeta2.getFileMetaData().getKeyValueMetaData());
        Assert.assertEquals((Object)meta1.getFileMetaData().getKeyValueMetaData(), (Object)meta2.getFileMetaData().getKeyValueMetaData());
        Path mergedOut = new Path(new File(this.temp.getRoot(), "merged_meta").getAbsolutePath());
        Path mergedCommonOut = new Path(new File(this.temp.getRoot(), "merged_common_meta").getAbsolutePath());
        ParquetFileWriter.writeMergedMetadataFile(Arrays.asList(info.metaPath1, info.metaPath2), (Path)mergedOut, (Configuration)info.conf);
        ParquetFileWriter.writeMergedMetadataFile(Arrays.asList(info.commonMetaPath1, info.commonMetaPath2), (Path)mergedCommonOut, (Configuration)info.conf);
        ParquetMetadata mergedMeta = ParquetFileReader.readFooter((Configuration)info.conf, (Path)mergedOut, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        ParquetMetadata mergedCommonMeta = ParquetFileReader.readFooter((Configuration)info.conf, (Path)mergedCommonOut, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        Assert.assertEquals((long)(meta1.getBlocks().size() + meta2.getBlocks().size()), (long)mergedMeta.getBlocks().size());
        Assert.assertTrue((boolean)mergedCommonMeta.getBlocks().isEmpty());
        Assert.assertEquals((Object)meta1.getFileMetaData().getSchema(), (Object)mergedMeta.getFileMetaData().getSchema());
        Assert.assertEquals((Object)commonMeta1.getFileMetaData().getSchema(), (Object)mergedCommonMeta.getFileMetaData().getSchema());
        Assert.assertEquals((Object)meta1.getFileMetaData().getKeyValueMetaData(), (Object)mergedMeta.getFileMetaData().getKeyValueMetaData());
        Assert.assertEquals((Object)commonMeta1.getFileMetaData().getKeyValueMetaData(), (Object)mergedCommonMeta.getFileMetaData().getKeyValueMetaData());
    }

    @Test
    public void testThrowsWhenIncompatible() throws Exception {
        boolean eq2;
        boolean eq1;
        WrittenFileInfo info = this.writeFiles(true);
        Path mergedOut = new Path(new File(this.temp.getRoot(), "merged_meta").getAbsolutePath());
        Path mergedCommonOut = new Path(new File(this.temp.getRoot(), "merged_common_meta").getAbsolutePath());
        try {
            ParquetFileWriter.writeMergedMetadataFile(Arrays.asList(info.metaPath1, info.metaPath2), (Path)mergedOut, (Configuration)info.conf);
            Assert.fail((String)"this should throw");
        }
        catch (RuntimeException e) {
            eq1 = e.getMessage().equals("could not merge metadata: key schema_num has conflicting values: [2, 1]");
            eq2 = e.getMessage().equals("could not merge metadata: key schema_num has conflicting values: [1, 2]");
            Assert.assertEquals((Object)(eq1 || eq2 ? 1 : 0), (Object)true);
        }
        try {
            ParquetFileWriter.writeMergedMetadataFile(Arrays.asList(info.commonMetaPath1, info.commonMetaPath2), (Path)mergedCommonOut, (Configuration)info.conf);
            Assert.fail((String)"this should throw");
        }
        catch (RuntimeException e) {
            eq1 = e.getMessage().equals("could not merge metadata: key schema_num has conflicting values: [2, 1]");
            eq2 = e.getMessage().equals("could not merge metadata: key schema_num has conflicting values: [1, 2]");
            Assert.assertEquals((Object)(eq1 || eq2 ? 1 : 0), (Object)true);
        }
    }

    private static class WrittenFileInfo {
        public Configuration conf;
        public Path metaPath1;
        public Path metaPath2;
        public Path commonMetaPath1;
        public Path commonMetaPath2;

        private WrittenFileInfo() {
        }
    }
}

