/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.statistics;

import java.math.BigInteger;
import java.util.Random;
import org.apache.parquet.io.api.Binary;

public class RandomValues {
    private static final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890";

    private static class RandomRange<T extends Comparable<T>> {
        private T minimum;
        private T maximum;

        public RandomRange(T lhs, T rhs) {
            this.minimum = lhs;
            this.maximum = rhs;
            if (this.minimum.compareTo(rhs) > 0) {
                T temporary = this.minimum;
                this.minimum = this.maximum;
                this.maximum = temporary;
            }
        }

        public T minimum() {
            return this.minimum;
        }

        public T maximum() {
            return this.maximum;
        }
    }

    public static class FixedGenerator
    extends RandomBinaryBase<Binary> {
        public FixedGenerator(long seed, int length) {
            super(seed, length);
        }

        @Override
        public Binary nextValue() {
            for (int index = 0; index < this.buffer.length; ++index) {
                this.buffer[index] = (byte)this.randomInt();
            }
            return Binary.fromReusedByteArray((byte[])this.buffer);
        }

        @Override
        public Binary nextBinaryValue() {
            return this.nextValue();
        }
    }

    public static class BinaryGenerator
    extends RandomBinaryBase<Binary> {
        private static final int MAX_STRING_LENGTH = 16;

        public BinaryGenerator(long seed) {
            super(seed, 16);
        }

        @Override
        public Binary nextValue() {
            int length = 5 + this.randomPositiveInt(this.buffer.length - 5);
            for (int index = 0; index < length; ++index) {
                this.buffer[index] = (byte)this.randomInt();
            }
            return Binary.fromReusedByteArray((byte[])this.buffer, (int)0, (int)length);
        }

        @Override
        public Binary nextBinaryValue() {
            return this.nextValue();
        }
    }

    public static class StringGenerator
    extends RandomBinaryBase<String> {
        private static final int MAX_STRING_LENGTH = 16;

        public StringGenerator(long seed) {
            super(seed, 16);
        }

        @Override
        public String nextValue() {
            int stringLength = this.randomPositiveInt(15) + 1;
            return this.randomString(stringLength);
        }

        @Override
        public Binary nextBinaryValue() {
            return this.asReusedBinary(this.nextValue().getBytes());
        }
    }

    public static class UnconstrainedDoubleGenerator
    extends RandomValueGenerator<Double> {
        public UnconstrainedDoubleGenerator(long seed) {
            super(seed);
        }

        @Override
        public Double nextValue() {
            return this.randomDouble();
        }
    }

    public static class DoubleGenerator
    extends RandomValueGenerator<Double> {
        private final RandomRange<Double> randomRange = new RandomRange<Double>(this.randomDouble(), this.randomDouble());
        private final double minimum = this.randomRange.minimum();
        private final double maximum = this.randomRange.maximum();
        private final double range = this.maximum - this.minimum;

        public DoubleGenerator(long seed) {
            super(seed);
        }

        @Override
        public Double nextValue() {
            return this.minimum + this.randomDouble(this.range);
        }
    }

    public static class UnconstrainedFloatGenerator
    extends RandomValueGenerator<Float> {
        public UnconstrainedFloatGenerator(long seed) {
            super(seed);
        }

        @Override
        public Float nextValue() {
            return Float.valueOf(this.randomFloat());
        }
    }

    public static class FloatGenerator
    extends RandomValueGenerator<Float> {
        private final RandomRange<Float> randomRange = new RandomRange<Float>(Float.valueOf(this.randomFloat()), Float.valueOf(this.randomFloat()));
        private final float minimum = this.randomRange.minimum().floatValue();
        private final float maximum = this.randomRange.maximum().floatValue();
        private final float range = this.maximum - this.minimum;

        public FloatGenerator(long seed) {
            super(seed);
        }

        @Override
        public Float nextValue() {
            return Float.valueOf(this.minimum + this.randomFloat(this.range));
        }
    }

    public static class Int96Generator
    extends RandomBinaryBase<BigInteger> {
        private final RandomRange<BigInteger> randomRange = new RandomRange<BigInteger>(this.randomInt96(), this.randomInt96());
        private final BigInteger minimum = this.randomRange.minimum();
        private final BigInteger maximum = this.randomRange.maximum();
        private final BigInteger range = this.maximum.subtract(this.minimum);
        private static final int INT_96_LENGTH = 12;

        public Int96Generator(long seed) {
            super(seed, 12);
        }

        @Override
        public BigInteger nextValue() {
            return this.minimum.add(this.randomInt96(this.range));
        }

        @Override
        public Binary nextBinaryValue() {
            return this.asReusedBinary(this.nextValue().toByteArray());
        }
    }

    public static class UnconstrainedLongGenerator
    extends RandomValueGenerator<Long> {
        public UnconstrainedLongGenerator(long seed) {
            super(seed);
        }

        @Override
        public Long nextValue() {
            return this.randomLong();
        }
    }

    public static class LongGenerator
    extends RandomValueGenerator<Long> {
        private final RandomRange<Long> randomRange = new RandomRange<Long>(this.randomLong(), this.randomLong());
        private final long minimum = this.randomRange.minimum();
        private final long maximum = this.randomRange.maximum();
        private final long range = this.maximum - this.minimum;

        public LongGenerator(long seed) {
            super(seed);
        }

        @Override
        public Long nextValue() {
            return this.minimum + this.randomLong(this.range);
        }
    }

    public static class UnconstrainedIntGenerator
    extends RandomValueGenerator<Integer> {
        public UnconstrainedIntGenerator(long seed) {
            super(seed);
        }

        @Override
        public Integer nextValue() {
            return this.randomInt();
        }
    }

    public static class UIntGenerator
    extends IntGenerator {
        private final int mask;

        public UIntGenerator(long seed, byte minimum, byte maximum) {
            super(seed, minimum, maximum);
            this.mask = 255;
        }

        public UIntGenerator(long seed, short minimum, short maximum) {
            super(seed, minimum, maximum);
            this.mask = 65535;
        }

        @Override
        public Integer nextValue() {
            return super.nextValue() & this.mask;
        }
    }

    public static class IntGenerator
    extends RandomValueGenerator<Integer> {
        private final int minimum;
        private final int range;

        public IntGenerator(long seed) {
            super(seed);
            RandomRange<Integer> randomRange = new RandomRange<Integer>(this.randomInt(), this.randomInt());
            this.minimum = randomRange.minimum();
            this.range = randomRange.maximum() - this.minimum;
        }

        public IntGenerator(long seed, int minimum, int maximum) {
            super(seed);
            RandomRange<Integer> randomRange = new RandomRange<Integer>(minimum, maximum);
            this.minimum = randomRange.minimum();
            this.range = randomRange.maximum() - this.minimum;
        }

        @Override
        public Integer nextValue() {
            return this.minimum + this.randomPositiveInt(this.range);
        }
    }

    static abstract class RandomBinaryBase<T extends Comparable<T>>
    extends RandomValueGenerator<T> {
        protected final int bufferLength;
        protected final byte[] buffer;

        public RandomBinaryBase(long seed, int bufferLength) {
            super(seed);
            this.bufferLength = bufferLength;
            this.buffer = new byte[bufferLength];
        }

        public abstract Binary nextBinaryValue();

        public Binary asReusedBinary(byte[] data) {
            int length = Math.min(data.length, this.bufferLength);
            System.arraycopy(data, 0, this.buffer, 0, length);
            return Binary.fromReusedByteArray((byte[])data, (int)0, (int)length);
        }
    }

    static abstract class RandomValueGenerator<T extends Comparable<T>> {
        private final Random random;

        protected RandomValueGenerator(long seed) {
            this.random = new Random(seed);
        }

        public boolean shouldGenerateNull() {
            return this.random.nextInt(10) == 0;
        }

        public int randomInt() {
            return this.random.nextInt();
        }

        public int randomPositiveInt(int maximum) {
            return this.random.nextInt(Math.abs(maximum) + 1);
        }

        public long randomLong() {
            return this.random.nextLong();
        }

        public long randomLong(long maximum) {
            return this.randomLong() % maximum;
        }

        public float randomFloat() {
            return this.random.nextFloat();
        }

        public float randomFloat(float maximum) {
            return this.random.nextFloat() % maximum;
        }

        public double randomDouble() {
            return this.random.nextDouble();
        }

        public double randomDouble(double maximum) {
            return this.random.nextDouble() % maximum;
        }

        public BigInteger randomInt96() {
            return new BigInteger(95, this.random);
        }

        public BigInteger randomInt96(BigInteger maximum) {
            BigInteger result;
            while ((result = this.randomInt96()).compareTo(maximum) > 0) {
            }
            return result;
        }

        public char randomLetter() {
            return RandomValues.ALPHABET.charAt(this.randomPositiveInt(RandomValues.ALPHABET.length() - 1));
        }

        public String randomString(int maxLength) {
            return this.randomFixedLengthString(this.randomPositiveInt(maxLength));
        }

        public String randomFixedLengthString(int length) {
            StringBuilder builder = new StringBuilder();
            for (int index = 0; index < length; ++index) {
                builder.append(this.randomLetter());
            }
            return builder.toString();
        }

        public abstract T nextValue();
    }
}

