/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.crypto.propertiesfactory;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.crypto.ColumnEncryptionProperties;
import org.apache.parquet.crypto.DecryptionKeyRetriever;
import org.apache.parquet.crypto.DecryptionKeyRetrieverMock;
import org.apache.parquet.crypto.DecryptionPropertiesFactory;
import org.apache.parquet.crypto.EncryptionPropertiesFactory;
import org.apache.parquet.crypto.FileDecryptionProperties;
import org.apache.parquet.crypto.FileEncryptionProperties;
import org.apache.parquet.crypto.ParquetCipher;
import org.apache.parquet.crypto.ParquetCryptoRuntimeException;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaCryptoPropertiesFactory
implements EncryptionPropertiesFactory,
DecryptionPropertiesFactory {
    public static final String PATH_NAME_PREFIX = "column_encryption_1178_";
    private static Logger log = LoggerFactory.getLogger(SchemaCryptoPropertiesFactory.class);
    public static final String CONF_ENCRYPTION_ALGORITHM = "parquet.encryption.algorithm";
    public static final String CONF_ENCRYPTION_FOOTER = "parquet.encrypt.footer";
    private static final byte[] FOOTER_KEY = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    private static final byte[] FOOTER_KEY_METADATA = "footkey".getBytes(StandardCharsets.UTF_8);
    private static final byte[] COL_KEY = new byte[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
    private static final byte[] COL_KEY_METADATA = "col".getBytes(StandardCharsets.UTF_8);

    public FileEncryptionProperties getFileEncryptionProperties(Configuration conf, Path tempFilePath, WriteSupport.WriteContext fileWriteContext) throws ParquetCryptoRuntimeException {
        MessageType schema = fileWriteContext.getSchema();
        List paths = schema.getPaths();
        if (paths == null || paths.isEmpty()) {
            throw new ParquetCryptoRuntimeException("Null or empty fields is found");
        }
        HashMap<ColumnPath, ColumnEncryptionProperties> columnPropertyMap = new HashMap<ColumnPath, ColumnEncryptionProperties>();
        for (String[] path : paths) {
            this.getColumnEncryptionProperties(path, columnPropertyMap, conf);
        }
        if (columnPropertyMap.size() == 0) {
            log.debug("No column is encrypted. Returning null so that Parquet can skip. Empty properties will cause Parquet exception");
            return null;
        }
        boolean shouldEncryptFooter = this.getEncryptFooter(conf);
        FileEncryptionProperties.Builder encryptionPropertiesBuilder = FileEncryptionProperties.builder((byte[])FOOTER_KEY).withFooterKeyMetadata(FOOTER_KEY_METADATA).withAlgorithm(this.getParquetCipherOrDefault(conf)).withEncryptedColumns(columnPropertyMap);
        if (!shouldEncryptFooter) {
            encryptionPropertiesBuilder = encryptionPropertiesBuilder.withPlaintextFooter();
        }
        FileEncryptionProperties encryptionProperties = encryptionPropertiesBuilder.build();
        log.info("FileEncryptionProperties is built with, algorithm:{}, footerEncrypted:{}", (Object)encryptionProperties.getAlgorithm(), (Object)encryptionProperties.encryptedFooter());
        return encryptionProperties;
    }

    private ParquetCipher getParquetCipherOrDefault(Configuration conf) {
        String algorithm = conf.get(CONF_ENCRYPTION_ALGORITHM, "AES_GCM_CTR_V1");
        log.debug("Encryption algorithm is {}", (Object)algorithm);
        return ParquetCipher.valueOf((String)algorithm.toUpperCase());
    }

    private boolean getEncryptFooter(Configuration conf) {
        boolean encryptFooter = conf.getBoolean(CONF_ENCRYPTION_FOOTER, false);
        log.debug("Encrypt Footer: {}", (Object)encryptFooter);
        return encryptFooter;
    }

    private void getColumnEncryptionProperties(String[] path, Map<ColumnPath, ColumnEncryptionProperties> columnPropertyMap, Configuration conf) throws ParquetCryptoRuntimeException {
        String pathName = String.join((CharSequence)".", path);
        String columnKeyName = conf.get(PATH_NAME_PREFIX + pathName, null);
        if (columnKeyName != null) {
            ColumnPath columnPath = ColumnPath.get((String[])path);
            ColumnEncryptionProperties colEncProp = ColumnEncryptionProperties.builder((ColumnPath)columnPath).withKey(COL_KEY).withKeyMetaData(COL_KEY_METADATA).build();
            columnPropertyMap.put(columnPath, colEncProp);
        }
    }

    public FileDecryptionProperties getFileDecryptionProperties(Configuration hadoopConfig, Path filePath) throws ParquetCryptoRuntimeException {
        DecryptionKeyRetrieverMock keyRetriever = new DecryptionKeyRetrieverMock();
        keyRetriever.putKey("footkey", FOOTER_KEY);
        keyRetriever.putKey("col", COL_KEY);
        return FileDecryptionProperties.builder().withPlaintextFilesAllowed().withKeyRetriever((DecryptionKeyRetriever)keyRetriever).build();
    }
}

