/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.CombineFileInputFormat;
import org.apache.hadoop.mapred.lib.CombineFileRecordReader;
import org.apache.hadoop.mapred.lib.CombineFileSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.hadoop.example.ExampleOutputFormat;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.hadoop.mapred.Container;
import org.apache.parquet.hadoop.mapred.DeprecatedParquetInputFormat;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DeprecatedInputFormatTest {
    final Path parquetPath = new Path("target/test/example/TestInputOutputFormat/parquet");
    final Path inputPath = new Path("src/test/java/org/apache/parquet/hadoop/example/TestInputOutputFormat.java");
    final Path outputPath = new Path("target/test/example/TestInputOutputFormat/out");
    Job writeJob;
    JobConf jobConf;
    RunningJob mapRedJob;
    private String writeSchema;
    private String readSchema;
    private Configuration conf;

    @Before
    public void setUp() {
        this.conf = new Configuration();
        this.jobConf = new JobConf();
        this.writeSchema = "message example {\nrequired int32 line;\nrequired binary content;\n}";
        this.readSchema = "message example {\nrequired int32 line;\nrequired binary content;\n}";
    }

    private void runMapReduceJob(CompressionCodecName codec) throws IOException, ClassNotFoundException, InterruptedException {
        FileSystem fileSystem = this.parquetPath.getFileSystem(this.conf);
        fileSystem.delete(this.parquetPath, true);
        fileSystem.delete(this.outputPath, true);
        this.writeJob = new Job(this.conf, "write");
        TextInputFormat.addInputPath((Job)this.writeJob, (Path)this.inputPath);
        this.writeJob.setInputFormatClass(TextInputFormat.class);
        this.writeJob.setNumReduceTasks(0);
        ExampleOutputFormat.setCompression((Job)this.writeJob, (CompressionCodecName)codec);
        ExampleOutputFormat.setOutputPath((Job)this.writeJob, (Path)this.parquetPath);
        this.writeJob.setOutputFormatClass(ExampleOutputFormat.class);
        this.writeJob.setMapperClass(ReadMapper.class);
        ExampleOutputFormat.setSchema((Job)this.writeJob, (MessageType)MessageTypeParser.parseMessageType((String)this.writeSchema));
        this.writeJob.submit();
        this.waitForJob(this.writeJob);
        this.jobConf.set("parquet.read.schema", this.readSchema);
        this.jobConf.set("parquet.read.support.class", GroupReadSupport.class.getCanonicalName());
        this.jobConf.setInputFormat(MyDeprecatedInputFormat.class);
        MyDeprecatedInputFormat.setInputPaths((JobConf)this.jobConf, (Path[])new Path[]{this.parquetPath});
        this.jobConf.setOutputFormat(TextOutputFormat.class);
        TextOutputFormat.setOutputPath((JobConf)this.jobConf, (Path)this.outputPath);
        this.jobConf.setMapperClass(DeprecatedWriteMapper.class);
        this.jobConf.setNumReduceTasks(0);
        this.mapRedJob = JobClient.runJob((JobConf)this.jobConf);
    }

    private File createParquetFile(String content) throws IOException, ClassNotFoundException, InterruptedException {
        File inputFile = File.createTempFile("temp", null);
        File outputFile = File.createTempFile("temp", null);
        outputFile.delete();
        PrintWriter pw = new PrintWriter(new FileWriter(inputFile));
        if (content != null) {
            pw.println(content);
        }
        pw.close();
        this.writeJob = new Job(this.conf, "write");
        TextInputFormat.addInputPath((Job)this.writeJob, (Path)new Path(inputFile.toURI()));
        this.writeJob.setInputFormatClass(TextInputFormat.class);
        this.writeJob.setNumReduceTasks(0);
        ExampleOutputFormat.setOutputPath((Job)this.writeJob, (Path)new Path(outputFile.toURI()));
        this.writeJob.setOutputFormatClass(ExampleOutputFormat.class);
        this.writeJob.setMapperClass(ReadMapper.class);
        ExampleOutputFormat.setSchema((Job)this.writeJob, (MessageType)MessageTypeParser.parseMessageType((String)this.writeSchema));
        this.writeJob.submit();
        this.waitForJob(this.writeJob);
        File partFile = outputFile.listFiles(new PartFileFilter())[0];
        inputFile.delete();
        return partFile;
    }

    @Test
    public void testCombineParquetInputFormat() throws Exception {
        File inputDir = File.createTempFile("temp", null);
        inputDir.delete();
        inputDir.mkdirs();
        File parquetFile1 = this.createParquetFile(null);
        File parquetFile2 = this.createParquetFile("hello");
        File parquetFile3 = this.createParquetFile("world");
        Files.move(parquetFile1.toPath(), new File(inputDir, "1").toPath(), new CopyOption[0]);
        Files.move(parquetFile2.toPath(), new File(inputDir, "2").toPath(), new CopyOption[0]);
        Files.move(parquetFile3.toPath(), new File(inputDir, "3").toPath(), new CopyOption[0]);
        File outputDir = File.createTempFile("temp", null);
        outputDir.delete();
        JobConf conf = new JobConf(DeprecatedInputFormatTest.class);
        conf.setInputFormat(CombinedInputFormat.class);
        conf.setNumReduceTasks(0);
        conf.setOutputFormat(TextOutputFormat.class);
        conf.setMapperClass(DeprecatedWriteMapper.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{new Path(inputDir.toURI())});
        TextOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(outputDir.toURI()));
        conf.set("parquet.read.support.class", GroupReadSupport.class.getCanonicalName());
        JobClient.runJob((JobConf)conf);
        File partFile = outputDir.listFiles(new PartFileFilter())[0];
        try (BufferedReader br = new BufferedReader(new FileReader(partFile));){
            String line;
            HashSet<String> s = new HashSet<String>();
            while ((line = br.readLine()) != null) {
                s.add(line.split("\t")[1]);
            }
            Assert.assertEquals((long)s.size(), (long)2L);
            Assert.assertTrue((boolean)s.contains("hello"));
            Assert.assertTrue((boolean)s.contains("world"));
        }
        FileUtils.deleteDirectory((File)inputDir);
        FileUtils.deleteDirectory((File)outputDir);
    }

    @Test
    public void testReadWriteWithCountDeprecated() throws Exception {
        this.runMapReduceJob(CompressionCodecName.GZIP);
        Assert.assertTrue((this.mapRedJob.getCounters().getGroup("parquet").getCounterForName("bytesread").getValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.mapRedJob.getCounters().getGroup("parquet").getCounterForName("bytestotal").getValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.mapRedJob.getCounters().getGroup("parquet").getCounterForName("bytesread").getValue() == this.mapRedJob.getCounters().getGroup("parquet").getCounterForName("bytestotal").getValue() ? 1 : 0) != 0);
    }

    @Test
    public void testReadWriteWithoutCounter() throws Exception {
        this.jobConf.set("parquet.benchmark.time.read", "false");
        this.jobConf.set("parquet.benchmark.bytes.total", "false");
        this.jobConf.set("parquet.benchmark.bytes.read", "false");
        this.runMapReduceJob(CompressionCodecName.GZIP);
        Assert.assertEquals((long)this.mapRedJob.getCounters().getGroup("parquet").getCounterForName("bytesread").getValue(), (long)0L);
        Assert.assertEquals((long)this.mapRedJob.getCounters().getGroup("parquet").getCounterForName("bytestotal").getValue(), (long)0L);
        Assert.assertEquals((long)this.mapRedJob.getCounters().getGroup("parquet").getCounterForName("timeread").getValue(), (long)0L);
    }

    private void waitForJob(Job job) throws InterruptedException, IOException {
        while (!job.isComplete()) {
            System.out.println("waiting for job " + job.getJobName());
            Thread.sleep(100L);
        }
        System.out.println("status for job " + job.getJobName() + ": " + (job.isSuccessful() ? "SUCCESS" : "FAILURE"));
        if (!job.isSuccessful()) {
            throw new RuntimeException("job failed " + job.getJobName());
        }
    }

    static class MyDeprecatedInputFormat
    extends DeprecatedParquetInputFormat<Group> {
        MyDeprecatedInputFormat() {
        }
    }

    public static class DeprecatedWriteMapper
    implements org.apache.hadoop.mapred.Mapper<Void, Container<Group>, LongWritable, Text> {
        public void map(Void aVoid, Container<Group> valueContainer, OutputCollector<LongWritable, Text> longWritableTextOutputCollector, Reporter reporter) throws IOException {
            Group value = (Group)valueContainer.get();
            longWritableTextOutputCollector.collect((Object)new LongWritable((long)value.getInteger("line", 0)), (Object)new Text(value.getString("content", 0)));
        }

        public void close() throws IOException {
        }

        public void configure(JobConf entries) {
        }
    }

    public static class ReadMapper
    extends Mapper<LongWritable, Text, Void, Group> {
        private SimpleGroupFactory factory;

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.factory = new SimpleGroupFactory(GroupWriteSupport.getSchema((Configuration)ContextUtil.getConfiguration((JobContext)context)));
        }

        protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            Group group = this.factory.newGroup().append("line", (int)key.get()).append("content", value.toString());
            context.write(null, (Object)group);
        }
    }

    class PartFileFilter
    implements FilenameFilter {
        PartFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith("part");
        }
    }

    static class CombinedInputFormat
    extends CombineFileInputFormat
    implements Configurable {
        private Configuration conf;

        CombinedInputFormat() {
        }

        public RecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
            return new CombineFileRecordReader(job, (CombineFileSplit)split, reporter, CombineFileRecordReaderWrapper.class);
        }

        public void setConf(Configuration conf) {
            this.conf = conf;
        }

        public Configuration getConf() {
            return this.conf;
        }
    }

    static class CombineFileRecordReaderWrapper<K, V>
    implements RecordReader<K, V> {
        private final RecordReader<K, V> delegate;

        public CombineFileRecordReaderWrapper(CombineFileSplit split, Configuration conf, Reporter reporter, Integer idx) throws Exception {
            FileSplit fileSplit = new FileSplit(split.getPath(idx.intValue()), split.getOffset(idx.intValue()), split.getLength(idx.intValue()), split.getLocations());
            this.delegate = new DeprecatedParquetInputFormat().getRecordReader((InputSplit)fileSplit, (JobConf)conf, reporter);
        }

        public boolean next(K key, V value) throws IOException {
            return this.delegate.next(key, value);
        }

        public K createKey() {
            return (K)this.delegate.createKey();
        }

        public V createValue() {
            return (V)this.delegate.createValue();
        }

        public long getPos() throws IOException {
            return this.delegate.getPos();
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public float getProgress() throws IOException {
            return this.delegate.getProgress();
        }
    }
}

