/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.filter2.dictionarylevel;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.FixedBinaryTestUtils;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.EncodingStats;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.page.DictionaryPageReadStore;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.filter2.dictionarylevel.DictionaryFilter;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.LogicalInverseRewriter;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.filter2.predicate.Statistics;
import org.apache.parquet.filter2.predicate.UserDefinedPredicate;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class DictionaryFilterTest {
    private static final int nElements = 1000;
    private static final Configuration conf = new Configuration();
    private static final Path FILE_V1 = new Path("target/test/TestDictionaryFilter/testParquetFileV1.parquet");
    private static final Path FILE_V2 = new Path("target/test/TestDictionaryFilter/testParquetFileV2.parquet");
    private static final MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required binary binary_field; required binary single_value_field; optional binary optional_single_value_field; required fixed_len_byte_array(17) fixed_field (DECIMAL(40,4)); required int32 int32_field; required int64 int64_field; required double double_field; required float float_field; required int32 plain_int32_field; required binary fallback_binary_field; required int96 int96_field; } ");
    private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyz";
    private static final int[] intValues = new int[]{-100, 302, 3333333, 7654321, 1234567, -2000, -77775, 0, 75, 22223, 77, 22221, -444443, 205, 12, 44444, 889, 66665, -777889, -7, 52, 33, -257, 1111, 775, 26};
    private static final long[] longValues = new long[]{-100L, 302L, 3333333L, 7654321L, 1234567L, -2000L, -77775L, 0L, 75L, 22223L, 77L, 22221L, -444443L, 205L, 12L, 44444L, 889L, 66665L, -777889L, -7L, 52L, 33L, -257L, 1111L, 775L, 26L};
    private static final Binary[] DECIMAL_VALUES = new Binary[]{DictionaryFilterTest.toBinary("-9999999999999999999999999999999999999999", 17), DictionaryFilterTest.toBinary("-9999999999999999999999999999999999999998", 17), DictionaryFilterTest.toBinary(BigInteger.valueOf(Long.MIN_VALUE).subtract(BigInteger.ONE), 17), DictionaryFilterTest.toBinary(BigInteger.valueOf(Long.MIN_VALUE), 17), DictionaryFilterTest.toBinary(BigInteger.valueOf(Long.MIN_VALUE).add(BigInteger.ONE), 17), DictionaryFilterTest.toBinary("-1", 17), DictionaryFilterTest.toBinary("0", 17), DictionaryFilterTest.toBinary(BigInteger.valueOf(Long.MAX_VALUE).subtract(BigInteger.ONE), 17), DictionaryFilterTest.toBinary(BigInteger.valueOf(Long.MAX_VALUE), 17), DictionaryFilterTest.toBinary(BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE), 17), DictionaryFilterTest.toBinary("999999999999999999999999999999999999999", 17), DictionaryFilterTest.toBinary("9999999999999999999999999999999999999998", 17), DictionaryFilterTest.toBinary("9999999999999999999999999999999999999999", 17)};
    private static final Binary[] INT96_VALUES = new Binary[]{DictionaryFilterTest.toBinary("-9999999999999999999999999999", 12), DictionaryFilterTest.toBinary("-9999999999999999999999999998", 12), DictionaryFilterTest.toBinary("-1234567890", 12), DictionaryFilterTest.toBinary("-1", 12), DictionaryFilterTest.toBinary("-0", 12), DictionaryFilterTest.toBinary("1", 12), DictionaryFilterTest.toBinary("1234567890", 12), DictionaryFilterTest.toBinary("-9999999999999999999999999998", 12), DictionaryFilterTest.toBinary("9999999999999999999999999999", 12)};
    List<ColumnChunkMetaData> ccmd;
    ParquetFileReader reader;
    DictionaryPageReadStore dictionaries;
    private Path file;
    private ParquetProperties.WriterVersion version;

    private static Binary toBinary(String decimalWithoutScale, int byteCount) {
        return DictionaryFilterTest.toBinary(new BigInteger(decimalWithoutScale), byteCount);
    }

    private static Binary toBinary(BigInteger decimalWithoutScale, int byteCount) {
        return FixedBinaryTestUtils.getFixedBinary((int)byteCount, (BigInteger)decimalWithoutScale);
    }

    private static void writeData(SimpleGroupFactory f, ParquetWriter<Group> writer) throws IOException {
        for (int i = 0; i < 1000; ++i) {
            int index = i % ALPHABET.length();
            Group group = f.newGroup().append("binary_field", ALPHABET.substring(index, index + 1)).append("single_value_field", "sharp").append("fixed_field", DECIMAL_VALUES[i % DECIMAL_VALUES.length]).append("int32_field", intValues[i % intValues.length]).append("int64_field", longValues[i % longValues.length]).append("double_field", DictionaryFilterTest.toDouble(intValues[i % intValues.length])).append("float_field", DictionaryFilterTest.toFloat(intValues[i % intValues.length])).append("plain_int32_field", i).append("fallback_binary_field", i < 500 ? ALPHABET.substring(index, index + 1) : UUID.randomUUID().toString()).append("int96_field", INT96_VALUES[i % INT96_VALUES.length]);
            if (index % 10 > 0) {
                group.append("optional_single_value_field", "sharp");
            }
            writer.write((Object)group);
        }
        writer.close();
    }

    @BeforeClass
    public static void prepareFile() throws IOException {
        DictionaryFilterTest.cleanup();
        DictionaryFilterTest.prepareFile(ParquetProperties.WriterVersion.PARQUET_1_0, FILE_V1);
        DictionaryFilterTest.prepareFile(ParquetProperties.WriterVersion.PARQUET_2_0, FILE_V2);
    }

    private static void prepareFile(ParquetProperties.WriterVersion version, Path file) throws IOException {
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        SimpleGroupFactory f = new SimpleGroupFactory(schema);
        ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)file).withWriterVersion(version)).withCompressionCodec(CompressionCodecName.GZIP)).withRowGroupSize(0x100000)).withPageSize(1024)).enableDictionaryEncoding()).withDictionaryPageSize(2048)).withConf(conf)).build();
        DictionaryFilterTest.writeData(f, (ParquetWriter<Group>)writer);
    }

    @AfterClass
    public static void cleanup() throws IOException {
        DictionaryFilterTest.deleteFile(FILE_V1);
        DictionaryFilterTest.deleteFile(FILE_V2);
    }

    private static void deleteFile(Path file) throws IOException {
        FileSystem fs = file.getFileSystem(conf);
        if (fs.exists(file)) {
            fs.delete(file, true);
        }
    }

    @Parameterized.Parameters
    public static Object[] params() {
        return new Object[]{ParquetProperties.WriterVersion.PARQUET_1_0, ParquetProperties.WriterVersion.PARQUET_2_0};
    }

    public DictionaryFilterTest(ParquetProperties.WriterVersion version) {
        this.version = version;
        switch (version) {
            case PARQUET_1_0: {
                this.file = FILE_V1;
                break;
            }
            case PARQUET_2_0: {
                this.file = FILE_V2;
            }
        }
    }

    @Before
    public void setUp() throws Exception {
        this.reader = ParquetFileReader.open((Configuration)conf, (Path)this.file);
        ParquetMetadata meta = this.reader.getFooter();
        this.ccmd = ((BlockMetaData)meta.getBlocks().get(0)).getColumns();
        this.dictionaries = this.reader.getDictionaryReader((BlockMetaData)meta.getBlocks().get(0));
    }

    @After
    public void tearDown() throws Exception {
        this.reader.close();
    }

    @Test
    public void testDictionaryEncodedColumns() throws Exception {
        switch (this.version) {
            case PARQUET_1_0: {
                this.testDictionaryEncodedColumnsV1();
                break;
            }
            case PARQUET_2_0: {
                this.testDictionaryEncodedColumnsV2();
            }
        }
    }

    private void testDictionaryEncodedColumnsV1() throws Exception {
        HashSet<String> dictionaryEncodedColumns = new HashSet<String>(Arrays.asList("binary_field", "single_value_field", "optional_single_value_field", "int32_field", "int64_field", "double_field", "float_field", "int96_field"));
        for (ColumnChunkMetaData column : this.ccmd) {
            String name = column.getPath().toDotString();
            if (dictionaryEncodedColumns.contains(name)) {
                Assert.assertTrue((String)("Column should be dictionary encoded: " + name), (boolean)column.getEncodings().contains(Encoding.PLAIN_DICTIONARY));
                Assert.assertFalse((String)("Column should not have plain data pages" + name), (boolean)column.getEncodings().contains(Encoding.PLAIN));
                continue;
            }
            Assert.assertTrue((String)("Column should have plain encoding: " + name), (boolean)column.getEncodings().contains(Encoding.PLAIN));
            if (name.startsWith("fallback")) {
                Assert.assertTrue((String)("Column should have some dictionary encoding: " + name), (boolean)column.getEncodings().contains(Encoding.PLAIN_DICTIONARY));
                continue;
            }
            Assert.assertFalse((String)("Column should have no dictionary encoding: " + name), (boolean)column.getEncodings().contains(Encoding.PLAIN_DICTIONARY));
        }
    }

    private void testDictionaryEncodedColumnsV2() throws Exception {
        HashSet<String> dictionaryEncodedColumns = new HashSet<String>(Arrays.asList("binary_field", "single_value_field", "optional_single_value_field", "fixed_field", "int32_field", "int64_field", "double_field", "float_field", "int96_field"));
        for (ColumnChunkMetaData column : this.ccmd) {
            EncodingStats encStats = column.getEncodingStats();
            String name = column.getPath().toDotString();
            if (dictionaryEncodedColumns.contains(name)) {
                Assert.assertTrue((String)("Column should have dictionary pages: " + name), (boolean)encStats.hasDictionaryPages());
                Assert.assertTrue((String)("Column should have dictionary encoded pages: " + name), (boolean)encStats.hasDictionaryEncodedPages());
                Assert.assertFalse((String)("Column should not have non-dictionary encoded pages: " + name), (boolean)encStats.hasNonDictionaryEncodedPages());
                continue;
            }
            Assert.assertTrue((String)("Column should have non-dictionary encoded pages: " + name), (boolean)encStats.hasNonDictionaryEncodedPages());
            if (name.startsWith("fallback")) {
                Assert.assertTrue((String)("Column should have dictionary pages: " + name), (boolean)encStats.hasDictionaryPages());
                Assert.assertTrue((String)("Column should have dictionary encoded pages: " + name), (boolean)encStats.hasDictionaryEncodedPages());
                continue;
            }
            Assert.assertFalse((String)("Column should not have dictionary pages: " + name), (boolean)encStats.hasDictionaryPages());
            Assert.assertFalse((String)("Column should not have dictionary encoded pages: " + name), (boolean)encStats.hasDictionaryEncodedPages());
        }
    }

    @Test
    public void testEqBinary() throws Exception {
        Operators.BinaryColumn b = FilterApi.binaryColumn((String)"binary_field");
        Operators.Eq pred = FilterApi.eq((Operators.Column)b, (Comparable)Binary.fromString((String)"c"));
        Assert.assertFalse((String)"Should not drop block for lower case letters", (boolean)DictionaryFilter.canDrop((FilterPredicate)pred, this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertTrue((String)"Should drop block for upper case letters", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)b, (Comparable)Binary.fromString((String)"A")), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop block for null", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)b, null), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
    }

    @Test
    public void testEqFixed() throws Exception {
        Operators.BinaryColumn b = FilterApi.binaryColumn((String)"fixed_field");
        if (this.version == ParquetProperties.WriterVersion.PARQUET_2_0) {
            Assert.assertTrue((String)"Should drop block for -2", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)b, (Comparable)DictionaryFilterTest.toBinary("-2", 17)), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        }
        Assert.assertFalse((String)"Should not drop block for -1", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)b, (Comparable)DictionaryFilterTest.toBinary("-1", 17)), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop block for null", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)b, null), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
    }

    @Test
    public void testEqInt96() throws Exception {
        Operators.BinaryColumn b = FilterApi.binaryColumn((String)"int96_field");
        Assert.assertFalse((String)"Should not drop block for -2", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)b, (Comparable)DictionaryFilterTest.toBinary("-2", 12)), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop block for -1", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)b, (Comparable)DictionaryFilterTest.toBinary("-1", 12)), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop block for null", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)b, null), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
    }

    @Test
    public void testNotEqBinary() throws Exception {
        Operators.BinaryColumn sharp = FilterApi.binaryColumn((String)"single_value_field");
        Operators.BinaryColumn sharpAndNull = FilterApi.binaryColumn((String)"optional_single_value_field");
        Operators.BinaryColumn b = FilterApi.binaryColumn((String)"binary_field");
        Assert.assertTrue((String)"Should drop block with only the excluded value", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)sharp, (Comparable)Binary.fromString((String)"sharp")), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop block with any other value", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)sharp, (Comparable)Binary.fromString((String)"applause")), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop block with only the excluded value and null", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)sharpAndNull, (Comparable)Binary.fromString((String)"sharp")), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop block with any other value", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)sharpAndNull, (Comparable)Binary.fromString((String)"applause")), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop block with a known value", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)b, (Comparable)Binary.fromString((String)"x")), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop block with a known value", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)b, (Comparable)Binary.fromString((String)"B")), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop block for null", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)b, null), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
    }

    @Test
    public void testLtInt() throws Exception {
        Operators.IntColumn i32 = FilterApi.intColumn((String)"int32_field");
        int lowest = Integer.MAX_VALUE;
        for (int value : intValues) {
            lowest = Math.min(lowest, value);
        }
        Assert.assertTrue((String)"Should drop: < lowest value", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.lt((Operators.Column)i32, (Comparable)Integer.valueOf(lowest)), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop: < (lowest value + 1)", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.lt((Operators.Column)i32, (Comparable)Integer.valueOf(lowest + 1)), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop: contains matching values", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.lt((Operators.Column)i32, (Comparable)Integer.valueOf(Integer.MAX_VALUE)), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
    }

    @Test
    public void testLtFixed() throws Exception {
        Operators.BinaryColumn fixed = FilterApi.binaryColumn((String)"fixed_field");
        if (this.version == ParquetProperties.WriterVersion.PARQUET_2_0) {
            Assert.assertTrue((String)"Should drop: < lowest value", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.lt((Operators.Column)fixed, (Comparable)DECIMAL_VALUES[0]), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        }
        Assert.assertFalse((String)"Should not drop: < 2nd lowest value", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.lt((Operators.Column)fixed, (Comparable)DECIMAL_VALUES[1]), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
    }

    @Test
    public void testLtEqLong() throws Exception {
        Operators.LongColumn i64 = FilterApi.longColumn((String)"int64_field");
        long lowest = Long.MAX_VALUE;
        for (long value : longValues) {
            lowest = Math.min(lowest, value);
        }
        Assert.assertTrue((String)"Should drop: <= lowest - 1", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.ltEq((Operators.Column)i64, (Comparable)Long.valueOf(lowest - 1L)), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop: <= lowest", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.ltEq((Operators.Column)i64, (Comparable)Long.valueOf(lowest)), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop: contains matching values", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.ltEq((Operators.Column)i64, (Comparable)Long.valueOf(Long.MAX_VALUE)), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
    }

    @Test
    public void testGtFloat() throws Exception {
        Operators.FloatColumn f = FilterApi.floatColumn((String)"float_field");
        float highest = Float.MIN_VALUE;
        for (int value : intValues) {
            highest = Math.max(highest, DictionaryFilterTest.toFloat(value));
        }
        Assert.assertTrue((String)"Should drop: > highest value", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.gt((Operators.Column)f, (Comparable)Float.valueOf(highest)), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop: > (highest value - 1.0)", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.gt((Operators.Column)f, (Comparable)Float.valueOf(highest - 1.0f)), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop: contains matching values", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.gt((Operators.Column)f, (Comparable)Float.valueOf(Float.MIN_VALUE)), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
    }

    @Test
    public void testGtEqDouble() throws Exception {
        Operators.DoubleColumn d = FilterApi.doubleColumn((String)"double_field");
        double highest = Double.MIN_VALUE;
        for (int value : intValues) {
            highest = Math.max(highest, DictionaryFilterTest.toDouble(value));
        }
        Assert.assertTrue((String)"Should drop: >= highest + 0.00000001", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.gtEq((Operators.Column)d, (Comparable)Double.valueOf(highest + 1.0E-8)), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop: >= highest", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.gtEq((Operators.Column)d, (Comparable)Double.valueOf(highest)), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop: contains matching values", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.gtEq((Operators.Column)d, (Comparable)Double.valueOf(Double.MIN_VALUE)), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
    }

    @Test
    public void testInBinary() throws Exception {
        Operators.BinaryColumn b = FilterApi.binaryColumn((String)"binary_field");
        HashSet<Binary> set1 = new HashSet<Binary>();
        set1.add(Binary.fromString((String)"F"));
        set1.add(Binary.fromString((String)"C"));
        set1.add(Binary.fromString((String)"h"));
        set1.add(Binary.fromString((String)"E"));
        Operators.In predIn1 = FilterApi.in((Operators.Column)b, set1);
        Operators.NotIn predNotIn1 = FilterApi.notIn((Operators.Column)b, set1);
        Assert.assertFalse((String)"Should not drop block", (boolean)DictionaryFilter.canDrop((FilterPredicate)predIn1, this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop block", (boolean)DictionaryFilter.canDrop((FilterPredicate)predNotIn1, this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        HashSet<Binary> set2 = new HashSet<Binary>();
        for (int i = 0; i < 26; ++i) {
            set2.add(Binary.fromString((String)Character.toString((char)(i + 97))));
        }
        set2.add(Binary.fromString((String)"A"));
        Operators.In predIn2 = FilterApi.in((Operators.Column)b, set2);
        Operators.NotIn predNotIn2 = FilterApi.notIn((Operators.Column)b, set2);
        Assert.assertFalse((String)"Should not drop block", (boolean)DictionaryFilter.canDrop((FilterPredicate)predIn2, this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertTrue((String)"Should not drop block", (boolean)DictionaryFilter.canDrop((FilterPredicate)predNotIn2, this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        HashSet<Binary> set3 = new HashSet<Binary>();
        set3.add(Binary.fromString((String)"F"));
        set3.add(Binary.fromString((String)"C"));
        set3.add(Binary.fromString((String)"A"));
        set3.add(Binary.fromString((String)"E"));
        Operators.In predIn3 = FilterApi.in((Operators.Column)b, set3);
        Operators.NotIn predNotIn3 = FilterApi.notIn((Operators.Column)b, set3);
        Assert.assertTrue((String)"Should drop block", (boolean)DictionaryFilter.canDrop((FilterPredicate)predIn3, this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop block", (boolean)DictionaryFilter.canDrop((FilterPredicate)predNotIn3, this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        HashSet<Object> set4 = new HashSet<Object>();
        set4.add(null);
        Operators.In predIn4 = FilterApi.in((Operators.Column)b, set4);
        Operators.NotIn predNotIn4 = FilterApi.notIn((Operators.Column)b, set4);
        Assert.assertFalse((String)"Should not drop block for null", (boolean)DictionaryFilter.canDrop((FilterPredicate)predIn4, this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop block for null", (boolean)DictionaryFilter.canDrop((FilterPredicate)predNotIn4, this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Operators.BinaryColumn sharpAndNull = FilterApi.binaryColumn((String)"optional_single_value_field");
        HashSet<Binary> set5 = new HashSet<Binary>();
        set5.add(Binary.fromString((String)"sharp"));
        Operators.NotIn predNotIn5 = FilterApi.notIn((Operators.Column)sharpAndNull, set5);
        Operators.In predIn5 = FilterApi.in((Operators.Column)sharpAndNull, set5);
        Assert.assertFalse((String)"Should not drop block", (boolean)DictionaryFilter.canDrop((FilterPredicate)predNotIn5, this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop block", (boolean)DictionaryFilter.canDrop((FilterPredicate)predIn5, this.ccmd, (DictionaryPageReadStore)this.dictionaries));
    }

    @Test
    public void testInFixed() throws Exception {
        Operators.BinaryColumn b = FilterApi.binaryColumn((String)"fixed_field");
        if (this.version == ParquetProperties.WriterVersion.PARQUET_2_0) {
            HashSet<Binary> set1 = new HashSet<Binary>();
            set1.add(DictionaryFilterTest.toBinary("-2", 17));
            set1.add(DictionaryFilterTest.toBinary("-22", 17));
            set1.add(DictionaryFilterTest.toBinary("12345", 17));
            Operators.In predIn1 = FilterApi.in((Operators.Column)b, set1);
            Operators.NotIn predNotIn1 = FilterApi.notIn((Operators.Column)b, set1);
            Assert.assertTrue((String)"Should drop block for in (-2, -22, 12345)", (boolean)DictionaryFilter.canDrop((FilterPredicate)predIn1, this.ccmd, (DictionaryPageReadStore)this.dictionaries));
            Assert.assertFalse((String)"Should not drop block for notIn (-2, -22, 12345)", (boolean)DictionaryFilter.canDrop((FilterPredicate)predNotIn1, this.ccmd, (DictionaryPageReadStore)this.dictionaries));
            HashSet<Binary> set2 = new HashSet<Binary>();
            set2.add(DictionaryFilterTest.toBinary("-1", 17));
            set2.add(DictionaryFilterTest.toBinary("0", 17));
            set2.add(DictionaryFilterTest.toBinary("12345", 17));
            Assert.assertFalse((String)"Should not drop block for in (-1, 0, 12345)", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.in((Operators.Column)b, set2), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
            Assert.assertFalse((String)"Should not drop block for in (-1, 0, 12345)", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.notIn((Operators.Column)b, set2), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        }
        HashSet<Object> set3 = new HashSet<Object>();
        set3.add(null);
        Operators.In predIn3 = FilterApi.in((Operators.Column)b, set3);
        Operators.NotIn predNotIn3 = FilterApi.notIn((Operators.Column)b, set3);
        Assert.assertFalse((String)"Should not drop block for null", (boolean)DictionaryFilter.canDrop((FilterPredicate)predIn3, this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop block for null", (boolean)DictionaryFilter.canDrop((FilterPredicate)predNotIn3, this.ccmd, (DictionaryPageReadStore)this.dictionaries));
    }

    @Test
    public void testInInt96() throws Exception {
        Operators.BinaryColumn b = FilterApi.binaryColumn((String)"int96_field");
        HashSet<Binary> set1 = new HashSet<Binary>();
        set1.add(DictionaryFilterTest.toBinary("-2", 12));
        set1.add(DictionaryFilterTest.toBinary("-0", 12));
        set1.add(DictionaryFilterTest.toBinary("12345", 12));
        Operators.In predIn1 = FilterApi.in((Operators.Column)b, set1);
        Operators.NotIn predNotIn1 = FilterApi.notIn((Operators.Column)b, set1);
        Assert.assertFalse((String)"Should not drop block for in (-2, -0, 12345)", (boolean)DictionaryFilter.canDrop((FilterPredicate)predIn1, this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop block for notIn (-2, -0, 12345)", (boolean)DictionaryFilter.canDrop((FilterPredicate)predNotIn1, this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        HashSet<Binary> set2 = new HashSet<Binary>();
        set2.add(DictionaryFilterTest.toBinary("-2", 17));
        set2.add(DictionaryFilterTest.toBinary("12345", 17));
        set2.add(DictionaryFilterTest.toBinary("-789", 17));
        Operators.In predIn2 = FilterApi.in((Operators.Column)b, set2);
        Operators.NotIn predNotIn2 = FilterApi.notIn((Operators.Column)b, set2);
        Assert.assertFalse((String)"Should not drop block for in (-2, 12345, -789)", (boolean)DictionaryFilter.canDrop((FilterPredicate)predIn2, this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop block for notIn (-2, 12345, -789)", (boolean)DictionaryFilter.canDrop((FilterPredicate)predNotIn2, this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        HashSet<Object> set3 = new HashSet<Object>();
        set3.add(null);
        Operators.In predIn3 = FilterApi.in((Operators.Column)b, set3);
        Operators.NotIn predNotIn3 = FilterApi.notIn((Operators.Column)b, set3);
        Assert.assertFalse((String)"Should not drop block for null", (boolean)DictionaryFilter.canDrop((FilterPredicate)predIn3, this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop block for null", (boolean)DictionaryFilter.canDrop((FilterPredicate)predNotIn3, this.ccmd, (DictionaryPageReadStore)this.dictionaries));
    }

    @Test
    public void testAnd() throws Exception {
        Operators.BinaryColumn col = FilterApi.binaryColumn((String)"binary_field");
        Operators.Eq B = FilterApi.eq((Operators.Column)col, (Comparable)Binary.fromString((String)"B"));
        Operators.Eq C = FilterApi.eq((Operators.Column)col, (Comparable)Binary.fromString((String)"C"));
        Operators.Eq x = FilterApi.eq((Operators.Column)col, (Comparable)Binary.fromString((String)"x"));
        Operators.Eq y = FilterApi.eq((Operators.Column)col, (Comparable)Binary.fromString((String)"y"));
        Assert.assertTrue((String)"Should drop when either predicate must be false", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.and((FilterPredicate)B, (FilterPredicate)y), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertTrue((String)"Should drop when either predicate must be false", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.and((FilterPredicate)x, (FilterPredicate)C), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertTrue((String)"Should drop when either predicate must be false", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.and((FilterPredicate)B, (FilterPredicate)C), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop when either predicate could be true", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.and((FilterPredicate)x, (FilterPredicate)y), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
    }

    @Test
    public void testOr() throws Exception {
        Operators.BinaryColumn col = FilterApi.binaryColumn((String)"binary_field");
        Operators.Eq B = FilterApi.eq((Operators.Column)col, (Comparable)Binary.fromString((String)"B"));
        Operators.Eq C = FilterApi.eq((Operators.Column)col, (Comparable)Binary.fromString((String)"C"));
        Operators.Eq x = FilterApi.eq((Operators.Column)col, (Comparable)Binary.fromString((String)"x"));
        Operators.Eq y = FilterApi.eq((Operators.Column)col, (Comparable)Binary.fromString((String)"y"));
        Assert.assertFalse((String)"Should not drop when one predicate could be true", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.or((FilterPredicate)B, (FilterPredicate)y), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop when one predicate could be true", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.or((FilterPredicate)x, (FilterPredicate)C), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertTrue((String)"Should drop when both predicates must be false", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.or((FilterPredicate)B, (FilterPredicate)C), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop when one predicate could be true", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.or((FilterPredicate)x, (FilterPredicate)y), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
    }

    @Test
    public void testUdp() throws Exception {
        InInt32UDP dropabble = new InInt32UDP((Set<Integer>)ImmutableSet.of((Object)42));
        InInt32UDP undroppable = new InInt32UDP((Set<Integer>)ImmutableSet.of((Object)205));
        Assert.assertTrue((String)"Should drop block for non-matching UDP", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.userDefined((Operators.Column)FilterApi.intColumn((String)"int32_field"), (UserDefinedPredicate)dropabble), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop block for matching UDP", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.userDefined((Operators.Column)FilterApi.intColumn((String)"int32_field"), (UserDefinedPredicate)undroppable), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
    }

    @Test
    public void testInverseUdp() throws Exception {
        InInt32UDP droppable = new InInt32UDP((Set<Integer>)ImmutableSet.of((Object)42));
        InInt32UDP undroppable = new InInt32UDP((Set<Integer>)ImmutableSet.of((Object)205));
        ImmutableSet allValues = ImmutableSet.copyOf((Collection)Ints.asList((int[])intValues));
        InInt32UDP completeMatch = new InInt32UDP((Set<Integer>)allValues);
        FilterPredicate inverse = LogicalInverseRewriter.rewrite((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.userDefined((Operators.Column)FilterApi.intColumn((String)"int32_field"), (UserDefinedPredicate)droppable)));
        FilterPredicate inverse1 = LogicalInverseRewriter.rewrite((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.userDefined((Operators.Column)FilterApi.intColumn((String)"int32_field"), (UserDefinedPredicate)undroppable)));
        FilterPredicate inverse2 = LogicalInverseRewriter.rewrite((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.userDefined((Operators.Column)FilterApi.intColumn((String)"int32_field"), (UserDefinedPredicate)completeMatch)));
        Assert.assertFalse((String)"Should not drop block for inverse of non-matching UDP", (boolean)DictionaryFilter.canDrop((FilterPredicate)inverse, this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop block for inverse of UDP with some matches", (boolean)DictionaryFilter.canDrop((FilterPredicate)inverse1, this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertTrue((String)"Should drop block for inverse of UDP with all matches", (boolean)DictionaryFilter.canDrop((FilterPredicate)inverse2, this.ccmd, (DictionaryPageReadStore)this.dictionaries));
    }

    @Test
    public void testColumnWithoutDictionary() throws Exception {
        Operators.IntColumn plain = FilterApi.intColumn((String)"plain_int32_field");
        DictionaryPageReadStore dictionaryStore = (DictionaryPageReadStore)Mockito.mock(DictionaryPageReadStore.class);
        Assert.assertFalse((String)"Should never drop block using plain encoding", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)plain, (Comparable)Integer.valueOf(-10)), this.ccmd, (DictionaryPageReadStore)dictionaryStore));
        Assert.assertFalse((String)"Should never drop block using plain encoding", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.lt((Operators.Column)plain, (Comparable)Integer.valueOf(-10)), this.ccmd, (DictionaryPageReadStore)dictionaryStore));
        Assert.assertFalse((String)"Should never drop block using plain encoding", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.ltEq((Operators.Column)plain, (Comparable)Integer.valueOf(-10)), this.ccmd, (DictionaryPageReadStore)dictionaryStore));
        Assert.assertFalse((String)"Should never drop block using plain encoding", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.gt((Operators.Column)plain, (Comparable)Integer.valueOf(1010)), this.ccmd, (DictionaryPageReadStore)dictionaryStore));
        Assert.assertFalse((String)"Should never drop block using plain encoding", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.gtEq((Operators.Column)plain, (Comparable)Integer.valueOf(1010)), this.ccmd, (DictionaryPageReadStore)dictionaryStore));
        Assert.assertFalse((String)"Should never drop block using plain encoding", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)plain, (Comparable)Integer.valueOf(1010)), this.ccmd, (DictionaryPageReadStore)dictionaryStore));
        Mockito.verifyZeroInteractions((Object[])new Object[]{dictionaryStore});
    }

    @Test
    public void testColumnWithDictionaryAndPlainEncodings() throws Exception {
        Operators.IntColumn plain = FilterApi.intColumn((String)"fallback_binary_field");
        DictionaryPageReadStore dictionaryStore = (DictionaryPageReadStore)Mockito.mock(DictionaryPageReadStore.class);
        Assert.assertFalse((String)"Should never drop block using plain encoding", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)plain, (Comparable)Integer.valueOf(-10)), this.ccmd, (DictionaryPageReadStore)dictionaryStore));
        Assert.assertFalse((String)"Should never drop block using plain encoding", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.lt((Operators.Column)plain, (Comparable)Integer.valueOf(-10)), this.ccmd, (DictionaryPageReadStore)dictionaryStore));
        Assert.assertFalse((String)"Should never drop block using plain encoding", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.ltEq((Operators.Column)plain, (Comparable)Integer.valueOf(-10)), this.ccmd, (DictionaryPageReadStore)dictionaryStore));
        Assert.assertFalse((String)"Should never drop block using plain encoding", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.gt((Operators.Column)plain, (Comparable)Integer.valueOf(1010)), this.ccmd, (DictionaryPageReadStore)dictionaryStore));
        Assert.assertFalse((String)"Should never drop block using plain encoding", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.gtEq((Operators.Column)plain, (Comparable)Integer.valueOf(1010)), this.ccmd, (DictionaryPageReadStore)dictionaryStore));
        Assert.assertFalse((String)"Should never drop block using plain encoding", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)plain, (Comparable)Integer.valueOf(1010)), this.ccmd, (DictionaryPageReadStore)dictionaryStore));
        Mockito.verifyZeroInteractions((Object[])new Object[]{dictionaryStore});
    }

    @Test
    public void testEqMissingColumn() throws Exception {
        Operators.BinaryColumn b = FilterApi.binaryColumn((String)"missing_column");
        Assert.assertTrue((String)"Should drop block for non-null query", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)b, (Comparable)Binary.fromString((String)"any")), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop block null query", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)b, null), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
    }

    @Test
    public void testNotEqMissingColumn() throws Exception {
        Operators.BinaryColumn b = FilterApi.binaryColumn((String)"missing_column");
        Assert.assertFalse((String)"Should not drop block for non-null query", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)b, (Comparable)Binary.fromString((String)"any")), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertTrue((String)"Should not drop block null query", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)b, null), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
    }

    @Test
    public void testLtMissingColumn() throws Exception {
        Operators.BinaryColumn b = FilterApi.binaryColumn((String)"missing_column");
        Assert.assertTrue((String)"Should drop block for any non-null query", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.lt((Operators.Column)b, (Comparable)Binary.fromString((String)"any")), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
    }

    @Test
    public void testLtEqMissingColumn() throws Exception {
        Operators.BinaryColumn b = FilterApi.binaryColumn((String)"missing_column");
        Assert.assertTrue((String)"Should drop block for any non-null query", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.ltEq((Operators.Column)b, (Comparable)Binary.fromString((String)"any")), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
    }

    @Test
    public void testGtMissingColumn() throws Exception {
        Operators.BinaryColumn b = FilterApi.binaryColumn((String)"missing_column");
        Assert.assertTrue((String)"Should drop block for any non-null query", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.gt((Operators.Column)b, (Comparable)Binary.fromString((String)"any")), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
    }

    @Test
    public void testGtEqMissingColumn() throws Exception {
        Operators.BinaryColumn b = FilterApi.binaryColumn((String)"missing_column");
        Assert.assertTrue((String)"Should drop block for any non-null query", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.gtEq((Operators.Column)b, (Comparable)Binary.fromString((String)"any")), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
    }

    @Test
    public void testUdpMissingColumn() throws Exception {
        InInt32UDP nullRejecting = new InInt32UDP((Set<Integer>)ImmutableSet.of((Object)42));
        InInt32UDP nullAccepting = new InInt32UDP(Sets.newHashSet((Object[])new Integer[]{null}));
        Operators.IntColumn fake = FilterApi.intColumn((String)"missing_column");
        Assert.assertTrue((String)"Should drop block for null rejecting udp", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.userDefined((Operators.Column)fake, (UserDefinedPredicate)nullRejecting), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop block for null accepting udp", (boolean)DictionaryFilter.canDrop((FilterPredicate)FilterApi.userDefined((Operators.Column)fake, (UserDefinedPredicate)nullAccepting), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
    }

    @Test
    public void testInverseUdpMissingColumn() throws Exception {
        InInt32UDP nullRejecting = new InInt32UDP((Set<Integer>)ImmutableSet.of((Object)42));
        InInt32UDP nullAccepting = new InInt32UDP(Sets.newHashSet((Object[])new Integer[]{null}));
        Operators.IntColumn fake = FilterApi.intColumn((String)"missing_column");
        Assert.assertTrue((String)"Should drop block for null accepting udp", (boolean)DictionaryFilter.canDrop((FilterPredicate)LogicalInverseRewriter.rewrite((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.userDefined((Operators.Column)fake, (UserDefinedPredicate)nullAccepting))), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
        Assert.assertFalse((String)"Should not drop block for null rejecting udp", (boolean)DictionaryFilter.canDrop((FilterPredicate)LogicalInverseRewriter.rewrite((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.userDefined((Operators.Column)fake, (UserDefinedPredicate)nullRejecting))), this.ccmd, (DictionaryPageReadStore)this.dictionaries));
    }

    private static double toDouble(int value) {
        return (double)value * 1.0;
    }

    private static float toFloat(int value) {
        return (float)((double)value * 2.0);
    }

    private static final class InInt32UDP
    extends UserDefinedPredicate<Integer>
    implements Serializable {
        private final Set<Integer> ints;

        InInt32UDP(Set<Integer> ints) {
            this.ints = ints;
        }

        public boolean keep(Integer value) {
            return this.ints.contains(value);
        }

        public boolean canDrop(Statistics<Integer> statistics) {
            return false;
        }

        public boolean inverseCanDrop(Statistics<Integer> statistics) {
            return false;
        }
    }
}

