/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;
import org.junit.Assert;
import org.junit.Test;

public class TestParquetReaderEmptyBlock {
    private static final Path EMPTY_BLOCK_FILE_1 = TestParquetReaderEmptyBlock.createPathFromCP("/test-empty-row-group_1.parquet");
    private static final Path EMPTY_BLOCK_FILE_2 = TestParquetReaderEmptyBlock.createPathFromCP("/test-empty-row-group_2.parquet");
    private static final Path EMPTY_BLOCK_FILE_3 = TestParquetReaderEmptyBlock.createPathFromCP("/test-empty-row-group_3.parquet");

    private static Path createPathFromCP(String path) {
        try {
            return new Path(TestParquetReaderEmptyBlock.class.getResource(path).toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testReadOnlyEmptyBlock() throws IOException {
        Configuration conf = new Configuration();
        ParquetReadOptions options = ParquetReadOptions.builder().build();
        HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)EMPTY_BLOCK_FILE_1, (Configuration)conf);
        ParquetMetadata readFooter = ParquetFileReader.readFooter((InputFile)inputFile, (ParquetReadOptions)options, (SeekableInputStream)inputFile.newStream());
        Assert.assertEquals((long)1L, (long)readFooter.getBlocks().size());
        try (ParquetFileReader r = new ParquetFileReader((InputFile)inputFile, options);){
            Assert.assertNull((Object)r.readNextRowGroup());
        }
        FilterCompat.Filter filter = FilterCompat.get((FilterPredicate)FilterApi.gt((Operators.Column)FilterApi.intColumn((String)"a"), (Comparable)Integer.valueOf(1)));
        ParquetReadOptions filterOptions = ParquetReadOptions.builder().copy(options).withRecordFilter(filter).useStatsFilter(true).build();
        try (ParquetFileReader r = new ParquetFileReader((InputFile)inputFile, filterOptions);){
            Assert.assertNull((Object)r.readNextFilteredRowGroup());
        }
    }

    @Test
    public void testSkipEmptyBlock() throws IOException {
        Configuration conf = new Configuration();
        ParquetReadOptions options = ParquetReadOptions.builder().build();
        HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)EMPTY_BLOCK_FILE_2, (Configuration)conf);
        ParquetMetadata readFooter = ParquetFileReader.readFooter((InputFile)inputFile, (ParquetReadOptions)options, (SeekableInputStream)inputFile.newStream());
        Assert.assertEquals((long)3L, (long)readFooter.getBlocks().size());
        try (ParquetFileReader r = new ParquetFileReader((InputFile)inputFile, options);){
            PageReadStore pages = null;
            pages = r.readNextRowGroup();
            Assert.assertNotNull((Object)pages);
            Assert.assertEquals((long)1L, (long)pages.getRowCount());
            pages = r.readNextRowGroup();
            Assert.assertNotNull((Object)pages);
            Assert.assertEquals((long)3L, (long)pages.getRowCount());
            pages = r.readNextRowGroup();
            Assert.assertNull((Object)pages);
        }
        FilterCompat.Filter filter = FilterCompat.get((FilterPredicate)FilterApi.gt((Operators.Column)FilterApi.intColumn((String)"a"), (Comparable)Integer.valueOf(1)));
        ParquetReadOptions filterOptions = ParquetReadOptions.builder().copy(options).withRecordFilter(filter).useStatsFilter(true).build();
        try (ParquetFileReader r = new ParquetFileReader((InputFile)inputFile, filterOptions);){
            PageReadStore pages = null;
            pages = r.readNextFilteredRowGroup();
            Assert.assertNotNull((Object)pages);
            Assert.assertEquals((long)3L, (long)pages.getRowCount());
            pages = r.readNextFilteredRowGroup();
            Assert.assertNull((Object)pages);
        }
    }

    @Test
    public void testSkipEmptyBlocksNextToEachOther() throws IOException {
        Configuration conf = new Configuration();
        ParquetReadOptions options = ParquetReadOptions.builder().build();
        HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)EMPTY_BLOCK_FILE_3, (Configuration)conf);
        ParquetMetadata readFooter = ParquetFileReader.readFooter((InputFile)inputFile, (ParquetReadOptions)options, (SeekableInputStream)inputFile.newStream());
        Assert.assertEquals((long)4L, (long)readFooter.getBlocks().size());
        try (ParquetFileReader r = new ParquetFileReader((InputFile)inputFile, options);){
            PageReadStore pages = null;
            pages = r.readNextRowGroup();
            Assert.assertNotNull((Object)pages);
            Assert.assertEquals((long)1L, (long)pages.getRowCount());
            pages = r.readNextRowGroup();
            Assert.assertNotNull((Object)pages);
            Assert.assertEquals((long)4L, (long)pages.getRowCount());
            pages = r.readNextRowGroup();
            Assert.assertNull((Object)pages);
        }
        FilterCompat.Filter filter = FilterCompat.get((FilterPredicate)FilterApi.gt((Operators.Column)FilterApi.intColumn((String)"a"), (Comparable)Integer.valueOf(1)));
        ParquetReadOptions filterOptions = ParquetReadOptions.builder().copy(options).withRecordFilter(filter).useStatsFilter(true).build();
        try (ParquetFileReader r = new ParquetFileReader((InputFile)inputFile, filterOptions);){
            PageReadStore pages = null;
            pages = r.readNextFilteredRowGroup();
            Assert.assertNotNull((Object)pages);
            Assert.assertEquals((long)4L, (long)pages.getRowCount());
            pages = r.readNextFilteredRowGroup();
            Assert.assertNull((Object)pages);
        }
    }
}

