/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.crypto.propertiesfactory;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.conf.HadoopParquetConfiguration;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.crypto.ParquetCipher;
import org.apache.parquet.crypto.propertiesfactory.SchemaCryptoPropertiesFactory;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroup;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaControlEncryptionTest {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaControlEncryptionTest.class);
    private static final int numRecord = 1000;
    private Random rnd = new Random(5L);
    private Map<String, Map<String, Object>> cryptoMetadata = new HashMap<String, Map<String, Object>>();
    private Map<String, Object[]> testData = new HashMap<String, Object[]>();

    @Before
    public void generateTestData() {
        String[] names = new String[1000];
        Long[] ages = new Long[1000];
        String[] linkedInWebs = new String[1000];
        String[] twitterWebs = new String[1000];
        for (int i = 0; i < 1000; ++i) {
            names[i] = this.getString();
            ages[i] = SchemaControlEncryptionTest.getLong();
            linkedInWebs[i] = this.getString();
            twitterWebs[i] = this.getString();
        }
        this.testData.put("Name", names);
        this.testData.put("Age", ages);
        this.testData.put("LinkedIn", linkedInWebs);
        this.testData.put("Twitter", twitterWebs);
    }

    @Test
    public void testEncryptionDefault() throws Exception {
        Configuration conf = new Configuration();
        this.runTest(conf);
    }

    @Test
    public void testEncryptionGcm() throws Exception {
        Configuration conf = new Configuration();
        conf.set("parquet.encryption.algorithm", ParquetCipher.AES_GCM_V1.toString());
        this.runTest(conf);
    }

    @Test
    public void testEncryptionGcmCtr() throws Exception {
        Configuration conf = new Configuration();
        conf.set("parquet.encryption.algorithm", ParquetCipher.AES_GCM_CTR_V1.toString());
        this.runTest(conf);
    }

    @Test
    public void testEncryptionWithFooter() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("parquet.encrypt.footer", true);
        this.runTest(conf);
    }

    private void runTest(Configuration conf) throws Exception {
        conf.set("parquet.crypto.factory.class", SchemaCryptoPropertiesFactory.class.getName());
        String file = SchemaControlEncryptionTest.createTempFile("test");
        this.markEncryptColumns();
        this.encryptParquetFile(file, conf);
        this.decryptParquetFileAndValid(file, conf);
    }

    private void markEncryptColumns() {
        HashMap<String, String> ageMetadata = new HashMap<String, String>();
        ageMetadata.put("columnKeyMetaData", "age_key_id");
        this.cryptoMetadata.put("Age", ageMetadata);
        HashMap<String, String> linkMetadata = new HashMap<String, String>();
        linkMetadata.put("columnKeyMetaData", "link_key_id");
        this.cryptoMetadata.put("LinkedIn", linkMetadata);
    }

    private String encryptParquetFile(String file, Configuration conf) throws IOException {
        MessageType schema = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Name"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "Age"), new GroupType(Type.Repetition.OPTIONAL, "WebLinks", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "LinkedIn"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Twitter")})});
        conf.set("parquet.example.schema", schema.toString());
        Path path = new Path(file);
        Builder builder = new Builder(path);
        builder.withConf(conf);
        try (ParquetWriter writer = builder.build();){
            for (int i = 0; i < 1000; ++i) {
                SimpleGroup g = new SimpleGroup((GroupType)schema);
                g.add("Name", (String)this.testData.get("Name")[i]);
                g.add("Age", ((Long)this.testData.get("Age")[i]).longValue());
                Group links = g.addGroup("WebLinks");
                links.add(0, (String)this.testData.get("LinkedIn")[i]);
                links.add(1, (String)this.testData.get("Twitter")[i]);
                writer.write((Object)g);
            }
        }
        return file;
    }

    private void decryptParquetFileAndValid(String file, Configuration conf) throws IOException {
        ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)new Path(file)).withConf(conf).build();
        for (int i = 0; i < 1000; ++i) {
            Group group = (Group)reader.read();
            Assert.assertEquals((Object)this.testData.get("Name")[i], (Object)group.getBinary("Name", 0).toStringUsingUTF8());
            Assert.assertEquals((Object)this.testData.get("Age")[i], (Object)group.getLong("Age", 0));
            Group subGroup = group.getGroup("WebLinks", 0);
            Assert.assertArrayEquals((byte[])subGroup.getBinary("LinkedIn", 0).getBytes(), (byte[])((String)this.testData.get("LinkedIn")[i]).getBytes());
            Assert.assertArrayEquals((byte[])subGroup.getBinary("Twitter", 0).getBytes(), (byte[])((String)this.testData.get("Twitter")[i]).getBytes());
        }
        reader.close();
    }

    private static String createTempFile(String prefix) {
        try {
            return Files.createTempDirectory(prefix, new FileAttribute[0]).toAbsolutePath().toString() + "/test.parquet";
        }
        catch (IOException e) {
            throw new AssertionError("Unable to create temporary file", e);
        }
    }

    private static long getLong() {
        return ThreadLocalRandom.current().nextLong(1000L);
    }

    private String getString() {
        char[] chars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'x', 'z', 'y'};
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            sb.append(chars[this.rnd.nextInt(10)]);
        }
        return sb.toString();
    }

    public class Builder
    extends ParquetWriter.Builder<Group, Builder> {
        private Builder(Path file) {
            super(file);
        }

        protected Builder self() {
            return this;
        }

        protected WriteSupport<Group> getWriteSupport(Configuration conf) {
            return this.getWriteSupport((ParquetConfiguration)null);
        }

        protected WriteSupport<Group> getWriteSupport(ParquetConfiguration conf) {
            return new CryptoGroupWriteSupport();
        }
    }

    private class CryptoGroupWriteSupport
    extends GroupWriteSupport {
        public WriteSupport.WriteContext init(Configuration conf) {
            return this.init((ParquetConfiguration)new HadoopParquetConfiguration(conf));
        }

        public WriteSupport.WriteContext init(ParquetConfiguration conf) {
            WriteSupport.WriteContext writeContext = super.init(conf);
            MessageType schema = writeContext.getSchema();
            List columns = schema.getColumns();
            if (LOG.isDebugEnabled()) {
                LOG.debug("There are " + columns.size() + " columns");
            }
            for (ColumnDescriptor column : columns) {
                this.setMetadata(column, conf);
            }
            return writeContext;
        }

        private void setMetadata(ColumnDescriptor column, Configuration conf) {
            this.setMetadata(column, (ParquetConfiguration)new HadoopParquetConfiguration(conf));
        }

        private void setMetadata(ColumnDescriptor column, ParquetConfiguration conf) {
            String columnShortName = column.getPath()[column.getPath().length - 1];
            if (SchemaControlEncryptionTest.this.cryptoMetadata.containsKey(columnShortName) && ((Map)SchemaControlEncryptionTest.this.cryptoMetadata.get(columnShortName)).get("columnKeyMetaData") != null) {
                String columnKey = String.join((CharSequence)".", column.getPath());
                conf.set("column_encryption_1178_" + columnKey, ((Map)SchemaControlEncryptionTest.this.cryptoMetadata.get(columnShortName)).get("columnKeyMetaData").toString());
            }
        }
    }
}

