/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroup;
import org.apache.parquet.hadoop.InterOpTester;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.junit.Assert;
import org.junit.Test;

public class TestInterOpReadByteStreamSplit {
    private static final String FLOATS_FILE = "byte_stream_split.zstd.parquet";
    private static final String EXTENDED_FILE = "byte_stream_split_extended.gzip.parquet";
    private static final String CHANGESET = "74278bc";
    private final InterOpTester interop = new InterOpTester();

    @Test
    public void testReadFloats() throws IOException {
        Path floatsFile = this.interop.GetInterOpFile(FLOATS_FILE, CHANGESET);
        int expectRows = 300;
        try (ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)floatsFile).build();){
            block15: for (int i = 0; i < 300; ++i) {
                Group group = (Group)reader.read();
                Assert.assertNotNull((Object)group);
                float fval = group.getFloat("f32", 0);
                double dval = group.getDouble("f64", 0);
                Assert.assertTrue(((double)Math.abs(fval) < 4.0 ? 1 : 0) != 0);
                Assert.assertTrue((Math.abs(dval) < 4.0 ? 1 : 0) != 0);
                switch (i) {
                    case 0: {
                        Assert.assertEquals((double)1.764052391052246, (double)fval, (double)0.0);
                        Assert.assertEquals((double)-1.3065268517353166, (double)dval, (double)0.0);
                        continue block15;
                    }
                    case 1: {
                        Assert.assertEquals((double)0.4001572f, (double)fval, (double)0.0);
                        Assert.assertEquals((double)1.658130679618188, (double)dval, (double)0.0);
                        continue block15;
                    }
                    case 298: {
                        Assert.assertEquals((double)-0.39944902062416077, (double)fval, (double)0.0);
                        Assert.assertEquals((double)-0.9301565025243212, (double)dval, (double)0.0);
                        continue block15;
                    }
                    case 299: {
                        Assert.assertEquals((double)0.3700558841228485, (double)fval, (double)0.0);
                        Assert.assertEquals((double)-0.17858909208732915, (double)dval, (double)0.0);
                    }
                }
            }
            Assert.assertNull((Object)reader.read());
        }
    }

    private void compareColumnValues(Path path, int expectRows, String leftCol, String rightCol) throws IOException {
        try (ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)path).build();){
            for (int i = 0; i < expectRows; ++i) {
                SimpleGroup group = (SimpleGroup)reader.read();
                Assert.assertNotNull((Object)group);
                Object left = group.getObject(leftCol, 0);
                Object right = group.getObject(rightCol, 0);
                Assert.assertEquals((Object)left, (Object)right);
            }
            Assert.assertNull((Object)reader.read());
        }
    }

    @Test
    public void testReadAllSupportedTypes() throws IOException {
        Path extendedFile = this.interop.GetInterOpFile(EXTENDED_FILE, CHANGESET);
        int expectRows = 200;
        this.compareColumnValues(extendedFile, 200, "float_plain", "float_byte_stream_split");
        this.compareColumnValues(extendedFile, 200, "double_plain", "double_byte_stream_split");
        this.compareColumnValues(extendedFile, 200, "int32_plain", "int32_byte_stream_split");
        this.compareColumnValues(extendedFile, 200, "int64_plain", "int64_byte_stream_split");
        this.compareColumnValues(extendedFile, 200, "float16_plain", "float16_byte_stream_split");
        this.compareColumnValues(extendedFile, 200, "flba5_plain", "flba5_byte_stream_split");
        this.compareColumnValues(extendedFile, 200, "decimal_plain", "decimal_byte_stream_split");
    }
}

