/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.statistics;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.Preconditions;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.internal.column.columnindex.ColumnIndex;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestFloat16ReadWriteRoundTrip {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private Binary[] valuesInAscendingOrder = new Binary[]{Binary.fromConstantByteArray((byte[])new byte[]{0, -4}), Binary.fromConstantByteArray((byte[])new byte[]{0, -64}), Binary.fromConstantByteArray((byte[])new byte[]{-1, 123}), Binary.fromConstantByteArray((byte[])new byte[]{0, -128}), Binary.fromConstantByteArray((byte[])new byte[]{0, 0}), Binary.fromConstantByteArray((byte[])new byte[]{1, 0}), Binary.fromConstantByteArray((byte[])new byte[]{-1, 123}), Binary.fromConstantByteArray((byte[])new byte[]{0, 124})};
    private Binary[] valuesInDescendingOrder = new Binary[]{Binary.fromConstantByteArray((byte[])new byte[]{0, 124}), Binary.fromConstantByteArray((byte[])new byte[]{-1, 123}), Binary.fromConstantByteArray((byte[])new byte[]{1, 0}), Binary.fromConstantByteArray((byte[])new byte[]{0, 0}), Binary.fromConstantByteArray((byte[])new byte[]{0, -128}), Binary.fromConstantByteArray((byte[])new byte[]{-1, 123}), Binary.fromConstantByteArray((byte[])new byte[]{0, -64}), Binary.fromConstantByteArray((byte[])new byte[]{0, -4})};
    private Binary[] valuesUndefinedOrder = new Binary[]{Binary.fromConstantByteArray((byte[])new byte[]{-1, 123}), Binary.fromConstantByteArray((byte[])new byte[]{0, 124}), Binary.fromConstantByteArray((byte[])new byte[]{0, -128}), Binary.fromConstantByteArray((byte[])new byte[]{1, 0}), Binary.fromConstantByteArray((byte[])new byte[]{0, 0}), Binary.fromConstantByteArray((byte[])new byte[]{0, -64}), Binary.fromConstantByteArray((byte[])new byte[]{-1, 123}), Binary.fromConstantByteArray((byte[])new byte[]{0, -4})};
    private Binary[] valuesAllPositiveZero = new Binary[]{Binary.fromConstantByteArray((byte[])new byte[]{0, 0}), Binary.fromConstantByteArray((byte[])new byte[]{0, 0}), Binary.fromConstantByteArray((byte[])new byte[]{0, 0}), Binary.fromConstantByteArray((byte[])new byte[]{0, 0})};
    private Binary[] valuesAllNegativeZero = new Binary[]{Binary.fromConstantByteArray((byte[])new byte[]{0, -128}), Binary.fromConstantByteArray((byte[])new byte[]{0, -128}), Binary.fromConstantByteArray((byte[])new byte[]{0, -128}), Binary.fromConstantByteArray((byte[])new byte[]{0, -128})};
    private Binary[] valuesWithNaN = new Binary[]{Binary.fromConstantByteArray((byte[])new byte[]{0, -64}), Binary.fromConstantByteArray((byte[])new byte[]{-1, 123}), Binary.fromConstantByteArray((byte[])new byte[]{1, 0}), Binary.fromConstantByteArray((byte[])new byte[]{0, 126})};
    private Binary[] valuesInAscendingOrderMinMax = new Binary[]{Binary.fromConstantByteArray((byte[])new byte[]{0, -4}), Binary.fromConstantByteArray((byte[])new byte[]{0, 124})};
    private Binary[] valuesInDescendingOrderMinMax = new Binary[]{Binary.fromConstantByteArray((byte[])new byte[]{0, -4}), Binary.fromConstantByteArray((byte[])new byte[]{0, 124})};
    private Binary[] valuesUndefinedOrderMinMax = new Binary[]{Binary.fromConstantByteArray((byte[])new byte[]{0, -4}), Binary.fromConstantByteArray((byte[])new byte[]{0, 124})};
    private Binary[] valuesAllPositiveZeroMinMax = new Binary[]{Binary.fromConstantByteArray((byte[])new byte[]{0, 0}), Binary.fromConstantByteArray((byte[])new byte[]{0, 0})};
    private Binary[] valuesAllNegativeZeroMinMax = new Binary[]{Binary.fromConstantByteArray((byte[])new byte[]{0, -128}), Binary.fromConstantByteArray((byte[])new byte[]{0, -128})};
    private Binary[] valuesWithNaNMinMax = new Binary[]{Binary.fromConstantByteArray((byte[])new byte[]{0, -64}), Binary.fromConstantByteArray((byte[])new byte[]{0, 126})};

    @Test
    public void testFloat16ColumnIndex() throws IOException {
        List testValues = Arrays.asList(this.valuesInAscendingOrder, this.valuesInDescendingOrder, this.valuesUndefinedOrder, this.valuesAllPositiveZero, this.valuesAllNegativeZero, this.valuesWithNaN);
        List expectedValues = Arrays.asList(this.valuesInAscendingOrderMinMax, this.valuesInDescendingOrderMinMax, this.valuesUndefinedOrderMinMax, this.valuesAllPositiveZeroMinMax, this.valuesAllNegativeZeroMinMax, this.valuesWithNaNMinMax);
        for (int i = 0; i < testValues.size(); ++i) {
            MessageType schema = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.float16Type())).length(2)).named("col_float16")).named("msg");
            Configuration conf = new Configuration();
            GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
            SimpleGroupFactory factory = new SimpleGroupFactory(schema);
            Path path = this.newTempPath();
            try (ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)path).withConf(conf)).withDictionaryEncoding(false)).build();){
                for (Binary value : (Binary[])testValues.get(i)) {
                    writer.write((Object)factory.newGroup().append("col_float16", value));
                }
            }
            var9_9 = null;
            try (ParquetFileReader reader = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)path, (Configuration)new Configuration()));){
                ColumnChunkMetaData column = (ColumnChunkMetaData)((BlockMetaData)reader.getFooter().getBlocks().get(0)).getColumns().get(0);
                ColumnIndex index = reader.readColumnIndex(column);
                Assert.assertEquals(Collections.singletonList(((Binary[])expectedValues.get(i))[0]), TestFloat16ReadWriteRoundTrip.toFloat16List(index.getMinValues()));
                Assert.assertEquals(Collections.singletonList(((Binary[])expectedValues.get(i))[1]), TestFloat16ReadWriteRoundTrip.toFloat16List(index.getMaxValues()));
                continue;
            }
            catch (Throwable throwable) {
                var9_9 = throwable;
                throw throwable;
            }
        }
    }

    private Path newTempPath() throws IOException {
        File file = this.temp.newFile();
        Preconditions.checkArgument((boolean)file.delete(), (String)"Could not remove temp file");
        return new Path(file.getAbsolutePath());
    }

    private static List<Binary> toFloat16List(List<ByteBuffer> buffers) {
        return buffers.stream().map(buffer -> Binary.fromConstantByteArray((byte[])buffer.array())).collect(Collectors.toList());
    }
}

