/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.crypto.keytools.mocks;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.crypto.KeyAccessDeniedException;
import org.apache.parquet.crypto.ParquetCryptoRuntimeException;
import org.apache.parquet.crypto.keytools.KeyToolkit;
import org.apache.parquet.crypto.keytools.KmsClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryKMS
implements KmsClient {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryKMS.class);
    public static final String KEY_LIST_PROPERTY_NAME = "parquet.encryption.key.list";
    public static final String NEW_KEY_LIST_PROPERTY_NAME = "parquet.encryption.new.key.list";
    private static Map<String, byte[]> masterKeyMap;
    private static Map<String, byte[]> newMasterKeyMap;

    public static synchronized void startKeyRotation(Configuration hadoopConfiguration) {
        String[] newMasterKeys = hadoopConfiguration.getTrimmedStrings(NEW_KEY_LIST_PROPERTY_NAME);
        if (null == newMasterKeys || newMasterKeys.length == 0) {
            throw new ParquetCryptoRuntimeException("No encryption key list");
        }
        newMasterKeyMap = InMemoryKMS.parseKeyList(newMasterKeys);
    }

    public static synchronized void finishKeyRotation() {
        masterKeyMap = newMasterKeyMap;
    }

    public synchronized void initialize(Configuration configuration, String kmsInstanceID, String kmsInstanceURL, String accessToken) {
        String[] masterKeys = configuration.getTrimmedStrings(KEY_LIST_PROPERTY_NAME);
        if (null == masterKeys || masterKeys.length == 0) {
            throw new ParquetCryptoRuntimeException("No encryption key list");
        }
        masterKeyMap = InMemoryKMS.parseKeyList(masterKeys);
        newMasterKeyMap = masterKeyMap;
    }

    private static Map<String, byte[]> parseKeyList(String[] masterKeys) {
        HashMap<String, byte[]> keyMap = new HashMap<String, byte[]>();
        int nKeys = masterKeys.length;
        for (int i = 0; i < nKeys; ++i) {
            String[] parts = masterKeys[i].split(":");
            String keyName = parts[0].trim();
            if (parts.length != 2) {
                throw new IllegalArgumentException("Key '" + keyName + "' is not formatted correctly");
            }
            String key = parts[1].trim();
            try {
                byte[] keyBytes = Base64.getDecoder().decode(key);
                keyMap.put(keyName, keyBytes);
                continue;
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Could not decode key '" + keyName + "'!");
                throw e;
            }
        }
        return keyMap;
    }

    public synchronized String wrapKey(byte[] keyBytes, String masterKeyIdentifier) throws KeyAccessDeniedException, UnsupportedOperationException {
        byte[] masterKey = newMasterKeyMap.get(masterKeyIdentifier);
        if (null == masterKey) {
            throw new ParquetCryptoRuntimeException("Key not found: " + masterKeyIdentifier);
        }
        byte[] AAD = masterKeyIdentifier.getBytes(StandardCharsets.UTF_8);
        return KeyToolkit.encryptKeyLocally((byte[])keyBytes, (byte[])masterKey, (byte[])AAD);
    }

    public synchronized byte[] unwrapKey(String wrappedKey, String masterKeyIdentifier) throws KeyAccessDeniedException, UnsupportedOperationException {
        byte[] masterKey = masterKeyMap.get(masterKeyIdentifier);
        if (null == masterKey) {
            throw new ParquetCryptoRuntimeException("Key not found: " + masterKeyIdentifier);
        }
        byte[] AAD = masterKeyIdentifier.getBytes(StandardCharsets.UTF_8);
        return KeyToolkit.decryptKeyLocally((String)wrappedKey, (byte[])masterKey, (byte[])AAD);
    }
}

