/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.IOException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterOpTester {
    private static final String PARQUET_TESTING_REPO = "https://github.com/apache/parquet-testing/raw/";
    private static final String PARQUET_TESTING_PATH = "target/parquet-testing/";
    private static final Logger LOG = LoggerFactory.getLogger(InterOpTester.class);
    private OkHttpClient httpClient = new OkHttpClient();

    public Path GetInterOpFile(String fileName, String changeset) throws IOException {
        return this.GetInterOpFile(fileName, changeset, "data");
    }

    public Path GetInterOpFile(String fileName, String changeset, String subdir) throws IOException {
        Path file;
        Path rootPath = new Path(PARQUET_TESTING_PATH, subdir);
        Configuration conf = new Configuration();
        FileSystem fs = rootPath.getFileSystem(conf);
        if (!fs.exists(rootPath)) {
            LOG.info("Create folder for interOp files: " + rootPath);
            if (!fs.mkdirs(rootPath)) {
                throw new IOException("Cannot create path " + rootPath);
            }
        }
        if (!fs.exists(file = new Path(rootPath, fileName))) {
            String downloadUrl = String.format("%s/%s/%s/%s", PARQUET_TESTING_REPO, changeset, subdir, fileName);
            LOG.info("Download interOp file: " + downloadUrl);
            Request request = new Request.Builder().url(downloadUrl).build();
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw new IOException("Failed to download file: " + response);
                }
                try (FSDataOutputStream fdos = fs.create(file);){
                    fdos.write(response.body().bytes());
                }
            }
        }
        return file;
    }
}

